/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class WindowsInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    private Color selectedTitleGradientColor;
    private Color notSelectedTitleGradientColor;
    private JPopupMenu systemPopupMenu;
    private JLabel systemLabel;
    private Font titleFont;
    private int shadowOffset;
    private Color shadowColor;

    protected void addSubComponents() {
        this.add(this.systemLabel);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected void assembleSystemMenu() {
        this.systemPopupMenu = new JPopupMenu();
        this.addSystemMenuItems(this.systemPopupMenu);
        this.enableActions();
        this.systemLabel = new JLabel(this.frame.getFrameIcon());
        this.systemLabel.addMouseListener(new MouseAdapter(this){
            private final WindowsInternalFrameTitlePane this$0;
            {
                this.this$0 = windowsInternalFrameTitlePane;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                WindowsInternalFrameTitlePane.access$000(this.this$0, mouseEvent.getComponent());
            }
        });
    }

    protected void createButtons() {
        super.createButtons();
        if (XPStyle.getXP() != null) {
            this.iconButton.setContentAreaFilled(false);
            this.maxButton.setContentAreaFilled(false);
            this.closeButton.setContentAreaFilled(false);
        }
    }

    protected void installDefaults() {
        super.installDefaults();
        if (XPStyle.getXP() == null) {
            this.selectedTitleGradientColor = UIManager.getColor("InternalFrame.activeTitleGradient");
            this.notSelectedTitleGradientColor = UIManager.getColor("InternalFrame.inactiveTitleGradient");
            Color color = UIManager.getColor("InternalFrame.activeBorderColor");
            this.setBorder(BorderFactory.createLineBorder(color, 1));
        }
    }

    protected void showSystemMenu() {
        this.showSystemPopupMenu(this.systemLabel);
    }

    private void showSystemPopupMenu(Component component) {
        Dimension dimension = new Dimension();
        Border border = this.frame.getBorder();
        if (border != null) {
            dimension.width += border.getBorderInsets((Component)this.frame).left + border.getBorderInsets((Component)this.frame).right;
            dimension.height += border.getBorderInsets((Component)this.frame).bottom + border.getBorderInsets((Component)this.frame).top;
        }
        if (!this.frame.isIcon()) {
            this.systemPopupMenu.show(component, this.getX() - dimension.width, this.getY() + this.getHeight() - dimension.height);
        } else {
            this.systemPopupMenu.show(component, this.getX() - dimension.width, this.getY() - this.systemPopupMenu.getPreferredSize().height - dimension.height);
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            dimension.height = xPStyle.getInt("sysmetrics.captionbarheight", dimension.height);
            dimension.height = this.frame.isMaximum() ? ++dimension.height : (dimension.height += 5);
        }
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paintComponent(Graphics graphics) {
        this.paintTitleBackground(graphics);
        String string = this.frame.getTitle();
        if (string != null) {
            int n2;
            boolean bl2 = this.frame.isSelected();
            Font font = graphics.getFont();
            Font font2 = this.titleFont != null ? this.titleFont : this.getFont();
            graphics.setFont(font2);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rectangle = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rectangle = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rectangle = this.closeButton.getBounds();
            }
            if (WindowsGraphicsUtils.isLeftToRight(this.frame)) {
                if (rectangle.x == 0) {
                    rectangle.x = this.frame.getWidth() - this.frame.getInsets().right;
                }
                n2 = this.systemLabel.getX() + this.systemLabel.getWidth() + 2;
                int n4 = rectangle.x - n2 - 3;
                string = this.getTitle(this.frame.getTitle(), fontMetrics, n4);
            } else {
                n2 = this.systemLabel.getX() - 2 - SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            if (this.shadowOffset != 0 && this.shadowColor != null) {
                graphics.setColor(this.shadowColor);
                graphics.drawString(string, n2 + this.shadowOffset, n3 + this.shadowOffset);
            }
            graphics.setColor(bl2 ? this.selectedTextColor : this.notSelectedTextColor);
            graphics.drawString(string, n2, n3);
            graphics.setFont(font);
        }
    }

    protected void paintTitleBackground(Graphics graphics) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            XPStyle.Skin skin = xPStyle.getSkin(this.frame.isIcon() ? "window.mincaption" : (this.frame.isMaximum() ? "window.maxcaption" : "window.caption"));
            skin.paintSkin(graphics, 0, 0, this.getSize().width, this.getSize().height, this.frame.isSelected() ? 0 : 1);
        } else {
            Boolean bl2 = (Boolean)LookAndFeel.getDesktopPropertyValue("win.frame.captionGradientsOn", false);
            if (bl2.booleanValue() && graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = graphics2D.getPaint();
                boolean bl3 = this.frame.isSelected();
                int n2 = this.getWidth();
                if (bl3) {
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.selectedTitleColor, (int)((double)n2 * 0.75), 0.0f, this.selectedTitleGradientColor);
                    graphics2D.setPaint(gradientPaint);
                } else {
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.notSelectedTitleColor, (int)((double)n2 * 0.75), 0.0f, this.notSelectedTitleGradientColor);
                    graphics2D.setPaint(gradientPaint);
                }
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setPaint(paint);
            } else {
                super.paintTitleBackground(graphics);
            }
        }
    }

    protected LayoutManager createLayout() {
        return new WindowsTitlePaneLayout(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new WindowsPropertyChangeHandler(this);
    }

    public WindowsInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void addSystemMenuItems(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(this.restoreAction);
        jMenuItem.setMnemonic('R');
        jMenuItem = jPopupMenu.add(this.moveAction);
        jMenuItem.setMnemonic('M');
        jMenuItem = jPopupMenu.add(this.sizeAction);
        jMenuItem.setMnemonic('S');
        jMenuItem = jPopupMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic('n');
        jMenuItem = jPopupMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic('x');
        this.systemPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(this.closeAction);
        jMenuItem.setMnemonic('C');
    }

    static void access$000(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane, Component component) {
        windowsInternalFrameTitlePane.showSystemPopupMenu(component);
    }

    static JButton access$1000(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.iconButton;
    }

    static JButton access$600(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.closeButton;
    }

    static JButton access$800(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.maxButton;
    }

    static JInternalFrame access$100(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$1100(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$200(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$400(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$500(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$700(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$900(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JLabel access$300(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.systemLabel;
    }

    public class WindowsPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        private final WindowsInternalFrameTitlePane this$0;

        public WindowsPropertyChangeHandler(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
            this.this$0 = windowsInternalFrameTitlePane;
            super(windowsInternalFrameTitlePane);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("frameIcon".equals(string) && WindowsInternalFrameTitlePane.access$300(this.this$0) != null) {
                WindowsInternalFrameTitlePane.access$300(this.this$0).setIcon(WindowsInternalFrameTitlePane.access$1100(this.this$0).getFrameIcon());
            }
            super.propertyChange(propertyChangeEvent);
        }
    }

    public class WindowsTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        private Insets captionMargin;
        private Insets contentMargin;
        private XPStyle xp;
        private final WindowsInternalFrameTitlePane this$0;

        WindowsTitlePaneLayout(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
            this.this$0 = windowsInternalFrameTitlePane;
            super(windowsInternalFrameTitlePane);
            this.captionMargin = null;
            this.contentMargin = null;
            this.xp = XPStyle.getXP();
            if (this.xp != null) {
                this.captionMargin = this.xp.getMargin("window.caption.captionmargins");
                this.contentMargin = this.xp.getMargin("window.caption.contentmargins");
            }
            if (this.captionMargin == null) {
                this.captionMargin = new Insets(0, 2, 0, 2);
            }
            if (this.contentMargin == null) {
                this.contentMargin = new Insets(0, 0, 0, 0);
            }
        }

        public void layoutContainer(Container container) {
            boolean bl2 = WindowsGraphicsUtils.isLeftToRight(WindowsInternalFrameTitlePane.access$100(this.this$0));
            int n2 = this.this$0.getWidth();
            int n3 = this.this$0.getHeight();
            Icon icon = WindowsInternalFrameTitlePane.access$200(this.this$0).getFrameIcon();
            int n4 = icon != null ? icon.getIconHeight() : 0;
            int n5 = bl2 ? this.captionMargin.left : n2 - this.captionMargin.right;
            int n6 = (n3 - n4) / 2 + 1;
            this.layoutButton(WindowsInternalFrameTitlePane.access$300(this.this$0), "window.sysbutton", n5, n6, 16, 16, bl2);
            if (this.xp != null) {
                n5 = bl2 ? n2 - this.captionMargin.right - 2 : this.captionMargin.left + 2;
                n6 = this.contentMargin.top + this.captionMargin.top;
                n6 = WindowsInternalFrameTitlePane.access$400(this.this$0).isMaximum() ? ++n6 : (n6 += 5);
            } else {
                n5 = bl2 ? n2 - this.captionMargin.right : this.captionMargin.left;
                n6 = (n3 - 16) / 2 + 1;
            }
            if (WindowsInternalFrameTitlePane.access$500(this.this$0).isClosable()) {
                n5 = this.layoutButton(WindowsInternalFrameTitlePane.access$600(this.this$0), "window.closebutton", n5, n6, 16, 14, !bl2);
            }
            if (WindowsInternalFrameTitlePane.access$700(this.this$0).isMaximizable()) {
                n5 = this.layoutButton(WindowsInternalFrameTitlePane.access$800(this.this$0), "window.maxbutton", n5, n6, 16, 14, !bl2);
            }
            if (WindowsInternalFrameTitlePane.access$900(this.this$0).isIconifiable()) {
                this.layoutButton(WindowsInternalFrameTitlePane.access$1000(this.this$0), "window.minbutton", n5, n6, 16, 14, !bl2);
            }
        }

        private int layoutButton(JComponent jComponent, String string, int n2, int n3, int n4, int n5, boolean bl2) {
            XPStyle.Skin skin;
            if (this.xp != null && (skin = this.xp.getSkin(string)).getImage() != null) {
                n4 = skin.getWidth();
                n5 = skin.getHeight();
            }
            if (!bl2) {
                n2 -= n4;
            }
            jComponent.setBounds(n2, n3, n4, n5);
            n2 = bl2 ? (n2 += n4 + 2) : (n2 -= 2);
            return n2;
        }
    }
}

