/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.UIManager;
import javax.swing.plaf.DesktopPaneUI;

public class JDesktopPane
extends JLayeredPane
implements Accessible {
    private static final String uiClassID = "DesktopPaneUI";
    transient DesktopManager desktopManager;
    private transient JInternalFrame selectedFrame = null;
    public static int LIVE_DRAG_MODE = 0;
    public static int OUTLINE_DRAG_MODE = 1;
    private int dragMode = LIVE_DRAG_MODE;

    public int getDragMode() {
        return this.dragMode;
    }

    public JDesktopPane() {
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(this){
            private final JDesktopPane this$0;
            {
                this.this$0 = jDesktopPane;
            }

            public Component getDefaultComponent(Container container) {
                JInternalFrame[] jInternalFrameArray = this.this$0.getAllFrames();
                Component component = null;
                for (int i2 = 0; i2 < jInternalFrameArray.length && (component = jInternalFrameArray[i2].getFocusTraversalPolicy().getDefaultComponent(jInternalFrameArray[i2])) == null; ++i2) {
                }
                return component;
            }
        });
        this.updateUI();
    }

    public void updateUI() {
        this.setUI((DesktopPaneUI)UIManager.getUI(this));
    }

    public boolean isOpaque() {
        return true;
    }

    public void setDragMode(int n2) {
        this.firePropertyChange("dragMode", this.dragMode, n2);
        this.dragMode = n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.desktopManager != null ? this.desktopManager.toString() : "";
        return super.paramString() + ",desktopManager=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJDesktopPane(this);
        }
        return this.accessibleContext;
    }

    public DesktopManager getDesktopManager() {
        return this.desktopManager;
    }

    public void setDesktopManager(DesktopManager desktopManager) {
        this.desktopManager = desktopManager;
    }

    public JInternalFrame getSelectedFrame() {
        return this.selectedFrame;
    }

    public JInternalFrame[] getAllFrames() {
        Vector vector = new Vector(10);
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            JInternalFrame jInternalFrame;
            Component component = this.getComponent(i2);
            if (component instanceof JInternalFrame) {
                vector.addElement(component);
                continue;
            }
            if (!(component instanceof JInternalFrame.JDesktopIcon) || (jInternalFrame = ((JInternalFrame.JDesktopIcon)component).getInternalFrame()) == null) continue;
            vector.addElement(jInternalFrame);
        }
        Object[] objectArray = new JInternalFrame[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public JInternalFrame[] getAllFramesInLayer(int n2) {
        Vector vector = new Vector(10);
        int n3 = this.getComponentCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            JInternalFrame jInternalFrame;
            Component component = this.getComponent(i2);
            if (component instanceof JInternalFrame) {
                if (((JInternalFrame)component).getLayer() != n2) continue;
                vector.addElement(component);
                continue;
            }
            if (!(component instanceof JInternalFrame.JDesktopIcon) || (jInternalFrame = ((JInternalFrame.JDesktopIcon)component).getInternalFrame()) == null || jInternalFrame.getLayer() != n2) continue;
            vector.addElement(jInternalFrame);
        }
        Object[] objectArray = new JInternalFrame[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setSelectedFrame(JInternalFrame jInternalFrame) {
        this.selectedFrame = jInternalFrame;
    }

    public DesktopPaneUI getUI() {
        return (DesktopPaneUI)this.ui;
    }

    public void setUI(DesktopPaneUI desktopPaneUI) {
        super.setUI(desktopPaneUI);
    }

    protected class AccessibleJDesktopPane
    extends JComponent.AccessibleJComponent {
        private final JDesktopPane this$0;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DESKTOP_PANE;
        }

        protected AccessibleJDesktopPane(JDesktopPane jDesktopPane) {
            this.this$0 = jDesktopPane;
            super(jDesktopPane);
        }
    }
}

