/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalRootPaneUI;
import javax.swing.plaf.metal.MetalUtils;

class MetalTitlePane
extends JComponent {
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private Icon maximizeIcon;
    private Icon minimizeIcon;
    private WindowListener windowListener;
    private Window window;
    private JRootPane rootPane;
    private int buttonsWidth;
    private int state;
    private MetalRootPaneUI rootPaneUI;
    private Color inactiveBackground = UIManager.getColor("inactiveCaption");
    private Color inactiveForeground = UIManager.getColor("inactiveCaptionText");
    private Color inactiveShadow = UIManager.getColor("inactiveCaptionBorder");
    private Color activeBumpsHighlight = MetalLookAndFeel.getPrimaryControlHighlight();
    private Color activeBumpsShadow = MetalLookAndFeel.getPrimaryControlDarkShadow();
    private Color activeBackground = null;
    private Color activeForeground = null;
    private Color activeShadow = null;
    private MetalBumps activeBumps = new MetalBumps(0, 0, this.activeBumpsHighlight, this.activeBumpsShadow, MetalLookAndFeel.getPrimaryControl());
    private MetalBumps inactiveBumps = new MetalBumps(0, 0, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction(this);
        this.iconifyAction = new IconifyAction(this);
        this.restoreAction = new RestoreAction(this);
        this.maximizeAction = new MaximizeAction(this);
    }

    private void createButtons() {
        this.maximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
        this.minimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.closeButton.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        this.iconifyButton = this.createTitleButton();
        this.iconifyButton.setAction(this.iconifyAction);
        this.iconifyButton.setText(null);
        this.iconifyButton.putClientProperty("paintActive", Boolean.TRUE);
        this.iconifyButton.setBorder(handyEmptyBorder);
        this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
        this.iconifyButton.setIcon(UIManager.getIcon("InternalFrame.iconifyIcon"));
        this.toggleButton = this.createTitleButton();
        this.toggleButton.setAction(this.restoreAction);
        this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
        this.toggleButton.setBorder(handyEmptyBorder);
        this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
        this.toggleButton.setIcon(this.maximizeIcon);
    }

    private void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            case 1: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeForeground = UIManager.getColor("activeCaptionText");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
                break;
            }
            case 4: {
                this.activeBackground = UIManager.getColor("OptionPane.errorDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.errorDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.errorDialog.titlePane.shadow");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.activeBackground = UIManager.getColor("OptionPane.questionDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.questionDialog.titlePane.shadow");
                break;
            }
            case 8: {
                this.activeBackground = UIManager.getColor("OptionPane.warningDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.warningDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.warningDialog.titlePane.shadow");
                break;
            }
            default: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeForeground = UIManager.getColor("activeCaptionText");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
            }
        }
        this.activeBumps.setBumpColors(this.activeBumpsHighlight, this.activeBumpsShadow, this.activeBackground);
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void installSubcomponents() {
        if (this.getWindowDecorationStyle() == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons();
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 6);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void uninstallDefaults() {
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void setState(int n2) {
        this.setState(n2, false);
    }

    private void setState(int n2, boolean bl2) {
        Window window = this.getWindow();
        if (window != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == n2 && !bl2) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane jRootPane = this.getRootPane();
                if ((n2 & 6) != 0 && (jRootPane.getBorder() == null || jRootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    jRootPane.setBorder(null);
                } else if ((n2 & 6) == 0) {
                    this.rootPaneUI.installBorder(jRootPane);
                }
                if (frame.isResizable()) {
                    if ((n2 & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, this.minimizeIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = n2;
        }
    }

    private void setActive(boolean bl2) {
        if (this.getWindowDecorationStyle() == 1) {
            Boolean bl3 = bl2 ? Boolean.TRUE : Boolean.FALSE;
            this.iconifyButton.putClientProperty("paintActive", bl3);
            this.closeButton.putClientProperty("paintActive", bl3);
            this.toggleButton.putClientProperty("paintActive", bl3);
        }
        this.getRootPane().repaint();
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    public void paintComponent(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        String string;
        int n5;
        MetalBumps metalBumps;
        Color color;
        Color color2;
        Color color3;
        Window window;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        boolean bl2 = (window = this.getWindow()) == null ? this.getRootPane().getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        boolean bl3 = window == null ? true : window.isActive();
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        if (bl3) {
            color3 = this.activeBackground;
            color2 = this.activeForeground;
            color = this.activeShadow;
            metalBumps = this.activeBumps;
        } else {
            color3 = this.inactiveBackground;
            color2 = this.inactiveForeground;
            color = this.inactiveShadow;
            metalBumps = this.inactiveBumps;
        }
        graphics.setColor(color3);
        graphics.fillRect(0, 0, n6, n7);
        graphics.setColor(color);
        graphics.drawLine(0, n7 - 1, n6, n7 - 1);
        graphics.drawLine(0, 0, 0, 0);
        graphics.drawLine(n6 - 1, 0, n6 - 1, 0);
        int n8 = n5 = bl2 ? 5 : n6 - 5;
        if (this.getWindowDecorationStyle() == 1) {
            n5 += bl2 ? 21 : -21;
        }
        if ((string = this.getTitle()) != null) {
            Font font = this.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.setColor(color2);
            n4 = (n7 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
                rectangle = this.iconifyButton.getBounds();
            }
            if (bl2) {
                if (rectangle.x == 0) {
                    rectangle.x = window.getWidth() - window.getInsets().right - 2;
                }
                int n9 = rectangle.x - n5 - 4;
                string = this.clippedText(string, fontMetrics, n9);
            } else {
                int n10 = n5 - rectangle.x - rectangle.width - 4;
                string = this.clippedText(string, fontMetrics, n10);
                n5 -= SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            int n11 = SwingUtilities.computeStringWidth(fontMetrics, string);
            graphics.drawString(string, n5, n4);
            n5 += bl2 ? n11 + 5 : -5;
        }
        if (bl2) {
            n3 = n6 - this.buttonsWidth - n5 - 5;
            n2 = n5;
        } else {
            n3 = n5 - this.buttonsWidth - 5;
            n2 = this.buttonsWidth + 5;
        }
        n4 = 3;
        int n12 = this.getHeight() - 2 * n4;
        metalBumps.setBumpArea(n3, n12);
        metalBumps.paintIcon(this, graphics, n2, n4);
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout(this, null);
    }

    private Window getWindow() {
        return this.window;
    }

    private WindowListener createWindowListener() {
        return new WindowHandler(this, null);
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler(this, null);
    }

    private String getTitle() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return ((Frame)window).getTitle();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).getTitle();
        }
        return null;
    }

    private JButton createTitleButton() {
        JButton jButton = new JButton();
        jButton.setFocusPainted(false);
        jButton.setFocusable(false);
        jButton.setOpaque(true);
        return jButton;
    }

    private JMenu createMenu() {
        JMenu jMenu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(jMenu);
        }
        return jMenu;
    }

    private void addMenuItems(JMenu jMenu) {
        Locale locale = this.getRootPane().getLocale();
        JMenuItem jMenuItem = jMenu.add(this.restoreAction);
        int n2 = MetalUtils.getInt("MetalTitlePane.restoreMnemonic", -1);
        if (n2 != -1) {
            jMenuItem.setMnemonic(n2);
        }
        jMenuItem = jMenu.add(this.iconifyAction);
        n2 = MetalUtils.getInt("MetalTitlePane.iconifyMnemonic", -1);
        if (n2 != -1) {
            jMenuItem.setMnemonic(n2);
        }
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            jMenuItem = jMenu.add(this.maximizeAction);
            n2 = MetalUtils.getInt("MetalTitlePane.maximizeMnemonic", -1);
            if (n2 != -1) {
                jMenuItem.setMnemonic(n2);
            }
        }
        jMenu.add(new JSeparator());
        jMenuItem = jMenu.add(this.closeAction);
        n2 = MetalUtils.getInt("MetalTitlePane.closeMnemonic", -1);
        if (n2 != -1) {
            jMenuItem.setMnemonic(n2);
        }
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar(this, null);
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    static int access$900(MetalTitlePane metalTitlePane) {
        return metalTitlePane.getWindowDecorationStyle();
    }

    static void access$400(MetalTitlePane metalTitlePane) {
        metalTitlePane.close();
    }

    static void access$500(MetalTitlePane metalTitlePane) {
        metalTitlePane.iconify();
    }

    static void access$600(MetalTitlePane metalTitlePane) {
        metalTitlePane.restore();
    }

    static void access$700(MetalTitlePane metalTitlePane) {
        metalTitlePane.maximize();
    }

    static int access$1002(MetalTitlePane metalTitlePane, int n2) {
        metalTitlePane.buttonsWidth = n2;
        return metalTitlePane.buttonsWidth;
    }

    static void access$1600(MetalTitlePane metalTitlePane, int n2, boolean bl2) {
        metalTitlePane.setState(n2, bl2);
    }

    static void access$1700(MetalTitlePane metalTitlePane, boolean bl2) {
        metalTitlePane.setActive(bl2);
    }

    static Frame access$800(MetalTitlePane metalTitlePane) {
        return metalTitlePane.getFrame();
    }

    static Window access$1100(MetalTitlePane metalTitlePane) {
        return metalTitlePane.window;
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    static JButton access$1200(MetalTitlePane metalTitlePane) {
        return metalTitlePane.closeButton;
    }

    static JButton access$1400(MetalTitlePane metalTitlePane) {
        return metalTitlePane.toggleButton;
    }

    static JButton access$1500(MetalTitlePane metalTitlePane) {
        return metalTitlePane.iconifyButton;
    }

    static JMenuBar access$1300(MetalTitlePane metalTitlePane) {
        return metalTitlePane.menuBar;
    }

    public MetalTitlePane(JRootPane jRootPane, MetalRootPaneUI metalRootPaneUI) {
        this.rootPane = jRootPane;
        this.rootPaneUI = metalRootPaneUI;
        this.state = -1;
        this.installSubcomponents();
        this.determineColors();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private String clippedText(String string, FontMetrics fontMetrics, int n2) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n3 = SwingUtilities.computeStringWidth(fontMetrics, string);
        String string2 = "...";
        if (n3 > n2) {
            int n4;
            int n5 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            for (n4 = 0; n4 < string.length() && (n5 += fontMetrics.charWidth(string.charAt(n4))) <= n2; ++n4) {
            }
            string = string.substring(0, n4) + string2;
        }
        return string;
    }

    static class 1 {
    }

    private class CloseAction
    extends AbstractAction {
        private final MetalTitlePane this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            MetalTitlePane.access$400(this.this$0);
        }

        public CloseAction(MetalTitlePane metalTitlePane) {
            this.this$0 = metalTitlePane;
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", metalTitlePane.getLocale()));
        }
    }

    private class IconifyAction
    extends AbstractAction {
        private final MetalTitlePane this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            MetalTitlePane.access$500(this.this$0);
        }

        public IconifyAction(MetalTitlePane metalTitlePane) {
            this.this$0 = metalTitlePane;
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", metalTitlePane.getLocale()));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        private final MetalTitlePane this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            MetalTitlePane.access$700(this.this$0);
        }

        public MaximizeAction(MetalTitlePane metalTitlePane) {
            this.this$0 = metalTitlePane;
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", metalTitlePane.getLocale()));
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private final MetalTitlePane this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("resizable".equals(string) || "state".equals(string)) {
                Frame frame = MetalTitlePane.access$800(this.this$0);
                if (frame != null) {
                    MetalTitlePane.access$1600(this.this$0, frame.getExtendedState(), true);
                }
                if ("resizable".equals(string)) {
                    this.this$0.getRootPane().repaint();
                }
            } else if ("title".equals(string)) {
                this.this$0.repaint();
            } else if ("componentOrientation".equals(string)) {
                this.this$0.revalidate();
                this.this$0.repaint();
            }
        }

        private PropertyChangeHandler(MetalTitlePane metalTitlePane) {
            this.this$0 = metalTitlePane;
        }

        PropertyChangeHandler(MetalTitlePane metalTitlePane, 1 var2_2) {
            this(metalTitlePane);
        }
    }

    private class RestoreAction
    extends AbstractAction {
        private final MetalTitlePane this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            MetalTitlePane.access$600(this.this$0);
        }

        public RestoreAction(MetalTitlePane metalTitlePane) {
            this.this$0 = metalTitlePane;
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", metalTitlePane.getLocale()));
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private final MetalTitlePane this$0;

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(Math.max(16, dimension.width), Math.max(dimension.height, 16));
        }

        public void paint(Graphics graphics) {
            Image image;
            Frame frame = MetalTitlePane.access$800(this.this$0);
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                graphics.drawImage(image, 0, 0, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, graphics, 0, 0);
                }
            }
        }

        private SystemMenuBar(MetalTitlePane metalTitlePane) {
            this.this$0 = metalTitlePane;
        }

        SystemMenuBar(MetalTitlePane metalTitlePane, 1 var2_2) {
            this(metalTitlePane);
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private final MetalTitlePane this$0;

        private int computeHeight() {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.this$0.getFont());
            int n2 = fontMetrics.getHeight();
            n2 += 7;
            int n3 = 0;
            if (MetalTitlePane.access$900(this.this$0) == 1) {
                n3 = 16;
            }
            int n4 = Math.max(n2, n3);
            return n4;
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            int n2;
            int n3;
            if (MetalTitlePane.access$900(this.this$0) != 1) {
                MetalTitlePane.access$1002(this.this$0, 0);
                return;
            }
            boolean bl2 = MetalTitlePane.access$1100(this.this$0) == null ? this.this$0.getRootPane().getComponentOrientation().isLeftToRight() : MetalTitlePane.access$1100(this.this$0).getComponentOrientation().isLeftToRight();
            int n4 = this.this$0.getWidth();
            int n5 = 3;
            if (MetalTitlePane.access$1200(this.this$0) != null && MetalTitlePane.access$1200(this.this$0).getIcon() != null) {
                n3 = MetalTitlePane.access$1200(this.this$0).getIcon().getIconHeight();
                n2 = MetalTitlePane.access$1200(this.this$0).getIcon().getIconWidth();
            } else {
                n3 = 16;
                n2 = 16;
            }
            int n6 = bl2 ? n4 : 0;
            int n7 = 5;
            n6 = bl2 ? n7 : n4 - n2 - n7;
            MetalTitlePane.access$1300(this.this$0).setBounds(n6, n5, n2, n3);
            n6 = bl2 ? n4 : 0;
            n7 = 4;
            n6 += bl2 ? -n7 - n2 : n7;
            if (MetalTitlePane.access$1200(this.this$0) != null) {
                MetalTitlePane.access$1200(this.this$0).setBounds(n6, n5, n2, n3);
            }
            if (!bl2) {
                n6 += n2;
            }
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && MetalTitlePane.access$1400(this.this$0).getParent() != null) {
                n7 = 10;
                MetalTitlePane.access$1400(this.this$0).setBounds(n6 += bl2 ? -n7 - n2 : n7, n5, n2, n3);
                if (!bl2) {
                    n6 += n2;
                }
            }
            if (MetalTitlePane.access$1500(this.this$0) != null && MetalTitlePane.access$1500(this.this$0).getParent() != null) {
                n7 = 2;
                MetalTitlePane.access$1500(this.this$0).setBounds(n6 += bl2 ? -n7 - n2 : n7, n5, n2, n3);
                if (!bl2) {
                    n6 += n2;
                }
            }
            MetalTitlePane.access$1002(this.this$0, bl2 ? n4 - n6 : n6);
        }

        private TitlePaneLayout(MetalTitlePane metalTitlePane) {
            this.this$0 = metalTitlePane;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n2 = this.computeHeight();
            return new Dimension(n2, n2);
        }

        TitlePaneLayout(MetalTitlePane metalTitlePane, 1 var2_2) {
            this(metalTitlePane);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private final MetalTitlePane this$0;

        public void windowActivated(WindowEvent windowEvent) {
            MetalTitlePane.access$1700(this.this$0, true);
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            MetalTitlePane.access$1700(this.this$0, false);
        }

        private WindowHandler(MetalTitlePane metalTitlePane) {
            this.this$0 = metalTitlePane;
        }

        WindowHandler(MetalTitlePane metalTitlePane, 1 var2_2) {
            this(metalTitlePane);
        }
    }
}

