/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class JTableHeader
extends JComponent
implements TableColumnModelListener,
Accessible {
    private static final String uiClassID = "TableHeaderUI";
    protected JTable table;
    protected TableColumnModel columnModel;
    protected boolean reorderingAllowed;
    protected boolean resizingAllowed;
    protected boolean updateTableInRealTime;
    protected transient TableColumn resizingColumn;
    protected transient TableColumn draggedColumn;
    protected transient int draggedDistance;
    private TableCellRenderer defaultRenderer;

    public int getDraggedDistance() {
        return this.draggedDistance;
    }

    private int getWidthInRightToLeft() {
        if (this.table != null && this.table.getAutoResizeMode() != 0) {
            return this.table.getWidth();
        }
        return super.getWidth();
    }

    public JTableHeader() {
        this(null);
    }

    protected void initializeLocalVars() {
        this.setOpaque(true);
        this.table = null;
        this.reorderingAllowed = true;
        this.resizingAllowed = true;
        this.draggedColumn = null;
        this.draggedDistance = 0;
        this.resizingColumn = null;
        this.updateTableInRealTime = true;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setDefaultRenderer(this.createDefaultRenderer());
    }

    public void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public void updateUI() {
        this.setUI((TableHeaderUI)UIManager.getUI(this));
        this.resizeAndRepaint();
        this.invalidate();
    }

    public boolean getReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public boolean getResizingAllowed() {
        return this.resizingAllowed;
    }

    public boolean getUpdateTableInRealTime() {
        return this.updateTableInRealTime;
    }

    public void setDraggedDistance(int n2) {
        this.draggedDistance = n2;
    }

    public void setReorderingAllowed(boolean bl2) {
        boolean bl3 = this.reorderingAllowed;
        this.reorderingAllowed = bl2;
        this.firePropertyChange("reorderingAllowed", bl3, bl2);
    }

    public void setResizingAllowed(boolean bl2) {
        boolean bl3 = this.resizingAllowed;
        this.resizingAllowed = bl2;
        this.firePropertyChange("resizingAllowed", bl3, bl2);
    }

    public void setUpdateTableInRealTime(boolean bl2) {
        this.updateTableInRealTime = bl2;
    }

    public int columnAtPoint(Point point) {
        int n2 = point.x;
        if (!this.getComponentOrientation().isLeftToRight()) {
            n2 = this.getWidthInRightToLeft() - n2;
        }
        return this.getColumnModel().getColumnIndexAtX(n2);
    }

    public Rectangle getHeaderRect(int n2) {
        Rectangle rectangle = new Rectangle();
        TableColumnModel tableColumnModel = this.getColumnModel();
        rectangle.height = this.getHeight();
        if (n2 < 0) {
            if (!this.getComponentOrientation().isLeftToRight()) {
                rectangle.x = this.getWidthInRightToLeft();
            }
        } else if (n2 >= tableColumnModel.getColumnCount()) {
            if (this.getComponentOrientation().isLeftToRight()) {
                rectangle.x = this.getWidth();
            }
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                rectangle.x += tableColumnModel.getColumn(i2).getWidth();
            }
            if (!this.getComponentOrientation().isLeftToRight()) {
                rectangle.x = this.getWidthInRightToLeft() - rectangle.x - tableColumnModel.getColumn(n2).getWidth();
            }
            rectangle.width = tableColumnModel.getColumn(n2).getWidth();
        }
        return rectangle;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.reorderingAllowed ? "true" : "false";
        String string2 = this.resizingAllowed ? "true" : "false";
        String string3 = this.updateTableInRealTime ? "true" : "false";
        return super.paramString() + ",draggedDistance=" + this.draggedDistance + ",reorderingAllowed=" + string + ",resizingAllowed=" + string2 + ",updateTableInRealTime=" + string3;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTableHeader(this);
        }
        return this.accessibleContext;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable jTable) {
        JTable jTable2 = this.table;
        this.table = jTable;
        this.firePropertyChange("table", jTable2, jTable);
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        this.resizeAndRepaint();
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.resizeAndRepaint();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        this.repaint();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.resizeAndRepaint();
    }

    public TableHeaderUI getUI() {
        return (TableHeaderUI)this.ui;
    }

    public void setUI(TableHeaderUI tableHeaderUI) {
        if (this.ui != tableHeaderUI) {
            super.setUI(tableHeaderUI);
            this.repaint();
        }
    }

    protected TableCellRenderer createDefaultRenderer() {
        UIResourceTableCellRenderer uIResourceTableCellRenderer = new UIResourceTableCellRenderer(null);
        uIResourceTableCellRenderer.setHorizontalAlignment(0);
        return uIResourceTableCellRenderer;
    }

    public TableCellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
        this.defaultRenderer = tableCellRenderer;
    }

    public TableColumn getDraggedColumn() {
        return this.draggedColumn;
    }

    public TableColumn getResizingColumn() {
        return this.resizingColumn;
    }

    public void setDraggedColumn(TableColumn tableColumn) {
        this.draggedColumn = tableColumn;
    }

    public void setResizingColumn(TableColumn tableColumn) {
        this.resizingColumn = tableColumn;
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public JTableHeader(TableColumnModel tableColumnModel) {
        this.setFocusable(false);
        if (tableColumnModel == null) {
            tableColumnModel = this.createDefaultColumnModel();
        }
        this.setColumnModel(tableColumnModel);
        this.initializeLocalVars();
        this.updateUI();
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            throw new IllegalArgumentException("Cannot set a null ColumnModel");
        }
        TableColumnModel tableColumnModel2 = this.columnModel;
        if (tableColumnModel != tableColumnModel2) {
            if (tableColumnModel2 != null) {
                tableColumnModel2.removeColumnModelListener(this);
            }
            this.columnModel = tableColumnModel;
            tableColumnModel.addColumnModelListener(this);
            this.firePropertyChange("columnModel", tableColumnModel2, tableColumnModel);
            this.resizeAndRepaint();
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        int n2 = this.columnModel.getColumnIndexAtX(point.x);
        if (n2 != -1) {
            Component component;
            TableColumn tableColumn = this.columnModel.getColumn(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.defaultRenderer;
            }
            if ((component = tableCellRenderer.getTableCellRendererComponent(this.getTable(), tableColumn.getHeaderValue(), false, false, -1, n2)) instanceof JComponent) {
                Rectangle rectangle = this.getHeaderRect(n2);
                point.translate(-rectangle.x, -rectangle.y);
                MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                string = ((JComponent)component).getToolTipText(mouseEvent2);
            }
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    static TableCellRenderer access$100(JTableHeader jTableHeader) {
        return jTableHeader.defaultRenderer;
    }

    static class 1 {
    }

    protected class AccessibleJTableHeader
    extends JComponent.AccessibleJComponent {
        private final JTableHeader this$0;

        public int getAccessibleChildrenCount() {
            return this.this$0.columnModel.getColumnCount();
        }

        public Accessible getAccessibleChild(int n2) {
            if (n2 < 0 || n2 >= this.getAccessibleChildrenCount()) {
                return null;
            }
            TableColumn tableColumn = this.this$0.columnModel.getColumn(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                if (JTableHeader.access$100(this.this$0) != null) {
                    tableCellRenderer = JTableHeader.access$100(this.this$0);
                } else {
                    return null;
                }
            }
            Component component = tableCellRenderer.getTableCellRendererComponent(this.this$0.getTable(), tableColumn.getHeaderValue(), false, false, -1, n2);
            return new AccessibleJTableHeaderEntry(this, n2, this.this$0, this.this$0.table);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        protected AccessibleJTableHeader(JTableHeader jTableHeader) {
            this.this$0 = jTableHeader;
            super(jTableHeader);
        }

        public Accessible getAccessibleAt(Point point) {
            int n2 = this.this$0.columnAtPoint(point);
            if (n2 != -1) {
                TableColumn tableColumn = this.this$0.columnModel.getColumn(n2);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    if (JTableHeader.access$100(this.this$0) != null) {
                        tableCellRenderer = JTableHeader.access$100(this.this$0);
                    } else {
                        return null;
                    }
                }
                Component component = tableCellRenderer.getTableCellRendererComponent(this.this$0.getTable(), tableColumn.getHeaderValue(), false, false, -1, n2);
                return new AccessibleJTableHeaderEntry(this, n2, this.this$0, this.this$0.table);
            }
            return null;
        }

        static JTableHeader access$200(AccessibleJTableHeader accessibleJTableHeader) {
            return accessibleJTableHeader.this$0;
        }

        protected class AccessibleJTableHeaderEntry
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JTableHeader parent;
            private int column;
            private JTable table;
            private final AccessibleJTableHeader this$1;

            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            public int getAccessibleIndexInParent() {
                return this.column;
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public boolean isShowing() {
                return this.isVisible() && AccessibleJTableHeader.access$200(this.this$1).isShowing();
            }

            public boolean isVisible() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isVisible();
                }
                return false;
            }

            public void setEnabled(boolean bl2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl2);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl2);
                    }
                }
            }

            public void setVisible(boolean bl2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setVisible(bl2);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setVisible(bl2);
                    }
                }
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            private Component getCurrentComponent() {
                TableColumnModel tableColumnModel = this.table.getColumnModel();
                if (tableColumnModel != null) {
                    if (this.column < 0 || this.column >= tableColumnModel.getColumnCount()) {
                        return null;
                    }
                    TableColumn tableColumn = tableColumnModel.getColumn(this.column);
                    TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                    if (tableCellRenderer == null) {
                        if (JTableHeader.access$100(AccessibleJTableHeader.access$200(this.this$1)) != null) {
                            tableCellRenderer = JTableHeader.access$100(AccessibleJTableHeader.access$200(this.this$1));
                        } else {
                            return null;
                        }
                    }
                    return tableCellRenderer.getTableCellRendererComponent(AccessibleJTableHeader.access$200(this.this$1).getTable(), tableColumn.getHeaderValue(), false, false, -1, this.column);
                }
                return null;
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            public Dimension getSize() {
                return this.getBounds().getSize();
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            public Point getLocation() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.getLocation();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.getLocation();
                }
                return this.getBounds().getLocation();
            }

            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point point = this.parent.getLocationOnScreen();
                    Point point2 = this.getLocation();
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            public void setLocation(Point point) {
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public Rectangle getBounds() {
                Rectangle rectangle = this.table.getCellRect(-1, this.column, false);
                rectangle.y = 0;
                return rectangle;
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBounds(rectangle);
                    }
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                } else {
                    super.addPropertyChangeListener(propertyChangeListener);
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                } else {
                    super.removePropertyChangeListener(propertyChangeListener);
                }
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            public String getAccessibleName() {
                String string;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (string = accessibleContext.getAccessibleName()) != null && string != "") {
                    return accessibleContext.getAccessibleName();
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return this.table.getColumnName(this.column);
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                } else {
                    super.setAccessibleDescription(string);
                }
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                } else {
                    super.setAccessibleName(string);
                }
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            public Accessible getAccessibleChild(int n2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n2);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                TableColumnModel tableColumnModel = this.table.getColumnModel();
                if (tableColumnModel != null) {
                    Component component;
                    if (this.column < 0 || this.column >= tableColumnModel.getColumnCount()) {
                        return null;
                    }
                    TableColumn tableColumn = tableColumnModel.getColumn(this.column);
                    TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                    if (tableCellRenderer == null) {
                        if (JTableHeader.access$100(AccessibleJTableHeader.access$200(this.this$1)) != null) {
                            tableCellRenderer = JTableHeader.access$100(AccessibleJTableHeader.access$200(this.this$1));
                        } else {
                            return null;
                        }
                    }
                    if ((component = tableCellRenderer.getTableCellRendererComponent(AccessibleJTableHeader.access$200(this.this$1).getTable(), tableColumn.getHeaderValue(), false, false, -1, this.column)) instanceof Accessible) {
                        return ((Accessible)((Object)component)).getAccessibleContext();
                    }
                }
                return null;
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.COLUMN_HEADER;
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    AccessibleStateSet accessibleStateSet = accessibleContext.getAccessibleStateSet();
                    if (this.isShowing()) {
                        accessibleStateSet.add(AccessibleState.SHOWING);
                    }
                    return accessibleStateSet;
                }
                return new AccessibleStateSet();
            }

            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public AccessibleJTableHeaderEntry(AccessibleJTableHeader accessibleJTableHeader, int n2, JTableHeader jTableHeader, JTable jTable) {
                this.this$1 = accessibleJTableHeader;
                this.parent = jTableHeader;
                this.column = n2;
                this.table = jTable;
                this.setAccessibleParent(this.parent);
            }
        }
    }

    private static class UIResourceTableCellRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private UIResourceTableCellRenderer() {
        }

        UIResourceTableCellRenderer(1 var1_1) {
            this();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }
}

