/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TableColumn
implements Serializable {
    public static final String COLUMN_WIDTH_PROPERTY = "columWidth";
    public static final String HEADER_VALUE_PROPERTY = "headerValue";
    public static final String HEADER_RENDERER_PROPERTY = "headerRenderer";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    protected int modelIndex;
    protected Object identifier;
    protected int width;
    protected int minWidth;
    private int preferredWidth;
    protected int maxWidth;
    protected TableCellRenderer headerRenderer;
    protected Object headerValue;
    protected TableCellRenderer cellRenderer;
    protected TableCellEditor cellEditor;
    protected boolean isResizable;
    protected transient int resizedPostingDisableCount;
    private SwingPropertyChangeSupport changeSupport;

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public int getWidth() {
        return this.width;
    }

    public TableColumn() {
        this(0);
    }

    public void disableResizedPosting() {
        ++this.resizedPostingDisableCount;
    }

    public void enableResizedPosting() {
        --this.resizedPostingDisableCount;
    }

    public void sizeWidthToFit() {
        if (this.headerRenderer == null) {
            return;
        }
        Component component = this.headerRenderer.getTableCellRendererComponent(null, this.getHeaderValue(), false, false, 0, 0);
        this.setMinWidth(component.getMinimumSize().width);
        this.setMaxWidth(component.getMaximumSize().width);
        this.setPreferredWidth(component.getPreferredSize().width);
        this.setWidth(this.getPreferredWidth());
    }

    public boolean getResizable() {
        return this.isResizable;
    }

    public TableColumn(int n2) {
        this(n2, 75, null, null);
    }

    public void setMaxWidth(int n2) {
        int n3 = this.maxWidth;
        this.maxWidth = Math.max(this.minWidth, n2);
        if (this.width > n2) {
            this.setWidth(n2);
        }
        if (this.preferredWidth > n2) {
            this.setPreferredWidth(n2);
        }
        this.firePropertyChange("maxWidth", n3, this.maxWidth);
    }

    public void setMinWidth(int n2) {
        int n3 = this.minWidth;
        this.minWidth = Math.max(n2, 0);
        if (this.width < n2) {
            this.setWidth(n2);
        }
        if (this.preferredWidth < n2) {
            this.setPreferredWidth(n2);
        }
        this.firePropertyChange("minWidth", n3, this.minWidth);
    }

    public void setModelIndex(int n2) {
        int n3 = this.modelIndex;
        this.modelIndex = n2;
        this.firePropertyChange("modelIndex", n3, n2);
    }

    public void setPreferredWidth(int n2) {
        int n3 = this.preferredWidth;
        this.preferredWidth = Math.min(Math.max(n2, this.minWidth), this.maxWidth);
        this.firePropertyChange("preferredWidth", n3, this.preferredWidth);
    }

    public void setWidth(int n2) {
        int n3 = this.width;
        this.width = Math.min(Math.max(n2, this.minWidth), this.maxWidth);
        this.firePropertyChange("width", n3, this.width);
    }

    public TableColumn(int n2, int n3) {
        this(n2, n3, null, null);
    }

    public void setResizable(boolean bl2) {
        boolean bl3 = this.isResizable;
        this.isResizable = bl2;
        this.firePropertyChange("isResizable", bl3, this.isResizable);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public Object getHeaderValue() {
        return this.headerValue;
    }

    public Object getIdentifier() {
        return this.identifier != null ? this.identifier : this.getHeaderValue();
    }

    public void setHeaderValue(Object object) {
        Object object2 = this.headerValue;
        this.headerValue = object;
        this.firePropertyChange(HEADER_VALUE_PROPERTY, object2, object);
    }

    public void setIdentifier(Object object) {
        Object object2 = this.identifier;
        this.identifier = object;
        this.firePropertyChange("identifier", object2, object);
    }

    private void firePropertyChange(String string, int n2, int n3) {
        if (n2 != n3) {
            this.firePropertyChange(string, new Integer(n2), new Integer(n3));
        }
    }

    private void firePropertyChange(String string, boolean bl2, boolean bl3) {
        if (bl2 != bl3) {
            this.firePropertyChange(string, (Object)bl2, (Object)bl3);
        }
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        TableCellEditor tableCellEditor2 = this.cellEditor;
        this.cellEditor = tableCellEditor;
        this.firePropertyChange("cellEditor", tableCellEditor2, tableCellEditor);
    }

    protected TableCellRenderer createDefaultHeaderRenderer() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(this){
            private final TableColumn this$0;
            {
                this.this$0 = tableColumn;
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                JTableHeader jTableHeader;
                if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                    this.setForeground(jTableHeader.getForeground());
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(jTableHeader.getFont());
                }
                this.setText(object == null ? "" : object.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        };
        defaultTableCellRenderer.setHorizontalAlignment(0);
        return defaultTableCellRenderer;
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setCellRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.cellRenderer;
        this.cellRenderer = tableCellRenderer;
        this.firePropertyChange(CELL_RENDERER_PROPERTY, tableCellRenderer2, tableCellRenderer);
    }

    public void setHeaderRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.headerRenderer;
        this.headerRenderer = tableCellRenderer;
        this.firePropertyChange(HEADER_RENDERER_PROPERTY, tableCellRenderer2, tableCellRenderer);
    }

    public TableColumn(int n2, int n3, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
        this.modelIndex = n2;
        this.width = n3;
        this.preferredWidth = n3;
        this.cellRenderer = tableCellRenderer;
        this.cellEditor = tableCellEditor;
        this.minWidth = 15;
        this.maxWidth = Integer.MAX_VALUE;
        this.isResizable = true;
        this.resizedPostingDisableCount = 0;
        this.headerValue = null;
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }
}

