/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StateInvariantError;

public class DefaultCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    JTextComponent component;
    boolean async = false;
    boolean visible;
    int dot;
    int mark;
    Object selectionTag;
    boolean selectionVisible;
    Timer flasher;
    Point magicCaretPosition;
    transient Position.Bias dotBias;
    transient Position.Bias markBias;
    boolean dotLTR;
    boolean markLTR;
    transient UpdateHandler updateHandler = new UpdateHandler(this);
    private transient int[] flagXPoints = new int[3];
    private transient int[] flagYPoints = new int[3];
    private transient FocusListener focusListener;
    private transient NavigationFilter.FilterBypass filterBypass;
    private transient ClipboardOwner clipboardOwner;
    private boolean ownsSelection;
    private boolean forceCaretPositionChange;
    private transient boolean shouldHandleRelease;
    static Class class$javax$swing$event$ChangeListener;

    public int getBlinkRate() {
        return this.flasher == null ? 0 : this.flasher.getDelay();
    }

    public int getDot() {
        return this.dot;
    }

    public int getMark() {
        return this.mark;
    }

    private void ensureValidPosition() {
        int n2 = this.component.getDocument().getLength();
        if (this.dot > n2 || this.mark > n2) {
            this.handleSetDot(n2, Position.Bias.Forward);
        }
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$ChangeListener == null ? DefaultCaret.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i2 + 1]).stateChanged(this.changeEvent);
        }
    }

    protected final synchronized void repaint() {
        if (this.component != null) {
            this.component.repaint(this.x, this.y, this.width, this.height);
        }
    }

    void repaintNewCaret() {
        if (this.component != null) {
            TextUI textUI = this.component.getUI();
            Document document = this.component.getDocument();
            if (textUI != null && document != null) {
                Rectangle rectangle;
                try {
                    rectangle = textUI.modelToView(this.component, this.dot, this.dotBias);
                }
                catch (BadLocationException badLocationException) {
                    rectangle = null;
                }
                if (rectangle != null) {
                    this.adjustVisibility(rectangle);
                    if (this.getMagicCaretPosition() == null) {
                        this.setMagicCaretPosition(new Point(rectangle.x, rectangle.y));
                    }
                }
                this.damage(rectangle);
            }
        }
    }

    private void updateSystemSelection() {
        Clipboard clipboard;
        if (!SwingUtilities2.canCurrentEventAccessSystemClipboard()) {
            return;
        }
        if (this.dot != this.mark && this.component != null && (clipboard = this.getSystemSelection()) != null) {
            String string = null;
            if (this.component instanceof JPasswordField && this.component.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
                StringBuffer stringBuffer = null;
                char c2 = ((JPasswordField)this.component).getEchoChar();
                int n2 = Math.min(this.getDot(), this.getMark());
                int n3 = Math.max(this.getDot(), this.getMark());
                for (int i2 = n2; i2 < n3; ++i2) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(c2);
                }
                string = stringBuffer != null ? stringBuffer.toString() : null;
            } else {
                string = this.component.getSelectedText();
            }
            clipboard.setContents(new StringSelection(string), this.getClipboardOwner());
            this.ownsSelection = true;
        }
    }

    boolean getAsynchronousMovement() {
        return this.async;
    }

    boolean isDotLeftToRight() {
        return this.dotLTR;
    }

    boolean isMarkLeftToRight() {
        return this.markLTR;
    }

    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void moveDot(int n2) {
        this.moveDot(n2, Position.Bias.Forward);
    }

    public void setBlinkRate(int n2) {
        if (n2 != 0) {
            if (this.flasher == null) {
                this.flasher = new Timer(n2, this.updateHandler);
            }
            this.flasher.setDelay(n2);
        } else if (this.flasher != null) {
            this.flasher.stop();
            this.flasher.removeActionListener(this.updateHandler);
            this.flasher = null;
        }
    }

    public void setDot(int n2) {
        this.setDot(n2, Position.Bias.Forward);
    }

    private boolean _contains(int n2, int n3, int n4, int n5) {
        int n6 = this.width;
        int n7 = this.height;
        if ((n6 | n7 | n4 | n5) < 0) {
            return false;
        }
        int n8 = this.x;
        int n9 = this.y;
        if (n2 < n8 || n3 < n9) {
            return false;
        }
        if (n4 > 0) {
            n6 += n8;
            if ((n4 += n2) <= n2 ? n6 >= n8 || n4 > n6 : n6 >= n8 && n4 > n6) {
                return false;
            }
        } else if (n8 + n6 < n2) {
            return false;
        }
        if (n5 > 0) {
            n7 += n9;
            if ((n5 += n3) <= n3 ? n7 >= n9 || n5 > n7 : n7 >= n9 && n5 > n7) {
                return false;
            }
        } else if (n9 + n7 < n3) {
            return false;
        }
        return true;
    }

    private void adjustFocus(boolean bl2) {
        if (this.component != null && this.component.isEnabled() && this.component.isRequestFocusEnabled()) {
            if (bl2) {
                this.component.requestFocusInWindow();
            } else {
                this.component.requestFocus();
            }
        }
    }

    void setAsynchronousMovement(boolean bl2) {
        this.async = bl2;
    }

    public void setSelectionVisible(boolean bl2) {
        if (bl2 != this.selectionVisible) {
            this.selectionVisible = bl2;
            if (this.selectionVisible) {
                Highlighter highlighter = this.component.getHighlighter();
                if (this.dot != this.mark && highlighter != null && this.selectionTag == null) {
                    int n2 = Math.min(this.dot, this.mark);
                    int n3 = Math.max(this.dot, this.mark);
                    Highlighter.HighlightPainter highlightPainter = this.getSelectionPainter();
                    try {
                        this.selectionTag = highlighter.addHighlight(n2, n3, highlightPainter);
                    }
                    catch (BadLocationException badLocationException) {
                        this.selectionTag = null;
                    }
                }
            } else if (this.selectionTag != null) {
                Highlighter highlighter = this.component.getHighlighter();
                highlighter.removeHighlight(this.selectionTag);
                this.selectionTag = null;
            }
        }
    }

    public void setVisible(boolean bl2) {
        if (this.component != null) {
            TextUI textUI = this.component.getUI();
            if (this.visible != bl2) {
                this.visible = bl2;
                try {
                    Rectangle rectangle = textUI.modelToView(this.component, this.dot, this.dotBias);
                    this.damage(rectangle);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        if (this.flasher != null) {
            if (this.visible) {
                this.flasher.start();
            } else {
                this.flasher.stop();
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            try {
                Element element;
                Object object;
                TextUI textUI = this.component.getUI();
                Rectangle rectangle = textUI.modelToView(this.component, this.dot, this.dotBias);
                if (rectangle == null || rectangle.width == 0 && rectangle.height == 0) {
                    return;
                }
                if (this.width > 0 && this.height > 0 && !this._contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                    object = graphics.getClipBounds();
                    if (object != null && !((Rectangle)object).contains(this)) {
                        this.repaint();
                    }
                    this.damage(rectangle);
                }
                graphics.setColor(this.component.getCaretColor());
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                object = this.component.getDocument();
                if (object instanceof AbstractDocument && (element = ((AbstractDocument)object).getBidiRootElement()) != null && element.getElementCount() > 1) {
                    this.flagXPoints[0] = rectangle.x;
                    this.flagYPoints[0] = rectangle.y;
                    this.flagXPoints[1] = rectangle.x;
                    this.flagYPoints[1] = rectangle.y + 4;
                    this.flagYPoints[2] = rectangle.y;
                    this.flagXPoints[2] = this.dotLTR ? rectangle.x + 5 : rectangle.x - 4;
                    graphics.fillPolygon(this.flagXPoints, this.flagYPoints, 3);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    public void setMagicCaretPosition(Point point) {
        this.magicCaretPosition = point;
    }

    protected void adjustVisibility(Rectangle rectangle) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.component != null) {
                this.component.scrollRectToVisible(rectangle);
            }
        } else {
            SwingUtilities.invokeLater(new SafeScroller(this, rectangle));
        }
    }

    protected synchronized void damage(Rectangle rectangle) {
        if (rectangle != null) {
            this.x = rectangle.x - 4;
            this.y = rectangle.y;
            this.width = 10;
            this.height = rectangle.height;
            this.repaint();
        }
    }

    private Clipboard getSystemSelection() {
        try {
            return this.component.getToolkit().getSystemSelection();
        }
        catch (HeadlessException headlessException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private ClipboardOwner getClipboardOwner() {
        if (this.clipboardOwner == null) {
            this.clipboardOwner = new ClipboardHandler(this, null);
        }
        return this.clipboardOwner;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.component.isEnabled()) {
            if (this.component.isEditable()) {
                this.setVisible(true);
            }
            this.setSelectionVisible(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setVisible(false);
        this.setSelectionVisible(this.ownsSelection || focusEvent.isTemporary());
    }

    private void adjustCaret(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(mouseEvent);
        } else {
            this.positionCaret(mouseEvent);
        }
    }

    void adjustCaretAndFocus(MouseEvent mouseEvent) {
        this.adjustCaret(mouseEvent);
        this.adjustFocus(false);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            JTextComponent jTextComponent;
            int n2 = mouseEvent.getClickCount();
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (n2 == 2 && SwingUtilities2.canEventAccessSystemClipboard(mouseEvent)) {
                    DefaultEditorKit.SelectWordAction selectWordAction = new DefaultEditorKit.SelectWordAction();
                    selectWordAction.actionPerformed(new ActionEvent(this.getComponent(), 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
                } else if (n2 == 3 && SwingUtilities2.canEventAccessSystemClipboard(mouseEvent)) {
                    DefaultEditorKit.SelectLineAction selectLineAction = new DefaultEditorKit.SelectLineAction();
                    selectLineAction.actionPerformed(new ActionEvent(this.getComponent(), 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
                }
            } else if (SwingUtilities.isMiddleMouseButton(mouseEvent) && n2 == 1 && this.component.isEditable() && this.component.isEnabled() && SwingUtilities2.canEventAccessSystemClipboard(mouseEvent) && (jTextComponent = (JTextComponent)mouseEvent.getSource()) != null) {
                try {
                    Toolkit toolkit = jTextComponent.getToolkit();
                    Clipboard clipboard = toolkit.getSystemSelection();
                    if (clipboard != null) {
                        Transferable transferable;
                        this.adjustCaret(mouseEvent);
                        TransferHandler transferHandler = jTextComponent.getTransferHandler();
                        if (transferHandler != null && (transferable = clipboard.getContents(null)) != null) {
                            transferHandler.importData(jTextComponent, transferable);
                        }
                        this.adjustFocus(true);
                    }
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.moveCaret(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (mouseEvent.isConsumed()) {
                this.shouldHandleRelease = true;
            } else {
                this.shouldHandleRelease = false;
                this.adjustCaretAndFocus(mouseEvent);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.shouldHandleRelease && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.adjustCaretAndFocus(mouseEvent);
        }
    }

    protected void moveCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Position.Bias[] biasArray = new Position.Bias[1];
        int n2 = this.component.getUI().viewToModel(this.component, point, biasArray);
        if (biasArray[0] == null) {
            biasArray[0] = Position.Bias.Forward;
        }
        if (n2 >= 0) {
            this.moveDot(n2, biasArray[0]);
        }
    }

    protected void positionCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Position.Bias[] biasArray = new Position.Bias[1];
        int n2 = this.component.getUI().viewToModel(this.component, point, biasArray);
        if (biasArray[0] == null) {
            biasArray[0] = Position.Bias.Forward;
        }
        if (n2 >= 0) {
            this.setDot(n2, biasArray[0]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.updateHandler = new UpdateHandler(this);
        this.dotBias = !objectInputStream.readBoolean() ? Position.Bias.Forward : Position.Bias.Backward;
        this.markBias = !objectInputStream.readBoolean() ? Position.Bias.Forward : Position.Bias.Backward;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeBoolean(this.dotBias == Position.Bias.Backward);
        objectOutputStream.writeBoolean(this.markBias == Position.Bias.Backward);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public String toString() {
        String string = "Dot=(" + this.dot + ", " + this.dotBias + ")";
        string = string + " Mark=(" + this.mark + ", " + this.markBias + ")";
        return string;
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DefaultCaret.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DefaultCaret.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DefaultCaret.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    static void access$300(DefaultCaret defaultCaret) {
        defaultCaret.ensureValidPosition();
    }

    static boolean access$200(DefaultCaret defaultCaret) {
        return defaultCaret.ownsSelection;
    }

    static boolean access$202(DefaultCaret defaultCaret, boolean bl2) {
        defaultCaret.ownsSelection = bl2;
        return defaultCaret.ownsSelection;
    }

    static boolean access$402(DefaultCaret defaultCaret, boolean bl2) {
        defaultCaret.forceCaretPositionChange = bl2;
        return defaultCaret.forceCaretPositionChange;
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return DefaultHighlighter.DefaultPainter;
    }

    protected final JTextComponent getComponent() {
        return this.component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinstall(JTextComponent jTextComponent) {
        jTextComponent.removeMouseListener(this);
        jTextComponent.removeMouseMotionListener(this);
        if (this.focusListener != null) {
            jTextComponent.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        jTextComponent.removePropertyChangeListener(this.updateHandler);
        Document document = jTextComponent.getDocument();
        if (document != null) {
            document.removeDocumentListener(this.updateHandler);
        }
        DefaultCaret defaultCaret = this;
        synchronized (defaultCaret) {
            this.component = null;
        }
        if (this.flasher != null) {
            this.flasher.stop();
        }
    }

    public void install(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        Document document = jTextComponent.getDocument();
        this.mark = 0;
        this.dot = 0;
        this.markLTR = true;
        this.dotLTR = true;
        this.dotBias = this.markBias = Position.Bias.Forward;
        if (document != null) {
            document.addDocumentListener(this.updateHandler);
        }
        jTextComponent.addPropertyChangeListener(this.updateHandler);
        this.focusListener = new FocusHandler(this);
        jTextComponent.addFocusListener(this.focusListener);
        jTextComponent.addMouseListener(this);
        jTextComponent.addMouseMotionListener(this);
        if (this.component.hasFocus()) {
            this.focusGained(null);
        }
    }

    private NavigationFilter.FilterBypass getFilterBypass() {
        if (this.filterBypass == null) {
            this.filterBypass = new DefaultFilterBypass(this, null);
        }
        return this.filterBypass;
    }

    Position.Bias getDotBias() {
        return this.dotBias;
    }

    Position.Bias getMarkBias() {
        return this.markBias;
    }

    void changeCaretPosition(int n2, Position.Bias bias) {
        this.repaint();
        if (this.flasher != null && this.flasher.isRunning()) {
            this.visible = true;
            this.flasher.restart();
        }
        this.dot = n2;
        this.dotBias = bias;
        this.dotLTR = this.isPositionLTR(n2, bias);
        this.fireStateChanged();
        this.updateSystemSelection();
        this.setMagicCaretPosition(null);
        Runnable runnable = new Runnable(this){
            private final DefaultCaret this$0;

            public void run() {
                this.this$0.repaintNewCaret();
            }
            {
                this.this$0 = defaultCaret;
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    void handleMoveDot(int n2, Position.Bias bias) {
        Highlighter highlighter;
        this.changeCaretPosition(n2, bias);
        if (this.selectionVisible && (highlighter = this.component.getHighlighter()) != null) {
            int n3;
            int n4 = Math.min(n2, this.mark);
            if (n4 == (n3 = Math.max(n2, this.mark))) {
                if (this.selectionTag != null) {
                    highlighter.removeHighlight(this.selectionTag);
                    this.selectionTag = null;
                }
            } else {
                try {
                    if (this.selectionTag != null) {
                        highlighter.changeHighlight(this.selectionTag, n4, n3);
                    } else {
                        Highlighter.HighlightPainter highlightPainter = this.getSelectionPainter();
                        this.selectionTag = highlighter.addHighlight(n4, n3, highlightPainter);
                    }
                }
                catch (BadLocationException badLocationException) {
                    throw new StateInvariantError("Bad caret position");
                }
            }
        }
    }

    void handleSetDot(int n2, Position.Bias bias) {
        Document document = this.component.getDocument();
        if (document != null) {
            n2 = Math.min(n2, document.getLength());
        }
        if ((n2 = Math.max(n2, 0)) == 0) {
            bias = Position.Bias.Forward;
        }
        this.mark = n2;
        if (this.dot != n2 || this.dotBias != bias || this.selectionTag != null || this.forceCaretPositionChange) {
            this.changeCaretPosition(n2, bias);
        }
        this.markBias = this.dotBias;
        this.markLTR = this.dotLTR;
        Highlighter highlighter = this.component.getHighlighter();
        if (highlighter != null && this.selectionTag != null) {
            highlighter.removeHighlight(this.selectionTag);
            this.selectionTag = null;
        }
    }

    void moveDot(int n2, Position.Bias bias) {
        if (!this.component.isEnabled()) {
            this.setDot(n2, bias);
            return;
        }
        if (n2 != this.dot) {
            NavigationFilter navigationFilter = this.component.getNavigationFilter();
            if (navigationFilter != null) {
                navigationFilter.moveDot(this.getFilterBypass(), n2, bias);
            } else {
                this.handleMoveDot(n2, bias);
            }
        }
    }

    void setDot(int n2, Position.Bias bias) {
        NavigationFilter navigationFilter = this.component.getNavigationFilter();
        if (navigationFilter != null) {
            navigationFilter.setDot(this.getFilterBypass(), n2, bias);
        } else {
            this.handleSetDot(n2, bias);
        }
    }

    boolean isPositionLTR(int n2, Position.Bias bias) {
        Document document = this.component.getDocument();
        if (document instanceof AbstractDocument) {
            if (bias == Position.Bias.Backward && --n2 < 0) {
                n2 = 0;
            }
            return ((AbstractDocument)document).isLeftToRight(n2, n2);
        }
        return true;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    Position.Bias guessBiasForOffset(int n2, Position.Bias bias, boolean bl2) {
        if (bl2 != this.isPositionLTR(n2, bias)) {
            bias = Position.Bias.Backward;
        } else if (bias != Position.Bias.Backward && bl2 != this.isPositionLTR(n2, Position.Bias.Backward)) {
            bias = Position.Bias.Backward;
        }
        if (bias == Position.Bias.Backward && n2 > 0) {
            try {
                Segment segment = new Segment();
                this.component.getDocument().getText(n2 - 1, 1, segment);
                if (segment.count > 0 && segment.array[segment.offset] == '\n') {
                    bias = Position.Bias.Forward;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return bias;
    }

    private class ClipboardHandler
    implements ClipboardOwner {
        private final DefaultCaret this$0;

        private ClipboardHandler(DefaultCaret defaultCaret) {
            this.this$0 = defaultCaret;
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            if (DefaultCaret.access$200(this.this$0)) {
                DefaultCaret.access$202(this.this$0, false);
                if (this.this$0.component != null && !this.this$0.component.hasFocus()) {
                    this.this$0.setSelectionVisible(false);
                }
            }
        }

        ClipboardHandler(DefaultCaret defaultCaret, 1 var2_2) {
            this(defaultCaret);
        }
    }

    private class DefaultFilterBypass
    extends NavigationFilter.FilterBypass {
        private final DefaultCaret this$0;

        public Caret getCaret() {
            return this.this$0;
        }

        private DefaultFilterBypass(DefaultCaret defaultCaret) {
            this.this$0 = defaultCaret;
        }

        public void moveDot(int n2, Position.Bias bias) {
            this.this$0.handleMoveDot(n2, bias);
        }

        public void setDot(int n2, Position.Bias bias) {
            this.this$0.handleSetDot(n2, bias);
        }

        DefaultFilterBypass(DefaultCaret defaultCaret, 1 var2_2) {
            this(defaultCaret);
        }
    }

    private static class FocusHandler
    implements FocusListener {
        private transient FocusListener fl;

        public void focusGained(FocusEvent focusEvent) {
            this.fl.focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.fl.focusLost(focusEvent);
        }

        FocusHandler(FocusListener focusListener) {
            this.fl = focusListener;
        }
    }

    class SafeScroller
    implements Runnable {
        Rectangle r;
        private final DefaultCaret this$0;

        public void run() {
            if (this.this$0.component != null) {
                this.this$0.component.scrollRectToVisible(this.r);
            }
        }

        SafeScroller(DefaultCaret defaultCaret, Rectangle rectangle) {
            this.this$0 = defaultCaret;
            this.r = rectangle;
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener,
    ActionListener {
        private final DefaultCaret this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (!(this.this$0.visible || this.this$0.width != 0 && this.this$0.height != 0 || this.this$0.component == null)) {
                TextUI textUI = this.this$0.component.getUI();
                try {
                    Rectangle rectangle = textUI.modelToView(this.this$0.component, this.this$0.dot, this.this$0.dotBias);
                    if (rectangle != null && rectangle.width != 0 && rectangle.height != 0) {
                        this.this$0.setVisible(true);
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.this$0.visible = !this.this$0.visible;
            this.this$0.repaint();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object instanceof Document || object2 instanceof Document) {
                this.this$0.setDot(0);
                if (object != null) {
                    ((Document)object).removeDocumentListener(this);
                }
                if (object2 != null) {
                    ((Document)object2).addDocumentListener(this);
                }
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.this$0.async || SwingUtilities.isEventDispatchThread()) {
                int n2;
                boolean bl2 = false;
                int n3 = documentEvent.getOffset();
                int n4 = documentEvent.getLength();
                int n5 = this.this$0.dot;
                short s2 = 0;
                if (n5 >= n3) {
                    n5 += n4;
                    s2 = (short)(s2 | 1);
                }
                if ((n2 = this.this$0.mark) >= n3) {
                    n2 += n4;
                    s2 = (short)(s2 | 2);
                }
                if (s2 != 0) {
                    Position.Bias bias = this.this$0.dotBias;
                    if (this.this$0.dot == n3) {
                        boolean bl3;
                        Document document = this.this$0.component.getDocument();
                        try {
                            Segment segment = new Segment();
                            document.getText(n5 - 1, 1, segment);
                            bl3 = segment.count > 0 && segment.array[segment.offset] == '\n';
                        }
                        catch (BadLocationException badLocationException) {
                            bl3 = false;
                        }
                        bias = bl3 ? Position.Bias.Forward : Position.Bias.Backward;
                    }
                    if (n2 == n5) {
                        this.this$0.setDot(n5, bias);
                        DefaultCaret.access$300(this.this$0);
                    } else {
                        this.this$0.setDot(n2, this.this$0.markBias);
                        if (this.this$0.getDot() == n2) {
                            this.this$0.moveDot(n5, bias);
                        }
                        DefaultCaret.access$300(this.this$0);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.this$0.async || SwingUtilities.isEventDispatchThread()) {
                boolean bl2 = false;
                int n2 = documentEvent.getOffset();
                int n3 = n2 + documentEvent.getLength();
                int n4 = this.this$0.dot;
                boolean bl3 = false;
                if (n4 >= n3) {
                    if ((n4 -= n3 - n2) == n3) {
                        bl3 = true;
                    }
                } else if (n4 >= n2) {
                    n4 = n2;
                    bl3 = true;
                }
                int n5 = this.this$0.mark;
                boolean bl4 = false;
                if (n5 >= n3) {
                    if ((n5 -= n3 - n2) == n3) {
                        bl4 = true;
                    }
                } else if (n5 >= n2) {
                    n5 = n2;
                    bl4 = true;
                }
                if (n5 == n4) {
                    DefaultCaret.access$402(this.this$0, true);
                    try {
                        this.this$0.setDot(n4, this.this$0.guessBiasForOffset(n4, this.this$0.dotBias, this.this$0.dotLTR));
                    }
                    finally {
                        DefaultCaret.access$402(this.this$0, false);
                    }
                    DefaultCaret.access$300(this.this$0);
                } else {
                    Position.Bias bias = this.this$0.dotBias;
                    Position.Bias bias2 = this.this$0.markBias;
                    if (bl3) {
                        bias = this.this$0.guessBiasForOffset(n4, bias, this.this$0.dotLTR);
                    }
                    if (bl4) {
                        bias2 = this.this$0.guessBiasForOffset(this.this$0.mark, bias2, this.this$0.markLTR);
                    }
                    this.this$0.setDot(n5, bias2);
                    if (this.this$0.getDot() == n5) {
                        this.this$0.moveDot(n4, bias);
                    }
                    DefaultCaret.access$300(this.this$0);
                }
            }
        }

        UpdateHandler(DefaultCaret defaultCaret) {
            this.this$0 = defaultCaret;
        }
    }
}

