/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.text.CharacterIterator;

public class Segment
implements Cloneable,
CharacterIterator {
    public char[] array;
    public int offset;
    public int count;
    private boolean partialReturn;
    private int pos;

    public char current() {
        if (this.count != 0 && this.pos < this.offset + this.count) {
            return this.array[this.pos];
        }
        return '\uffff';
    }

    public char first() {
        this.pos = this.offset;
        if (this.count != 0) {
            return this.array[this.pos];
        }
        return '\uffff';
    }

    public char last() {
        this.pos = this.offset + this.count;
        if (this.count != 0) {
            --this.pos;
            return this.array[this.pos];
        }
        return '\uffff';
    }

    public char next() {
        ++this.pos;
        int n2 = this.offset + this.count;
        if (this.pos >= n2) {
            this.pos = n2;
            return '\uffff';
        }
        return this.current();
    }

    public char previous() {
        if (this.pos == this.offset) {
            return '\uffff';
        }
        --this.pos;
        return this.current();
    }

    public int getBeginIndex() {
        return this.offset;
    }

    public int getEndIndex() {
        return this.offset + this.count;
    }

    public int getIndex() {
        return this.pos;
    }

    public Segment() {
        this(null, 0, 0);
    }

    public boolean isPartialReturn() {
        return this.partialReturn;
    }

    public char setIndex(int n2) {
        int n3 = this.offset + this.count;
        if (n2 < this.offset || n2 > n3) {
            throw new IllegalArgumentException("bad position: " + n2);
        }
        this.pos = n2;
        if (this.pos != n3 && this.count != 0) {
            return this.array[this.pos];
        }
        return '\uffff';
    }

    public void setPartialReturn(boolean bl2) {
        this.partialReturn = bl2;
    }

    public Segment(char[] cArray, int n2, int n3) {
        this.array = cArray;
        this.offset = n2;
        this.count = n3;
        this.partialReturn = false;
    }

    public Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            object = null;
        }
        return object;
    }

    public String toString() {
        if (this.array != null) {
            return new String(this.array, this.offset, this.count);
        }
        return new String();
    }
}

