/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.ClipboardTransferable;
import sun.awt.datatransfer.TransferableProxy;

public abstract class SunClipboard
extends Clipboard
implements PropertyChangeListener {
    public static final FlavorTable flavorMap = (FlavorTable)SystemFlavorMap.getDefaultFlavorMap();
    private AppContext contentsContext = null;

    public abstract long getID();

    protected abstract void clearNativeContext();

    public void closeClipboard() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initContext() {
        AppContext appContext = AppContext.getAppContext();
        if (this.contentsContext != appContext) {
            AppContext appContext2 = appContext;
            synchronized (appContext2) {
                if (appContext.isDisposed()) {
                    throw new IllegalStateException("Can't set contents from disposed AppContext");
                }
                appContext.addPropertyChangeListener("disposed", this);
            }
            if (this.contentsContext != null) {
                this.contentsContext.removePropertyChangeListener("disposed", this);
            }
            this.contentsContext = appContext;
        }
    }

    protected void lostOwnershipImpl() {
        this.lostOwnershipLater(null);
    }

    protected abstract void setContentsNative(Transferable var1);

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("disposed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
            AppContext appContext = (AppContext)propertyChangeEvent.getSource();
            this.lostOwnershipLater(appContext);
        }
    }

    public SunClipboard(String string) {
        super(string);
    }

    protected void lostOwnershipLater(AppContext appContext) {
        AppContext appContext2 = this.contentsContext;
        if (appContext2 == null) {
            return;
        }
        Runnable runnable = new Runnable(this, appContext){
            private final AppContext val$disposedContext;
            private final SunClipboard this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SunClipboard sunClipboard = this.this$0;
                ClipboardOwner clipboardOwner = null;
                Transferable transferable = null;
                SunClipboard sunClipboard2 = sunClipboard;
                synchronized (sunClipboard2) {
                    AppContext appContext = SunClipboard.access$000(sunClipboard);
                    if (appContext == null) {
                        return;
                    }
                    if (this.val$disposedContext != null && appContext != this.val$disposedContext) {
                        return;
                    }
                    clipboardOwner = SunClipboard.access$100(sunClipboard);
                    transferable = SunClipboard.access$200(sunClipboard);
                    SunClipboard.access$002(sunClipboard, null);
                    SunClipboard.access$302(sunClipboard, null);
                    SunClipboard.access$402(sunClipboard, null);
                    sunClipboard.clearNativeContext();
                    appContext.removePropertyChangeListener("disposed", sunClipboard);
                }
                if (clipboardOwner != null) {
                    clipboardOwner.lostOwnership(sunClipboard, transferable);
                }
            }
            {
                this.this$0 = sunClipboard;
                this.val$disposedContext = appContext;
            }
        };
        SunToolkit.postEvent(appContext2, new PeerEvent(this, runnable, 1L));
    }

    public void openClipboard(SunClipboard sunClipboard) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        if (transferable == null) {
            throw new NullPointerException("contents");
        }
        this.initContext();
        ClipboardOwner clipboardOwner2 = this.owner;
        Transferable transferable2 = this.contents;
        try {
            this.owner = clipboardOwner;
            this.contents = new TransferableProxy(transferable, true);
            this.setContentsNative(transferable);
            Object var6_5 = null;
            if (clipboardOwner2 != null && clipboardOwner2 != clipboardOwner) {
                clipboardOwner2.lostOwnership(this, transferable2);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (clipboardOwner2 != null && clipboardOwner2 != clipboardOwner) {
                clipboardOwner2.lostOwnership(this, transferable2);
            }
            throw throwable;
        }
    }

    static ClipboardOwner access$100(SunClipboard sunClipboard) {
        return sunClipboard.owner;
    }

    public synchronized Transferable getContents(Object object) {
        if (this.contents != null) {
            return this.contents;
        }
        return new ClipboardTransferable(this);
    }

    static Transferable access$200(SunClipboard sunClipboard) {
        return sunClipboard.contents;
    }

    static AppContext access$000(SunClipboard sunClipboard) {
        return sunClipboard.contentsContext;
    }

    static ClipboardOwner access$302(SunClipboard sunClipboard, ClipboardOwner clipboardOwner) {
        sunClipboard.owner = clipboardOwner;
        return sunClipboard.owner;
    }

    static Transferable access$402(SunClipboard sunClipboard, Transferable transferable) {
        sunClipboard.contents = transferable;
        return sunClipboard.contents;
    }

    static AppContext access$002(SunClipboard sunClipboard, AppContext appContext) {
        sunClipboard.contentsContext = appContext;
        return sunClipboard.contentsContext;
    }
}

