/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.dnd.SunDropTargetEvent;

public abstract class SunDropTargetContextPeer
implements DropTargetContextPeer,
Transferable {
    private DropTarget currentDT;
    private DropTargetContext currentDTC;
    private long[] currentT;
    private int currentA;
    private int currentSA;
    private int currentDA;
    private int previousDA;
    private long nativeDragContext;
    private Transferable local;
    private boolean dragRejected = false;
    protected int dropStatus = 0;
    protected boolean dropComplete = false;
    protected static final Object _globalLock = new Object();
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$dnd$SunDropTargetContextPeer == null ? (class$sun$awt$dnd$SunDropTargetContextPeer = SunDropTargetContextPeer.class$("sun.awt.dnd.SunDropTargetContextPeer")) : class$sun$awt$dnd$SunDropTargetContextPeer);
    protected static Transferable currentJVMLocalSourceTransferable = null;
    protected static final int STATUS_NONE = 0;
    protected static final int STATUS_WAIT = 1;
    protected static final int STATUS_ACCEPT = 2;
    protected static final int STATUS_REJECT = -1;
    static Class class$sun$awt$dnd$SunDropTargetContextPeer;

    public int getTargetActions() {
        return this.currentA;
    }

    protected synchronized long getNativeDragContext() {
        return this.nativeDragContext;
    }

    public synchronized void rejectDrag() {
        if (this.currentDT == null) {
            throw new InvalidDnDOperationException("No Drag pending");
        }
        this.currentDA = 0;
        this.dragRejected = true;
    }

    public synchronized void rejectDrop() {
        if (this.dropStatus != 1) {
            throw new InvalidDnDOperationException("invalid rejectDrop()");
        }
        this.dropStatus = -1;
        this.currentDA = 0;
        this.dropComplete(false);
    }

    public boolean isTransferableJVMLocal() {
        return this.local != null || SunDropTargetContextPeer.getJVMLocalSourceTransferable() != null;
    }

    private int mapOperation(int n2) {
        int[] nArray = new int[]{2, 1, 0x40000000};
        int n3 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if ((n2 & nArray[i2]) != nArray[i2]) continue;
            n3 = nArray[i2];
            break;
        }
        return n3;
    }

    public synchronized void acceptDrag(int n2) {
        if (this.currentDT == null) {
            throw new InvalidDnDOperationException("No Drag pending");
        }
        this.currentDA = this.mapOperation(n2);
        if (this.currentDA != 0) {
            this.dragRejected = false;
        }
    }

    public synchronized void acceptDrop(int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("invalid acceptDrop() action");
        }
        if (this.dropStatus != 1) {
            throw new InvalidDnDOperationException("invalid acceptDrop()");
        }
        this.currentDA = this.currentA = this.mapOperation(n2 & this.currentSA);
        this.dropStatus = 2;
        this.dropComplete = false;
    }

    public synchronized void setTargetActions(int n2) {
        this.currentA = n2 & 0x40000003;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dropComplete(boolean bl2) {
        if (this.dropStatus == 0) {
            throw new InvalidDnDOperationException("No Drop pending");
        }
        if (this.currentDTC != null) {
            this.currentDTC.removeNotify();
        }
        this.currentDT = null;
        this.currentDTC = null;
        this.currentT = null;
        this.currentA = 0;
        Object object = _globalLock;
        synchronized (object) {
            currentJVMLocalSourceTransferable = null;
        }
        this.dropStatus = 0;
        this.dropComplete = true;
        this.doDropDone(bl2, this.currentDA, this.local != null);
        this.currentDA = 0;
        this.nativeDragContext = 0L;
    }

    protected abstract void doDropDone(boolean var1, int var2, boolean var3);

    private int handleEnterMessage(Component component, int n2, int n3, int n4, int n5, long[] lArray, long l2) {
        EventDispatcher eventDispatcher = new EventDispatcher(this, n4, n5, lArray, l2, true);
        SunDropTargetEvent sunDropTargetEvent = new SunDropTargetEvent(component, 504, n2, n3, eventDispatcher);
        DataTransferer.getInstance().getToolkitThreadBlockedHandler().lock();
        SunToolkit.postEvent(SunToolkit.targetToAppContext(component), sunDropTargetEvent);
        while (!eventDispatcher.isDone()) {
            DataTransferer.getInstance().getToolkitThreadBlockedHandler().enter();
        }
        DataTransferer.getInstance().getToolkitThreadBlockedHandler().unlock();
        return eventDispatcher.getReturnValue();
    }

    private int handleMotionMessage(Component component, int n2, int n3, int n4, int n5, long[] lArray, long l2) {
        EventDispatcher eventDispatcher = new EventDispatcher(this, n4, n5, lArray, l2, true);
        SunDropTargetEvent sunDropTargetEvent = new SunDropTargetEvent(component, 506, n2, n3, eventDispatcher);
        DataTransferer.getInstance().getToolkitThreadBlockedHandler().lock();
        SunToolkit.postEvent(SunToolkit.targetToAppContext(component), sunDropTargetEvent);
        while (!eventDispatcher.isDone()) {
            DataTransferer.getInstance().getToolkitThreadBlockedHandler().enter();
        }
        DataTransferer.getInstance().getToolkitThreadBlockedHandler().unlock();
        return eventDispatcher.getReturnValue();
    }

    private void handleDropMessage(Component component, int n2, int n3, int n4, int n5, long[] lArray, long l2) {
        EventDispatcher eventDispatcher = new EventDispatcher(this, n4, n5, lArray, l2, false);
        SunDropTargetEvent sunDropTargetEvent = new SunDropTargetEvent(component, 502, n2, n3, eventDispatcher);
        SunToolkit.postEvent(SunToolkit.targetToAppContext(component), sunDropTargetEvent);
    }

    private void handleExitMessage(Component component, long l2) {
        EventDispatcher eventDispatcher = new EventDispatcher(this, l2, true);
        SunDropTargetEvent sunDropTargetEvent = new SunDropTargetEvent(component, 505, 0, 0, eventDispatcher);
        DataTransferer.getInstance().getToolkitThreadBlockedHandler().lock();
        SunToolkit.postEvent(SunToolkit.targetToAppContext(component), sunDropTargetEvent);
        while (!eventDispatcher.isDone()) {
            DataTransferer.getInstance().getToolkitThreadBlockedHandler().enter();
        }
        DataTransferer.getInstance().getToolkitThreadBlockedHandler().unlock();
    }

    public DataFlavor[] getTransferDataFlavors() {
        Transferable transferable = this.local;
        if (transferable != null) {
            return transferable.getTransferDataFlavors();
        }
        return DataTransferer.getInstance().getFlavorsForFormatsAsArray(this.currentT, DataTransferer.adaptFlavorMap(this.currentDT.getFlavorMap()));
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        Transferable transferable = this.local;
        if (transferable != null) {
            return transferable.isDataFlavorSupported(dataFlavor);
        }
        return DataTransferer.getInstance().getFlavorsForFormats(this.currentT, DataTransferer.adaptFlavorMap(this.currentDT.getFlavorMap())).containsKey(dataFlavor);
    }

    private static Transferable getJVMLocalSourceTransferable() {
        return currentJVMLocalSourceTransferable;
    }

    public Transferable getTransferable() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentJVMLocalSourceTransferable(Transferable transferable) throws InvalidDnDOperationException {
        Object object = _globalLock;
        synchronized (object) {
            if (transferable != null && currentJVMLocalSourceTransferable != null) {
                throw new InvalidDnDOperationException();
            }
            currentJVMLocalSourceTransferable = transferable;
        }
    }

    public DropTarget getDropTarget() {
        return this.currentDT;
    }

    protected abstract Object getNativeData(long var1);

    static DebugHelper access$900() {
        return dbg;
    }

    static int access$000(SunDropTargetContextPeer sunDropTargetContextPeer) {
        return sunDropTargetContextPeer.previousDA;
    }

    static int access$400(SunDropTargetContextPeer sunDropTargetContextPeer) {
        return sunDropTargetContextPeer.currentDA;
    }

    static int access$002(SunDropTargetContextPeer sunDropTargetContextPeer, int n2) {
        sunDropTargetContextPeer.previousDA = n2;
        return sunDropTargetContextPeer.previousDA;
    }

    static int access$302(SunDropTargetContextPeer sunDropTargetContextPeer, int n2) {
        sunDropTargetContextPeer.currentSA = n2;
        return sunDropTargetContextPeer.currentSA;
    }

    static int access$402(SunDropTargetContextPeer sunDropTargetContextPeer, int n2) {
        sunDropTargetContextPeer.currentDA = n2;
        return sunDropTargetContextPeer.currentDA;
    }

    static long access$102(SunDropTargetContextPeer sunDropTargetContextPeer, long l2) {
        sunDropTargetContextPeer.nativeDragContext = l2;
        return sunDropTargetContextPeer.nativeDragContext;
    }

    static long[] access$202(SunDropTargetContextPeer sunDropTargetContextPeer, long[] lArray) {
        sunDropTargetContextPeer.currentT = lArray;
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processDropMessage(SunDropTargetEvent sunDropTargetEvent) {
        Component component = (Component)sunDropTargetEvent.getSource();
        Point point = sunDropTargetEvent.getPoint();
        DropTarget dropTarget = component.getDropTarget();
        this.dropStatus = 1;
        this.dropComplete = false;
        if (component.isShowing() && dropTarget != null && dropTarget.isActive()) {
            DropTargetContext dropTargetContext = dropTarget.getDropTargetContext();
            this.currentDT = dropTarget;
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentDTC = dropTargetContext;
            this.currentDTC.addNotify(this);
            this.currentA = dropTarget.getDefaultActions();
            Object object = _globalLock;
            synchronized (object) {
                this.local = SunDropTargetContextPeer.getJVMLocalSourceTransferable();
                if (this.local != null) {
                    SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
                }
            }
            try {
                dropTarget.drop(new DropTargetDropEvent(dropTargetContext, point, this.currentDA, this.currentSA, this.local != null));
                Object var9_8 = null;
                if (this.dropStatus == 1) {
                    this.rejectDrop();
                    return;
                }
                if (this.dropComplete) return;
                this.dropComplete(false);
                return;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (this.dropStatus == 1) {
                    this.rejectDrop();
                    throw throwable;
                } else {
                    if (this.dropComplete) throw throwable;
                    this.dropComplete(false);
                }
                throw throwable;
            }
        }
        this.rejectDrop();
    }

    private void processEnterMessage(SunDropTargetEvent sunDropTargetEvent) {
        Component component = (Component)sunDropTargetEvent.getSource();
        DropTarget dropTarget = component.getDropTarget();
        Point point = sunDropTargetEvent.getPoint();
        this.local = SunDropTargetContextPeer.getJVMLocalSourceTransferable();
        if (this.currentDTC != null) {
            this.currentDTC.removeNotify();
            this.currentDTC = null;
        }
        if (component.isShowing() && dropTarget != null && dropTarget.isActive()) {
            this.currentDT = dropTarget;
            this.currentDTC = this.currentDT.getDropTargetContext();
            this.currentDTC.addNotify(this);
            this.currentA = dropTarget.getDefaultActions();
            try {
                dropTarget.dragEnter(new DropTargetDragEvent(this.currentDTC, point, this.currentDA, this.currentSA));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.currentDA = 0;
            }
        } else {
            this.currentDT = null;
            this.currentDTC = null;
            this.currentDA = 0;
            this.currentSA = 0;
            this.currentA = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExitMessage(SunDropTargetEvent sunDropTargetEvent) {
        Component component = (Component)sunDropTargetEvent.getSource();
        DropTarget dropTarget = component.getDropTarget();
        DropTargetContext dropTargetContext = null;
        if (dropTarget == null) {
            this.currentDT = null;
            this.currentT = null;
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentDTC = null;
            return;
        }
        if (dropTarget != this.currentDT) {
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentDT = dropTarget;
            this.currentDTC = dropTarget.getDropTargetContext();
            this.currentDTC.addNotify(this);
        }
        dropTargetContext = this.currentDTC;
        if (dropTarget.isActive()) {
            try {
                try {
                    dropTarget.dragExit(new DropTargetEvent(dropTargetContext));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var7_6 = null;
                    this.currentA = 0;
                    this.currentSA = 0;
                    this.currentDA = 0;
                    this.currentDT = null;
                    this.currentT = null;
                    this.currentDTC.removeNotify();
                    this.currentDTC = null;
                    this.local = null;
                    this.dragRejected = false;
                }
                Object var7_5 = null;
                this.currentA = 0;
                this.currentSA = 0;
                this.currentDA = 0;
                this.currentDT = null;
                this.currentT = null;
                this.currentDTC.removeNotify();
                this.currentDTC = null;
                this.local = null;
                this.dragRejected = false;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.currentA = 0;
                this.currentSA = 0;
                this.currentDA = 0;
                this.currentDT = null;
                this.currentT = null;
                this.currentDTC.removeNotify();
                this.currentDTC = null;
                this.local = null;
                this.dragRejected = false;
                throw throwable;
            }
        }
    }

    private void processMotionMessage(SunDropTargetEvent sunDropTargetEvent, boolean bl2) {
        Component component = (Component)sunDropTargetEvent.getSource();
        Point point = sunDropTargetEvent.getPoint();
        int n2 = sunDropTargetEvent.getID();
        DropTarget dropTarget = component.getDropTarget();
        DropTargetContext dropTargetContext = null;
        if (component.isShowing() && dropTarget != null && dropTarget.isActive()) {
            if (this.currentDT != dropTarget) {
                if (this.currentDTC != null) {
                    this.currentDTC.removeNotify();
                }
                this.currentDT = dropTarget;
                this.currentDTC = null;
            }
            if ((dropTargetContext = this.currentDT.getDropTargetContext()) != this.currentDTC) {
                if (this.currentDTC != null) {
                    this.currentDTC.removeNotify();
                }
                this.currentDTC = dropTargetContext;
                this.currentDTC.addNotify(this);
            }
            this.currentA = this.currentDT.getDefaultActions();
            try {
                DropTargetDragEvent dropTargetDragEvent = new DropTargetDragEvent(dropTargetContext, point, this.currentDA, this.currentSA);
                DropTarget dropTarget2 = dropTarget;
                if (bl2) {
                    dropTarget2.dropActionChanged(dropTargetDragEvent);
                } else {
                    dropTarget2.dragOver(dropTargetDragEvent);
                }
                if (this.dragRejected) {
                    this.currentDA = 0;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.currentDA = 0;
            }
        } else {
            this.currentDA = 0;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException, InvalidDnDOperationException {
        Long l2 = null;
        Transferable transferable = this.local;
        if (transferable != null) {
            return transferable.getTransferData(dataFlavor);
        }
        if (this.dropStatus != 2 || this.dropComplete) {
            throw new InvalidDnDOperationException("No drop current");
        }
        Map map = DataTransferer.getInstance().getFlavorsForFormats(this.currentT, DataTransferer.adaptFlavorMap(this.currentDT.getFlavorMap()));
        l2 = (Long)map.get(dataFlavor);
        if (l2 == null) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (dataFlavor.isRepresentationClassRemote() && this.currentDA != 0x40000000) {
            throw new InvalidDnDOperationException("only ACTION_LINK is permissable for transfer of java.rmi.Remote objects");
        }
        long l3 = l2;
        Object object = this.getNativeData(l3);
        if (object instanceof byte[]) {
            try {
                return DataTransferer.getInstance().translateBytes((byte[])object, dataFlavor, l3, this);
            }
            catch (IOException iOException) {
                throw new InvalidDnDOperationException(iOException.getMessage());
            }
        }
        if (object instanceof InputStream) {
            try {
                return DataTransferer.getInstance().translateStream((InputStream)object, dataFlavor, l3, this);
            }
            catch (IOException iOException) {
                throw new InvalidDnDOperationException(iOException.getMessage());
            }
        }
        throw new IOException("no native data was transfered");
    }

    static void access$500(SunDropTargetContextPeer sunDropTargetContextPeer, SunDropTargetEvent sunDropTargetEvent) {
        sunDropTargetContextPeer.processEnterMessage(sunDropTargetEvent);
    }

    static void access$700(SunDropTargetContextPeer sunDropTargetContextPeer, SunDropTargetEvent sunDropTargetEvent) {
        sunDropTargetContextPeer.processExitMessage(sunDropTargetEvent);
    }

    static void access$800(SunDropTargetContextPeer sunDropTargetContextPeer, SunDropTargetEvent sunDropTargetEvent) {
        sunDropTargetContextPeer.processDropMessage(sunDropTargetEvent);
    }

    static void access$600(SunDropTargetContextPeer sunDropTargetContextPeer, SunDropTargetEvent sunDropTargetEvent, boolean bl2) {
        sunDropTargetContextPeer.processMotionMessage(sunDropTargetEvent, bl2);
    }

    static class EventDispatcher {
        private final SunDropTargetContextPeer peer;
        private final int dropAction;
        private final int actions;
        private final long[] formats;
        private final long nativeCtxt;
        private final boolean exitBlockedMode;
        private int returnValue = 0;
        private final HashSet eventSet = new HashSet(3);
        static final boolean EXIT_BLOCKED_MODE = true;
        static final ToolkitThreadBlockedHandler handler = DataTransferer.getInstance().getToolkitThreadBlockedHandler();

        int getReturnValue() {
            return this.returnValue;
        }

        boolean isDone() {
            return this.eventSet.isEmpty();
        }

        void setReturnValue(int n2) {
            this.returnValue = n2;
        }

        EventDispatcher(SunDropTargetContextPeer sunDropTargetContextPeer, int n2, int n3, long[] lArray, long l2, boolean bl2) {
            this.peer = sunDropTargetContextPeer;
            this.nativeCtxt = l2;
            this.dropAction = n2;
            this.actions = n3;
            this.formats = lArray;
            this.exitBlockedMode = bl2;
        }

        EventDispatcher(SunDropTargetContextPeer sunDropTargetContextPeer, long l2, boolean bl2) {
            this.peer = sunDropTargetContextPeer;
            this.nativeCtxt = l2;
            this.dropAction = 0;
            this.actions = 0;
            this.formats = null;
            this.exitBlockedMode = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchDropEvent(SunDropTargetEvent sunDropTargetEvent) {
            SunDropTargetContextPeer sunDropTargetContextPeer = this.peer;
            synchronized (sunDropTargetContextPeer) {
                SunDropTargetContextPeer.access$102(this.peer, this.nativeCtxt);
                SunDropTargetContextPeer.access$202(this.peer, this.formats);
                SunDropTargetContextPeer.access$302(this.peer, this.actions);
                SunDropTargetContextPeer.access$402(this.peer, this.dropAction);
                SunDropTargetContextPeer.access$800(this.peer, sunDropTargetEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchEnterEvent(SunDropTargetEvent sunDropTargetEvent) {
            SunDropTargetContextPeer sunDropTargetContextPeer = this.peer;
            synchronized (sunDropTargetContextPeer) {
                SunDropTargetContextPeer.access$002(this.peer, this.dropAction);
                SunDropTargetContextPeer.access$102(this.peer, this.nativeCtxt);
                SunDropTargetContextPeer.access$202(this.peer, this.formats);
                SunDropTargetContextPeer.access$302(this.peer, this.actions);
                SunDropTargetContextPeer.access$402(this.peer, this.dropAction);
                SunDropTargetContextPeer.access$500(this.peer, sunDropTargetEvent);
                this.setReturnValue(SunDropTargetContextPeer.access$400(this.peer));
            }
        }

        void dispatchEvent(SunDropTargetEvent sunDropTargetEvent) {
            int n2 = sunDropTargetEvent.getID();
            switch (n2) {
                case 504: {
                    this.dispatchEnterEvent(sunDropTargetEvent);
                    break;
                }
                case 506: {
                    this.dispatchMotionEvent(sunDropTargetEvent);
                    break;
                }
                case 505: {
                    this.dispatchExitEvent(sunDropTargetEvent);
                    break;
                }
                case 502: {
                    this.dispatchDropEvent(sunDropTargetEvent);
                    break;
                }
                default: {
                    throw new InvalidDnDOperationException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchExitEvent(SunDropTargetEvent sunDropTargetEvent) {
            SunDropTargetContextPeer sunDropTargetContextPeer = this.peer;
            synchronized (sunDropTargetContextPeer) {
                SunDropTargetContextPeer.access$102(this.peer, this.nativeCtxt);
                SunDropTargetContextPeer.access$700(this.peer, sunDropTargetEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchMotionEvent(SunDropTargetEvent sunDropTargetEvent) {
            SunDropTargetContextPeer sunDropTargetContextPeer = this.peer;
            synchronized (sunDropTargetContextPeer) {
                boolean bl2 = SunDropTargetContextPeer.access$000(this.peer) != this.dropAction;
                SunDropTargetContextPeer.access$002(this.peer, this.dropAction);
                SunDropTargetContextPeer.access$102(this.peer, this.nativeCtxt);
                SunDropTargetContextPeer.access$202(this.peer, this.formats);
                SunDropTargetContextPeer.access$302(this.peer, this.actions);
                SunDropTargetContextPeer.access$402(this.peer, this.dropAction);
                SunDropTargetContextPeer.access$600(this.peer, sunDropTargetEvent, bl2);
                this.setReturnValue(SunDropTargetContextPeer.access$400(this.peer));
            }
        }

        void registerEvent(SunDropTargetEvent sunDropTargetEvent) {
            if (this.exitBlockedMode) {
                handler.lock();
                if (!this.eventSet.add(sunDropTargetEvent)) {
                    SunDropTargetContextPeer.access$900();
                }
                handler.unlock();
            }
        }

        void unregisterEvent(SunDropTargetEvent sunDropTargetEvent) {
            if (this.exitBlockedMode) {
                handler.lock();
                this.eventSet.remove(sunDropTargetEvent);
                if (this.eventSet.isEmpty()) {
                    handler.exit();
                }
                handler.unlock();
            }
        }
    }
}

