/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import sun.awt.font.StandardGlyphVector;
import sun.java2d.loops.FontInfo;

public final class GlyphList {
    private static final int MINGRAYLENGTH = 1024;
    private static final int MAXGRAYLENGTH = 8192;
    long pData;
    int glyphindex;
    int[] metrics;
    byte[] graybits;
    private static GlyphList saved;
    static Class class$sun$awt$font$NativeFontWrapper;

    public native int getNumGlyphs();

    public long getPeer() {
        return this.pData;
    }

    static {
        GlyphList.initIDs();
    }

    private GlyphList() {
    }

    private native void discardData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class clazz = class$sun$awt$font$NativeFontWrapper == null ? (class$sun$awt$font$NativeFontWrapper = GlyphList.class$("sun.awt.font.NativeFontWrapper")) : class$sun$awt$font$NativeFontWrapper;
        synchronized (clazz) {
            this.discardData();
            if (this.graybits != null && this.graybits.length > 8192) {
                this.graybits = null;
            }
            saved = this;
        }
    }

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getGrayBits() {
        int n2 = this.metrics[2] * this.metrics[3];
        if (this.graybits == null) {
            this.graybits = new byte[Math.max(n2, 1024)];
        } else if (n2 > this.graybits.length) {
            this.graybits = new byte[n2];
        }
        Class clazz = class$sun$awt$font$NativeFontWrapper == null ? (class$sun$awt$font$NativeFontWrapper = GlyphList.class$("sun.awt.font.NativeFontWrapper")) : class$sun$awt$font$NativeFontWrapper;
        synchronized (clazz) {
            this.fillGrayBits(this.glyphindex, this.graybits);
        }
        return this.graybits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getBounds() {
        if (this.glyphindex >= 0) {
            throw new InternalError("calling getBounds after setGlyphIndex");
        }
        if (this.metrics == null) {
            this.metrics = new int[4];
        }
        Class clazz = class$sun$awt$font$NativeFontWrapper == null ? (class$sun$awt$font$NativeFontWrapper = GlyphList.class$("sun.awt.font.NativeFontWrapper")) : class$sun$awt$font$NativeFontWrapper;
        synchronized (clazz) {
            this.fillBounds(this.metrics);
        }
        return this.metrics;
    }

    public int[] getMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlyphIndex(int n2) {
        this.glyphindex = n2;
        if (this.metrics == null) {
            this.metrics = new int[4];
        }
        Class clazz = class$sun$awt$font$NativeFontWrapper == null ? (class$sun$awt$font$NativeFontWrapper = GlyphList.class$("sun.awt.font.NativeFontWrapper")) : class$sun$awt$font$NativeFontWrapper;
        synchronized (clazz) {
            this.fillMetrics(n2, this.metrics);
        }
    }

    private native void fillGrayBits(int var1, byte[] var2);

    private native void fillMetrics(int var1, int[] var2);

    private native void fillBounds(int[] var1);

    private native void setupByteData(byte[] var1, int var2, int var3, Font var4, float var5, float var6, double[] var7, boolean var8, boolean var9);

    private native void setupCharData(char[] var1, int var2, int var3, Font var4, float var5, float var6, double[] var7, boolean var8, boolean var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlyphList getInstance() {
        Class clazz = class$sun$awt$font$NativeFontWrapper == null ? (class$sun$awt$font$NativeFontWrapper = GlyphList.class$("sun.awt.font.NativeFontWrapper")) : class$sun$awt$font$NativeFontWrapper;
        synchronized (clazz) {
            GlyphList glyphList = saved;
            if (glyphList == null) {
                glyphList = new GlyphList();
            } else {
                saved = null;
            }
            return glyphList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromBytes(FontInfo fontInfo, byte[] byArray, int n2, int n3, float f2, float f3) {
        Class clazz = class$sun$awt$font$NativeFontWrapper == null ? (class$sun$awt$font$NativeFontWrapper = GlyphList.class$("sun.awt.font.NativeFontWrapper")) : class$sun$awt$font$NativeFontWrapper;
        synchronized (clazz) {
            this.setupByteData(byArray, n2, n3, fontInfo.font, f2, f3, fontInfo.glyphTx, fontInfo.doAntiAlias, fontInfo.doFractEnable);
            this.glyphindex = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromChars(FontInfo fontInfo, char[] cArray, int n2, int n3, float f2, float f3) {
        Class clazz = class$sun$awt$font$NativeFontWrapper == null ? (class$sun$awt$font$NativeFontWrapper = GlyphList.class$("sun.awt.font.NativeFontWrapper")) : class$sun$awt$font$NativeFontWrapper;
        synchronized (clazz) {
            this.setupCharData(cArray, n2, n3, fontInfo.font, f2, f3, fontInfo.glyphTx, fontInfo.doAntiAlias, fontInfo.doFractEnable);
            this.glyphindex = -1;
        }
    }

    private native void setupGlyphData(GlyphVector var1, Font var2, float var3, float var4, double[] var5, double[] var6, boolean var7, boolean var8);

    private native void setupStringData(String var1, Font var2, float var3, float var4, double[] var5, boolean var6, boolean var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromGlyphVector(FontInfo fontInfo, GlyphVector glyphVector, float f2, float f3) {
        Object object;
        double[] dArray = null;
        FontRenderContext fontRenderContext = glyphVector.getFontRenderContext();
        boolean bl2 = fontRenderContext.isAntiAliased();
        boolean bl3 = fontRenderContext.usesFractionalMetrics();
        try {
            object = (StandardGlyphVector)glyphVector;
            dArray = ((StandardGlyphVector)object).fontTX;
        }
        catch (ClassCastException classCastException) {
            dArray = new double[6];
            double d2 = fontInfo.font.getSize2D();
            if (fontInfo.font.isTransformed()) {
                fontInfo.font.getTransform().getMatrix(dArray);
                int n2 = 0;
                while (n2 < dArray.length) {
                    int n3 = n2++;
                    dArray[n3] = dArray[n3] * d2;
                }
            }
            dArray[0] = dArray[3] = d2;
        }
        object = class$sun$awt$font$NativeFontWrapper == null ? (class$sun$awt$font$NativeFontWrapper = GlyphList.class$("sun.awt.font.NativeFontWrapper")) : class$sun$awt$font$NativeFontWrapper;
        synchronized (object) {
            this.setupGlyphData(glyphVector, fontInfo.font, f2, f3, dArray, fontInfo.devTx, bl2, bl3);
            this.glyphindex = -1;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromString(FontInfo fontInfo, String string, float f2, float f3) {
        Class clazz = class$sun$awt$font$NativeFontWrapper == null ? (class$sun$awt$font$NativeFontWrapper = GlyphList.class$("sun.awt.font.NativeFontWrapper")) : class$sun$awt$font$NativeFontWrapper;
        synchronized (clazz) {
            this.setupStringData(string, fontInfo.font, f2, f3, fontInfo.glyphTx, fontInfo.doAntiAlias, fontInfo.doFractEnable);
            this.glyphindex = -1;
        }
    }
}

