/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOVecWrapper;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Util;

class IOUtil {
    static final boolean $assertionsDisabled = !(class$sun$nio$ch$IOUtil == null ? (class$sun$nio$ch$IOUtil = IOUtil.class$("sun.nio.ch.IOUtil")) : class$sun$nio$ch$IOUtil).desiredAssertionStatus();
    static Class class$sun$nio$ch$IOUtil;

    static {
        Util.load();
    }

    private IOUtil() {
    }

    static native void initIDs();

    static native boolean drain(int var0) throws IOException;

    static native boolean randomBytes(byte[] var0);

    static native void initPipe(int[] var0, boolean var1);

    static FileDescriptor newFD(int n2) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        IOUtil.setfdVal(fileDescriptor, n2);
        return fileDescriptor;
    }

    static native int fdVal(FileDescriptor var0);

    static native void setfdVal(FileDescriptor var0, int var1);

    static native void configureBlocking(FileDescriptor var0, boolean var1) throws IOException;

    private static int remaining(ByteBuffer[] byteBufferArray) {
        int n2 = byteBufferArray.length;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!byteBufferArray[i2].hasRemaining()) continue;
            return i2;
        }
        return -1;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private static ByteBuffer[] skipBufs(ByteBuffer[] byteBufferArray, int n2) {
        int n3 = byteBufferArray.length - n2;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            byteBufferArray2[i2] = byteBufferArray[i2 + n2];
        }
        return byteBufferArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long read(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        int n2;
        int n3 = IOUtil.remaining(byteBufferArray);
        if (n3 < 0) {
            return 0L;
        }
        if (n3 > 0) {
            byteBufferArray = IOUtil.skipBufs(byteBufferArray, n3);
        }
        int n4 = byteBufferArray.length;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            if (byteBufferArray[i2].isReadOnly()) {
                throw new IllegalArgumentException("Read-only buffer");
            }
            byteBufferArray2[i2] = !(byteBufferArray[i2] instanceof DirectBuffer) ? ByteBuffer.allocateDirect(byteBufferArray[i2].remaining()) : byteBufferArray[i2];
        }
        IOVecWrapper iOVecWrapper = null;
        long l2 = 0L;
        try {
            iOVecWrapper = new IOVecWrapper(n4);
            for (int i3 = 0; i3 < n4; ++i3) {
                ByteBuffer byteBuffer = byteBufferArray2[i3];
                long l3 = byteBuffer.position();
                long l4 = byteBuffer.remaining();
                iOVecWrapper.putBase(i3, ((DirectBuffer)((Object)byteBuffer)).address() + l3);
                iOVecWrapper.putLen(i3, l4);
            }
            l2 = nativeDispatcher.readv(fileDescriptor, iOVecWrapper.address, n4);
        }
        finally {
            iOVecWrapper.free();
        }
        long l5 = l2;
        for (n2 = 0; n2 < n4; ++n2) {
            int n5;
            ByteBuffer byteBuffer = byteBufferArray2[n2];
            int n6 = byteBuffer.position();
            int n7 = byteBuffer.remaining();
            if (l2 >= (long)n7) {
                l2 -= (long)n7;
            } else {
                if (l2 <= 0L) break;
                if (!$assertionsDisabled && (long)n6 + l2 >= Integer.MAX_VALUE) {
                    throw new AssertionError();
                }
                n5 = (int)((long)n6 + l2);
                byteBuffer.position(n5);
                break;
            }
            n5 = n6 + n7;
            byteBuffer.position(n5);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (byteBufferArray[n2] instanceof DirectBuffer) continue;
            byteBufferArray2[n2].flip();
            byteBufferArray[n2].put(byteBufferArray2[n2]);
        }
        return l5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long write(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        ByteBuffer byteBuffer;
        int n2;
        int n3 = IOUtil.remaining(byteBufferArray);
        if (n3 < 0) {
            return 0L;
        }
        if (n3 > 0) {
            byteBufferArray = IOUtil.skipBufs(byteBufferArray, n3);
        }
        int n4 = byteBufferArray.length;
        int n5 = 0;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!(byteBufferArray[i2] instanceof DirectBuffer)) {
                int n6 = byteBufferArray[i2].position();
                int n7 = byteBufferArray[i2].limit();
                if (!$assertionsDisabled && n6 > n7) {
                    throw new AssertionError();
                }
                n2 = n6 <= n7 ? n7 - n6 : 0;
                byteBufferArray2[i2] = byteBuffer = ByteBuffer.allocateDirect(n2);
                byteBuffer.put(byteBufferArray[i2]);
                byteBufferArray[i2].position(n6);
                byteBuffer.flip();
                continue;
            }
            byteBufferArray2[i2] = byteBufferArray[i2];
        }
        IOVecWrapper iOVecWrapper = null;
        long l2 = 0L;
        try {
            iOVecWrapper = new IOVecWrapper(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                byteBuffer = byteBufferArray2[n2];
                long l3 = byteBuffer.position();
                long l4 = (long)byteBuffer.limit() - l3;
                n5 = (int)((long)n5 + l4);
                iOVecWrapper.putBase(n2, ((DirectBuffer)((Object)byteBuffer)).address() + l3);
                iOVecWrapper.putLen(n2, l4);
            }
            l2 = nativeDispatcher.writev(fileDescriptor, iOVecWrapper.address, n4);
        }
        finally {
            iOVecWrapper.free();
        }
        long l5 = l2;
        for (int i3 = 0; i3 < n4; ++i3) {
            int n8;
            int n9;
            ByteBuffer byteBuffer2 = byteBufferArray[i3];
            int n10 = byteBuffer2.position();
            int n11 = byteBuffer2.limit();
            if (!$assertionsDisabled && n10 > n11) {
                throw new AssertionError();
            }
            int n12 = n9 = n10 <= n11 ? n11 - n10 : n11;
            if (l2 >= (long)n9) {
                l2 -= (long)n9;
            } else {
                if (l2 <= 0L) break;
                if (!$assertionsDisabled && (long)n10 + l2 >= Integer.MAX_VALUE) {
                    throw new AssertionError();
                }
                n8 = (int)((long)n10 + l2);
                byteBuffer2.position(n8);
                break;
            }
            n8 = n10 + n9;
            byteBuffer2.position(n8);
        }
        return l5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int read(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l2, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer, l2, nativeDispatcher, object);
        }
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(byteBuffer.remaining());
            int n2 = IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer2, l2, nativeDispatcher, object);
            byteBuffer2.flip();
            if (n2 > 0) {
                byteBuffer.put(byteBuffer2);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private static int readIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l2, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n2;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        if (!$assertionsDisabled && n3 > n4) {
            throw new AssertionError();
        }
        int n5 = n2 = n3 <= n4 ? n4 - n3 : 0;
        if (n2 == 0) {
            return 0;
        }
        int n6 = 0;
        n6 = l2 != -1L ? nativeDispatcher.pread(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n3, n2, l2, object) : nativeDispatcher.read(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n3, n2);
        if (n6 > 0) {
            byteBuffer.position(n3 + n6);
        }
        return n6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int write(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l2, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer, l2, nativeDispatcher, object);
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(n4);
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            byteBuffer.position(n2);
            int n5 = IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer2, l2, nativeDispatcher, object);
            if (n5 > 0) {
                byteBuffer.position(n2 + n5);
            }
            int n6 = n5;
            return n6;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private static int writeFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l2, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = 0;
        if (n4 == 0) {
            return 0;
        }
        n5 = l2 != -1L ? nativeDispatcher.pwrite(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n4, l2, object) : nativeDispatcher.write(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n4);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }
}

