/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.ServicePermission;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.misc.HexDumpEncoder;
import sun.security.action.GetBooleanAction;
import sun.security.jgss.LoginUtility;
import sun.security.jgss.TokenTracker;
import sun.security.jgss.krb5.AcceptSecContextToken;
import sun.security.jgss.krb5.InitSecContextToken;
import sun.security.jgss.krb5.InitialToken;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5Token;
import sun.security.jgss.krb5.MessageToken;
import sun.security.jgss.krb5.MicToken;
import sun.security.jgss.krb5.SubjectComber;
import sun.security.jgss.krb5.WrapToken;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

class Krb5Context
implements GSSContextSpi {
    private static final int STATE_NEW = 1;
    private static final int STATE_IN_PROCESS = 2;
    private static final int STATE_DONE = 3;
    private static final int STATE_DELETED = 4;
    private int state = 1;
    private boolean credDelegState = false;
    private boolean mutualAuthState = true;
    private boolean replayDetState = true;
    private boolean sequenceDetState = true;
    private boolean confState = true;
    private boolean integState = true;
    private int mySeqNumber;
    private int peerSeqNumber;
    private TokenTracker peerTokenTracker;
    private Object mySeqNumberLock = new Object();
    private Object peerSeqNumberLock = new Object();
    private EncryptionKey key;
    private Krb5NameElement myName;
    private Krb5NameElement peerName;
    private int lifetime;
    private boolean initiator;
    private ChannelBinding channelBinding;
    private Krb5CredElement myCred;
    private Krb5CredElement delegatedCred;
    private Cipher desCipher = null;
    private Credentials serviceCreds;
    private KrbApReq apReq;
    public static final boolean DEBUG = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.security.krb5.debug"));
    static Class class$javax$security$auth$kerberos$KerberosTicket;

    public final int getLifetime() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int incrementMySequenceNumber() {
        int n2;
        Object object = this.mySeqNumberLock;
        synchronized (object) {
            n2 = this.mySeqNumber;
            this.mySeqNumber = n2 + 1;
        }
        return n2;
    }

    public final void dispose() throws GSSException {
        this.state = 4;
        this.delegatedCred = null;
    }

    public final boolean getAnonymityState() {
        return false;
    }

    public final boolean getConfState() {
        return this.confState;
    }

    public final boolean getCredDelegState() {
        return this.credDelegState;
    }

    public final boolean getIntegState() {
        return this.integState;
    }

    public final boolean getMutualAuthState() {
        return this.mutualAuthState;
    }

    public final boolean getReplayDetState() {
        return this.replayDetState || this.sequenceDetState;
    }

    public final boolean getSequenceDetState() {
        return this.sequenceDetState || this.replayDetState;
    }

    public final boolean isEstablished() {
        return this.state == 3;
    }

    public final boolean isInitiator() {
        return this.initiator;
    }

    public final boolean isProtReady() {
        return this.state == 3;
    }

    public final boolean isTransferable() throws GSSException {
        return false;
    }

    public final byte[] export() throws GSSException {
        throw new GSSException(16, -1, "GSS Export Context not available");
    }

    public void requestLifetime(int n2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.lifetime = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetMySequenceNumber(int n2) {
        if (DEBUG) {
            System.out.println("Krb5Context setting mySeqNumber to: " + n2);
        }
        Object object = this.mySeqNumberLock;
        synchronized (object) {
            this.mySeqNumber = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetPeerSequenceNumber(int n2) {
        if (DEBUG) {
            System.out.println("Krb5Context setting peerSeqNumber to: " + n2);
        }
        Object object = this.peerSeqNumberLock;
        synchronized (object) {
            this.peerSeqNumber = n2;
            this.peerTokenTracker = new TokenTracker(this.peerSeqNumber);
        }
    }

    public final int getWrapSizeLimit(int n2, boolean bl2, int n3) throws GSSException {
        return WrapToken.getSizeLimit(n2, bl2, n3);
    }

    public final void requestAnonymity(boolean bl2) throws GSSException {
    }

    public final void requestConf(boolean bl2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.confState = bl2;
        }
    }

    public final void requestCredDeleg(boolean bl2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.credDelegState = bl2;
        }
    }

    public final void requestInteg(boolean bl2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.integState = bl2;
        }
    }

    public final void requestMutualAuth(boolean bl2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.mutualAuthState = bl2;
        }
    }

    public final void requestReplayDet(boolean bl2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.replayDetState = bl2;
        }
    }

    public final void requestSequenceDet(boolean bl2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.sequenceDetState = bl2;
        }
    }

    final void setConfState(boolean bl2) {
        this.confState = bl2;
    }

    final void setCredDelegState(boolean bl2) {
        this.credDelegState = bl2;
    }

    final void setIntegState(boolean bl2) {
        this.integState = bl2;
    }

    final void setMutualAuthState(boolean bl2) {
        this.mutualAuthState = bl2;
    }

    final void setReplayDetState(boolean bl2) {
        this.replayDetState = bl2;
    }

    final void setSequenceDetState(boolean bl2) {
        this.sequenceDetState = bl2;
    }

    public Krb5Context(byte[] byArray) throws GSSException {
        throw new GSSException(16, -1, "GSS Import Context not available");
    }

    public final byte[] acceptSecContext(InputStream inputStream, int n2) throws GSSException {
        byte[] byArray = null;
        if (DEBUG) {
            System.out.println("Entered Krb5Context.acceptSecContext with state=" + Krb5Context.printState(this.state));
        }
        if (this.isInitiator()) {
            throw new GSSException(11, -1, "acceptSecContext on an initiator GSSContext");
        }
        try {
            if (this.state == 1) {
                this.state = 2;
                if (this.myCred == null) {
                    this.myCred = Krb5AcceptCredential.getInstance(this.myName);
                } else if (!this.myCred.isAcceptorCredential()) {
                    throw new GSSException(13, -1, "No Secret Key available");
                }
                this.myName = (Krb5NameElement)this.myCred.getName();
                EncryptionKey encryptionKey = ((Krb5AcceptCredential)this.myCred).getKrb5EncryptionKey();
                this.checkPermission(this.myName.getKrb5PrincipalName().getName(), "accept");
                InitSecContextToken initSecContextToken = new InitSecContextToken(this, encryptionKey, inputStream);
                PrincipalName principalName = initSecContextToken.getKrbApReq().getClient();
                this.peerName = Krb5NameElement.getInstance(principalName);
                if (this.getMutualAuthState()) {
                    byArray = new AcceptSecContextToken(this, initSecContextToken.getKrbApReq()).encode();
                }
                this.myCred = null;
                this.state = 3;
            } else {
                System.out.println(this.state);
            }
        }
        catch (KrbException krbException) {
            throw new GSSException(11, -1, krbException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new GSSException(11, -1, iOException.getMessage());
        }
        return byArray;
    }

    public final byte[] initSecContext(InputStream inputStream, int n2) throws GSSException {
        byte[] byArray = null;
        InitSecContextToken initSecContextToken = null;
        int n3 = 11;
        KerberosTicket kerberosTicket = null;
        if (DEBUG) {
            System.out.println("Entered Krb5Context.initSecContext with state=" + Krb5Context.printState(this.state));
        }
        if (!this.isInitiator()) {
            throw new GSSException(11, -1, "initSecContext on an acceptor GSSContext");
        }
        try {
            if (this.state == 1) {
                this.state = 2;
                n3 = 13;
                if (this.myCred == null) {
                    this.myCred = Krb5InitCredential.getInstance(this.myName, 0);
                } else if (!this.myCred.isInitiatorCredential()) {
                    throw new GSSException(n3, -1, "No TGT available");
                }
                this.myName = (Krb5NameElement)this.myCred.getName();
                Credentials credentials = ((Krb5InitCredential)this.myCred).getKrb5Credentials();
                this.checkPermission(this.peerName.getKrb5PrincipalName().getName(), "initiate");
                AccessControlContext accessControlContext = AccessController.getContext();
                Object object = null;
                if (LoginUtility.useSubjectCredsOnly() && (object = AccessController.doPrivileged(new SubjectComber(accessControlContext, this.peerName.getKrb5PrincipalName().getName(), this.myName.getKrb5PrincipalName().getName(), class$javax$security$auth$kerberos$KerberosTicket == null ? (class$javax$security$auth$kerberos$KerberosTicket = Krb5Context.class$("javax.security.auth.kerberos.KerberosTicket")) : class$javax$security$auth$kerberos$KerberosTicket))) != null) {
                    kerberosTicket = (KerberosTicket)object;
                    if (DEBUG) {
                        System.out.println("Found service ticket in the subject" + kerberosTicket);
                    }
                    this.serviceCreds = new Credentials(kerberosTicket.getEncoded(), kerberosTicket.getClient().getName(), kerberosTicket.getServer().getName(), kerberosTicket.getSessionKey().getEncoded(), kerberosTicket.getSessionKeyType(), kerberosTicket.getFlags(), kerberosTicket.getAuthTime(), kerberosTicket.getStartTime(), kerberosTicket.getEndTime(), kerberosTicket.getRenewTill(), kerberosTicket.getClientAddresses());
                }
                if (this.serviceCreds == null) {
                    if (DEBUG) {
                        System.out.println("Service ticket not found in the subject");
                    }
                    this.serviceCreds = Credentials.acquireServiceCreds(this.peerName.getKrb5PrincipalName().getName(), credentials);
                    if (LoginUtility.useSubjectCredsOnly()) {
                        Subject subject = (Subject)AccessController.doPrivileged(new PrivilegedAction(this, accessControlContext){
                            private final AccessControlContext val$acc;
                            private final Krb5Context this$0;

                            public Object run() {
                                return Subject.getSubject(this.val$acc);
                            }
                            {
                                this.this$0 = krb5Context;
                                this.val$acc = accessControlContext;
                            }
                        });
                        if (subject != null && !subject.isReadOnly()) {
                            EncryptionKey encryptionKey = this.serviceCreds.getSessionKey();
                            KerberosTicket kerberosTicket2 = kerberosTicket = new KerberosTicket(this.serviceCreds.getEncoded(), new KerberosPrincipal(this.serviceCreds.getClient().getName()), new KerberosPrincipal(this.serviceCreds.getServer().getName()), encryptionKey.getBytes(), encryptionKey.getEType(), this.serviceCreds.getFlags(), this.serviceCreds.getAuthTime(), this.serviceCreds.getStartTime(), this.serviceCreds.getEndTime(), this.serviceCreds.getRenewTill(), this.serviceCreds.getClientAddresses());
                            Subject subject2 = subject;
                            AccessController.doPrivileged(new PrivilegedAction(this, subject2, kerberosTicket2){
                                private final Subject val$subjectF;
                                private final KerberosTicket val$kt;
                                private final Krb5Context this$0;

                                public Object run() {
                                    this.val$subjectF.getPrivateCredentials().add(this.val$kt);
                                    return null;
                                }
                                {
                                    this.this$0 = krb5Context;
                                    this.val$subjectF = subject;
                                    this.val$kt = kerberosTicket;
                                }
                            });
                        } else if (DEBUG) {
                            System.out.println("Subject is readOnly;Kerberos Service ticket not stored");
                        }
                    }
                }
                n3 = 11;
                initSecContextToken = new InitSecContextToken(this, credentials, this.serviceCreds);
                this.apReq = initSecContextToken.getKrbApReq();
                byArray = ((InitialToken)initSecContextToken).encode();
                this.myCred = null;
                if (!this.getMutualAuthState()) {
                    this.state = 3;
                }
                if (DEBUG) {
                    System.out.println("Created InitSecContextToken:\n" + new HexDumpEncoder().encode(Krb5Token.getHexBytes(byArray, byArray.length).getBytes()));
                }
            } else if (this.state == 2) {
                new AcceptSecContextToken(this, this.serviceCreds, this.apReq, inputStream);
                this.serviceCreds = null;
                this.apReq = null;
                this.state = 3;
            } else {
                System.out.println(this.state);
            }
        }
        catch (KrbException krbException) {
            krbException.printStackTrace();
            throw new GSSException(n3, -1, krbException.getMessage());
        }
        catch (IOException iOException) {
            throw new GSSException(n3, -1, iOException.getMessage());
        }
        return byArray;
    }

    private static String printState(int n2) {
        switch (n2) {
            case 1: {
                return "STATE_NEW";
            }
            case 2: {
                return "STATE_IN_PROCESS";
            }
            case 3: {
                return "STATE_DONE";
            }
            case 4: {
                return "STATE_DELETED";
            }
        }
        return "Unknown state " + n2;
    }

    private static String getHexBytes(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = byArray[i2] >> 4 & 0xF;
            int n5 = byArray[i2] & 0xF;
            stringBuffer.append(Integer.toHexString(n4));
            stringBuffer.append(Integer.toHexString(n5));
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    final Cipher getDesCipher() throws GeneralSecurityException {
        if (this.desCipher == null) {
            this.desCipher = Cipher.getInstance("DES/CBC/NoPadding");
        }
        return this.desCipher;
    }

    final ChannelBinding getChannelBinding() {
        return this.channelBinding;
    }

    public final void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        this.channelBinding = channelBinding;
    }

    public final byte[] getMIC(byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "GetMIC called in invalid state!");
        }
        MicToken micToken = new MicToken(this, messageProp, byArray, n2, n3);
        try {
            return micToken.encode();
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
    }

    public final byte[] unwrap(byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        if (DEBUG) {
            System.out.println("Krb5Context.unwrap: token=[" + Krb5Context.getHexBytes(byArray, n2, n3) + "]");
        }
        if (this.state != 3) {
            throw new GSSException(12, -1, " Unwrap called in invalid state!");
        }
        WrapToken wrapToken = new WrapToken(this, byArray, n2, n3, messageProp);
        byte[] byArray2 = wrapToken.getData();
        this.setSequencingAndReplayProps(wrapToken, messageProp);
        if (DEBUG) {
            System.out.println("Krb5Context.unwrap: data=[" + Krb5Context.getHexBytes(byArray2, 0, byArray2.length) + "]");
        }
        return byArray2;
    }

    public final byte[] wrap(byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        if (DEBUG) {
            System.out.println("Krb5Context.wrap: data=[" + Krb5Context.getHexBytes(byArray, n2, n3) + "]");
        }
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        try {
            WrapToken wrapToken = new WrapToken(this, messageProp, byArray, n2, n3);
            byte[] byArray2 = wrapToken.encode();
            if (DEBUG) {
                System.out.println("Krb5Context.wrap: token=[" + Krb5Context.getHexBytes(byArray2, 0, byArray2.length) + "]");
            }
            return byArray2;
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
    }

    public final void verifyMIC(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "verifyMIC called in invalid state!");
        }
        MicToken micToken = new MicToken(this, byArray, n2, n3, messageProp);
        micToken.verify(byArray2, n4, n5);
        this.setSequencingAndReplayProps(micToken, messageProp);
    }

    private int getMIC(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "GetMIC called in invalid state!");
        }
        MicToken micToken = new MicToken(this, messageProp, byArray, n2, n3);
        try {
            return micToken.encode(byArray2, n4);
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
    }

    public final int unwrap(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        WrapToken wrapToken = new WrapToken(this, byArray, n2, n3, messageProp);
        n3 = wrapToken.getData(byArray2, n4);
        this.setSequencingAndReplayProps(wrapToken, messageProp);
        return n3;
    }

    public final int wrap(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        try {
            WrapToken wrapToken = new WrapToken(this, messageProp, byArray, n2, n3);
            int n5 = wrapToken.encode(byArray2, n4);
            if (DEBUG) {
                System.out.println("Krb5Context.wrap: token=[" + Krb5Context.getHexBytes(byArray2, n4, n5) + "]");
            }
            return n5;
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
    }

    public final Oid getMech() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    Krb5Context(Krb5CredElement krb5CredElement) throws GSSException {
        this.myCred = krb5CredElement;
        this.initiator = false;
    }

    final void setDelegCred(Krb5CredElement krb5CredElement) {
        this.delegatedCred = krb5CredElement;
    }

    public final GSSCredentialSpi getDelegCred() throws GSSException {
        if (this.state != 2 && this.state != 3) {
            throw new GSSException(12);
        }
        if (this.delegatedCred == null) {
            throw new GSSException(13);
        }
        return this.delegatedCred;
    }

    public final GSSNameSpi getSrcName() throws GSSException {
        return this.isInitiator() ? this.myName : this.peerName;
    }

    public final GSSNameSpi getTargName() throws GSSException {
        return !this.isInitiator() ? this.myName : this.peerName;
    }

    final EncryptionKey getKey() {
        return this.key;
    }

    final void setKey(EncryptionKey encryptionKey) {
        this.key = encryptionKey;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private void checkPermission(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ServicePermission servicePermission = new ServicePermission(string, string2);
            securityManager.checkPermission(servicePermission);
        }
    }

    private void verifyMIC(InputStream inputStream, byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "verifyMIC called in invalid state!");
        }
        MicToken micToken = new MicToken(this, inputStream, messageProp);
        micToken.verify(byArray, n2, n3);
        this.setSequencingAndReplayProps(micToken, messageProp);
    }

    public final int unwrap(InputStream inputStream, byte[] byArray, int n2, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        WrapToken wrapToken = new WrapToken(this, inputStream, messageProp);
        int n3 = wrapToken.getData(byArray, n2);
        this.setSequencingAndReplayProps(wrapToken, messageProp);
        return n3;
    }

    private void getMIC(byte[] byArray, int n2, int n3, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "GetMIC called in invalid state!");
        }
        MicToken micToken = new MicToken(this, messageProp, byArray, n2, n3);
        try {
            micToken.encode(outputStream);
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
    }

    public final void wrap(byte[] byArray, int n2, int n3, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        WrapToken wrapToken = new WrapToken(this, messageProp, byArray, n2, n3);
        try {
            wrapToken.encode(outputStream);
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
        if (DEBUG) {
            try {
                byte[] byArray2 = wrapToken.encode();
                System.out.println("Krb5Context.wrap: token=[" + Krb5Context.getHexBytes(byArray2, 0, byArray2.length) + "]");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setSequencingAndReplayProps(MessageToken messageToken, MessageProp messageProp) {
        if (this.replayDetState || this.sequenceDetState) {
            int n2 = messageToken.getSequenceNumber();
            this.peerTokenTracker.getProps(n2, messageProp);
        }
    }

    Krb5Context(Krb5NameElement krb5NameElement, Krb5CredElement krb5CredElement, int n2) throws GSSException {
        if (krb5NameElement == null) {
            throw new IllegalArgumentException("Cannot have null peer name");
        }
        this.peerName = krb5NameElement;
        this.myCred = krb5CredElement;
        this.lifetime = n2;
        this.initiator = true;
    }

    public final void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        byte[] byArray;
        try {
            byArray = new byte[inputStream2.available()];
            inputStream2.read(byArray);
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
        this.verifyMIC(inputStream, byArray, 0, byArray.length, messageProp);
    }

    public final void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        byte[] byArray;
        try {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
        this.getMIC(byArray, 0, byArray.length, outputStream, messageProp);
    }

    public final void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        WrapToken wrapToken = new WrapToken(this, inputStream, messageProp);
        try {
            outputStream.write(wrapToken.getData());
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
        this.setSequencingAndReplayProps(wrapToken, messageProp);
    }

    public final void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        byte[] byArray;
        try {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
        this.wrap(byArray, 0, byArray.length, outputStream, messageProp);
    }
}

