/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import sun.security.pkcs.PKCS8Key;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgIdDSA;

public final class DSAPrivateKey
extends PKCS8Key
implements java.security.interfaces.DSAPrivateKey,
Serializable {
    private static final long serialVersionUID = -3244453684193605938L;
    private BigInteger x;
    static Class class$java$security$spec$DSAParameterSpec;

    public DSAPrivateKey() {
    }

    private void clearOldKey() {
        int n2;
        if (this.encodedKey != null) {
            for (n2 = 0; n2 < this.encodedKey.length; ++n2) {
                this.encodedKey[n2] = 0;
            }
        }
        if (this.key != null) {
            for (n2 = 0; n2 < this.key.length; ++n2) {
                this.key[n2] = 0;
            }
        }
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.x = derInputStream.getBigInteger();
        }
        catch (IOException iOException) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(iOException.getMessage());
            invalidKeyException.initCause(iOException);
            throw invalidKeyException;
        }
    }

    public DSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        this.clearOldKey();
        this.decode(byArray);
    }

    public String toString() {
        return "Sun DSA Private Key \nparameters:" + this.algid + "\nx: " + Debug.toHexString(this.x) + "\n";
    }

    public BigInteger getX() {
        return this.x;
    }

    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)((Object)this.algid);
            }
            AlgorithmParameters algorithmParameters = this.algid.getParameters();
            if (algorithmParameters == null) {
                return null;
            }
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameters.getParameterSpec(class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = DSAPrivateKey.class$("java.security.spec.DSAParameterSpec")) : class$java$security$spec$DSAParameterSpec);
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public DSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this.x = bigInteger;
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        try {
            this.key = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            InvalidKeyException invalidKeyException = new InvalidKeyException("could not DER encode x: " + iOException.getMessage());
            invalidKeyException.initCause(iOException);
            throw invalidKeyException;
        }
    }
}

