/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVAKeyword;
import sun.security.x509.X500Name;
import sun.text.Normalizer;

public class AVA
implements DerEncoder {
    private static final Debug debug = Debug.getInstance("x509", "\t[AVA]");
    static final int DEFAULT = 1;
    static final int RFC1779 = 2;
    static final int RFC2253 = 3;
    final ObjectIdentifier oid;
    final DerValue value;
    private static final String specialChars = ",+=\n<>#;";
    private static final String specialChars2253 = ",+\"\\<>;";
    private static final String specialCharsAll = ",=\n+<>#;\\\" ";
    private static final String hexDigits = "0123456789ABCDEF";

    public int hashCode() {
        return this.toRFC2253CanonicalString().hashCode();
    }

    boolean hasRFC2253Keyword() {
        return AVAKeyword.hasKeyword(this.oid, 3);
    }

    private static boolean isTerminator(int n2, int n3) {
        switch (n2) {
            case -1: 
            case 43: 
            case 44: {
                return true;
            }
            case 59: 
            case 62: {
                return n3 != 3;
            }
        }
        return false;
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.oid);
        this.value.encode(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    AVA(Reader reader) throws IOException {
        this(reader, 1);
    }

    private static boolean trailingSpace(Reader reader) throws IOException {
        boolean bl2;
        block3: {
            block4: {
                bl2 = false;
                if (!reader.markSupported()) {
                    return true;
                }
                reader.mark(9999);
                while (true) {
                    int n2;
                    if ((n2 = reader.read()) == -1) {
                        bl2 = true;
                        break block3;
                    }
                    if (n2 == 32) continue;
                    if (n2 != 92) break block4;
                    int n3 = reader.read();
                    if (n3 != 32) break;
                }
                bl2 = false;
                break block3;
            }
            bl2 = false;
        }
        reader.reset();
        return bl2;
    }

    AVA(Reader reader, int n2) throws IOException {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n3 = AVA.readChar(reader, "Incorrect AVA format")) != 61) {
            stringBuffer.append((char)n3);
        }
        this.oid = AVAKeyword.getOID(stringBuffer.toString(), n2);
        stringBuffer.setLength(0);
        if (n2 == 3) {
            n3 = reader.read();
            if (n3 == 32) {
                throw new IOException("Incorrect AVA RFC2253 format - leading space must be escaped");
            }
        } else {
            while ((n3 = reader.read()) == 32 || n3 == 10) {
            }
        }
        if (n3 == -1) {
            this.value = new DerValue("");
            return;
        }
        this.value = n3 == 35 ? AVA.parseHexString(reader, n2) : (n3 == 34 && n2 != 3 ? this.parseQuotedString(reader, stringBuffer) : this.parseString(reader, n3, n2, stringBuffer));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AVA)) {
            return false;
        }
        AVA aVA = (AVA)object;
        return this.toRFC2253CanonicalString().equals(aVA.toRFC2253CanonicalString());
    }

    public String getValueString() {
        try {
            String string = this.value.getAsString();
            if (string == null) {
                throw new RuntimeException("AVA string is null");
            }
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException("AVA error: " + iOException, iOException);
        }
    }

    public String toRFC1779String() {
        return this.toKeywordValueString(this.toKeyword(2));
    }

    public String toRFC2253CanonicalString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(this.toKeyword(3));
        stringBuffer.append('=');
        if (stringBuffer.charAt(0) >= '0' && stringBuffer.charAt(0) <= '9' || !AVA.isDerString(this.value, true)) {
            object = null;
            try {
                object = this.value.toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            stringBuffer.append('#');
            for (int i2 = 0; i2 < ((byte[])object).length; ++i2) {
                byte by = object[i2];
                stringBuffer.append(Character.forDigit(0xF & by >>> 4, 16));
                stringBuffer.append(Character.forDigit(0xF & by, 16));
            }
        } else {
            object = null;
            try {
                object = new String(this.value.getDataBytes(), "UTF8");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl2 = false;
            for (int i3 = 0; i3 < ((String)object).length(); ++i3) {
                char c2 = ((String)object).charAt(i3);
                if (DerValue.isPrintableStringChar(c2) || ",+<>;\"\\".indexOf(c2) >= 0 || i3 == 0 && c2 == '#') {
                    if (i3 == 0 && c2 == '#' || ",+<>;\"\\".indexOf(c2) >= 0) {
                        stringBuffer2.append('\\');
                    }
                    if (!Character.isWhitespace(c2)) {
                        bl2 = false;
                        stringBuffer2.append(c2);
                        continue;
                    }
                    if (bl2) continue;
                    bl2 = true;
                    stringBuffer2.append(c2);
                    continue;
                }
                if (debug != null && Debug.isOn("ava")) {
                    bl2 = false;
                    byte[] byArray = null;
                    try {
                        byArray = Character.toString(c2).getBytes("UTF8");
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("DER Value conversion");
                    }
                    for (int i4 = 0; i4 < byArray.length; ++i4) {
                        stringBuffer2.append('\\');
                        stringBuffer2.append(Character.forDigit(0xF & byArray[i4] >>> 4, 16));
                        stringBuffer2.append(Character.forDigit(0xF & byArray[i4], 16));
                    }
                    continue;
                }
                bl2 = false;
                stringBuffer2.append(c2);
            }
            stringBuffer.append(stringBuffer2.toString().trim());
        }
        object = new String(stringBuffer);
        object = ((String)object).toUpperCase(Locale.US).toLowerCase(Locale.US);
        return Normalizer.normalize((String)object, Normalizer.DECOMP_COMPAT, 0);
    }

    public String toRFC2253String() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.toKeyword(3));
        stringBuffer.append('=');
        if (stringBuffer.charAt(0) >= '0' && stringBuffer.charAt(0) <= '9' || !AVA.isDerString(this.value, false)) {
            byte[] byArray = null;
            try {
                byArray = this.value.toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            stringBuffer.append('#');
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byte by = byArray[i2];
                stringBuffer.append(Character.forDigit(0xF & by >>> 4, 16));
                stringBuffer.append(Character.forDigit(0xF & by, 16));
            }
        } else {
            int n2;
            char c2;
            int n3;
            int n4;
            String string = null;
            try {
                string = new String(this.value.getDataBytes(), "UTF8");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i3 = 0; i3 < string.length(); ++i3) {
                n4 = string.charAt(i3);
                if (DerValue.isPrintableStringChar((char)n4) || ",=+<>#;\"\\".indexOf(n4) >= 0) {
                    if (",=+<>#;\"\\".indexOf(n4) >= 0) {
                        stringBuffer2.append('\\');
                    }
                    stringBuffer2.append((char)n4);
                    continue;
                }
                if (debug != null && Debug.isOn("ava")) {
                    byte[] byArray = null;
                    try {
                        byArray = Character.toString((char)n4).getBytes("UTF8");
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("DER Value conversion");
                    }
                    for (n3 = 0; n3 < byArray.length; ++n3) {
                        stringBuffer2.append('\\');
                        c2 = Character.forDigit(0xF & byArray[n3] >>> 4, 16);
                        stringBuffer2.append(Character.toUpperCase(c2));
                        c2 = Character.forDigit(0xF & byArray[n3], 16);
                        stringBuffer2.append(Character.toUpperCase(c2));
                    }
                    continue;
                }
                stringBuffer2.append((char)n4);
            }
            char[] cArray = stringBuffer2.toString().toCharArray();
            stringBuffer2 = new StringBuffer();
            for (n4 = '\u0000'; n4 < cArray.length && (cArray[n4] == ' ' || cArray[n4] == '\r'); ++n4) {
            }
            for (n2 = cArray.length - 1; n2 >= 0 && (cArray[n2] == ' ' || cArray[n2] == '\r'); --n2) {
            }
            for (n3 = 0; n3 < cArray.length; ++n3) {
                c2 = cArray[n3];
                if (n3 < n4 || n3 > n2) {
                    stringBuffer2.append('\\');
                }
                stringBuffer2.append(c2);
            }
            stringBuffer.append(stringBuffer2.toString());
        }
        return new String(stringBuffer);
    }

    public String toString() {
        return this.toKeywordValueString(this.toKeyword(1));
    }

    private String toKeyword(int n2) {
        return AVAKeyword.getKeyword(this.oid, n2);
    }

    AVA(DerInputStream derInputStream) throws IOException {
        this(derInputStream.getDerValue());
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    public DerValue getDerValue() {
        return this.value;
    }

    AVA(DerValue derValue) throws IOException {
        if (derValue.tag != 48) {
            throw new IOException("AVA not a sequence");
        }
        this.oid = X500Name.intern(derValue.data.getOID());
        this.value = derValue.data.getDerValue();
        if (derValue.data.available() != 0) {
            throw new IOException("AVA, extra bytes = " + derValue.data.available());
        }
    }

    private static boolean isDerString(DerValue derValue, boolean bl2) {
        if (bl2) {
            switch (derValue.tag) {
                case 12: 
                case 19: {
                    return true;
                }
            }
            return false;
        }
        switch (derValue.tag) {
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    public ObjectIdentifier getObjectIdentifier() {
        return this.oid;
    }

    private static Byte getEmbeddedHexPair(int n2, Reader reader) throws IOException {
        if (hexDigits.indexOf(Character.toUpperCase((char)n2)) >= 0) {
            int n3 = AVA.readChar(reader, "unexpected EOF - escaped hex value must include two valid digits");
            if (hexDigits.indexOf(Character.toUpperCase((char)n3)) >= 0) {
                int n4 = Character.digit((char)n2, 16);
                int n5 = Character.digit((char)n3, 16);
                return new Byte((byte)((n4 << 4) + n5));
            }
            throw new IOException("escaped hex value must include two valid digits");
        }
        return null;
    }

    private static int readChar(Reader reader, String string) throws IOException {
        int n2 = reader.read();
        if (n2 == -1) {
            throw new IOException(string);
        }
        return n2;
    }

    private String toKeywordValueString(String string) {
        StringBuffer stringBuffer;
        block16: {
            stringBuffer = new StringBuffer(40);
            stringBuffer.append(string);
            stringBuffer.append("=");
            try {
                int n2;
                String string2 = this.value.getAsString();
                if (string2 == null) {
                    byte[] byArray = this.value.toByteArray();
                    stringBuffer.append('#');
                    for (int i2 = 0; i2 < byArray.length; ++i2) {
                        stringBuffer.append(hexDigits.charAt(byArray[i2] >> 4 & 0xF));
                        stringBuffer.append(hexDigits.charAt(byArray[i2] & 0xF));
                    }
                    break block16;
                }
                boolean bl2 = false;
                StringBuffer stringBuffer2 = new StringBuffer();
                boolean bl3 = false;
                for (n2 = 0; n2 < string2.length(); ++n2) {
                    char c2 = string2.charAt(n2);
                    if (DerValue.isPrintableStringChar(c2) || specialChars.indexOf(c2) >= 0) {
                        if (!(bl2 || (n2 != 0 || c2 != ' ' && c2 != '\n') && specialChars.indexOf(c2) < 0)) {
                            bl2 = true;
                        }
                        if (c2 != ' ' && c2 != '\n') {
                            if (c2 == '\"' || c2 == '\\') {
                                stringBuffer2.append('\\');
                            }
                            bl3 = false;
                        } else {
                            if (!bl2 && bl3) {
                                bl2 = true;
                            }
                            bl3 = true;
                        }
                        stringBuffer2.append(c2);
                        continue;
                    }
                    if (debug != null && Debug.isOn("ava")) {
                        bl3 = false;
                        byte[] byArray = Character.toString(c2).getBytes("UTF8");
                        for (int i3 = 0; i3 < byArray.length; ++i3) {
                            stringBuffer2.append('\\');
                            char c3 = Character.forDigit(0xF & byArray[i3] >>> 4, 16);
                            stringBuffer2.append(Character.toUpperCase(c3));
                            c3 = Character.forDigit(0xF & byArray[i3], 16);
                            stringBuffer2.append(Character.toUpperCase(c3));
                        }
                        continue;
                    }
                    bl3 = false;
                    stringBuffer2.append(c2);
                }
                if (stringBuffer2.length() > 0 && ((n2 = (int)stringBuffer2.charAt(stringBuffer2.length() - 1)) == 32 || n2 == 10)) {
                    bl2 = true;
                }
                if (bl2) {
                    stringBuffer.append("\"" + stringBuffer2.toString() + "\"");
                } else {
                    stringBuffer.append(stringBuffer2.toString());
                }
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
        }
        return stringBuffer.toString();
    }

    private static String getEmbeddedHexString(ArrayList arrayList) throws IOException {
        byte[] byArray = new byte[arrayList.size()];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            byArray[i2] = (Byte)arrayList.get(i2);
        }
        return new String(byArray, "UTF8");
    }

    private static DerValue parseHexString(Reader reader, int n2) throws IOException {
        int n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n4 = 0;
        int n5 = 0;
        while (!AVA.isTerminator(n3 = reader.read(), n2)) {
            int n6 = hexDigits.indexOf(Character.toUpperCase((char)n3));
            if (n6 == -1) {
                throw new IOException("AVA parse, invalid hex digit: " + (char)n3);
            }
            if (n5 % 2 == 1) {
                n4 = (byte)(n4 * 16 + (byte)n6);
                byteArrayOutputStream.write(n4);
            } else {
                n4 = (byte)n6;
            }
            ++n5;
        }
        if (n5 == 0) {
            throw new IOException("AVA parse, zero hex digits");
        }
        if (n5 % 2 == 1) {
            throw new IOException("AVA parse, odd number of hex digits");
        }
        return new DerValue(byteArrayOutputStream.toByteArray());
    }

    public AVA(ObjectIdentifier objectIdentifier, DerValue derValue) {
        if (objectIdentifier == null || derValue == null) {
            throw new NullPointerException();
        }
        this.oid = objectIdentifier;
        this.value = derValue;
    }

    private DerValue parseString(Reader reader, int n2, int n3, StringBuffer stringBuffer) throws IOException {
        ArrayList arrayList = new ArrayList();
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = true;
        int n4 = 0;
        do {
            bl3 = false;
            if (n2 == 92) {
                bl3 = true;
                n2 = AVA.readChar(reader, "Invalid trailing backslash");
                Byte by = null;
                by = AVA.getEmbeddedHexPair(n2, reader);
                if (by != null) {
                    bl2 = false;
                    arrayList.add(by);
                    n2 = reader.read();
                    bl4 = false;
                    continue;
                }
                if (n3 == 1 && specialCharsAll.indexOf((char)n2) == -1 || n3 == 2 && specialChars.indexOf((char)n2) == -1 && n2 != 92 && n2 != 34) {
                    throw new IOException("Invalid escaped character in AVA: '" + (char)n2 + "'");
                }
                if (n3 == 3) {
                    if (n2 == 32) {
                        if (!bl4 && !AVA.trailingSpace(reader)) {
                            throw new IOException("Invalid escaped space character in AVA.  Only a leading or trailing space character can be escaped.");
                        }
                    } else if (n2 == 35) {
                        if (!bl4) {
                            throw new IOException("Invalid escaped '#' character in AVA.  Only a leading '#' can be escaped.");
                        }
                    } else if (specialChars2253.indexOf((char)n2) == -1) {
                        throw new IOException("Invalid escaped character in AVA: '" + (char)n2 + "'");
                    }
                }
            } else if (n3 == 3 && specialChars2253.indexOf((char)n2) != -1) {
                throw new IOException("Character '" + (char)n2 + "' in AVA appears without escape");
            }
            if (arrayList.size() > 0) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    stringBuffer.append(" ");
                }
                n4 = 0;
                String string = AVA.getEmbeddedHexString(arrayList);
                stringBuffer.append(string);
                arrayList.clear();
            }
            bl2 &= DerValue.isPrintableStringChar((char)n2);
            if (n2 == 32 && !bl3) {
                ++n4;
            } else {
                for (int i3 = 0; i3 < n4; ++i3) {
                    stringBuffer.append(" ");
                }
                n4 = 0;
                stringBuffer.append((char)n2);
            }
            n2 = reader.read();
            bl4 = false;
        } while (!AVA.isTerminator(n2, n3));
        if (n3 == 3 && n4 > 0) {
            throw new IOException("Incorrect AVA RFC2253 format - trailing space must be escaped");
        }
        if (arrayList.size() > 0) {
            String string = AVA.getEmbeddedHexString(arrayList);
            stringBuffer.append(string);
            arrayList.clear();
        }
        if (this.oid.equals(PKCS9Attribute.EMAIL_ADDRESS_OID)) {
            return new DerValue(22, stringBuffer.toString());
        }
        if (bl2) {
            return new DerValue(stringBuffer.toString());
        }
        return new DerValue(12, stringBuffer.toString());
    }

    private DerValue parseQuotedString(Reader reader, StringBuffer stringBuffer) throws IOException {
        Object object;
        int n2 = AVA.readChar(reader, "Quoted string did not end in quote");
        ArrayList arrayList = new ArrayList();
        boolean bl2 = true;
        while (n2 != 34) {
            if (n2 == 92) {
                n2 = AVA.readChar(reader, "Quoted string did not end in quote");
                object = null;
                object = AVA.getEmbeddedHexPair(n2, reader);
                if (object != null) {
                    bl2 = false;
                    arrayList.add(object);
                    n2 = reader.read();
                    continue;
                }
                if (n2 != 92 && n2 != 34 && specialChars.indexOf((char)n2) < 0) {
                    throw new IOException("Invalid escaped character in AVA: " + (char)n2);
                }
            }
            if (arrayList.size() > 0) {
                object = AVA.getEmbeddedHexString(arrayList);
                stringBuffer.append((String)object);
                arrayList.clear();
            }
            bl2 &= DerValue.isPrintableStringChar((char)n2);
            stringBuffer.append((char)n2);
            n2 = AVA.readChar(reader, "Quoted string did not end in quote");
        }
        if (arrayList.size() > 0) {
            object = AVA.getEmbeddedHexString(arrayList);
            stringBuffer.append((String)object);
            arrayList.clear();
        }
        while ((n2 = reader.read()) == 10 || n2 == 32) {
        }
        if (n2 != -1) {
            throw new IOException("AVA had characters other than whitespace after terminating quote");
        }
        if (this.oid.equals(PKCS9Attribute.EMAIL_ADDRESS_OID)) {
            return new DerValue(22, stringBuffer.toString().trim());
        }
        if (bl2) {
            return new DerValue(stringBuffer.toString().trim());
        }
        return new DerValue(12, stringBuffer.toString().trim());
    }
}

