/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.X500Name;

class AVAKeyword {
    private static final Map oidMap = new HashMap();
    private static final Map keywordMap = new HashMap();
    private String keyword;
    private ObjectIdentifier oid;
    private boolean rfc1779Compliant;
    private boolean rfc2253Compliant;

    static {
        new AVAKeyword("CN", X500Name.commonName_oid, true, true);
        new AVAKeyword("C", X500Name.countryName_oid, true, true);
        new AVAKeyword("L", X500Name.localityName_oid, true, true);
        new AVAKeyword("S", X500Name.stateName_oid, false, false);
        new AVAKeyword("ST", X500Name.stateName_oid, true, true);
        new AVAKeyword("O", X500Name.orgName_oid, true, true);
        new AVAKeyword("OU", X500Name.orgUnitName_oid, true, true);
        new AVAKeyword("T", X500Name.title_oid, false, false);
        new AVAKeyword("IP", X500Name.ipAddress_oid, false, false);
        new AVAKeyword("STREET", X500Name.streetAddress_oid, true, true);
        new AVAKeyword("DC", X500Name.DOMAIN_COMPONENT_OID, false, true);
        new AVAKeyword("DNQUALIFIER", X500Name.DNQUALIFIER_OID, false, false);
        new AVAKeyword("DNQ", X500Name.DNQUALIFIER_OID, false, false);
        new AVAKeyword("SURNAME", X500Name.SURNAME_OID, false, false);
        new AVAKeyword("GIVENNAME", X500Name.GIVENNAME_OID, false, false);
        new AVAKeyword("INITIALS", X500Name.INITIALS_OID, false, false);
        new AVAKeyword("GENERATION", X500Name.GENERATIONQUALIFIER_OID, false, false);
        new AVAKeyword("EMAIL", PKCS9Attribute.EMAIL_ADDRESS_OID, false, false);
        new AVAKeyword("EMAILADDRESS", PKCS9Attribute.EMAIL_ADDRESS_OID, false, false);
        new AVAKeyword("UID", X500Name.userid_oid, false, true);
        new AVAKeyword("SERIALNUMBER", X500Name.SERIALNUMBER_OID, false, false);
    }

    private boolean isCompliant(int n2) {
        switch (n2) {
            case 2: {
                return this.rfc1779Compliant;
            }
            case 3: {
                return this.rfc2253Compliant;
            }
            case 1: {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid standard " + n2);
    }

    static boolean hasKeyword(ObjectIdentifier objectIdentifier, int n2) {
        AVAKeyword aVAKeyword = (AVAKeyword)oidMap.get(objectIdentifier);
        if (aVAKeyword == null) {
            return false;
        }
        return aVAKeyword.isCompliant(n2);
    }

    static String getKeyword(ObjectIdentifier objectIdentifier, int n2) {
        AVAKeyword aVAKeyword = (AVAKeyword)oidMap.get(objectIdentifier);
        if (aVAKeyword != null && aVAKeyword.isCompliant(n2)) {
            return aVAKeyword.keyword;
        }
        String string = objectIdentifier.toString();
        if (n2 == 3) {
            return string;
        }
        return "OID." + string;
    }

    static ObjectIdentifier getOID(String string, int n2) throws IOException {
        char c2;
        AVAKeyword aVAKeyword;
        string = string.toUpperCase();
        if (n2 == 3) {
            if (string.startsWith(" ") || string.endsWith(" ")) {
                throw new IOException("Invalid leading or trailing space in keyword \"" + string + "\"");
            }
        } else {
            string = string.trim();
        }
        if ((aVAKeyword = (AVAKeyword)keywordMap.get(string)) != null && aVAKeyword.isCompliant(n2)) {
            return aVAKeyword.oid;
        }
        if (n2 == 2) {
            if (!string.startsWith("OID.")) {
                throw new IOException("Invalid RFC1779 keyword: " + string);
            }
            string = string.substring(4);
        } else if (n2 == 1 && string.startsWith("OID.")) {
            string = string.substring(4);
        }
        boolean bl2 = false;
        if (string.length() != 0 && (c2 = string.charAt(0)) >= '0' && c2 <= '9') {
            bl2 = true;
        }
        if (!bl2) {
            throw new IOException("Invalid keyword \"" + string + "\"");
        }
        return new ObjectIdentifier(string);
    }

    private AVAKeyword(String string, ObjectIdentifier objectIdentifier, boolean bl2, boolean bl3) {
        this.keyword = string;
        this.oid = objectIdentifier;
        this.rfc1779Compliant = bl2;
        this.rfc2253Compliant = bl3;
        oidMap.put(objectIdentifier, this);
        keywordMap.put(string, this);
    }
}

