/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public strictfp final class StrictMath {
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    private static Random randomNumberGenerator;
    private static long negativeZeroFloatBits;
    private static long negativeZeroDoubleBits;

    public static double random() {
        if (randomNumberGenerator == null) {
            StrictMath.initRNG();
        }
        return randomNumberGenerator.nextDouble();
    }

    static {
        negativeZeroFloatBits = Float.floatToIntBits(-0.0f);
        negativeZeroDoubleBits = Double.doubleToLongBits(-0.0);
    }

    private StrictMath() {
    }

    private static synchronized void initRNG() {
        if (randomNumberGenerator == null) {
            randomNumberGenerator = new Random();
        }
    }

    public static double abs(double d2) {
        return d2 <= 0.0 ? 0.0 - d2 : d2;
    }

    public static native double acos(double var0);

    public static native double asin(double var0);

    public static native double atan(double var0);

    public static native double ceil(double var0);

    public static native double cos(double var0);

    public static native double exp(double var0);

    public static native double floor(double var0);

    public static native double log(double var0);

    public static native double rint(double var0);

    public static native double sin(double var0);

    public static native double sqrt(double var0);

    public static native double tan(double var0);

    public static double toDegrees(double d2) {
        return d2 * 180.0 / Math.PI;
    }

    public static double toRadians(double d2) {
        return d2 / 180.0 * Math.PI;
    }

    public static long round(double d2) {
        return (long)StrictMath.floor(d2 + 0.5);
    }

    public static native double IEEEremainder(double var0, double var2);

    public static native double atan2(double var0, double var2);

    public static double max(double d2, double d3) {
        if (d2 != d2) {
            return d2;
        }
        if (d2 == 0.0 && d3 == 0.0 && Double.doubleToLongBits(d2) == negativeZeroDoubleBits) {
            return d3;
        }
        return d2 >= d3 ? d2 : d3;
    }

    public static double min(double d2, double d3) {
        if (d2 != d2) {
            return d2;
        }
        if (d2 == 0.0 && d3 == 0.0 && Double.doubleToLongBits(d3) == negativeZeroDoubleBits) {
            return d3;
        }
        return d2 <= d3 ? d2 : d3;
    }

    public static native double pow(double var0, double var2);

    public static float abs(float f2) {
        return f2 <= 0.0f ? 0.0f - f2 : f2;
    }

    public static int round(float f2) {
        return (int)StrictMath.floor(f2 + 0.5f);
    }

    public static float max(float f2, float f3) {
        if (f2 != f2) {
            return f2;
        }
        if (f2 == 0.0f && f3 == 0.0f && (long)Float.floatToIntBits(f2) == negativeZeroFloatBits) {
            return f3;
        }
        return f2 >= f3 ? f2 : f3;
    }

    public static float min(float f2, float f3) {
        if (f2 != f2) {
            return f2;
        }
        if (f2 == 0.0f && f3 == 0.0f && (long)Float.floatToIntBits(f3) == negativeZeroFloatBits) {
            return f3;
        }
        return f2 <= f3 ? f2 : f3;
    }

    public static int abs(int n2) {
        return n2 < 0 ? -n2 : n2;
    }

    public static int max(int n2, int n3) {
        return n2 >= n3 ? n2 : n3;
    }

    public static int min(int n2, int n3) {
        return n2 <= n3 ? n2 : n3;
    }

    public static long abs(long l2) {
        return l2 < 0L ? -l2 : l2;
    }

    public static long max(long l2, long l3) {
        return l2 >= l3 ? l2 : l3;
    }

    public static long min(long l2, long l3) {
        return l2 <= l3 ? l2 : l3;
    }
}

