/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import sun.plugin.ClassLoaderInfo;
import sun.plugin.cache.FileVersion;
import sun.plugin.cache.JarCache;
import sun.plugin.cache.JarCacheVersionException;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.util.Trace;

public class JarCacheUtil {
    private static String PRELOAD = "preload";

    public static synchronized String getJarsInCacheArchiveEx(String string) {
        if (string != null) {
            String string2 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string3 = stringTokenizer.nextToken().trim();
                int n2 = string3.indexOf(";");
                if (n2 == -1) continue;
                String string4 = string3.substring(0, n2);
                string2 = string2 + string4;
                string2 = string2 + (i != n - 1 ? "," : "");
            }
            return string2;
        }
        return null;
    }

    public static synchronized void preload(URL uRL, String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(59);
            if (n == -1 || (string2 = string3.substring(n)).toLowerCase().indexOf(PRELOAD) == -1) continue;
            String string4 = string3.substring(0, n);
            arrayList.add(string4);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            URL uRL2 = new URL(uRL, (String)arrayList.get(i));
            Trace.msgNetPrintln("cache.preloading", new Object[]{(String)arrayList.get(i)});
            JarCache.get(uRL2);
        }
    }

    public static synchronized void verifyJarVersions(URL uRL, String string, HashMap hashMap) throws IOException, JarCacheVersionException {
        boolean bl = false;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)hashMap.get(string2);
            URL uRL2 = new URL(uRL, string2);
            Trace.msgNetPrintln("cache.version_checking", new Object[]{string2, string3});
            boolean bl2 = JarCache.handleVersion(uRL2, new FileVersion(string3));
            if (!bl2) continue;
            bl = true;
        }
        if (bl) {
            ClassLoaderInfo.markNotCachable(uRL, string);
        }
    }

    public static HashMap getJarsWithVersion(String string, String string2, String string3) throws JarCacheVersionException {
        String string4;
        String string5;
        StringTokenizer stringTokenizer;
        StringTokenizer stringTokenizer2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null && string2 != null) {
            stringTokenizer2 = new StringTokenizer(string, ",", false);
            int n = stringTokenizer2.countTokens();
            stringTokenizer = new StringTokenizer(string2, ",", false);
            int n2 = stringTokenizer.countTokens();
            if (n2 != n2) {
                throw new JarCacheVersionException(ResourceHandler.getMessage("cache.version_attrib_error"));
            }
            while (stringTokenizer2.hasMoreTokens()) {
                string5 = stringTokenizer2.nextToken().trim();
                string4 = stringTokenizer.nextToken().trim();
                hashMap.put(string5, string4);
            }
        }
        if (string3 != null) {
            stringTokenizer2 = new StringTokenizer(string3, ",", false);
            block1: while (stringTokenizer2.hasMoreTokens()) {
                String string6 = stringTokenizer2.nextToken().trim();
                stringTokenizer = new StringTokenizer(string6, ";", false);
                string5 = stringTokenizer.nextToken().trim();
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken().trim();
                    if (!Pattern.matches("\\p{XDigit}{1,4}\\.\\p{XDigit}{1,4}\\.\\p{XDigit}{1,4}\\.\\p{XDigit}{1,4}", string4)) continue;
                    hashMap.put(string5, string4);
                    continue block1;
                }
            }
        }
        return hashMap;
    }
}

