/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ExceptionListener;
import java.beans.ObjectHandler;
import java.beans.Statement;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

public class XMLDecoder {
    private InputStream in;
    private Object owner;
    private ExceptionListener exceptionListener;
    private ObjectHandler handler;

    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                this.getExceptionListener().exceptionThrown(iOException);
            }
        }
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener != null ? this.exceptionListener : Statement.defaultExceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public XMLDecoder(InputStream inputStream) {
        this(inputStream, null);
    }

    public Object getOwner() {
        return this.owner;
    }

    public Object readObject() {
        return this.handler.dequeueResult();
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    public XMLDecoder(InputStream inputStream, Object object) {
        this(inputStream, object, null);
    }

    public XMLDecoder(InputStream inputStream, Object object, ExceptionListener exceptionListener) {
        this.in = inputStream;
        this.setOwner(object);
        this.setExceptionListener(exceptionListener);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            this.handler = new ObjectHandler(this);
            sAXParser.parse(inputStream, (HandlerBase)this.handler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.getExceptionListener().exceptionThrown(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            this.getExceptionListener().exceptionThrown(exception == null ? sAXException : exception);
        }
        catch (IOException iOException) {
            this.getExceptionListener().exceptionThrown(iOException);
        }
    }
}

