/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class MemoryHandler
extends Handler {
    private static final int DEFAULT_SIZE = 1000;
    private Level pushLevel;
    private int size;
    private Handler target;
    private LogRecord[] buffer;
    int start;
    int count;
    static Class class$java$util$logging$MemoryHandler;

    public MemoryHandler() {
        this.sealed = false;
        this.configure();
        this.sealed = true;
        String string = "???";
        try {
            LogManager logManager = LogManager.getLogManager();
            string = logManager.getProperty("java.util.logging.MemoryHandler.target");
            Class clazz = ClassLoader.getSystemClassLoader().loadClass(string);
            this.target = (Handler)clazz.newInstance();
        }
        catch (Exception exception) {
            System.err.println("MemoryHandler can't load handler \"" + string + "\"");
            System.err.println("" + exception);
            throw new RuntimeException("Can't load " + string);
        }
        this.init();
    }

    public void close() throws SecurityException {
        this.target.close();
        this.setLevel(Level.OFF);
    }

    private void configure() {
        LogManager logManager = LogManager.getLogManager();
        String string = (class$java$util$logging$MemoryHandler == null ? (class$java$util$logging$MemoryHandler = MemoryHandler.class$("java.util.logging.MemoryHandler")) : class$java$util$logging$MemoryHandler).getName();
        this.pushLevel = logManager.getLevelProperty(string + ".push", Level.SEVERE);
        this.size = logManager.getIntProperty(string + ".size", 1000);
        if (this.size <= 0) {
            this.size = 1000;
        }
        this.setLevel(logManager.getLevelProperty(string + ".level", Level.ALL));
        this.setFilter(logManager.getFilterProperty(string + ".filter", null));
        this.setFormatter(logManager.getFormatterProperty(string + ".formatter", new SimpleFormatter()));
    }

    public void flush() {
        this.target.flush();
    }

    private void init() {
        this.buffer = new LogRecord[this.size];
        this.start = 0;
        this.count = 0;
    }

    public synchronized void push() {
        for (int i2 = 0; i2 < this.count; ++i2) {
            int n2 = (this.start + i2) % this.buffer.length;
            LogRecord logRecord = this.buffer[n2];
            this.target.publish(logRecord);
        }
        this.start = 0;
        this.count = 0;
    }

    public synchronized Level getPushLevel() {
        return this.pushLevel;
    }

    public void setPushLevel(Level level) throws SecurityException {
        if (level == null) {
            throw new NullPointerException();
        }
        LogManager logManager = LogManager.getLogManager();
        this.checkAccess();
        this.pushLevel = level;
    }

    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        int n2 = (this.start + this.count) % this.buffer.length;
        this.buffer[n2] = logRecord;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
        }
        if (logRecord.getLevel().intValue() >= this.pushLevel.intValue()) {
            this.push();
        }
    }

    public boolean isLoggable(LogRecord logRecord) {
        return super.isLoggable(logRecord);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public MemoryHandler(Handler handler, int n2, Level level) {
        if (handler == null || level == null) {
            throw new NullPointerException();
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.sealed = false;
        this.configure();
        this.sealed = true;
        this.target = handler;
        this.pushLevel = level;
        this.size = n2;
        this.init();
    }
}

