/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Patch;
import javax.sound.midi.Track;

public class Sequence {
    public static final float PPQ = 0.0f;
    public static final float SMPTE_24 = 24.0f;
    public static final float SMPTE_25 = 25.0f;
    public static final float SMPTE_30DROP = 29.97f;
    public static final float SMPTE_30 = 30.0f;
    protected float divisionType;
    protected int resolution;
    protected Vector tracks = new Vector();

    public float getDivisionType() {
        return this.divisionType;
    }

    public int getResolution() {
        return this.resolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMicrosecondLength() {
        long l2 = this.getTickLength();
        if (this.divisionType != 0.0f) {
            double d2 = (double)this.getTickLength() / (double)(this.divisionType * (float)this.resolution);
            return (long)(1000000.0 * d2);
        }
        Track track = new Track();
        Track track2 = null;
        MidiEvent midiEvent = null;
        MidiMessage midiMessage = null;
        Object var9_7 = null;
        Vector vector = this.tracks;
        synchronized (vector) {
            for (int i2 = 0; i2 < this.tracks.size(); ++i2) {
                track2 = (Track)this.tracks.elementAt(i2);
                for (int i3 = 0; i3 < track2.size(); ++i3) {
                    midiEvent = track2.get(i3);
                    midiMessage = midiEvent.getMessage();
                    if (!(midiMessage instanceof MetaMessage) || ((MetaMessage)midiMessage).getType() != 81) continue;
                    track.add(midiEvent);
                }
            }
        }
        int n2 = 500000;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        for (int i4 = 0; i4 < track.size() - 1; ++i4) {
            midiEvent = track.get(i4);
            l5 = midiEvent.getTick();
            if (l5 < l4) continue;
            l3 += (l5 - l4) * (long)n2 / (long)this.resolution;
            l4 = l5;
            byte[] byArray = ((MetaMessage)midiEvent.getMessage()).getMessage();
            n2 = 0xFF & byArray[5];
            n2 |= (0xFF & byArray[4]) << 8;
            n2 |= (0xFF & byArray[3]) << 16;
        }
        l5 = this.getTickLength();
        if (l5 > l4) {
            l3 += (l5 - l4) * (long)n2 / (long)this.resolution;
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTickLength() {
        long l2 = 0L;
        Vector vector = this.tracks;
        synchronized (vector) {
            for (int i2 = 0; i2 < this.tracks.size(); ++i2) {
                long l3 = ((Track)this.tracks.elementAt(i2)).ticks();
                if (l3 <= l2) continue;
                l2 = l3;
            }
            return l2;
        }
    }

    public Sequence(float f2, int n2) throws InvalidMidiDataException {
        if (f2 == 0.0f) {
            this.divisionType = 0.0f;
        } else if (f2 == 24.0f) {
            this.divisionType = 24.0f;
        } else if (f2 == 25.0f) {
            this.divisionType = 25.0f;
        } else if (f2 == 29.97f) {
            this.divisionType = 29.97f;
        } else if (f2 == 30.0f) {
            this.divisionType = 30.0f;
        } else {
            throw new InvalidMidiDataException("Unsupported division type: " + f2);
        }
        this.resolution = n2;
    }

    public Sequence(float f2, int n2, int n3) throws InvalidMidiDataException {
        if (f2 == 0.0f) {
            this.divisionType = 0.0f;
        } else if (f2 == 24.0f) {
            this.divisionType = 24.0f;
        } else if (f2 == 25.0f) {
            this.divisionType = 25.0f;
        } else if (f2 == 29.97f) {
            this.divisionType = 29.97f;
        } else if (f2 == 30.0f) {
            this.divisionType = 30.0f;
        } else {
            throw new InvalidMidiDataException("Unsupported division type: " + f2);
        }
        this.resolution = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.tracks.addElement(new Track());
        }
    }

    public Patch[] getPatchList() {
        return new Patch[0];
    }

    public Track createTrack() {
        Track track = new Track();
        this.tracks.addElement(track);
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Track[] getTracks() {
        Vector vector = this.tracks;
        synchronized (vector) {
            Track[] trackArray = new Track[this.tracks.size()];
            for (int i2 = 0; i2 < trackArray.length; ++i2) {
                trackArray[i2] = (Track)this.tracks.elementAt(i2);
            }
            return trackArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTrack(Track track) {
        Vector vector = this.tracks;
        synchronized (vector) {
            return this.tracks.removeElement(track);
        }
    }
}

