/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;

public abstract class TableView
extends BoxView {
    int[] columnSpans;
    int[] columnOffsets;
    SizeRequirements[] columnRequirements;
    Vector rows = new Vector();
    boolean gridValid = false;
    private static final BitSet EMPTY = new BitSet();

    int getColumnCount() {
        return this.columnSpans.length;
    }

    int getRowCount() {
        return this.rows.size();
    }

    void invalidateGrid() {
        this.gridValid = false;
    }

    void updateGrid() {
        if (!this.gridValid) {
            int n2;
            int n3;
            this.rows.removeAllElements();
            int n4 = this.getViewCount();
            for (n3 = 0; n3 < n4; ++n3) {
                View view = this.getView(n3);
                if (!(view instanceof TableRow)) continue;
                this.rows.addElement(view);
                TableRow tableRow = (TableRow)view;
                tableRow.clearFilledColumns();
                tableRow.setRow(n3);
            }
            n3 = 0;
            int n5 = this.rows.size();
            for (n2 = 0; n2 < n5; ++n2) {
                TableRow tableRow = this.getRow(n2);
                int n6 = 0;
                int n7 = 0;
                while (n7 < tableRow.getViewCount()) {
                    View view = tableRow.getView(n7);
                    while (tableRow.isFilled(n6)) {
                        ++n6;
                    }
                    int n8 = this.getRowsOccupied(view);
                    int n9 = this.getColumnsOccupied(view);
                    if (n9 > 1 || n8 > 1) {
                        int n10 = n2 + n8;
                        int n11 = n6 + n9;
                        for (int i2 = n2; i2 < n10; ++i2) {
                            for (int i3 = n6; i3 < n11; ++i3) {
                                if (i2 == n2 && i3 == n6) continue;
                                this.addFill(i2, i3);
                            }
                        }
                        if (n9 > 1) {
                            n6 += n9 - 1;
                        }
                    }
                    ++n7;
                    ++n6;
                }
                n3 = Math.max(n3, n6);
            }
            this.columnSpans = new int[n3];
            this.columnOffsets = new int[n3];
            this.columnRequirements = new SizeRequirements[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.columnRequirements[n2] = new SizeRequirements();
            }
            this.gridValid = true;
        }
    }

    int getColumnSpan(int n2) {
        return this.columnSpans[n2];
    }

    int getRowSpan(int n2) {
        TableRow tableRow = this.getRow(n2);
        if (tableRow != null) {
            return (int)((View)tableRow).getPreferredSpan(1);
        }
        return 0;
    }

    void calculateColumnRequirements(int n2) {
        int n3;
        View view;
        int n4;
        int n5;
        int n6;
        TableRow tableRow;
        int n7;
        boolean bl2 = false;
        int n8 = this.getRowCount();
        for (n7 = 0; n7 < n8; ++n7) {
            tableRow = this.getRow(n7);
            n6 = 0;
            n5 = tableRow.getViewCount();
            n4 = 0;
            while (n4 < n5) {
                view = tableRow.getView(n4);
                while (tableRow.isFilled(n6)) {
                    ++n6;
                }
                n3 = this.getRowsOccupied(view);
                int n9 = this.getColumnsOccupied(view);
                if (n9 == 1) {
                    this.checkSingleColumnCell(n2, n6, view);
                } else {
                    bl2 = true;
                    n6 += n9 - 1;
                }
                ++n4;
                ++n6;
            }
        }
        if (bl2) {
            for (n7 = 0; n7 < n8; ++n7) {
                tableRow = this.getRow(n7);
                n6 = 0;
                n5 = tableRow.getViewCount();
                n4 = 0;
                while (n4 < n5) {
                    view = tableRow.getView(n4);
                    while (tableRow.isFilled(n6)) {
                        ++n6;
                    }
                    n3 = this.getColumnsOccupied(view);
                    if (n3 > 1) {
                        this.checkMultiColumnCell(n2, n6, n3, view);
                        n6 += n3 - 1;
                    }
                    ++n4;
                    ++n6;
                }
            }
        }
    }

    void addFill(int n2, int n3) {
        TableRow tableRow = this.getRow(n2);
        if (tableRow != null) {
            tableRow.fillColumn(n3);
        }
    }

    protected void layoutMinorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
        this.updateGrid();
        int n4 = this.getRowCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            TableRow tableRow = this.getRow(i2);
            tableRow.layoutChanged(n3);
        }
        this.layoutColumns(n2, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(n2, n3, nArray, nArray2);
    }

    static BitSet access$000() {
        return EMPTY;
    }

    protected void layoutColumns(int n2, int[] nArray, int[] nArray2, SizeRequirements[] sizeRequirementsArray) {
        SizeRequirements.calculateTiledPositions(n2, null, sizeRequirementsArray, nArray, nArray2);
    }

    public TableView(Element element) {
        super(element, 1);
    }

    TableRow getRow(int n2) {
        if (n2 < this.rows.size()) {
            return (TableRow)this.rows.elementAt(n2);
        }
        return null;
    }

    void checkMultiColumnCell(int n2, int n3, int n4, View view) {
        int n5;
        Object[] objectArray;
        SizeRequirements[] sizeRequirementsArray;
        int n6;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (n6 = 0; n6 < n4; ++n6) {
            sizeRequirementsArray = this.columnRequirements[n3 + n6];
            l2 += (long)sizeRequirementsArray.minimum;
            l3 += (long)sizeRequirementsArray.preferred;
            l4 += (long)sizeRequirementsArray.maximum;
        }
        n6 = (int)view.getMinimumSpan(n2);
        if ((long)n6 > l2) {
            Object object;
            sizeRequirementsArray = new SizeRequirements[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                sizeRequirementsArray[i2] = this.columnRequirements[n3 + i2];
                object = sizeRequirementsArray[i2];
                object.maximum = Math.max(object.maximum, (int)view.getMaximumSpan(n2));
            }
            objectArray = new int[n4];
            object = new int[n4];
            SizeRequirements.calculateTiledPositions(n6, null, sizeRequirementsArray, object, objectArray);
            for (int i3 = 0; i3 < n4; ++i3) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[i3];
                sizeRequirements.minimum = Math.max(objectArray[i3], sizeRequirements.minimum);
                sizeRequirements.preferred = Math.max(sizeRequirements.minimum, sizeRequirements.preferred);
                sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
            }
        }
        if ((long)(n5 = (int)view.getPreferredSpan(n2)) > l3) {
            objectArray = new SizeRequirements[n4];
            for (int i4 = 0; i4 < n4; ++i4) {
                objectArray[i4] = (int)this.columnRequirements[n3 + i4];
            }
            int[] nArray = new int[n4];
            int[] nArray2 = new int[n4];
            SizeRequirements.calculateTiledPositions(n5, null, (SizeRequirements[])objectArray, nArray2, nArray);
            for (int i5 = 0; i5 < n4; ++i5) {
                int n7 = objectArray[i5];
                n7.preferred = Math.max(nArray[i5], n7.preferred);
                n7.maximum = Math.max(n7.preferred, n7.maximum);
            }
        }
    }

    void checkSingleColumnCell(int n2, int n3, View view) {
        SizeRequirements sizeRequirements = this.columnRequirements[n3];
        sizeRequirements.minimum = Math.max((int)view.getMinimumSpan(n2), sizeRequirements.minimum);
        sizeRequirements.preferred = Math.max((int)view.getPreferredSpan(n2), sizeRequirements.preferred);
        sizeRequirements.maximum = Math.max((int)view.getMaximumSpan(n2), sizeRequirements.maximum);
    }

    public void replace(int n2, int n3, View[] viewArray) {
        super.replace(n2, n3, viewArray);
        this.invalidateGrid();
    }

    int getColumnsOccupied(View view) {
        AttributeSet attributeSet = view.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.COLSPAN);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    int getRowsOccupied(View view) {
        AttributeSet attributeSet = view.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.ROWSPAN);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
        this.updateGrid();
        this.calculateColumnRequirements(n2);
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (int i2 = 0; i2 < this.columnRequirements.length; ++i2) {
            SizeRequirements sizeRequirements2 = this.columnRequirements[i2];
            l2 += (long)sizeRequirements2.minimum;
            l3 += (long)sizeRequirements2.preferred;
            l4 += (long)sizeRequirements2.maximum;
        }
        sizeRequirements.minimum = (int)l2;
        sizeRequirements.preferred = (int)l3;
        sizeRequirements.maximum = (int)l4;
        sizeRequirements.alignment = 0.0f;
        return sizeRequirements;
    }

    protected TableCell createTableCell(Element element) {
        return new TableCell(this, element);
    }

    protected TableRow createTableRow(Element element) {
        return new TableRow(this, element);
    }

    protected View getViewAtPosition(int n2, Rectangle rectangle) {
        int n3 = this.getViewCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            View view = this.getView(i2);
            int n4 = view.getStartOffset();
            int n5 = view.getEndOffset();
            if (n2 < n4 || n2 >= n5) continue;
            if (rectangle != null) {
                this.childAllocation(i2, rectangle);
            }
            return view;
        }
        if (n2 == this.getEndOffset()) {
            View view = this.getView(n3 - 1);
            if (rectangle != null) {
                this.childAllocation(n3 - 1, rectangle);
            }
            return view;
        }
        return null;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Container container;
        super.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        if (shape != null && (container = this.getContainer()) != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    static interface GridCell {
        public int getColumnCount();

        public int getGridColumn();

        public int getGridRow();

        public int getRowCount();

        public void setGridLocation(int var1, int var2);
    }

    public class TableCell
    extends BoxView
    implements GridCell {
        int row;
        int col;
        private final TableView this$0;

        public int getColumnCount() {
            return 1;
        }

        public int getGridColumn() {
            return this.col;
        }

        public int getGridRow() {
            return this.row;
        }

        public int getRowCount() {
            return 1;
        }

        public void setGridLocation(int n2, int n3) {
            this.row = n2;
            this.col = n3;
        }

        public TableCell(TableView tableView, Element element) {
            this.this$0 = tableView;
            super(element, 1);
        }
    }

    public class TableRow
    extends BoxView {
        BitSet fillColumns;
        int row;
        private final TableView this$0;

        int getColumnCount() {
            int n2 = 0;
            int n3 = this.fillColumns.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!this.fillColumns.get(i2)) continue;
                ++n2;
            }
            return this.getViewCount() + n2;
        }

        int getRow() {
            return this.row;
        }

        void clearFilledColumns() {
            this.fillColumns.and(TableView.access$000());
        }

        public int getResizeWeight(int n2) {
            return 1;
        }

        void fillColumn(int n2) {
            this.fillColumns.set(n2);
        }

        void setRow(int n2) {
            this.row = n2;
        }

        boolean isFilled(int n2) {
            return this.fillColumns.get(n2);
        }

        protected void layoutMajorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
            int n4 = 0;
            int n5 = this.getViewCount();
            int n6 = 0;
            while (n6 < n5) {
                View view = this.getView(n6);
                while (this.isFilled(n4)) {
                    ++n4;
                }
                int n7 = this.this$0.getColumnsOccupied(view);
                nArray2[n6] = this.this$0.columnSpans[n4];
                nArray[n6] = this.this$0.columnOffsets[n4];
                if (n7 > 1) {
                    int n8 = this.this$0.columnSpans.length;
                    for (int i2 = 1; i2 < n7; ++i2) {
                        if (n4 + i2 >= n8) continue;
                        int n9 = n6;
                        nArray2[n9] = nArray2[n9] + this.this$0.columnSpans[n4 + i2];
                    }
                    n4 += n7 - 1;
                }
                ++n6;
                ++n4;
            }
        }

        protected void layoutMinorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
            super.layoutMinorAxis(n2, n3, nArray, nArray2);
            int n4 = 0;
            int n5 = this.getViewCount();
            int n6 = 0;
            while (n6 < n5) {
                View view = this.getView(n6);
                while (this.isFilled(n4)) {
                    ++n4;
                }
                int n7 = this.this$0.getColumnsOccupied(view);
                int n8 = this.this$0.getRowsOccupied(view);
                if (n8 > 1) {
                    for (int i2 = 1; i2 < n8; ++i2) {
                        int n9 = this.getRow() + i2;
                        if (n9 >= this.this$0.getViewCount()) continue;
                        int n10 = this.this$0.getSpan(1, this.getRow() + i2);
                        int n11 = n6;
                        nArray2[n11] = nArray2[n11] + n10;
                    }
                }
                if (n7 > 1) {
                    n4 += n7 - 1;
                }
                ++n6;
                ++n4;
            }
        }

        public void replace(int n2, int n3, View[] viewArray) {
            super.replace(n2, n3, viewArray);
            this.this$0.invalidateGrid();
        }

        public TableRow(TableView tableView, Element element) {
            this.this$0 = tableView;
            super(element, 0);
            this.fillColumns = new BitSet();
        }

        protected View getViewAtPosition(int n2, Rectangle rectangle) {
            int n3 = this.getViewCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                View view = this.getView(i2);
                int n4 = view.getStartOffset();
                int n5 = view.getEndOffset();
                if (n2 < n4 || n2 >= n5) continue;
                if (rectangle != null) {
                    this.childAllocation(i2, rectangle);
                }
                return view;
            }
            if (n2 == this.getEndOffset()) {
                View view = this.getView(n3 - 1);
                if (rectangle != null) {
                    this.childAllocation(n3 - 1, rectangle);
                }
                return view;
            }
            return null;
        }
    }
}

