/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.dtm.ref.DTMNodeList;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.RTFIterator;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.NodeList;

public class XRTreeFrag
extends XObject
implements Cloneable {
    DTM m_dtm;
    int m_dtmRoot;
    XPathContext m_xctxt;
    boolean m_allowRelease = false;
    private XMLString m_xmlStr = null;

    public double num() throws TransformerException {
        XMLString xMLString = this.xstr();
        return xMLString.toDouble();
    }

    public int getType() {
        return 5;
    }

    public int rtf() {
        return this.m_dtmRoot;
    }

    public void destruct() {
        int n2;
        DTM dTM;
        if (null != this.m_dtm && (dTM = this.m_xctxt.getDTM(n2 = this.m_xctxt.getDTMIdentity(this.m_dtm))) == this.m_dtm) {
            this.m_xctxt.release(this.m_dtm, true);
            this.m_dtm = null;
            this.m_xctxt = null;
        }
        this.m_obj = null;
    }

    public void detach() {
        if (this.m_allowRelease) {
            int n2 = this.m_xctxt.getDTMIdentity(this.m_dtm);
            DTM dTM = this.m_xctxt.getDTM(n2);
            if (dTM == this.m_dtm) {
                this.m_xctxt.release(this.m_dtm, true);
                this.m_dtm = null;
                this.m_xctxt = null;
            }
            this.m_obj = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destruct();
        }
        finally {
            super.finalize();
        }
    }

    public boolean bool() {
        return true;
    }

    public void allowDetachToRelease(boolean bl2) {
        this.m_allowRelease = bl2;
    }

    public Object object() {
        if (this.m_xctxt != null) {
            return new DTMNodeIterator(new NodeSetDTM(this.m_dtmRoot, this.m_xctxt.getDTMManager()));
        }
        return super.object();
    }

    public String getTypeString() {
        return "#RTREEFRAG";
    }

    public String str() {
        String string = ((Object)this.m_dtm.getStringValue(this.m_dtmRoot)).toString();
        return null == string ? "" : string;
    }

    public DTMIterator asNodeIterator() {
        return new RTFIterator(this.m_dtmRoot, this.m_xctxt.getDTMManager());
    }

    public void appendToFsb(FastStringBuffer fastStringBuffer) {
        XString xString = (XString)this.xstr();
        xString.appendToFsb(fastStringBuffer);
    }

    public XMLString xstr() {
        if (null == this.m_xmlStr) {
            this.m_xmlStr = this.m_dtm.getStringValue(this.m_dtmRoot);
        }
        return this.m_xmlStr;
    }

    public XRTreeFrag(Expression expression) {
        super(expression);
    }

    public XRTreeFrag(int n2, XPathContext xPathContext) {
        super(null);
        this.m_dtmRoot = n2;
        this.m_xctxt = xPathContext;
        this.m_dtm = xPathContext.getDTM(n2);
    }

    public boolean equals(XObject xObject) {
        try {
            if (4 == xObject.getType()) {
                return xObject.equals(this);
            }
            if (1 == xObject.getType()) {
                return this.bool() == xObject.bool();
            }
            if (2 == xObject.getType()) {
                return this.num() == xObject.num();
            }
            if (4 == xObject.getType()) {
                return this.xstr().equals(xObject.xstr());
            }
            if (3 == xObject.getType()) {
                return this.xstr().equals(xObject.xstr());
            }
            if (5 == xObject.getType()) {
                return this.xstr().equals(xObject.xstr());
            }
            return super.equals(xObject);
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
    }

    public NodeList convertToNodeset() {
        if (this.m_obj instanceof NodeList) {
            return (NodeList)this.m_obj;
        }
        return new DTMNodeList(this.asNodeIterator());
    }

    public XRTreeFrag(int n2, XPathContext xPathContext, ExpressionNode expressionNode) {
        super(null);
        this.exprSetParent(expressionNode);
        this.m_dtmRoot = n2;
        this.m_xctxt = xPathContext;
        this.m_dtm = xPathContext.getDTM(n2);
    }
}

