/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class OrientableFlowLayout
extends FlowLayout {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int TOP = 0;
    public static final int BOTTOM = 2;
    int orientation;
    int vAlign;
    int vHGap;
    int vVGap;

    public OrientableFlowLayout() {
        this(0, 1, 1, 5, 5, 5, 5);
    }

    public synchronized void orientHorizontally() {
        this.orientation = 0;
    }

    public synchronized void orientVertically() {
        this.orientation = 1;
    }

    public OrientableFlowLayout(int n2) {
        this(n2, 1, 1, 5, 5, 5, 5);
    }

    public OrientableFlowLayout(int n2, int n3, int n4) {
        this(n2, n3, n4, 5, 5, 5, 5);
    }

    public OrientableFlowLayout(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(n3, n5, n6);
        this.orientation = n2;
        this.vAlign = n4;
        this.vHGap = n7;
        this.vVGap = n8;
    }

    public void layoutContainer(Container container) {
        if (this.orientation == 0) {
            super.layoutContainer(container);
        } else {
            Insets insets = container.insets();
            Dimension dimension = container.size();
            int n2 = dimension.height - (insets.top + insets.bottom + this.vVGap * 2);
            int n3 = insets.left + this.vHGap;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = container.countComponents();
            for (int i2 = 0; i2 < n7; ++i2) {
                Component component = container.getComponent(i2);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.preferredSize();
                component.resize(dimension2.width, dimension2.height);
                if (n4 == 0 || n4 + dimension2.height <= n2) {
                    if (n4 > 0) {
                        n4 += this.vVGap;
                    }
                    n4 += dimension2.height;
                    n5 = Math.max(n5, dimension2.width);
                    continue;
                }
                this.moveComponents(container, n3, insets.top + this.vVGap, n5, n2 - n4, n6, i2);
                n3 += this.vHGap + n5;
                n4 = dimension2.width;
                n5 = dimension2.width;
                n6 = i2;
            }
            this.moveComponents(container, n3, insets.top + this.vVGap, n5, n2 - n4, n6, n7);
        }
    }

    private void moveComponents(Container container, int n2, int n3, int n4, int n5, int n6, int n7) {
        switch (this.vAlign) {
            case 0: {
                break;
            }
            case 1: {
                n3 += n5 / 2;
                break;
            }
            case 2: {
                n3 += n5;
            }
        }
        for (int i2 = n6; i2 < n7; ++i2) {
            Component component = container.getComponent(i2);
            Dimension dimension = component.size();
            if (!component.isVisible()) continue;
            component.move(n2 + (n4 - dimension.width) / 2, n3);
            n3 += this.vVGap + dimension.height;
        }
    }

    public String toString() {
        String string = "";
        switch (this.orientation) {
            case 0: {
                string = "orientation=horizontal, ";
                break;
            }
            case 1: {
                string = "orientation=vertical, ";
            }
        }
        return this.getClass().getName() + "[" + string + super.toString() + "]";
    }

    public Dimension minimumLayoutSize(Container container) {
        if (this.orientation == 0) {
            return super.minimumLayoutSize(container);
        }
        Dimension dimension = new Dimension(0, 0);
        int n2 = container.countComponents();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.minimumSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            if (i2 > 0) {
                dimension.height += this.vVGap;
            }
            dimension.height += dimension2.height;
        }
        Insets insets = container.insets();
        dimension.width += insets.left + insets.right + this.vHGap * 2;
        dimension.height += insets.top + insets.bottom + this.vVGap * 2;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        if (this.orientation == 0) {
            return super.preferredLayoutSize(container);
        }
        Dimension dimension = new Dimension(0, 0);
        int n2 = container.countComponents();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.preferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            if (i2 > 0) {
                dimension.height += this.vVGap;
            }
            dimension.height += dimension2.height;
        }
        Insets insets = container.insets();
        dimension.width += insets.left + insets.right + this.vHGap * 2;
        dimension.height += insets.top + insets.bottom + this.vVGap * 2;
        return dimension;
    }
}

