/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.EUC_JP;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208_Solaris_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Solaris_Encoder;
import sun.nio.cs.ext.JIS_X_0212_Solaris_Decoder;
import sun.nio.cs.ext.JIS_X_0212_Solaris_Encoder;

public class EUC_JP_Open
extends Charset
implements HistoricallyNamedCharset {
    public EUC_JP_Open() {
        super("x-eucJP-Open", ExtendedCharsets.aliasesFor("x-eucJP-Open"));
    }

    public String historicalName() {
        return "EUC_JP_Solaris";
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof JIS_X_0201 || charset instanceof EUC_JP;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this, null);
    }

    public CharsetEncoder newEncoder() {
        byte[] byArray = new byte[]{63};
        return new Encoder(this, null).replaceWith(byArray);
    }

    static class 1 {
    }

    private static class Decoder
    extends EUC_JP.Decoder {
        JIS_X_0201.Decoder decoderJ0201;
        JIS_X_0212_Solaris_Decoder decodeMappingJ0212;
        JIS_X_0208_Solaris_Decoder decodeMappingJ0208;
        short[] j0208Index1;
        String[] j0208Index2;
        protected final char REPLACE_CHAR = (char)65533;

        public boolean canEncode(char c) {
            return true;
        }

        protected char decode0212(int n, int n2) {
            return this.decodeMappingJ0212.decodeDouble(n, n2);
        }

        protected char decodeDouble(int n, int n2) {
            block6: {
                block5: {
                    if (n == 142) {
                        return this.decoderJ0201.decode(n2 - 256);
                    }
                    if (n < 0) break block5;
                    Decoder decoder = this;
                    if (n <= decoder.decodeMappingJ0208.getIndex1().length && n2 >= this.decodeMappingJ0208.start && n2 <= this.decodeMappingJ0208.end) break block6;
                }
                return '\ufffd';
            }
            char c = super.decodeDouble(n, n2);
            if (c != '\ufffd') {
                return c;
            }
            int n3 = (this.j0208Index1[n - 128] & 0xF) * (this.decodeMappingJ0208.end - this.decodeMappingJ0208.start + 1) + (n2 - this.decodeMappingJ0208.start);
            return this.j0208Index2[this.j0208Index1[n - 128] >> 4].charAt(n3);
        }

        private Decoder(Charset charset) {
            super(charset);
            this.decoderJ0201 = new JIS_X_0201.Decoder(charset);
            this.decodeMappingJ0212 = new JIS_X_0212_Solaris_Decoder(charset);
            this.decodeMappingJ0208 = new JIS_X_0208_Solaris_Decoder(charset);
            this.decodeMappingJ0208.start = 161;
            this.decodeMappingJ0208.end = 254;
            Decoder decoder = this;
            this.j0208Index1 = decoder.decodeMappingJ0208.getIndex1();
            Decoder decoder2 = this;
            this.j0208Index2 = decoder2.decodeMappingJ0208.getIndex2();
        }

        Decoder(Charset charset, 1 var2_2) {
            this(charset);
        }
    }

    private static class Encoder
    extends EUC_JP.Encoder {
        JIS_X_0201.Encoder encoderJ0201;
        JIS_X_0212_Solaris_Encoder encoderJ0212;
        JIS_X_0208_Solaris_Encoder encoderJ0208;
        short[] j0208Index1;
        String[] j0208Index2;
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        protected int encodeDouble(char c) {
            int n = super.encodeDouble(c);
            if (n != 0) {
                return n;
            }
            int n2 = this.j0208Index1[(c & 0xFF00) >> 8] << 8;
            n = this.j0208Index2[n2 >> 12].charAt((n2 & 0xFFF) + (c & 0xFF));
            if (n > 29952) {
                return 0x8F8080 + this.encoderJ0212.encodeDouble(c);
            }
            return n == 0 ? 0 : n + 32896;
        }

        protected int encodeSingle(char c, byte[] byArray) {
            if (c == '\u0000') {
                byArray[0] = 0;
                return 1;
            }
            byte by = this.encoderJ0201.encode(c);
            if (by == 0) {
                return 0;
            }
            if (by > 0 && by < 128) {
                byArray[0] = by;
                return 1;
            }
            byArray[0] = -114;
            byArray[1] = by;
            return 2;
        }

        private Encoder(Charset charset) {
            super(charset);
            this.encoderJ0201 = new JIS_X_0201.Encoder(charset);
            this.encoderJ0212 = new JIS_X_0212_Solaris_Encoder(charset);
            this.encoderJ0208 = new JIS_X_0208_Solaris_Encoder(charset);
            Encoder encoder = this;
            this.j0208Index1 = encoder.encoderJ0208.getIndex1();
            Encoder encoder2 = this;
            this.j0208Index2 = encoder2.encoderJ0208.getIndex2();
        }

        Encoder(Charset charset, 1 var2_2) {
            this(charset);
        }
    }
}

