/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import com.sun.java.swing.SwingUtilities2;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;
import sun.awt.AppContext;

public class SwingUtilities
implements SwingConstants {
    private static boolean canAccessEventQueue = false;
    private static boolean eventQueueTested = false;
    private static final Object sharedOwnerFrameKey = new StringBuffer("SwingUtilities.sharedOwnerFrame");

    private SwingUtilities() {
        throw new Error("SwingUtilities is just a container for static methods");
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static int getAccessibleChildrenCount(Component component) {
        return component.getAccessibleContext().getAccessibleChildrenCount();
    }

    public static int getAccessibleIndexInParent(Component component) {
        return component.getAccessibleContext().getAccessibleIndexInParent();
    }

    public static void updateComponentTreeUI(Component component) {
        SwingUtilities.updateComponentTreeUI0(component);
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private static void updateComponentTreeUI0(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                SwingUtilities.updateComponentTreeUI0(componentArray[i2]);
            }
        }
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static Frame getSharedOwnerFrame() throws HeadlessException {
        Frame frame = (Frame)SwingUtilities.appContextGet(sharedOwnerFrameKey);
        if (frame == null) {
            frame = new Frame(){

                public synchronized void dispose() {
                    try {
                        this.getToolkit().getSystemEventQueue();
                        super.dispose();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void show() {
                }
            };
            SwingUtilities.appContextPut(sharedOwnerFrameKey, frame);
        }
        return frame;
    }

    static boolean isValidKeyEventForKeyBindings(KeyEvent keyEvent) {
        int n2;
        return keyEvent.getID() != 400 || ((n2 = keyEvent.getModifiers()) & 8) == 0 || (n2 & 2) != 0;
    }

    public static boolean processKeyBindings(KeyEvent keyEvent) {
        if (keyEvent != null) {
            boolean bl2;
            Component component;
            if (keyEvent.isConsumed()) {
                return false;
            }
            Component component2 = component = keyEvent.getComponent();
            boolean bl3 = bl2 = keyEvent.getID() == 401;
            if (!SwingUtilities.isValidKeyEventForKeyBindings(keyEvent)) {
                return false;
            }
            while (component != null) {
                if (component instanceof JComponent) {
                    return ((JComponent)component).processKeyBindings(keyEvent, bl2);
                }
                component2 = component;
                component = component.getParent();
            }
            if (component2 instanceof Applet || component2 instanceof Window) {
                return JComponent.processKeyBindingsForAllComponents(keyEvent, (Container)component2, bl2);
            }
        }
        return false;
    }

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 0x10) != 0;
    }

    public static boolean isMiddleMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 8) == 8;
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 4) == 4;
    }

    static void appContextRemove(Object object) {
        AppContext.getAppContext().remove(object);
    }

    static final void doPrivileged(Runnable runnable) {
        AccessController.doPrivileged(new PrivilegedAction(runnable){
            private final Runnable val$doRun;

            public Object run() {
                this.val$doRun.run();
                return null;
            }
            {
                this.val$doRun = runnable;
            }
        });
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(runnable);
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    static int findDisplayedMnemonicIndex(String string, int n2) {
        if (string == null || n2 == 0) {
            return -1;
        }
        char c2 = Character.toUpperCase((char)n2);
        char c3 = Character.toLowerCase((char)n2);
        int n3 = string.indexOf(c2);
        int n4 = string.indexOf(c3);
        if (n3 == -1) {
            return n4;
        }
        if (n4 == -1) {
            return n3;
        }
        return n4 < n3 ? n4 : n3;
    }

    public static Component findFocusOwner(Component component) {
        Component component2;
        Component component3 = component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (component3 != null) {
            if (component3 == component) {
                return component2;
            }
            component3 = component3 instanceof Window ? null : component3.getParent();
        }
        return null;
    }

    public static Component getRoot(Component component) {
        Component component2 = null;
        for (Component component3 = component; component3 != null; component3 = component3.getParent()) {
            if (component3 instanceof Window) {
                return component3;
            }
            if (!(component3 instanceof Applet)) continue;
            component2 = component3;
        }
        return component2;
    }

    public static Component getDeepestComponentAt(Component component, int n2, int n3) {
        if (!component.contains(n2, n3)) {
            return null;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                Component component2 = componentArray[i2];
                if (component2 == null || !component2.isVisible()) continue;
                Point point = component2.getLocation();
                if ((component2 = component2 instanceof Container ? SwingUtilities.getDeepestComponentAt(component2, n2 - point.x, n3 - point.y) : component2.getComponentAt(n2 - point.x, n3 - point.y)) == null || !component2.isVisible()) continue;
                return component2;
            }
        }
        return component;
    }

    public static boolean isDescendingFrom(Component component, Component component2) {
        if (component == component2) {
            return true;
        }
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (container != component2) continue;
            return true;
        }
        return false;
    }

    public static void convertPointFromScreen(Point point, Component component) {
        do {
            int n2;
            int n3;
            if (component instanceof JComponent) {
                n3 = ((JComponent)component).getX();
                n2 = ((JComponent)component).getY();
            } else if (component instanceof Applet || component instanceof Window) {
                try {
                    Point point2 = component.getLocationOnScreen();
                    n3 = point2.x;
                    n2 = point2.y;
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    n3 = component.getX();
                    n2 = component.getY();
                }
            } else {
                n3 = component.getX();
                n2 = component.getY();
            }
            point.x -= n3;
            point.y -= n2;
        } while (!(component instanceof Window) && !(component instanceof Applet) && (component = component.getParent()) != null);
    }

    public static void convertPointToScreen(Point point, Component component) {
        do {
            int n2;
            int n3;
            if (component instanceof JComponent) {
                n3 = ((JComponent)component).getX();
                n2 = ((JComponent)component).getY();
            } else if (component instanceof Applet || component instanceof Window) {
                try {
                    Point point2 = component.getLocationOnScreen();
                    n3 = point2.x;
                    n2 = point2.y;
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    n3 = component.getX();
                    n2 = component.getY();
                }
            } else {
                n3 = component.getX();
                n2 = component.getY();
            }
            point.x += n3;
            point.y += n2;
        } while (!(component instanceof Window) && !(component instanceof Applet) && (component = component.getParent()) != null);
    }

    static boolean doesIconReferenceImage(Icon icon, Image image) {
        Image image2 = icon != null && icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
        return image2 == image;
    }

    static Point convertScreenLocationToParent(Container container, int n2, int n3) {
        for (Container container2 = container; container2 != null; container2 = container2.getParent()) {
            if (!(container2 instanceof Window)) continue;
            Point point = new Point(n2, n3);
            SwingUtilities.convertPointFromScreen(point, container);
            return point;
        }
        throw new Error("convertScreenLocationToParent: no window ancestor");
    }

    public static Rectangle getLocalBounds(Component component) {
        Rectangle rectangle = new Rectangle(component.getBounds());
        rectangle.y = 0;
        rectangle.x = 0;
        return rectangle;
    }

    public static Rectangle computeIntersection(int n2, int n3, int n4, int n5, Rectangle rectangle) {
        int n6 = n2 > rectangle.x ? n2 : rectangle.x;
        int n7 = n2 + n4 < rectangle.x + rectangle.width ? n2 + n4 : rectangle.x + rectangle.width;
        int n8 = n3 > rectangle.y ? n3 : rectangle.y;
        int n9 = n3 + n5 < rectangle.y + rectangle.height ? n3 + n5 : rectangle.y + rectangle.height;
        rectangle.x = n6;
        rectangle.y = n8;
        rectangle.width = n7 - n6;
        rectangle.height = n9 - n8;
        if (rectangle.width < 0 || rectangle.height < 0) {
            rectangle.height = 0;
            rectangle.width = 0;
            rectangle.y = 0;
            rectangle.x = 0;
        }
        return rectangle;
    }

    public static Rectangle computeUnion(int n2, int n3, int n4, int n5, Rectangle rectangle) {
        int n6 = n2 < rectangle.x ? n2 : rectangle.x;
        int n7 = n2 + n4 > rectangle.x + rectangle.width ? n2 + n4 : rectangle.x + rectangle.width;
        int n8 = n3 < rectangle.y ? n3 : rectangle.y;
        int n9 = n3 + n5 > rectangle.y + rectangle.height ? n3 + n5 : rectangle.y + rectangle.height;
        rectangle.x = n6;
        rectangle.y = n8;
        rectangle.width = n7 - n6;
        rectangle.height = n9 - n8;
        return rectangle;
    }

    public static final boolean isRectangleContainingRectangle(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width && rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
    }

    public static Window getWindowAncestor(Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            return (Window)container;
        }
        return null;
    }

    public static Window windowForComponent(Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            return (Window)container;
        }
        return null;
    }

    static Class loadSystemClass(String string) throws ClassNotFoundException {
        return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
    }

    static Object appContextGet(Object object) {
        return AppContext.getAppContext().get(object);
    }

    static void appContextPut(Object object, Object object2) {
        AppContext.getAppContext().put(object, object2);
    }

    public static int computeStringWidth(FontMetrics fontMetrics, String string) {
        return fontMetrics.stringWidth(string);
    }

    public static Accessible getAccessibleChild(Component component, int n2) {
        return component.getAccessibleContext().getAccessibleChild(n2);
    }

    public static AccessibleStateSet getAccessibleStateSet(Component component) {
        return component.getAccessibleContext().getAccessibleStateSet();
    }

    public static ActionMap getUIActionMap(JComponent jComponent) {
        ActionMap actionMap = jComponent.getActionMap(false);
        while (actionMap != null) {
            ActionMap actionMap2 = actionMap.getParent();
            if (actionMap2 instanceof UIResource) {
                return actionMap2;
            }
            actionMap = actionMap2;
        }
        return null;
    }

    public static void replaceUIActionMap(JComponent jComponent, ActionMap actionMap) {
        ActionMap actionMap2 = jComponent.getActionMap(actionMap != null);
        while (actionMap2 != null) {
            ActionMap actionMap3 = actionMap2.getParent();
            if (actionMap3 == null || actionMap3 instanceof UIResource) {
                actionMap2.setParent(actionMap);
                return;
            }
            actionMap2 = actionMap3;
        }
    }

    public static InputMap getUIInputMap(JComponent jComponent, int n2) {
        InputMap inputMap = jComponent.getInputMap(n2, false);
        while (inputMap != null) {
            InputMap inputMap2 = inputMap.getParent();
            if (inputMap2 instanceof UIResource) {
                return inputMap2;
            }
            inputMap = inputMap2;
        }
        return null;
    }

    public static void replaceUIInputMap(JComponent jComponent, int n2, InputMap inputMap) {
        InputMap inputMap2 = jComponent.getInputMap(n2, inputMap != null);
        while (inputMap2 != null) {
            InputMap inputMap3 = inputMap2.getParent();
            if (inputMap3 == null || inputMap3 instanceof UIResource) {
                inputMap2.setParent(inputMap);
                return;
            }
            inputMap2 = inputMap3;
        }
    }

    public static JRootPane getRootPane(Component component) {
        if (component instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)component)).getRootPane();
        }
        while (component != null) {
            if (component instanceof JRootPane) {
                return (JRootPane)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static void paintComponent(Graphics graphics, Component component, Container container, int n2, int n3, int n4, int n5) {
        SwingUtilities.getCellRendererPane(component, container).paintComponent(graphics, component, container, n2, n3, n4, n5, false);
    }

    public static Container getAncestorOfClass(Class clazz, Component component) {
        Container container;
        if (component == null || clazz == null) {
            return null;
        }
        for (container = component.getParent(); container != null && !clazz.isInstance(container); container = container.getParent()) {
        }
        return container;
    }

    public static Container getAncestorNamed(String string, Component component) {
        Container container;
        if (component == null || string == null) {
            return null;
        }
        for (container = component.getParent(); container != null && !string.equals(container.getName()); container = container.getParent()) {
        }
        return container;
    }

    public static Point convertPoint(Component component, int n2, int n3, Component component2) {
        Point point = new Point(n2, n3);
        return SwingUtilities.convertPoint(component, point, component2);
    }

    public static Rectangle[] computeDifference(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2 == null || !rectangle.intersects(rectangle2) || SwingUtilities.isRectangleContainingRectangle(rectangle2, rectangle)) {
            return new Rectangle[0];
        }
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = null;
        Rectangle rectangle5 = null;
        Rectangle rectangle6 = null;
        Rectangle rectangle7 = null;
        int n2 = 0;
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
            rectangle3.x = rectangle.x;
            rectangle3.y = rectangle.y;
            rectangle3.width = rectangle2.x - rectangle.x;
            rectangle3.height = rectangle.height;
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                rectangle4 = new Rectangle(rectangle3);
                ++n2;
            }
            rectangle3.x = rectangle2.x;
            rectangle3.y = rectangle.y;
            rectangle3.width = rectangle2.width;
            rectangle3.height = rectangle2.y - rectangle.y;
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                rectangle5 = new Rectangle(rectangle3);
                ++n2;
            }
            rectangle3.x = rectangle2.x;
            rectangle3.y = rectangle2.y + rectangle2.height;
            rectangle3.width = rectangle2.width;
            rectangle3.height = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                rectangle6 = new Rectangle(rectangle3);
                ++n2;
            }
            rectangle3.x = rectangle2.x + rectangle2.width;
            rectangle3.y = rectangle.y;
            rectangle3.width = rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width);
            rectangle3.height = rectangle.height;
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                rectangle7 = new Rectangle(rectangle3);
                ++n2;
            }
        } else if (rectangle2.x <= rectangle.x && rectangle2.y <= rectangle.y) {
            if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
                rectangle3.x = rectangle.x;
                rectangle3.y = rectangle2.y + rectangle2.height;
                rectangle3.width = rectangle.width;
                rectangle3.height = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = rectangle3;
                    ++n2;
                }
            } else if (rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = rectangle3;
                    ++n2;
                }
            } else {
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle2.y + rectangle2.height - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n2;
                }
            }
        } else if (rectangle2.x <= rectangle.x && rectangle2.y + rectangle2.height >= rectangle.y + rectangle.height) {
            if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = rectangle3;
                    ++n2;
                }
            } else {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle2.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.y + rectangle.height - rectangle2.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n2;
                }
            }
        } else if (rectangle2.x <= rectangle.x) {
            if (rectangle2.x + rectangle2.width >= rectangle.x + rectangle.width) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n2;
                }
            } else {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle2.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle2.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle6 = new Rectangle(rectangle3);
                    ++n2;
                }
            }
        } else if (rectangle2.x <= rectangle.x + rectangle.width && rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
            if (rectangle2.y <= rectangle.y && rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = rectangle3;
                    ++n2;
                }
            } else if (rectangle2.y <= rectangle.y) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle2.y + rectangle2.height - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n2;
                }
            } else if (rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y, rectangle2.x - rectangle.x, rectangle.y + rectangle.height - rectangle2.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n2;
                }
            } else {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y, rectangle2.x - rectangle.x, rectangle2.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle6 = new Rectangle(rectangle3);
                    ++n2;
                }
            }
        } else if (rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width) {
            if (rectangle2.y <= rectangle.y && rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n2;
                }
            } else if (rectangle2.y <= rectangle.y) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle2.x, rectangle2.y + rectangle2.height, rectangle2.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle6 = new Rectangle(rectangle3);
                    ++n2;
                }
            } else {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle2.x, rectangle.y, rectangle2.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n2;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle6 = new Rectangle(rectangle3);
                    ++n2;
                }
            }
        }
        Rectangle[] rectangleArray = new Rectangle[n2];
        n2 = 0;
        if (rectangle4 != null) {
            rectangleArray[n2++] = rectangle4;
        }
        if (rectangle5 != null) {
            rectangleArray[n2++] = rectangle5;
        }
        if (rectangle6 != null) {
            rectangleArray[n2++] = rectangle6;
        }
        if (rectangle7 != null) {
            rectangleArray[n2++] = rectangle7;
        }
        return rectangleArray;
    }

    public static Rectangle calculateInnerArea(JComponent jComponent, Rectangle rectangle) {
        if (jComponent == null) {
            return null;
        }
        Rectangle rectangle2 = rectangle;
        Insets insets = jComponent.getInsets();
        if (rectangle2 == null) {
            rectangle2 = new Rectangle();
        }
        rectangle2.x = insets.left;
        rectangle2.y = insets.top;
        rectangle2.width = jComponent.getWidth() - insets.left - insets.right;
        rectangle2.height = jComponent.getHeight() - insets.top - insets.bottom;
        return rectangle2;
    }

    public static Accessible getAccessibleAt(Component component, Point point) {
        if (component instanceof Container) {
            return component.getAccessibleContext().getAccessibleComponent().getAccessibleAt(point);
        }
        if (component instanceof Accessible) {
            AccessibleContext accessibleContext;
            Accessible accessible = (Accessible)((Object)component);
            if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null) {
                int n2 = accessibleContext.getAccessibleChildrenCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    AccessibleComponent accessibleComponent;
                    accessible = accessibleContext.getAccessibleChild(i2);
                    if (accessible == null || (accessibleContext = accessible.getAccessibleContext()) == null || (accessibleComponent = accessibleContext.getAccessibleComponent()) == null || !accessibleComponent.isShowing()) continue;
                    Point point2 = accessibleComponent.getLocation();
                    Point point3 = new Point(point.x - point2.x, point.y - point2.y);
                    if (!accessibleComponent.contains(point3)) continue;
                    return accessible;
                }
            }
            return (Accessible)((Object)component);
        }
        return null;
    }

    private static CellRendererPane getCellRendererPane(Component component, Container container) {
        Container container2 = component.getParent();
        if (container2 instanceof CellRendererPane) {
            if (container2.getParent() != container) {
                container.add(container2);
            }
        } else {
            container2 = new CellRendererPane();
            container2.add(component);
            container.add(container2);
        }
        return (CellRendererPane)container2;
    }

    public static Point convertPoint(Component component, Point point, Component component2) {
        if (component == null && component2 == null) {
            return point;
        }
        if (component == null && (component = SwingUtilities.getWindowAncestor(component2)) == null) {
            throw new Error("Source component not connected to component tree hierarchy");
        }
        Point point2 = new Point(point);
        SwingUtilities.convertPointToScreen(point2, component);
        if (component2 == null && (component2 = SwingUtilities.getWindowAncestor(component)) == null) {
            throw new Error("Destination component not connected to component tree hierarchy");
        }
        SwingUtilities.convertPointFromScreen(point2, component2);
        return point2;
    }

    public static Rectangle convertRectangle(Component component, Rectangle rectangle, Component component2) {
        Point point = new Point(rectangle.x, rectangle.y);
        point = SwingUtilities.convertPoint(component, point, component2);
        return new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
    }

    public static void paintComponent(Graphics graphics, Component component, Container container, Rectangle rectangle) {
        SwingUtilities.paintComponent(graphics, component, container, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static MouseEvent convertMouseEvent(Component component, MouseEvent mouseEvent, Component component2) {
        Point point = SwingUtilities.convertPoint(component, new Point(mouseEvent.getX(), mouseEvent.getY()), component2);
        Component component3 = component2 != null ? component2 : component;
        return new MouseEvent(component3, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    public static boolean notifyAction(Action action, KeyStroke keyStroke, KeyEvent keyEvent, Object object, int n2) {
        if (action == null || !action.isEnabled()) {
            return false;
        }
        Object object2 = action.getValue("ActionCommandKey");
        boolean bl2 = object2 == null && action instanceof JComponent.ActionStandin;
        String string = object2 != null ? object2.toString() : (!bl2 && keyEvent.getKeyChar() != '\uffff' ? String.valueOf(keyEvent.getKeyChar()) : null);
        action.actionPerformed(new ActionEvent(object, 1001, string, keyEvent.getWhen(), n2));
        return true;
    }

    public static String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        return SwingUtilities.layoutCompoundLabelImpl(null, fontMetrics, string, icon, n2, n3, n4, n5, rectangle, rectangle2, rectangle3, n6);
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        boolean bl2 = true;
        int n7 = n3;
        int n8 = n5;
        if (jComponent != null && !jComponent.getComponentOrientation().isLeftToRight()) {
            bl2 = false;
        }
        switch (n3) {
            case 10: {
                n7 = bl2 ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl2 ? 4 : 2;
            }
        }
        switch (n5) {
            case 10: {
                n8 = bl2 ? 2 : 4;
                break;
            }
            case 11: {
                n8 = bl2 ? 4 : 2;
            }
        }
        return SwingUtilities.layoutCompoundLabelImpl(jComponent, fontMetrics, string, icon, n2, n7, n4, n8, rectangle, rectangle2, rectangle3, n6);
    }

    private static String layoutCompoundLabelImpl(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        int n7;
        int n8;
        int n9;
        int n10;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl2 = string == null || string.equals("");
        int n11 = 0;
        View view = null;
        if (bl2) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
        } else {
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.width = (int)view.getPreferredSpan(0);
                rectangle3.height = (int)view.getPreferredSpan(1);
            } else {
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
                n11 = SwingUtilities2.getLeftSideBearing(fontMetrics.getFont(), string);
                if (n11 < 0) {
                    rectangle3.width -= n11;
                }
                rectangle3.height = fontMetrics.getHeight();
            }
        }
        int n12 = n10 = bl2 || icon == null ? 0 : n6;
        if (!bl2 && rectangle3.width > (n9 = n5 == 0 ? rectangle.width : rectangle.width - (rectangle2.width + n10))) {
            if (view != null) {
                rectangle3.width = n9;
            } else {
                String string2 = "...";
                n8 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                for (n7 = 0; n7 < string.length() && (n8 += fontMetrics.charWidth(string.charAt(n7))) <= n9; ++n7) {
                }
                string = string.substring(0, n7) + string2;
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
            }
        }
        rectangle3.y = n4 == 1 ? (n5 != 0 ? 0 : -(rectangle3.height + n10)) : (n4 == 0 ? rectangle2.height / 2 - rectangle3.height / 2 : (n5 != 0 ? rectangle2.height - rectangle3.height : rectangle2.height + n10));
        rectangle3.x = n5 == 2 ? -(rectangle3.width + n10) : (n5 == 0 ? rectangle2.width / 2 - rectangle3.width / 2 : rectangle2.width + n10);
        n9 = Math.min(rectangle2.x, rectangle3.x);
        int n13 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n9;
        n8 = Math.min(rectangle2.y, rectangle3.y);
        n7 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n8;
        int n14 = n2 == 1 ? rectangle.y - n8 : (n2 == 0 ? rectangle.y + rectangle.height / 2 - (n8 + n7 / 2) : rectangle.y + rectangle.height - (n8 + n7));
        int n15 = n3 == 2 ? rectangle.x - n9 : (n3 == 4 ? rectangle.x + rectangle.width - (n9 + n13) : rectangle.x + rectangle.width / 2 - (n9 + n13 / 2));
        rectangle3.x += n15;
        rectangle3.y += n14;
        rectangle2.x += n15;
        rectangle2.y += n14;
        if (n11 < 0) {
            rectangle3.width += n11;
            rectangle3.x -= n11;
        }
        return string;
    }
}

