/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.orbutil;

import com.sun.corba.se.internal.io.ObjectStreamClass;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;

public final class ObjectStreamClassUtil_1_3 {
    private static Comparator compareClassByName = new CompareClassByName(null);
    private static Comparator compareMemberByName = new CompareMemberByName(null);
    private static Method hasStaticInitializerMethod = null;
    static Class class$java$io$Serializable;
    static Class class$java$io$Externalizable;
    static Class class$java$lang$Object;
    static Class class$java$io$ObjectOutputStream;
    static Class class$java$io$ObjectStreamClass;
    static Class class$java$lang$Class;

    private static long _computeSerialVersionUID(Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l2 = 0L;
        try {
            String string;
            Object object;
            int n2;
            Object[] objectArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n3 = clazz.getModifiers();
            Member[] memberArray = clazz.getDeclaredMethods();
            if (((n3 &= 0x611) & 0x200) != 0) {
                n3 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n3 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n3);
            if (!clazz.isArray()) {
                objectArray = clazz.getInterfaces();
                Arrays.sort(objectArray, compareClassByName);
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    dataOutputStream.writeUTF(((Class)objectArray[n2]).getName());
                }
            }
            objectArray = clazz.getDeclaredFields();
            Arrays.sort(objectArray, compareMemberByName);
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Object object2 = objectArray[n2];
                int n4 = ((Field)object2).getModifiers();
                if (Modifier.isPrivate(n4) && (Modifier.isTransient(n4) || Modifier.isStatic(n4))) continue;
                dataOutputStream.writeUTF(((Field)object2).getName());
                dataOutputStream.writeInt(n4);
                dataOutputStream.writeUTF(ObjectStreamClassUtil_1_3.getSignature(((Field)object2).getType()));
            }
            if (ObjectStreamClassUtil_1_3.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            MethodSignature[] methodSignatureArray = MethodSignature.removePrivateAndSort(clazz.getDeclaredConstructors());
            for (int i2 = 0; i2 < methodSignatureArray.length; ++i2) {
                MethodSignature methodSignature = methodSignatureArray[i2];
                object = "<init>";
                string = methodSignature.signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF((String)object);
                dataOutputStream.writeInt(methodSignature.member.getModifiers());
                dataOutputStream.writeUTF(string);
            }
            MethodSignature[] methodSignatureArray2 = MethodSignature.removePrivateAndSort(memberArray);
            for (int i3 = 0; i3 < methodSignatureArray2.length; ++i3) {
                object = methodSignatureArray2[i3];
                string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                dataOutputStream.writeInt(((MethodSignature)object).member.getModifiers());
                dataOutputStream.writeUTF(string);
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i4 = 0; i4 < Math.min(8, byArray.length); ++i4) {
                l2 += (long)(byArray[i4] & 0xFF) << i4 * 8;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    static long access$000(Class clazz) {
        return ObjectStreamClassUtil_1_3._computeSerialVersionUID(clazz);
    }

    public static long computeSerialVersionUID(Class clazz) {
        long l2 = ObjectStreamClass.getSerialVersionUID(clazz);
        if (l2 == 0L) {
            return l2;
        }
        l2 = ObjectStreamClassUtil_1_3.getSerialVersion(l2, clazz);
        return l2;
    }

    private static boolean hasStaticInitializer(Class clazz) {
        Serializable serializable;
        if (hasStaticInitializerMethod == null) {
            serializable = null;
            try {
                try {
                    serializable = Class.forName("sun.misc.ClassReflector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (serializable == null) {
                    serializable = class$java$io$ObjectStreamClass == null ? (class$java$io$ObjectStreamClass = ObjectStreamClassUtil_1_3.class$("java.io.ObjectStreamClass")) : class$java$io$ObjectStreamClass;
                }
                hasStaticInitializerMethod = ((Class)serializable).getDeclaredMethod("hasStaticInitializer", new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = ObjectStreamClassUtil_1_3.class$("java.lang.Class")) : class$java$lang$Class});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (hasStaticInitializerMethod == null) {
                throw new InternalError("Can't find hasStaticInitializer method on " + ((Class)serializable).getName());
            }
            hasStaticInitializerMethod.setAccessible(true);
        }
        try {
            serializable = (Boolean)hasStaticInitializerMethod.invoke(null, new Object[]{clazz});
            return (Boolean)serializable;
        }
        catch (Exception exception) {
            throw new InternalError("Error invoking hasStaticInitializer: " + exception);
        }
    }

    public static long computeStructuralUID(boolean bl2, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l2 = 0L;
        try {
            int n2;
            int n3;
            Object object;
            if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClassUtil_1_3.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = ObjectStreamClassUtil_1_3.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clazz)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null && clazz2 != (class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClassUtil_1_3.class$("java.lang.Object")) : class$java$lang$Object)) {
                boolean bl3 = false;
                Class[] classArray = new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = ObjectStreamClassUtil_1_3.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream};
                object = ObjectStreamClassUtil_1_3.getDeclaredMethod(clazz2, "writeObject", classArray, 2, 8);
                if (object != null) {
                    bl3 = true;
                }
                dataOutputStream.writeLong(ObjectStreamClassUtil_1_3.computeStructuralUID(bl3, clazz2));
            }
            if (bl2) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            Object[] objectArray = ObjectStreamClassUtil_1_3.getDeclaredFields(clazz);
            Arrays.sort(objectArray, compareMemberByName);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                object = objectArray[i2];
                n3 = ((Field)object).getModifiers();
                if (Modifier.isTransient(n3) || Modifier.isStatic(n3)) continue;
                dataOutputStream.writeUTF(((Field)object).getName());
                dataOutputStream.writeUTF(ObjectStreamClassUtil_1_3.getSignature(((Field)object).getType()));
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (n3 = n2 = Math.min(8, byArray.length); n3 > 0; --n3) {
                l2 += (long)(byArray[n3] & 0xFF) << n3 * 8;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private static Long getSerialVersion(long l2, Class clazz) {
        return (Long)AccessController.doPrivileged(new PrivilegedAction(clazz, l2){
            private final Class val$cl;
            private final long val$csuid;
            {
                this.val$cl = clazz;
                this.val$csuid = l2;
            }

            public Object run() {
                long l2;
                try {
                    Field field = this.val$cl.getDeclaredField("serialVersionUID");
                    int n2 = field.getModifiers();
                    l2 = Modifier.isStatic(n2) && Modifier.isFinal(n2) && Modifier.isPrivate(n2) ? this.val$csuid : ObjectStreamClassUtil_1_3.access$000(this.val$cl);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    l2 = ObjectStreamClassUtil_1_3.access$000(this.val$cl);
                }
                return new Long(l2);
            }
        });
    }

    private static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class clazz2 = clazz;
            int n2 = 0;
            while (clazz2.isArray()) {
                ++n2;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append("[");
            }
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    static String access$400(Constructor constructor) {
        return ObjectStreamClassUtil_1_3.getSignature(constructor);
    }

    private static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = constructor.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(classArray[i2]));
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    static String access$300(Method method) {
        return ObjectStreamClassUtil_1_3.getSignature(method);
    }

    private static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = method.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(classArray[i2]));
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    private static Field[] getDeclaredFields(Class clazz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(clazz){
            private final Class val$clz;
            {
                this.val$clz = clazz;
            }

            public Object run() {
                return this.val$clz.getDeclaredFields();
            }
        });
    }

    private static Method getDeclaredMethod(Class clazz, String string, Class[] classArray, int n2, int n3) {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(clazz, string, classArray, n3, n2){
            private final Class val$cl;
            private final String val$methodName;
            private final Class[] val$args;
            private final int val$disallowedModifierMask;
            private final int val$requiredModifierMask;

            public Object run() {
                Method method = null;
                try {
                    method = this.val$cl.getDeclaredMethod(this.val$methodName, this.val$args);
                    int n2 = method.getModifiers();
                    if ((n2 & this.val$disallowedModifierMask) != 0 || (n2 & this.val$requiredModifierMask) != this.val$requiredModifierMask) {
                        method = null;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return method;
            }
            {
                this.val$cl = clazz;
                this.val$methodName = string;
                this.val$args = classArray;
                this.val$disallowedModifierMask = n2;
                this.val$requiredModifierMask = n3;
            }
        });
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        CompareClassByName(1 var1_1) {
            this();
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        CompareMemberByName(1 var1_1) {
            this();
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = string + ObjectStreamClassUtil_1_3.access$300((Method)object);
                string2 = string2 + ObjectStreamClassUtil_1_3.access$300((Method)object2);
            } else if (object instanceof Constructor) {
                string = string + ObjectStreamClassUtil_1_3.access$400((Constructor)object);
                string2 = string2 + ObjectStreamClassUtil_1_3.access$400((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClassUtil_1_3.access$400((Constructor)member) : ObjectStreamClassUtil_1_3.access$300((Method)member);
        }

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n2 = 0;
            for (int i2 = 0; i2 < memberArray.length; ++i2) {
                if (Modifier.isPrivate(memberArray[i2].getModifiers())) continue;
                ++n2;
            }
            Object[] objectArray = new MethodSignature[n2];
            int n3 = 0;
            for (int i3 = 0; i3 < memberArray.length; ++i3) {
                if (Modifier.isPrivate(memberArray[i3].getModifiers())) continue;
                objectArray[n3] = new MethodSignature(memberArray[i3]);
                ++n3;
            }
            if (n3 > 0) {
                Arrays.sort(objectArray, objectArray[0]);
            }
            return objectArray;
        }

        public int compare(Object object, Object object2) {
            int n2;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n2 = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n2 = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n2 == 0) {
                    n2 = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n2;
        }
    }
}

