/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;

public abstract class SampleModel {
    protected int width;
    protected int height;
    protected int numBands;
    protected int dataType;

    public final int getDataType() {
        return this.dataType;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumBands() {
        return this.numBands;
    }

    public abstract int getNumDataElements();

    public int getTransferType() {
        return this.dataType;
    }

    public final int getWidth() {
        return this.width;
    }

    static {
        ColorModel.loadLibraries();
        SampleModel.initIDs();
    }

    private static native void initIDs();

    public abstract int[] getSampleSize();

    public abstract int getSampleSize(int var1);

    public SampleModel(int n2, int n3, int n4, int n5) {
        float f2 = (float)n3 * (float)n4;
        if (n3 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException("Width (" + n3 + ") and height (" + n4 + ") must be > 0");
        }
        if (f2 >= 2.1474836E9f) {
            throw new IllegalArgumentException("Dimensions (width=" + n3 + " height=" + n4 + ") are too large");
        }
        if (n2 < 0 || n2 > 5 && n2 != 32) {
            throw new IllegalArgumentException("Unsupported dataType: " + n2);
        }
        if (n5 <= 0) {
            throw new IllegalArgumentException("Number of bands must be > 0");
        }
        this.dataType = n2;
        this.width = n3;
        this.height = n4;
        this.numBands = n5;
    }

    public abstract DataBuffer createDataBuffer();

    public void setSample(int n2, int n3, int n4, double d2, DataBuffer dataBuffer) {
        int n5 = (int)d2;
        this.setSample(n2, n3, n4, n5, dataBuffer);
    }

    public void setSample(int n2, int n3, int n4, float f2, DataBuffer dataBuffer) {
        int n5 = (int)f2;
        this.setSample(n2, n3, n4, n5, dataBuffer);
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, double[] dArray, DataBuffer dataBuffer) {
        int n7 = 0;
        for (int i2 = n3; i2 < n3 + n5; ++i2) {
            for (int i3 = n2; i3 < n2 + n4; ++i3) {
                this.setSample(i3, i2, n6, dArray[n7++], dataBuffer);
            }
        }
    }

    public double[] getSamples(int n2, int n3, int n4, int n5, int n6, double[] dArray, DataBuffer dataBuffer) {
        int n7 = 0;
        double[] dArray2 = dArray != null ? dArray : new double[n4 * n5];
        for (int i2 = n3; i2 < n3 + n5; ++i2) {
            for (int i3 = n2; i3 < n2 + n4; ++i3) {
                dArray2[n7++] = this.getSampleDouble(i3, i2, n6, dataBuffer);
            }
        }
        return dArray2;
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, float[] fArray, DataBuffer dataBuffer) {
        int n7 = 0;
        for (int i2 = n3; i2 < n3 + n5; ++i2) {
            for (int i3 = n2; i3 < n2 + n4; ++i3) {
                this.setSample(i3, i2, n6, fArray[n7++], dataBuffer);
            }
        }
    }

    public float[] getSamples(int n2, int n3, int n4, int n5, int n6, float[] fArray, DataBuffer dataBuffer) {
        int n7 = 0;
        float[] fArray2 = fArray != null ? fArray : new float[n4 * n5];
        for (int i2 = n3; i2 < n5 + n3; ++i2) {
            for (int i3 = n2; i3 < n4 + n2; ++i3) {
                fArray2[n7++] = this.getSampleFloat(i3, i2, n6, dataBuffer);
            }
        }
        return fArray2;
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        int n7 = 0;
        for (int i2 = n3; i2 < n3 + n5; ++i2) {
            for (int i3 = n2; i3 < n2 + n4; ++i3) {
                this.setSample(i3, i2, n6, nArray[n7++], dataBuffer);
            }
        }
    }

    public int[] getSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        int n7 = 0;
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5];
        for (int i2 = n3; i2 < n5 + n3; ++i2) {
            for (int i3 = n2; i3 < n4 + n2; ++i3) {
                nArray2[n7++] = this.getSample(i3, i2, n6, dataBuffer);
            }
        }
        return nArray2;
    }

    public abstract void setSample(int var1, int var2, int var3, int var4, DataBuffer var5);

    public void setPixels(int n2, int n3, int n4, int n5, double[] dArray, DataBuffer dataBuffer) {
        int n6 = 0;
        for (int i2 = n3; i2 < n3 + n5; ++i2) {
            for (int i3 = n2; i3 < n2 + n4; ++i3) {
                for (int i4 = 0; i4 < this.numBands; ++i4) {
                    this.setSample(i3, i2, i4, dArray[n6++], dataBuffer);
                }
            }
        }
    }

    public double[] getPixels(int n2, int n3, int n4, int n5, double[] dArray, DataBuffer dataBuffer) {
        int n6 = 0;
        double[] dArray2 = dArray != null ? dArray : new double[this.numBands * n4 * n5];
        for (int i2 = n3; i2 < n5 + n3; ++i2) {
            for (int i3 = n2; i3 < n4 + n2; ++i3) {
                for (int i4 = 0; i4 < this.numBands; ++i4) {
                    dArray2[n6++] = this.getSampleDouble(i3, i2, i4, dataBuffer);
                }
            }
        }
        return dArray2;
    }

    public void setPixels(int n2, int n3, int n4, int n5, float[] fArray, DataBuffer dataBuffer) {
        int n6 = 0;
        for (int i2 = n3; i2 < n3 + n5; ++i2) {
            for (int i3 = n2; i3 < n2 + n4; ++i3) {
                for (int i4 = 0; i4 < this.numBands; ++i4) {
                    this.setSample(i3, i2, i4, fArray[n6++], dataBuffer);
                }
            }
        }
    }

    public float[] getPixels(int n2, int n3, int n4, int n5, float[] fArray, DataBuffer dataBuffer) {
        int n6 = 0;
        float[] fArray2 = fArray != null ? fArray : new float[this.numBands * n4 * n5];
        for (int i2 = n3; i2 < n5 + n3; ++i2) {
            for (int i3 = n2; i3 < n4 + n2; ++i3) {
                for (int i4 = 0; i4 < this.numBands; ++i4) {
                    fArray2[n6++] = this.getSampleFloat(i3, i2, i4, dataBuffer);
                }
            }
        }
        return fArray2;
    }

    public void setPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = 0;
        for (int i2 = n3; i2 < n3 + n5; ++i2) {
            for (int i3 = n2; i3 < n2 + n4; ++i3) {
                for (int i4 = 0; i4 < this.numBands; ++i4) {
                    this.setSample(i3, i2, i4, nArray[n6++], dataBuffer);
                }
            }
        }
    }

    public int[] getPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands * n4 * n5];
        for (int i2 = n3; i2 < n5 + n3; ++i2) {
            for (int i3 = n2; i3 < n4 + n2; ++i3) {
                for (int i4 = 0; i4 < this.numBands; ++i4) {
                    nArray2[n6++] = this.getSample(i3, i2, i4, dataBuffer);
                }
            }
        }
        return nArray2;
    }

    public double getSampleDouble(int n2, int n3, int n4, DataBuffer dataBuffer) {
        double d2 = this.getSample(n2, n3, n4, dataBuffer);
        return d2;
    }

    public float getSampleFloat(int n2, int n3, int n4, DataBuffer dataBuffer) {
        float f2 = this.getSample(n2, n3, n4, dataBuffer);
        return f2;
    }

    public abstract int getSample(int var1, int var2, int var3, DataBuffer var4);

    public void setPixel(int n2, int n3, double[] dArray, DataBuffer dataBuffer) {
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            this.setSample(n2, n3, i2, dArray[i2], dataBuffer);
        }
    }

    public double[] getPixel(int n2, int n3, double[] dArray, DataBuffer dataBuffer) {
        double[] dArray2 = dArray != null ? dArray : new double[this.numBands];
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            dArray2[i2] = this.getSampleDouble(n2, n3, i2, dataBuffer);
        }
        return dArray2;
    }

    public void setPixel(int n2, int n3, float[] fArray, DataBuffer dataBuffer) {
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            this.setSample(n2, n3, i2, fArray[i2], dataBuffer);
        }
    }

    public float[] getPixel(int n2, int n3, float[] fArray, DataBuffer dataBuffer) {
        float[] fArray2 = fArray != null ? fArray : new float[this.numBands];
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            fArray2[i2] = this.getSampleFloat(n2, n3, i2, dataBuffer);
        }
        return fArray2;
    }

    public void setPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            this.setSample(n2, n3, i2, nArray[i2], dataBuffer);
        }
    }

    public int[] getPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            nArray2[i2] = this.getSample(n2, n3, i2, dataBuffer);
        }
        return nArray2;
    }

    public abstract SampleModel createCompatibleSampleModel(int var1, int var2);

    public abstract SampleModel createSubsetSampleModel(int[] var1);

    public void setDataElements(int n2, int n3, int n4, int n5, Object object, DataBuffer dataBuffer) {
        int n6 = 0;
        Object var8_8 = null;
        int n7 = this.getTransferType();
        int n8 = this.getNumDataElements();
        switch (n7) {
            case 0: {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = new byte[n8];
                for (int i2 = n3; i2 < n3 + n5; ++i2) {
                    for (int i3 = n2; i3 < n2 + n4; ++i3) {
                        for (int i4 = 0; i4 < n8; ++i4) {
                            byArray2[i4] = byArray[n6++];
                        }
                        this.setDataElements(i3, i2, byArray2, dataBuffer);
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                short[] sArray2 = new short[n8];
                for (int i5 = n3; i5 < n3 + n5; ++i5) {
                    for (int i6 = n2; i6 < n2 + n4; ++i6) {
                        for (int i7 = 0; i7 < n8; ++i7) {
                            sArray2[i7] = sArray[n6++];
                        }
                        this.setDataElements(i6, i5, sArray2, dataBuffer);
                    }
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int[] nArray2 = new int[n8];
                for (int i8 = n3; i8 < n3 + n5; ++i8) {
                    for (int i9 = n2; i9 < n2 + n4; ++i9) {
                        for (int i10 = 0; i10 < n8; ++i10) {
                            nArray2[i10] = nArray[n6++];
                        }
                        this.setDataElements(i9, i8, nArray2, dataBuffer);
                    }
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                float[] fArray2 = new float[n8];
                for (int i11 = n3; i11 < n3 + n5; ++i11) {
                    for (int i12 = n2; i12 < n2 + n4; ++i12) {
                        for (int i13 = 0; i13 < n8; ++i13) {
                            fArray2[i13] = fArray[n6++];
                        }
                        this.setDataElements(i12, i11, fArray2, dataBuffer);
                    }
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                double[] dArray2 = new double[n8];
                for (int i14 = n3; i14 < n3 + n5; ++i14) {
                    for (int i15 = n2; i15 < n2 + n4; ++i15) {
                        for (int i16 = 0; i16 < n8; ++i16) {
                            dArray2[i16] = dArray[n6++];
                        }
                        this.setDataElements(i15, i14, dArray2, dataBuffer);
                    }
                }
                break;
            }
        }
    }

    public abstract void setDataElements(int var1, int var2, Object var3, DataBuffer var4);

    public Object getDataElements(int n2, int n3, int n4, int n5, Object object, DataBuffer dataBuffer) {
        int n6 = this.getTransferType();
        int n7 = this.getNumDataElements();
        int n8 = 0;
        Object object2 = null;
        switch (n6) {
            case 0: {
                byte[] byArray = object == null ? new byte[n7 * n4 * n5] : (byte[])object;
                for (int i2 = n3; i2 < n3 + n5; ++i2) {
                    for (int i3 = n2; i3 < n2 + n4; ++i3) {
                        object2 = this.getDataElements(i3, i2, object2, dataBuffer);
                        byte[] byArray2 = (byte[])object2;
                        for (int i4 = 0; i4 < n7; ++i4) {
                            byArray[n8++] = byArray2[i4];
                        }
                    }
                }
                object = byArray;
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = object == null ? new short[n7 * n4 * n5] : (short[])object;
                for (int i5 = n3; i5 < n3 + n5; ++i5) {
                    for (int i6 = n2; i6 < n2 + n4; ++i6) {
                        object2 = this.getDataElements(i6, i5, object2, dataBuffer);
                        short[] sArray2 = (short[])object2;
                        for (int i7 = 0; i7 < n7; ++i7) {
                            sArray[n8++] = sArray2[i7];
                        }
                    }
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n7 * n4 * n5] : (int[])object;
                for (int i8 = n3; i8 < n3 + n5; ++i8) {
                    for (int i9 = n2; i9 < n2 + n4; ++i9) {
                        object2 = this.getDataElements(i9, i8, object2, dataBuffer);
                        int[] nArray2 = (int[])object2;
                        for (int i10 = 0; i10 < n7; ++i10) {
                            nArray[n8++] = nArray2[i10];
                        }
                    }
                }
                object = nArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n7 * n4 * n5] : (float[])object;
                for (int i11 = n3; i11 < n3 + n5; ++i11) {
                    for (int i12 = n2; i12 < n2 + n4; ++i12) {
                        object2 = this.getDataElements(i12, i11, object2, dataBuffer);
                        float[] fArray2 = (float[])object2;
                        for (int i13 = 0; i13 < n7; ++i13) {
                            fArray[n8++] = fArray2[i13];
                        }
                    }
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n7 * n4 * n5] : (double[])object;
                for (int i14 = n3; i14 < n3 + n5; ++i14) {
                    for (int i15 = n2; i15 < n2 + n4; ++i15) {
                        object2 = this.getDataElements(i15, i14, object2, dataBuffer);
                        double[] dArray2 = (double[])object2;
                        for (int i16 = 0; i16 < n7; ++i16) {
                            dArray[n8++] = dArray2[i16];
                        }
                    }
                }
                object = dArray;
            }
        }
        return object;
    }

    public abstract Object getDataElements(int var1, int var2, Object var3, DataBuffer var4);
}

