/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertPathHelperImpl;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import sun.misc.CharacterEncoder;
import sun.misc.HexDumpEncoder;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificatePoliciesExtension;
import sun.security.x509.CertificatePolicyId;
import sun.security.x509.CertificatePolicySet;
import sun.security.x509.DNSName;
import sun.security.x509.EDIPartyName;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.Extension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.GeneralSubtree;
import sun.security.x509.GeneralSubtrees;
import sun.security.x509.IPAddressName;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.OIDName;
import sun.security.x509.OtherName;
import sun.security.x509.PolicyInformation;
import sun.security.x509.PrivateKeyUsageExtension;
import sun.security.x509.RFC822Name;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.URIName;
import sun.security.x509.X400Address;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509Key;

public class X509CertSelector
implements CertSelector {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final ObjectIdentifier ANY_EXTENDED_KEY_USAGE = ObjectIdentifier.newInternal(new int[]{2, 5, 29, 37, 0});
    private BigInteger serialNumber;
    private X500Principal issuer;
    private X500Principal subject;
    private byte[] subjectKeyID;
    private byte[] authorityKeyID;
    private Date certificateValid;
    private Date privateKeyValid;
    private ObjectIdentifier subjectPublicKeyAlgID;
    private PublicKey subjectPublicKey;
    private byte[] subjectPublicKeyBytes;
    private boolean[] keyUsage;
    private Set keyPurposeSet;
    private Set keyPurposeOIDSet;
    private Set subjectAlternativeNames;
    private Set subjectAlternativeGeneralNames;
    private CertificatePolicySet policy;
    private Set policySet;
    private Set pathToNames;
    private Set pathToGeneralNames;
    private NameConstraintsExtension nc;
    private byte[] ncBytes;
    private int basicConstraints = -1;
    private X509Certificate x509Cert;
    private boolean matchAllSubjectAltNames = true;
    private static final Boolean FALSE;
    private static final int PRIVATE_KEY_USAGE_ID = 0;
    private static final int SUBJECT_ALT_NAME_ID = 1;
    private static final int NAME_CONSTRAINTS_ID = 2;
    private static final int CERT_POLICIES_ID = 3;
    private static final int EXTENDED_KEY_USAGE_ID = 4;
    private static final int NUM_OF_EXTENSIONS = 5;
    private static final String[] EXTENSION_OIDS;
    static final int NAME_ANY = 0;
    static final int NAME_RFC822 = 1;
    static final int NAME_DNS = 2;
    static final int NAME_X400 = 3;
    static final int NAME_DIRECTORY = 4;
    static final int NAME_EDI = 5;
    static final int NAME_URI = 6;
    static final int NAME_IP = 7;
    static final int NAME_OID = 8;

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    static {
        CertPathHelperImpl.initialize();
        FALSE = Boolean.FALSE;
        EXTENSION_OIDS = new String[5];
        X509CertSelector.EXTENSION_OIDS[0] = "2.5.29.16";
        X509CertSelector.EXTENSION_OIDS[1] = "2.5.29.17";
        X509CertSelector.EXTENSION_OIDS[2] = "2.5.29.30";
        X509CertSelector.EXTENSION_OIDS[3] = "2.5.29.32";
        X509CertSelector.EXTENSION_OIDS[4] = "2.5.29.37";
    }

    public boolean getMatchAllSubjectAltNames() {
        return this.matchAllSubjectAltNames;
    }

    public byte[] getAuthorityKeyIdentifier() {
        if (this.authorityKeyID == null) {
            return null;
        }
        return (byte[])this.authorityKeyID.clone();
    }

    public byte[] getIssuerAsBytes() throws IOException {
        return this.issuer == null ? null : this.issuer.getEncoded();
    }

    public byte[] getNameConstraints() {
        if (this.ncBytes == null) {
            return null;
        }
        return (byte[])this.ncBytes.clone();
    }

    public byte[] getSubjectAsBytes() throws IOException {
        return this.subject == null ? null : this.subject.getEncoded();
    }

    public byte[] getSubjectKeyIdentifier() {
        if (this.subjectKeyID == null) {
            return null;
        }
        return (byte[])this.subjectKeyID.clone();
    }

    public boolean[] getKeyUsage() {
        if (this.keyUsage == null) {
            return null;
        }
        return (boolean[])this.keyUsage.clone();
    }

    public void setBasicConstraints(int n2) {
        if (n2 < -2) {
            throw new IllegalArgumentException("basic constraints less than -2");
        }
        this.basicConstraints = n2;
    }

    public void addPathToName(int n2, byte[] byArray) throws IOException {
        this.addPathToNameInternal(n2, byArray.clone());
    }

    public void addSubjectAlternativeName(int n2, byte[] byArray) throws IOException {
        this.addSubjectAlternativeNameInternal(n2, byArray.clone());
    }

    public void setMatchAllSubjectAltNames(boolean bl2) {
        this.matchAllSubjectAltNames = bl2;
    }

    public void setAuthorityKeyIdentifier(byte[] byArray) {
        this.authorityKeyID = (byte[])(byArray == null ? null : (byte[])byArray.clone());
    }

    public void setIssuer(byte[] byArray) throws IOException {
        try {
            this.issuer = byArray == null ? null : new X500Principal(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (IOException)new IOException("Invalid name").initCause(illegalArgumentException);
        }
    }

    public void setNameConstraints(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.ncBytes = null;
            this.nc = null;
        } else {
            this.ncBytes = (byte[])byArray.clone();
            this.nc = new NameConstraintsExtension(FALSE, byArray);
        }
    }

    public void setSubject(byte[] byArray) throws IOException {
        try {
            this.subject = byArray == null ? null : new X500Principal(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (IOException)new IOException("Invalid name").initCause(illegalArgumentException);
        }
    }

    public void setSubjectKeyIdentifier(byte[] byArray) {
        this.subjectKeyID = (byte[])(byArray == null ? null : (byte[])byArray.clone());
    }

    public void setSubjectPublicKey(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.subjectPublicKey = null;
            this.subjectPublicKeyBytes = null;
        } else {
            this.subjectPublicKeyBytes = (byte[])byArray.clone();
            this.subjectPublicKey = X509Key.parse(new DerValue(this.subjectPublicKeyBytes));
        }
    }

    public void setKeyUsage(boolean[] blArray) {
        this.keyUsage = (boolean[])(blArray == null ? null : (boolean[])blArray.clone());
    }

    public Object clone() {
        try {
            Object object = super.clone();
            if (this.subjectAlternativeNames != null) {
                this.subjectAlternativeNames = X509CertSelector.cloneSet(this.subjectAlternativeNames);
                this.subjectAlternativeGeneralNames = X509CertSelector.cloneSet(this.subjectAlternativeGeneralNames);
            }
            if (this.pathToGeneralNames != null) {
                this.pathToNames = X509CertSelector.cloneSet(this.pathToNames);
                this.pathToGeneralNames = X509CertSelector.cloneSet(this.pathToGeneralNames);
            }
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    private void addPathToNameInternal(int n2, Object object) throws IOException {
        GeneralNameInterface generalNameInterface = X509CertSelector.makeGeneralNameInterface(n2, object);
        if (this.pathToGeneralNames == null) {
            this.pathToNames = new HashSet();
            this.pathToGeneralNames = new HashSet();
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Integer(n2));
        arrayList.add(object);
        this.pathToNames.add(arrayList);
        this.pathToGeneralNames.add(generalNameInterface);
    }

    private void addSubjectAlternativeNameInternal(int n2, Object object) throws IOException {
        GeneralNameInterface generalNameInterface = X509CertSelector.makeGeneralNameInterface(n2, object);
        if (this.subjectAlternativeNames == null) {
            this.subjectAlternativeNames = new HashSet();
        }
        if (this.subjectAlternativeGeneralNames == null) {
            this.subjectAlternativeGeneralNames = new HashSet();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Integer(n2));
        arrayList.add(object);
        this.subjectAlternativeNames.add(arrayList);
        this.subjectAlternativeGeneralNames.add(generalNameInterface);
    }

    public String getIssuerAsString() {
        return this.issuer == null ? null : this.issuer.getName();
    }

    public String getSubjectAsString() {
        return this.subject == null ? null : this.subject.getName();
    }

    public String getSubjectPublicKeyAlgID() {
        if (this.subjectPublicKeyAlgID == null) {
            return null;
        }
        return this.subjectPublicKeyAlgID.toString();
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509CertSelector: [\n");
        if (this.x509Cert != null) {
            stringBuffer.append("  Certificate: " + this.x509Cert.toString() + "\n");
        }
        if (this.serialNumber != null) {
            stringBuffer.append("  Serial Number: " + this.serialNumber.toString() + "\n");
        }
        if (this.issuer != null) {
            stringBuffer.append("  Issuer: " + this.getIssuerAsString() + "\n");
        }
        if (this.subject != null) {
            stringBuffer.append("  Subject: " + this.getSubjectAsString() + "\n");
        }
        stringBuffer.append("  matchAllSubjectAltNames flag: " + String.valueOf(this.matchAllSubjectAltNames) + "\n");
        if (this.subjectAlternativeNames != null) {
            stringBuffer.append("  SubjectAlternativeNames:\n");
            object = this.subjectAlternativeNames.iterator();
            while (object.hasNext()) {
                List list = (List)object.next();
                stringBuffer.append("    type " + list.get(0) + ", name " + list.get(1) + "\n");
            }
        }
        if (this.subjectKeyID != null) {
            object = new HexDumpEncoder();
            stringBuffer.append("  Subject Key Identifier: " + ((CharacterEncoder)object).encodeBuffer(this.subjectKeyID) + "\n");
        }
        if (this.authorityKeyID != null) {
            object = new HexDumpEncoder();
            stringBuffer.append("  Authority Key Identifier: " + ((CharacterEncoder)object).encodeBuffer(this.authorityKeyID) + "\n");
        }
        if (this.certificateValid != null) {
            stringBuffer.append("  Certificate Valid: " + this.certificateValid.toString() + "\n");
        }
        if (this.privateKeyValid != null) {
            stringBuffer.append("  Private Key Valid: " + this.privateKeyValid.toString() + "\n");
        }
        if (this.subjectPublicKeyAlgID != null) {
            stringBuffer.append("  Subject Public Key AlgID: " + this.subjectPublicKeyAlgID.toString() + "\n");
        }
        if (this.subjectPublicKey != null) {
            stringBuffer.append("  Subject Public Key: " + this.subjectPublicKey.toString() + "\n");
        }
        if (this.keyUsage != null) {
            stringBuffer.append("  Key Usage: " + X509CertSelector.keyUsageToString(this.keyUsage) + "\n");
        }
        if (this.keyPurposeSet != null) {
            stringBuffer.append("  Extended Key Usage: " + this.keyPurposeSet.toString() + "\n");
        }
        if (this.policy != null) {
            stringBuffer.append("  Policy: " + this.policy.toString() + "\n");
        }
        if (this.pathToGeneralNames != null) {
            stringBuffer.append("  Path to names:\n");
            object = this.pathToGeneralNames.iterator();
            while (object.hasNext()) {
                stringBuffer.append("    " + object.next() + "\n");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void addPathToName(int n2, String string) throws IOException {
        this.addPathToNameInternal(n2, string);
    }

    public void addSubjectAlternativeName(int n2, String string) throws IOException {
        this.addSubjectAlternativeNameInternal(n2, string);
    }

    public void setIssuer(String string) throws IOException {
        this.issuer = string == null ? null : new X500Name(string, "RFC2253").asX500Principal();
    }

    public void setSubject(String string) throws IOException {
        this.subject = string == null ? null : new X500Name(string, "RFC2253").asX500Principal();
    }

    public void setSubjectPublicKeyAlgID(String string) throws IOException {
        this.subjectPublicKeyAlgID = string == null ? null : new ObjectIdentifier(string);
    }

    private static String keyUsageToString(boolean[] blArray) {
        String string = "KeyUsage [\n";
        try {
            if (blArray[0]) {
                string = string + "  DigitalSignature\n";
            }
            if (blArray[1]) {
                string = string + "  Non_repudiation\n";
            }
            if (blArray[2]) {
                string = string + "  Key_Encipherment\n";
            }
            if (blArray[3]) {
                string = string + "  Data_Encipherment\n";
            }
            if (blArray[4]) {
                string = string + "  Key_Agreement\n";
            }
            if (blArray[5]) {
                string = string + "  Key_CertSign\n";
            }
            if (blArray[6]) {
                string = string + "  Crl_Sign\n";
            }
            if (blArray[7]) {
                string = string + "  Encipher_Only\n";
            }
            if (blArray[8]) {
                string = string + "  Decipher_Only\n";
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        string = string + "]\n";
        return string;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.serialNumber = bigInteger;
    }

    public PublicKey getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public void setSubjectPublicKey(PublicKey publicKey) {
        if (publicKey == null) {
            this.subjectPublicKey = null;
            this.subjectPublicKeyBytes = null;
        } else {
            this.subjectPublicKey = publicKey;
            this.subjectPublicKeyBytes = publicKey.getEncoded();
        }
    }

    public boolean match(Certificate certificate) {
        boolean bl2;
        byte[] byArray;
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (debug != null) {
            debug.println("X509CertSelector.match(SN: " + x509Certificate.getSerialNumber().toString(16) + "\n  Issuer: " + x509Certificate.getIssuerDN() + "\n  Subject: " + x509Certificate.getSubjectDN() + ")");
        }
        if (this.x509Cert != null && !this.x509Cert.equals(x509Certificate)) {
            if (debug != null) {
                debug.println("X509CertSelector.match: certs don't match");
            }
            return false;
        }
        if (this.serialNumber != null && !this.serialNumber.equals(x509Certificate.getSerialNumber())) {
            if (debug != null) {
                debug.println("X509CertSelector.match: serial numbers don't match");
            }
            return false;
        }
        if (this.issuer != null && !this.issuer.equals(x509Certificate.getIssuerX500Principal())) {
            if (debug != null) {
                debug.println("X509CertSelector.match: issuer DNs don't match");
            }
            return false;
        }
        if (this.subject != null && !this.subject.equals(x509Certificate.getSubjectX500Principal())) {
            if (debug != null) {
                debug.println("X509CertSelector.match: subject DNs don't match");
            }
            return false;
        }
        if (this.certificateValid != null) {
            try {
                x509Certificate.checkValidity(this.certificateValid);
            }
            catch (CertificateException certificateException) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: certificate not within validity period");
                }
                return false;
            }
        }
        if (this.subjectPublicKeyBytes != null && !Arrays.equals(this.subjectPublicKeyBytes, byArray = x509Certificate.getPublicKey().getEncoded())) {
            if (debug != null) {
                debug.println("X509CertSelector.match: subject public keys don't match");
            }
            return false;
        }
        boolean bl3 = bl2 = this.matchBasicConstraints(x509Certificate) && this.matchKeyUsage(x509Certificate) && this.matchExtendedKeyUsage(x509Certificate) && this.matchSubjectKeyID(x509Certificate) && this.matchAuthorityKeyID(x509Certificate) && this.matchPrivateKeyValid(x509Certificate) && this.matchSubjectPublicKeyAlgID(x509Certificate) && this.matchPolicy(x509Certificate) && this.matchSubjectAlternativeNames(x509Certificate) && this.matchPathToNames(x509Certificate) && this.matchNameConstraints(x509Certificate);
        if (bl2 && debug != null) {
            debug.println("X509CertSelector.match returning: true");
        }
        return bl2;
    }

    public X509Certificate getCertificate() {
        return this.x509Cert;
    }

    public void setCertificate(X509Certificate x509Certificate) {
        this.x509Cert = x509Certificate;
    }

    private boolean matchAuthorityKeyID(X509Certificate x509Certificate) {
        if (this.authorityKeyID == null) {
            return true;
        }
        try {
            byte[] byArray = x509Certificate.getExtensionValue("2.5.29.35");
            if (byArray == null) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: no authority key ID extension");
                }
                return false;
            }
            DerInputStream derInputStream = new DerInputStream(byArray);
            byte[] byArray2 = derInputStream.getOctetString();
            if (byArray2 == null || !Arrays.equals(this.authorityKeyID, byArray2)) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: authority key IDs don't match");
                }
                return false;
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("X509CertSelector.match: exception in authority key ID check");
            }
            return false;
        }
        return true;
    }

    private boolean matchBasicConstraints(X509Certificate x509Certificate) {
        if (this.basicConstraints == -1) {
            return true;
        }
        int n2 = x509Certificate.getBasicConstraints();
        if (this.basicConstraints == -2) {
            if (n2 != -1) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: not an EE cert");
                }
                return false;
            }
        } else if (n2 < this.basicConstraints) {
            if (debug != null) {
                debug.println("X509CertSelector.match: maxPathLen too small (" + n2 + " < " + this.basicConstraints + ")");
            }
            return false;
        }
        return true;
    }

    private boolean matchExtendedKeyUsage(X509Certificate x509Certificate) {
        if (this.keyPurposeSet == null || this.keyPurposeSet.isEmpty()) {
            return true;
        }
        try {
            Vector vector;
            ExtendedKeyUsageExtension extendedKeyUsageExtension = (ExtendedKeyUsageExtension)X509CertSelector.getExtensionObject(x509Certificate, 4);
            if (extendedKeyUsageExtension != null && !(vector = (Vector)extendedKeyUsageExtension.get("usages")).contains(ANY_EXTENDED_KEY_USAGE) && !vector.containsAll(this.keyPurposeOIDSet)) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: cert failed extendedKeyUsage criterion");
                }
                return false;
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("X509CertSelector.match: IOException in extended key usage check");
            }
            return false;
        }
        return true;
    }

    private boolean matchKeyUsage(X509Certificate x509Certificate) {
        if (this.keyUsage == null) {
            return true;
        }
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            for (int i2 = 0; i2 < this.keyUsage.length; ++i2) {
                if (!this.keyUsage[i2] || i2 < blArray.length && blArray[i2]) continue;
                if (debug != null) {
                    debug.println("X509CertSelector.match: key usage bits don't match");
                }
                return false;
            }
        }
        return true;
    }

    private boolean matchNameConstraints(X509Certificate x509Certificate) {
        if (this.nc == null) {
            return true;
        }
        try {
            if (!this.nc.verify(x509Certificate)) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: name constraints not satisfied");
                }
                return false;
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("X509CertSelector.match: IOException in name constraints check");
            }
            return false;
        }
        return true;
    }

    private boolean matchPathToNames(X509Certificate x509Certificate) {
        if (this.pathToGeneralNames == null) {
            return true;
        }
        try {
            Object object;
            NameConstraintsExtension nameConstraintsExtension = (NameConstraintsExtension)X509CertSelector.getExtensionObject(x509Certificate, 2);
            if (nameConstraintsExtension == null) {
                return true;
            }
            if (debug != null) {
                if (Debug.isOn("certpath")) {
                    debug.println("X509CertSelector.match pathToNames:\n");
                    object = this.pathToGeneralNames.iterator();
                    while (object.hasNext()) {
                        debug.println("    " + object.next() + "\n");
                    }
                }
            }
            object = (GeneralSubtrees)nameConstraintsExtension.get("permitted_subtrees");
            GeneralSubtrees generalSubtrees = (GeneralSubtrees)nameConstraintsExtension.get("excluded_subtrees");
            if (generalSubtrees != null && !this.matchExcluded(generalSubtrees)) {
                return false;
            }
            if (object != null && !this.matchPermitted((GeneralSubtrees)object)) {
                return false;
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("X509CertSelector.match: IOException in name constraints check");
            }
            return false;
        }
        return true;
    }

    private boolean matchPolicy(X509Certificate x509Certificate) {
        if (this.policy == null) {
            return true;
        }
        try {
            CertificatePoliciesExtension certificatePoliciesExtension = (CertificatePoliciesExtension)X509CertSelector.getExtensionObject(x509Certificate, 3);
            if (certificatePoliciesExtension == null) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: no certificate policy extension");
                }
                return false;
            }
            Vector vector = (Vector)certificatePoliciesExtension.get("policies");
            Vector vector2 = new Vector(vector.size());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                vector2.addElement(((PolicyInformation)enumeration.nextElement()).getPolicyIdentifier());
            }
            if (this.policy != null) {
                boolean bl2 = false;
                if (this.policy.getCertPolicyIds().isEmpty()) {
                    if (vector2.isEmpty()) {
                        if (debug != null) {
                            debug.println("X509CertSelector.match: cert failed policyAny criterion");
                        }
                        return false;
                    }
                } else {
                    Iterator iterator = this.policy.getCertPolicyIds().iterator();
                    while (iterator.hasNext() && !bl2) {
                        if (!vector2.contains(iterator.next())) continue;
                        bl2 = true;
                    }
                    if (!bl2) {
                        if (debug != null) {
                            debug.println("X509CertSelector.match: cert failed policyAny criterion");
                        }
                        return false;
                    }
                }
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("X509CertSelector.match: IOException in certificate policy ID check");
            }
            return false;
        }
        return true;
    }

    private boolean matchPrivateKeyValid(X509Certificate x509Certificate) {
        if (this.privateKeyValid == null) {
            return true;
        }
        PrivateKeyUsageExtension privateKeyUsageExtension = null;
        try {
            privateKeyUsageExtension = (PrivateKeyUsageExtension)X509CertSelector.getExtensionObject(x509Certificate, 0);
            if (privateKeyUsageExtension != null) {
                privateKeyUsageExtension.valid(this.privateKeyValid);
            }
        }
        catch (CertificateExpiredException certificateExpiredException) {
            if (debug != null) {
                String string = "n/a";
                try {
                    Date date = (Date)privateKeyUsageExtension.get("not_after");
                    string = date.toString();
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
                debug.println("X509CertSelector.match: private key usage not within validity date; ext.NOT_After: " + string + "; X509CertSelector: " + this.toString());
                certificateExpiredException.printStackTrace();
            }
            return false;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            if (debug != null) {
                String string = "n/a";
                try {
                    Date date = (Date)privateKeyUsageExtension.get("not_before");
                    string = date.toString();
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
                debug.println("X509CertSelector.match: private key usage not within validity date; ext.NOT_BEFORE: " + string + "; X509CertSelector: " + this.toString());
                certificateNotYetValidException.printStackTrace();
            }
            return false;
        }
        catch (CertificateException certificateException) {
            if (debug != null) {
                debug.println("X509CertSelector.match: CertificateException in private key usage check; X509CertSelector: " + this.toString());
                certificateException.printStackTrace();
            }
            return false;
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("X509CertSelector.match: IOException in private key usage check; X509CertSelector: " + this.toString());
                iOException.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private boolean matchSubjectAlternativeNames(X509Certificate x509Certificate) {
        if (this.subjectAlternativeNames == null || this.subjectAlternativeNames.isEmpty()) {
            return true;
        }
        try {
            SubjectAlternativeNameExtension subjectAlternativeNameExtension = (SubjectAlternativeNameExtension)X509CertSelector.getExtensionObject(x509Certificate, 1);
            if (subjectAlternativeNameExtension == null) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: no subject alternative name extension");
                }
                return false;
            }
            GeneralNames generalNames = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
            Iterator iterator = this.subjectAlternativeGeneralNames.iterator();
            while (iterator.hasNext()) {
                GeneralNameInterface generalNameInterface = (GeneralNameInterface)iterator.next();
                boolean bl2 = false;
                Iterator iterator2 = generalNames.iterator();
                while (iterator2.hasNext() && !bl2) {
                    GeneralNameInterface generalNameInterface2 = ((GeneralName)iterator2.next()).getName();
                    bl2 = generalNameInterface2.equals(generalNameInterface);
                }
                if (!(bl2 || !this.matchAllSubjectAltNames && iterator.hasNext())) {
                    if (debug != null) {
                        debug.println("X509CertSelector.match: subject alternative name " + generalNameInterface + " not found");
                    }
                    return false;
                }
                if (!bl2 || this.matchAllSubjectAltNames) continue;
                break;
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("X509CertSelector.match: IOException in subject alternative name check");
            }
            return false;
        }
        return true;
    }

    private boolean matchSubjectKeyID(X509Certificate x509Certificate) {
        if (this.subjectKeyID == null) {
            return true;
        }
        try {
            byte[] byArray = x509Certificate.getExtensionValue("2.5.29.14");
            if (byArray == null) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: no subject key ID extension");
                }
                return false;
            }
            DerInputStream derInputStream = new DerInputStream(byArray);
            byte[] byArray2 = derInputStream.getOctetString();
            if (byArray2 == null || !Arrays.equals(this.subjectKeyID, byArray2)) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: subject key IDs don't match");
                }
                return false;
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("X509CertSelector.match: exception in subject key ID check");
            }
            return false;
        }
        return true;
    }

    private boolean matchSubjectPublicKeyAlgID(X509Certificate x509Certificate) {
        if (this.subjectPublicKeyAlgID == null) {
            return true;
        }
        try {
            byte[] byArray = x509Certificate.getPublicKey().getEncoded();
            DerValue derValue = new DerValue(byArray);
            if (derValue.tag != 48) {
                throw new IOException("invalid key format");
            }
            AlgorithmId algorithmId = AlgorithmId.parse(derValue.data.getDerValue());
            if (debug != null) {
                debug.println("X509CertSelector.match: subjectPublicKeyAlgID = " + this.subjectPublicKeyAlgID + ", xcert subjectPublicKeyAlgID = " + algorithmId.getOID());
            }
            if (!this.subjectPublicKeyAlgID.equals(algorithmId.getOID())) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: subject public key alg IDs don't match");
                }
                return false;
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("X509CertSelector.match: IOException in subject public key algorithm OID check");
            }
            return false;
        }
        return true;
    }

    public Collection getPathToNames() {
        if (this.pathToNames == null) {
            return null;
        }
        return X509CertSelector.cloneNames(this.pathToNames);
    }

    public Collection getSubjectAlternativeNames() {
        if (this.subjectAlternativeNames == null) {
            return null;
        }
        return X509CertSelector.cloneNames(this.subjectAlternativeNames);
    }

    public void setPathToNames(Collection collection) throws IOException {
        if (collection == null || collection.isEmpty()) {
            this.pathToNames = null;
            this.pathToGeneralNames = null;
        } else {
            Set set = X509CertSelector.cloneAndCheckNames(collection);
            this.pathToGeneralNames = X509CertSelector.parseNames(set);
            this.pathToNames = set;
        }
    }

    public void setSubjectAlternativeNames(Collection collection) throws IOException {
        if (collection == null) {
            this.subjectAlternativeNames = null;
            this.subjectAlternativeGeneralNames = null;
        } else {
            if (collection.isEmpty()) {
                this.subjectAlternativeNames = null;
                this.subjectAlternativeGeneralNames = null;
                return;
            }
            Set set = X509CertSelector.cloneAndCheckNames(collection);
            this.subjectAlternativeGeneralNames = X509CertSelector.parseNames(set);
            this.subjectAlternativeNames = set;
        }
    }

    public Date getCertificateValid() {
        if (this.certificateValid == null) {
            return null;
        }
        return (Date)this.certificateValid.clone();
    }

    public Date getPrivateKeyValid() {
        if (this.privateKeyValid == null) {
            return null;
        }
        return (Date)this.privateKeyValid.clone();
    }

    public void setCertificateValid(Date date) {
        this.certificateValid = date == null ? null : (Date)date.clone();
    }

    public void setPrivateKeyValid(Date date) {
        this.privateKeyValid = date == null ? null : (Date)date.clone();
    }

    public Set getExtendedKeyUsage() {
        return this.keyPurposeSet;
    }

    public Set getPolicy() {
        return this.policySet;
    }

    public void setExtendedKeyUsage(Set set) throws IOException {
        if (set == null || set.isEmpty()) {
            this.keyPurposeSet = null;
        } else {
            this.keyPurposeSet = Collections.unmodifiableSet(new HashSet(set));
            this.keyPurposeOIDSet = new HashSet();
            Iterator iterator = this.keyPurposeSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.keyPurposeOIDSet.add(new ObjectIdentifier(string));
            }
        }
    }

    void setPathToNamesInternal(Set set) {
        this.pathToNames = Collections.EMPTY_SET;
        this.pathToGeneralNames = set;
    }

    public void setPolicy(Set set) throws IOException {
        if (set == null) {
            this.policySet = null;
            this.policy = null;
        } else {
            Set set2 = Collections.unmodifiableSet(new HashSet(set));
            Iterator iterator = set2.iterator();
            Vector vector = new Vector();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof String)) {
                    throw new IOException("non String in certPolicySet");
                }
                vector.add(new CertificatePolicyId(new ObjectIdentifier((String)object)));
            }
            this.policySet = set2;
            this.policy = new CertificatePolicySet(vector);
        }
    }

    X500Principal getIssuer() {
        return this.issuer;
    }

    X500Principal getSubject() {
        return this.subject;
    }

    void setIssuer(X500Principal x500Principal) {
        this.issuer = x500Principal;
    }

    void setSubject(X500Principal x500Principal) {
        this.subject = x500Principal;
    }

    private boolean matchExcluded(GeneralSubtrees generalSubtrees) {
        Iterator iterator = generalSubtrees.iterator();
        while (iterator.hasNext()) {
            GeneralSubtree generalSubtree = (GeneralSubtree)iterator.next();
            GeneralNameInterface generalNameInterface = generalSubtree.getName().getName();
            Iterator iterator2 = this.pathToGeneralNames.iterator();
            while (iterator2.hasNext()) {
                GeneralNameInterface generalNameInterface2 = (GeneralNameInterface)iterator2.next();
                if (generalNameInterface.getType() != generalNameInterface2.getType()) continue;
                switch (generalNameInterface2.constrains(generalNameInterface)) {
                    case 0: 
                    case 2: {
                        if (debug != null) {
                            debug.println("X509CertSelector.match: name constraints inhibit path to specified name");
                            debug.println("X509CertSelector.match: excluded name: " + generalNameInterface2);
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean matchPermitted(GeneralSubtrees generalSubtrees) {
        Iterator iterator = this.pathToGeneralNames.iterator();
        while (iterator.hasNext()) {
            GeneralNameInterface generalNameInterface = (GeneralNameInterface)iterator.next();
            Iterator iterator2 = generalSubtrees.iterator();
            boolean bl2 = false;
            boolean bl3 = false;
            String string = "";
            block4: while (iterator2.hasNext() && !bl2) {
                GeneralSubtree generalSubtree = (GeneralSubtree)iterator2.next();
                GeneralNameInterface generalNameInterface2 = generalSubtree.getName().getName();
                if (generalNameInterface2.getType() != generalNameInterface.getType()) continue;
                bl3 = true;
                string = string + "  " + generalNameInterface2;
                switch (generalNameInterface.constrains(generalNameInterface2)) {
                    case 0: 
                    case 2: {
                        bl2 = true;
                        continue block4;
                    }
                }
            }
            if (bl2 || !bl3) continue;
            if (debug != null) {
                debug.println("X509CertSelector.match: name constraints inhibit path to specified name; permitted names of type " + generalNameInterface.getType() + ": " + string);
            }
            return false;
        }
        return true;
    }

    static boolean equalNames(Collection collection, Collection collection2) {
        if (collection == null || collection2 == null) {
            return collection == collection2;
        }
        return ((Object)collection).equals(collection2);
    }

    private static Set cloneAndCheckNames(Collection collection) throws IOException {
        Object object;
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof List)) {
                throw new IOException("expected a List");
            }
            hashSet.add(new ArrayList((List)object));
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (List)iterator.next();
            if (object.size() != 2) {
                throw new IOException("name list size not 2");
            }
            Object object2 = object.get(0);
            if (!(object2 instanceof Integer)) {
                throw new IOException("expected an Integer");
            }
            int n2 = (Integer)object2;
            if (n2 < 0 || n2 > 8) {
                throw new IOException("name type not 0-8");
            }
            Object object3 = object.get(1);
            if (!(object3 instanceof byte[]) && !(object3 instanceof String)) {
                if (debug != null) {
                    debug.println("X509CertSelector.cloneAndCheckNames() name not byte array");
                }
                throw new IOException("name not byte array or String");
            }
            if (!(object3 instanceof byte[])) continue;
            object.set(1, ((byte[])object3).clone());
        }
        return hashSet;
    }

    private static Set cloneNames(Collection collection) {
        try {
            return X509CertSelector.cloneAndCheckNames(collection);
        }
        catch (IOException iOException) {
            throw new RuntimeException("cloneNames encountered IOException: " + iOException.getMessage());
        }
    }

    private static Set parseNames(Collection collection) throws IOException {
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof List)) {
                throw new IOException("expected List");
            }
            List list = (List)object;
            if (list.size() != 2) {
                throw new IOException("name list size not 2");
            }
            object = list.get(0);
            if (!(object instanceof Integer)) {
                throw new IOException("expected an Integer");
            }
            int n2 = (Integer)object;
            object = list.get(1);
            hashSet.add(X509CertSelector.makeGeneralNameInterface(n2, object));
        }
        return hashSet;
    }

    private static Set cloneSet(Set set) {
        if (set instanceof HashSet) {
            Object object = ((HashSet)set).clone();
            return (Set)object;
        }
        return new HashSet(set);
    }

    private static Extension getExtensionObject(X509Certificate x509Certificate, int n2) throws IOException {
        if (x509Certificate instanceof X509CertImpl) {
            X509CertImpl x509CertImpl = (X509CertImpl)x509Certificate;
            switch (n2) {
                case 0: {
                    return x509CertImpl.getPrivateKeyUsageExtension();
                }
                case 1: {
                    return x509CertImpl.getSubjectAlternativeNameExtension();
                }
                case 2: {
                    return x509CertImpl.getNameConstraintsExtension();
                }
                case 3: {
                    return x509CertImpl.getCertificatePoliciesExtension();
                }
                case 4: {
                    return x509CertImpl.getExtendedKeyUsageExtension();
                }
            }
            return null;
        }
        byte[] byArray = x509Certificate.getExtensionValue(EXTENSION_OIDS[n2]);
        if (byArray == null) {
            return null;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        switch (n2) {
            case 0: {
                try {
                    return new PrivateKeyUsageExtension(FALSE, byArray2);
                }
                catch (CertificateException certificateException) {
                    throw new IOException(certificateException.getMessage());
                }
            }
            case 1: {
                return new SubjectAlternativeNameExtension(FALSE, byArray2);
            }
            case 2: {
                return new NameConstraintsExtension(FALSE, byArray2);
            }
            case 3: {
                return new CertificatePoliciesExtension(FALSE, byArray2);
            }
            case 4: {
                return new ExtendedKeyUsageExtension(FALSE, byArray2);
            }
        }
        return null;
    }

    static GeneralNameInterface makeGeneralNameInterface(int n2, Object object) throws IOException {
        GeneralNameInterface generalNameInterface;
        if (debug != null) {
            debug.println("X509CertSelector.makeGeneralNameInterface(" + n2 + ")...");
        }
        if (object instanceof String) {
            if (debug != null) {
                debug.println("X509CertSelector.makeGeneralNameInterface() name is String: " + object);
            }
            switch (n2) {
                case 1: {
                    generalNameInterface = new RFC822Name((String)object);
                    break;
                }
                case 2: {
                    generalNameInterface = new DNSName((String)object);
                    break;
                }
                case 4: {
                    generalNameInterface = new X500Name((String)object, "RFC2253");
                    break;
                }
                case 6: {
                    generalNameInterface = new URIName((String)object);
                    break;
                }
                case 7: {
                    generalNameInterface = new IPAddressName((String)object);
                    break;
                }
                case 8: {
                    generalNameInterface = new OIDName((String)object);
                    break;
                }
                default: {
                    throw new IOException("unable to parse String names of type " + n2);
                }
            }
            if (debug != null) {
                debug.println("X509CertSelector.makeGeneralNameInterface() result: " + generalNameInterface.toString());
            }
        } else if (object instanceof byte[]) {
            DerValue derValue = new DerValue((byte[])object);
            if (debug != null) {
                debug.println("X509CertSelector.makeGeneralNameInterface() is byte[]");
            }
            switch (n2) {
                case 0: {
                    generalNameInterface = new OtherName(derValue);
                    break;
                }
                case 1: {
                    generalNameInterface = new RFC822Name(derValue);
                    break;
                }
                case 2: {
                    generalNameInterface = new DNSName(derValue);
                    break;
                }
                case 3: {
                    generalNameInterface = new X400Address(derValue);
                    break;
                }
                case 4: {
                    generalNameInterface = new X500Name(derValue);
                    break;
                }
                case 5: {
                    generalNameInterface = new EDIPartyName(derValue);
                    break;
                }
                case 6: {
                    generalNameInterface = new URIName(derValue);
                    break;
                }
                case 7: {
                    generalNameInterface = new IPAddressName(derValue);
                    break;
                }
                case 8: {
                    generalNameInterface = new OIDName(derValue);
                    break;
                }
                default: {
                    throw new IOException("unable to parse byte array names of type " + n2);
                }
            }
            if (debug != null) {
                debug.println("X509CertSelector.makeGeneralNameInterface() result: " + generalNameInterface.toString());
            }
        } else {
            if (debug != null) {
                debug.println("X509CertSelector.makeGeneralName() input name not String or byte array");
            }
            throw new IOException("name not String or byte array");
        }
        return generalNameInterface;
    }
}

