/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class DefaultCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    protected JComponent editorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart = 1;

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    public void setClickCountToStart(int n2) {
        this.clickCountToStart = n2;
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        return this.delegate.isCellEditable(eventObject);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return this.delegate.shouldSelectCell(eventObject);
    }

    public DefaultCellEditor(JCheckBox jCheckBox) {
        this.editorComponent = jCheckBox;
        this.delegate = new EditorDelegate(this, jCheckBox){
            private final JCheckBox val$checkBox;
            private final DefaultCellEditor this$0;

            public Object getCellEditorValue() {
                return this.val$checkBox.isSelected();
            }

            public void setValue(Object object) {
                boolean bl2 = false;
                if (object instanceof Boolean) {
                    bl2 = (Boolean)object;
                } else if (object instanceof String) {
                    bl2 = object.equals("true");
                }
                this.val$checkBox.setSelected(bl2);
            }
            {
                this.this$0 = defaultCellEditor;
                this.val$checkBox = jCheckBox;
                super(defaultCellEditor);
            }
        };
        jCheckBox.addActionListener(this.delegate);
    }

    public DefaultCellEditor(JComboBox jComboBox) {
        this.editorComponent = jComboBox;
        jComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.delegate = new EditorDelegate(this, jComboBox){
            private final JComboBox val$comboBox;
            private final DefaultCellEditor this$0;

            public boolean stopCellEditing() {
                if (this.val$comboBox.isEditable()) {
                    this.val$comboBox.actionPerformed(new ActionEvent(this.this$0, 0, ""));
                }
                return super.stopCellEditing();
            }

            public Object getCellEditorValue() {
                return this.val$comboBox.getSelectedItem();
            }

            public void setValue(Object object) {
                this.val$comboBox.setSelectedItem(object);
            }

            public boolean shouldSelectCell(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    return mouseEvent.getID() != 506;
                }
                return true;
            }
            {
                this.this$0 = defaultCellEditor;
                this.val$comboBox = jComboBox;
                super(defaultCellEditor);
            }
        };
        jComboBox.addActionListener(this.delegate);
    }

    public DefaultCellEditor(JTextField jTextField) {
        this.editorComponent = jTextField;
        this.clickCountToStart = 2;
        this.delegate = new EditorDelegate(this, jTextField){
            private final JTextField val$textField;
            private final DefaultCellEditor this$0;

            public Object getCellEditorValue() {
                return this.val$textField.getText();
            }

            public void setValue(Object object) {
                this.val$textField.setText(object != null ? object.toString() : "");
            }
            {
                this.this$0 = defaultCellEditor;
                this.val$textField = jTextField;
                super(defaultCellEditor);
            }
        };
        jTextField.addActionListener(this.delegate);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
        this.delegate.setValue(object);
        return this.editorComponent;
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2) {
        String string = jTree.convertValueToText(object, bl2, bl3, bl4, n2, false);
        this.delegate.setValue(string);
        return this.editorComponent;
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        protected Object value;
        private final DefaultCellEditor this$0;

        public void cancelCellEditing() {
            this.this$0.fireEditingCanceled();
        }

        public boolean stopCellEditing() {
            this.this$0.fireEditingStopped();
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.stopCellEditing();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.this$0.stopCellEditing();
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= this.this$0.clickCountToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean startCellEditing(EventObject eventObject) {
            return true;
        }

        protected EditorDelegate(DefaultCellEditor defaultCellEditor) {
            this.this$0 = defaultCellEditor;
        }
    }
}

