/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import javax.swing.SizeRequirements;

public class OverlayLayout
implements LayoutManager2,
Serializable {
    private Container target;
    private SizeRequirements[] xChildren;
    private SizeRequirements[] yChildren;
    private SizeRequirements xTotal;
    private SizeRequirements yTotal;

    void checkRequests() {
        if (this.xChildren == null || this.yChildren == null) {
            int n2 = this.target.getComponentCount();
            this.xChildren = new SizeRequirements[n2];
            this.yChildren = new SizeRequirements[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = this.target.getComponent(i2);
                Dimension dimension = component.getMinimumSize();
                Dimension dimension2 = component.getPreferredSize();
                Dimension dimension3 = component.getMaximumSize();
                this.xChildren[i2] = new SizeRequirements(dimension.width, dimension2.width, dimension3.width, component.getAlignmentX());
                this.yChildren[i2] = new SizeRequirements(dimension.height, dimension2.height, dimension3.height, component.getAlignmentY());
            }
            this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
            this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
        }
    }

    public void removeLayoutComponent(Component component) {
        this.invalidateLayout(component.getParent());
    }

    public float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.xTotal.alignment;
    }

    public float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.yTotal.alignment;
    }

    public OverlayLayout(Container container) {
        this.target = container;
    }

    void checkContainer(Container container) {
        if (this.target != container) {
            throw new AWTError("OverlayLayout can't be shared");
        }
    }

    public void invalidateLayout(Container container) {
        this.checkContainer(container);
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
    }

    public void layoutContainer(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        int n2 = container.getComponentCount();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        SizeRequirements.calculateAlignedPositions(dimension.width, this.xTotal, this.xChildren, nArray, nArray2);
        SizeRequirements.calculateAlignedPositions(dimension.height, this.yTotal, this.yChildren, nArray3, nArray4);
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = container.getComponent(i2);
            component.setBounds(insets.left + nArray[i2], insets.top + nArray3[i2], nArray2[i2], nArray4[i2]);
        }
    }

    public void addLayoutComponent(String string, Component component) {
        this.invalidateLayout(component.getParent());
    }

    public Dimension maximumLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.minimum, this.yTotal.minimum);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void addLayoutComponent(Component component, Object object) {
        this.invalidateLayout(component.getParent());
    }
}

