/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import sun.security.action.GetPropertyAction;
import sun.util.calendar.ZoneInfo;

public class ZoneInfoFile {
    public static final byte[] JAVAZI_LABEL = new byte[]{106, 97, 118, 97, 122, 105, 0};
    private static final int JAVAZI_LABEL_LENGTH = JAVAZI_LABEL.length;
    public static final byte JAVAZI_VERSION = 1;
    public static final byte TAG_RawOffset = 1;
    public static final byte TAG_LastDSTSaving = 2;
    public static final byte TAG_CRC32 = 3;
    public static final byte TAG_Transition = 4;
    public static final byte TAG_Offset = 5;
    public static final byte TAG_SimpleTimeZone = 6;
    public static final byte TAG_GMTOffsetWillChange = 7;
    public static final String JAVAZM_FILE_NAME = "ZoneInfoMappings";
    public static final byte[] JAVAZM_LABEL = new byte[]{106, 97, 118, 97, 122, 109, 0};
    private static final int JAVAZM_LABEL_LENGTH = JAVAZM_LABEL.length;
    public static final byte JAVAZM_VERSION = 1;
    public static final byte TAG_ZoneIDs = 64;
    public static final byte TAG_RawOffsets = 65;
    public static final byte TAG_RawOffsetIndices = 66;
    public static final byte TAG_ZoneAliases = 67;
    public static final byte TAG_TZDataVersion = 68;
    private static HashMap zoneInfoObjects = null;
    private static SoftReference zoneIDs = null;
    private static SoftReference rawOffsetIndices = null;
    private static SoftReference rawOffsets = null;
    private static SoftReference zoneInfoMappings = null;
    static Class class$sun$util$calendar$ZoneInfoFile;

    static byte[] getRawOffsetIndices() {
        byte[] byArray;
        block8: {
            byArray = null;
            if (rawOffsetIndices != null && (byArray = (byte[])rawOffsetIndices.get()) != null) {
                return byArray;
            }
            byte[] byArray2 = ZoneInfoFile.getZoneInfoMappings();
            int n2 = JAVAZM_LABEL_LENGTH + 1;
            int n3 = byArray2.length;
            try {
                while (n2 < n3) {
                    byte by = byArray2[n2++];
                    int n4 = ((byArray2[n2++] & 0xFF) << 8) + (byArray2[n2++] & 0xFF);
                    switch (by) {
                        case 66: {
                            byArray = new byte[n4];
                            for (int i2 = 0; i2 < n4; ++i2) {
                                byArray[i2] = byArray2[n2++];
                            }
                            break block8;
                        }
                        default: {
                            n2 += n4;
                            break;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        rawOffsetIndices = new SoftReference(byArray);
        return byArray;
    }

    private static byte[] getZoneInfoMappings() {
        int n2;
        byte[] byArray;
        if (zoneInfoMappings != null && (byArray = (byte[])zoneInfoMappings.get()) != null) {
            return byArray;
        }
        byArray = ZoneInfoFile.readZoneInfoFile(JAVAZM_FILE_NAME);
        if (byArray == null) {
            return null;
        }
        for (n2 = 0; n2 < JAVAZM_LABEL.length; ++n2) {
            if (byArray[n2] == JAVAZM_LABEL[n2]) continue;
            System.err.println("ZoneInfo: wrong magic number: ZoneInfoMappings");
            return null;
        }
        if (byArray[n2++] > 1) {
            System.err.println("ZoneInfo: incompatible version (" + byArray[n2 - 1] + "): " + JAVAZM_FILE_NAME);
            return null;
        }
        zoneInfoMappings = new SoftReference(byArray);
        return byArray;
    }

    static int[] getRawOffsets() {
        int[] nArray;
        block8: {
            nArray = null;
            if (rawOffsets != null && (nArray = (int[])rawOffsets.get()) != null) {
                return nArray;
            }
            byte[] byArray = ZoneInfoFile.getZoneInfoMappings();
            int n2 = JAVAZM_LABEL_LENGTH + 1;
            int n3 = byArray.length;
            try {
                while (n2 < n3) {
                    byte by = byArray[n2++];
                    int n4 = ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF);
                    switch (by) {
                        case 65: {
                            int n5 = n4 / 4;
                            nArray = new int[n5];
                            for (int i2 = 0; i2 < n5; ++i2) {
                                int n6 = byArray[n2++] & 0xFF;
                                n6 = (n6 << 8) + (byArray[n2++] & 0xFF);
                                n6 = (n6 << 8) + (byArray[n2++] & 0xFF);
                                nArray[i2] = n6 = (n6 << 8) + (byArray[n2++] & 0xFF);
                            }
                            break block8;
                        }
                        default: {
                            n2 += n4;
                            break;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        rawOffsets = new SoftReference(nArray);
        return nArray;
    }

    static String[] getZoneIDs() {
        String[] stringArray;
        block8: {
            stringArray = null;
            if (zoneIDs != null && (stringArray = (String[])zoneIDs.get()) != null) {
                return stringArray;
            }
            byte[] byArray = null;
            byArray = ZoneInfoFile.getZoneInfoMappings();
            int n2 = JAVAZM_LABEL_LENGTH + 1;
            int n3 = byArray.length;
            try {
                while (n2 < n3) {
                    byte by = byArray[n2++];
                    int n4 = ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF);
                    switch (by) {
                        case 64: {
                            int n5 = (byArray[n2++] << 8) + (byArray[n2++] & 0xFF);
                            stringArray = new String[n5];
                            for (int i2 = 0; i2 < n5; ++i2) {
                                byte by2 = byArray[n2++];
                                stringArray[i2] = new String(byArray, n2, (int)by2, "US-ASCII");
                                n2 += by2;
                            }
                            break block8;
                        }
                        default: {
                            n2 += n4;
                            break;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        zoneIDs = new SoftReference(stringArray);
        return stringArray;
    }

    private static byte[] readZoneInfoFile(String string) {
        byte[] byArray;
        block2: {
            byArray = null;
            try {
                String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
                String string3 = string2 + File.separator + "lib" + File.separator + "zi" + File.separator + string;
                byArray = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(string3){
                    private final String val$fname;

                    public Object run() throws IOException {
                        File file = new File(this.val$fname);
                        FileInputStream fileInputStream = new FileInputStream(file);
                        int n2 = (int)file.length();
                        byte[] byArray = new byte[n2];
                        if (fileInputStream.read(byArray) != n2) {
                            fileInputStream.close();
                            throw new IOException("read error on " + this.val$fname);
                        }
                        fileInputStream.close();
                        return byArray;
                    }
                    {
                        this.val$fname = string;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof FileNotFoundException && !JAVAZM_FILE_NAME.equals(string)) break block2;
                System.err.println("ZoneInfo: " + exception.getMessage());
            }
        }
        return byArray;
    }

    static HashMap getZoneAliases() {
        HashMap hashMap;
        block7: {
            byte[] byArray = ZoneInfoFile.getZoneInfoMappings();
            int n2 = JAVAZM_LABEL_LENGTH + 1;
            int n3 = byArray.length;
            hashMap = null;
            try {
                while (n2 < n3) {
                    byte by = byArray[n2++];
                    int n4 = ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF);
                    switch (by) {
                        case 67: {
                            int n5 = (byArray[n2++] << 8) + (byArray[n2++] & 0xFF);
                            hashMap = new HashMap(n5);
                            for (int i2 = 0; i2 < n5; ++i2) {
                                byte by2 = byArray[n2++];
                                String string = new String(byArray, n2, (int)by2, "US-ASCII");
                                n2 += by2;
                                by2 = byArray[n2++];
                                String string2 = new String(byArray, n2, (int)by2, "US-ASCII");
                                n2 += by2;
                                hashMap.put(string, string2);
                            }
                            break block7;
                        }
                        default: {
                            n2 += n4;
                            break;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
                return null;
            }
        }
        return hashMap;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public static String getFileName(String string) {
        if (File.separatorChar == '/') {
            return string;
        }
        return string.replace('/', File.separatorChar);
    }

    private static ZoneInfo createZoneInfo(String string) {
        int n2;
        byte[] byArray = ZoneInfoFile.readZoneInfoFile(ZoneInfoFile.getFileName(string));
        if (byArray == null) {
            return null;
        }
        for (n2 = 0; n2 < JAVAZI_LABEL.length; ++n2) {
            if (byArray[n2] == JAVAZI_LABEL[n2]) continue;
            System.err.println("ZoneInfo: wrong magic number: " + string);
            return null;
        }
        if (byArray[n2++] > 1) {
            System.err.println("ZoneInfo: incompatible version (" + byArray[n2 - 1] + "): " + string);
            return null;
        }
        int n3 = byArray.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = false;
        long[] lArray = null;
        int[] nArray = null;
        int[] nArray2 = null;
        try {
            block12: while (n2 < n3) {
                int n7;
                byte by = byArray[n2++];
                if (n3 >= n2 + (n7 = ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF))) {
                    switch (by) {
                        case 3: {
                            int n8 = byArray[n2++] & 0xFF;
                            n8 = (n8 << 8) + (byArray[n2++] & 0xFF);
                            n8 = (n8 << 8) + (byArray[n2++] & 0xFF);
                            n6 = n8 = (n8 << 8) + (byArray[n2++] & 0xFF);
                            continue block12;
                        }
                        case 2: {
                            int n8 = (short)(byArray[n2++] & 0xFF);
                            n8 = (short)((n8 << 8) + (byArray[n2++] & 0xFF));
                            n5 = n8 * 1000;
                            continue block12;
                        }
                        case 1: {
                            int n8 = byArray[n2++] & 0xFF;
                            n8 = (n8 << 8) + (byArray[n2++] & 0xFF);
                            n8 = (n8 << 8) + (byArray[n2++] & 0xFF);
                            n4 = n8 = (n8 << 8) + (byArray[n2++] & 0xFF);
                            continue block12;
                        }
                        case 4: {
                            int n9;
                            int n8 = n7 / 8;
                            lArray = new long[n8];
                            for (n9 = 0; n9 < n8; ++n9) {
                                long l2 = byArray[n2++] & 0xFF;
                                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                                lArray[n9] = l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                            }
                            continue block12;
                        }
                        case 5: {
                            int n9;
                            int n8 = n7 / 4;
                            nArray = new int[n8];
                            for (n9 = 0; n9 < n8; ++n9) {
                                int n10 = byArray[n2++] & 0xFF;
                                n10 = (n10 << 8) + (byArray[n2++] & 0xFF);
                                n10 = (n10 << 8) + (byArray[n2++] & 0xFF);
                                nArray[n9] = n10 = (n10 << 8) + (byArray[n2++] & 0xFF);
                            }
                            continue block12;
                        }
                        case 6: {
                            int n9;
                            if (n7 != 32 && n7 != 40) {
                                System.err.println("ZoneInfo: wrong SimpleTimeZone parameter size");
                                return null;
                            }
                            int n8 = n7 / 4;
                            nArray2 = new int[n8];
                            for (n9 = 0; n9 < n8; ++n9) {
                                int n11 = byArray[n2++] & 0xFF;
                                n11 = (n11 << 8) + (byArray[n2++] & 0xFF);
                                n11 = (n11 << 8) + (byArray[n2++] & 0xFF);
                                nArray2[n9] = n11 = (n11 << 8) + (byArray[n2++] & 0xFF);
                            }
                            continue block12;
                        }
                        case 7: {
                            if (n7 != 1) {
                                System.err.println("ZoneInfo: wrong byte length for TAG_GMTOffsetWillChange");
                            }
                            bl2 = byArray[n2++] == 1;
                            continue block12;
                        }
                    }
                    System.err.println("ZoneInfo: unknown tag < " + by + ">. ignored.");
                    n2 += n7;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.err.println("ZoneInfo: corrupted zoneinfo file: " + string);
            return null;
        }
        if (n2 != n3) {
            System.err.println("ZoneInfo: wrong file size: " + string);
            return null;
        }
        return new ZoneInfo(string, n4, n5, n6, lArray, nArray, nArray2, bl2);
    }

    public static synchronized ZoneInfo getZoneInfo(String string) {
        ZoneInfo zoneInfo = null;
        if (zoneInfoObjects == null) {
            zoneInfo = ZoneInfoFile.createZoneInfo(string);
            if (zoneInfo != null) {
                zoneInfoObjects = new HashMap();
                zoneInfoObjects.put(string, zoneInfo);
                return (ZoneInfo)zoneInfo.clone();
            }
            return null;
        }
        zoneInfo = (ZoneInfo)zoneInfoObjects.get(string);
        if (zoneInfo != null) {
            return (ZoneInfo)zoneInfo.clone();
        }
        zoneInfo = ZoneInfoFile.createZoneInfo(string);
        if (zoneInfo != null) {
            zoneInfoObjects.put(string, zoneInfo);
            return (ZoneInfo)zoneInfo.clone();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZoneInfo getCustomTimeZone(String string, int n2) {
        ZoneInfo zoneInfo;
        int n3;
        char c2;
        if (n2 >= 0) {
            c2 = '+';
            n3 = n2;
        } else {
            c2 = '-';
            n3 = -n2;
        }
        int n4 = n3 / 60;
        int n5 = n3 % 60;
        StringBuffer stringBuffer = new StringBuffer("GMT");
        stringBuffer.append(c2);
        if (n4 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n4).append(':');
        if (n5 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n5);
        String string2 = stringBuffer.toString();
        Class clazz = class$sun$util$calendar$ZoneInfoFile == null ? (class$sun$util$calendar$ZoneInfoFile = ZoneInfoFile.class$("sun.util.calendar.ZoneInfoFile")) : class$sun$util$calendar$ZoneInfoFile;
        synchronized (clazz) {
            if (zoneInfoObjects == null) {
                zoneInfoObjects = new HashMap();
            }
            if ((zoneInfo = (ZoneInfo)zoneInfoObjects.get(string2)) == null) {
                zoneInfo = new ZoneInfo(string2, n2 * 60000);
                zoneInfoObjects.put(string2, zoneInfo);
                if (!string2.equals(string)) {
                    zoneInfoObjects.put(string, zoneInfo);
                }
            }
        }
        return (ZoneInfo)zoneInfo.clone();
    }
}

