/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.peer.RobotPeer;
import java.lang.reflect.InvocationTargetException;
import sun.awt.ComponentFactory;
import sun.awt.SunToolkit;
import sun.security.util.SecurityConstants;

public class Robot {
    private static final int MAX_DELAY = 60000;
    private RobotPeer peer;
    private boolean isAutoWaitForIdle = false;
    private int autoDelay = 0;
    private static final int LEGAL_BUTTON_MASK = 28;
    private DirectColorModel screenCapCM = null;

    public synchronized int getAutoDelay() {
        return this.autoDelay;
    }

    public Robot() throws AWTException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new AWTException("headless environment");
        }
        this.init(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    private void afterEvent() {
        this.autoWaitForIdle();
        this.autoDelay();
    }

    private void autoDelay() {
        this.delay(this.autoDelay);
    }

    private void autoWaitForIdle() {
        if (this.isAutoWaitForIdle) {
            this.waitForIdle();
        }
    }

    private void checkNotDispatchThread() {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalThreadStateException("Cannot call method from the event dispatcher thread");
        }
    }

    private void checkRobotAllowed() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.CREATE_ROBOT_PERMISSION);
        }
    }

    private static void checkScreenCaptureAllowed() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.READ_DISPLAY_PIXELS_PERMISSION);
        }
    }

    public synchronized void waitForIdle() {
        this.checkNotDispatchThread();
        try {
            SunToolkit.flushPendingEvents();
            EventQueue.invokeAndWait(new Runnable(this){
                private final Robot this$0;

                public void run() {
                }
                {
                    this.this$0 = robot;
                }
            });
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Robot.waitForIdle, non-fatal exception caught:");
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("Robot.waitForIdle, non-fatal exception caught:");
            invocationTargetException.printStackTrace();
        }
    }

    public synchronized boolean isAutoWaitForIdle() {
        return this.isAutoWaitForIdle;
    }

    private void checkButtonsArgument(int n2) {
        if ((n2 | 0x1C) != 28) {
            throw new IllegalArgumentException("Invalid combination of button flags");
        }
    }

    private void checkDelayArgument(int n2) {
        if (n2 < 0 || n2 > 60000) {
            throw new IllegalArgumentException("Delay must be to 0 to 60,000ms");
        }
    }

    private void checkKeycodeArgument(int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("Invalid key code");
        }
    }

    public synchronized void delay(int n2) {
        this.checkDelayArgument(n2);
        try {
            Thread.sleep(n2);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public synchronized void keyPress(int n2) {
        this.checkKeycodeArgument(n2);
        this.peer.keyPress(n2);
        this.afterEvent();
    }

    public synchronized void keyRelease(int n2) {
        this.checkKeycodeArgument(n2);
        this.peer.keyRelease(n2);
        this.afterEvent();
    }

    public synchronized void mousePress(int n2) {
        this.checkButtonsArgument(n2);
        this.peer.mousePress(n2);
        this.afterEvent();
    }

    public synchronized void mouseRelease(int n2) {
        this.checkButtonsArgument(n2);
        this.peer.mouseRelease(n2);
        this.afterEvent();
    }

    public synchronized void mouseWheel(int n2) {
        this.peer.mouseWheel(n2);
        this.afterEvent();
    }

    public synchronized void setAutoDelay(int n2) {
        this.checkDelayArgument(n2);
        this.autoDelay = n2;
    }

    public synchronized void mouseMove(int n2, int n3) {
        this.peer.mouseMove(n2, n3);
        this.afterEvent();
    }

    public synchronized void setAutoWaitForIdle(boolean bl2) {
        this.isAutoWaitForIdle = bl2;
    }

    public synchronized Color getPixelColor(int n2, int n3) {
        Color color = new Color(this.peer.getRGBPixel(n2, n3));
        return color;
    }

    public Robot(GraphicsDevice graphicsDevice) throws AWTException {
        this.checkIsScreenDevice(graphicsDevice);
        this.init(graphicsDevice);
    }

    private void checkIsScreenDevice(GraphicsDevice graphicsDevice) {
        if (graphicsDevice == null || graphicsDevice.getType() != 0) {
            throw new IllegalArgumentException("not a valid screen device");
        }
    }

    private void init(GraphicsDevice graphicsDevice) throws AWTException {
        this.checkRobotAllowed();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof ComponentFactory) {
            this.peer = ((ComponentFactory)((Object)toolkit)).createRobot(this, graphicsDevice);
        }
    }

    private static void checkValidRect(Rectangle rectangle) {
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            throw new IllegalArgumentException("Rectangle width and height must be > 0");
        }
    }

    public synchronized String toString() {
        String string = "autoDelay = " + this.getAutoDelay() + ", " + "autoWaitForIdle = " + this.isAutoWaitForIdle();
        return this.getClass().getName() + "[ " + string + " ]";
    }

    public synchronized BufferedImage createScreenCapture(Rectangle rectangle) {
        Robot.checkScreenCaptureAllowed();
        Robot.checkValidRect(rectangle);
        if (this.screenCapCM == null) {
            this.screenCapCM = new DirectColorModel(24, 0xFF0000, 65280, 255);
        }
        int[] nArray = new int[3];
        int[] nArray2 = this.peer.getRGBPixels(rectangle);
        DataBufferInt dataBufferInt = new DataBufferInt(nArray2, nArray2.length);
        nArray[0] = this.screenCapCM.getRedMask();
        nArray[1] = this.screenCapCM.getGreenMask();
        nArray[2] = this.screenCapCM.getBlueMask();
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, rectangle.width, rectangle.height, rectangle.width, nArray, null);
        BufferedImage bufferedImage = new BufferedImage(this.screenCapCM, writableRaster, false, null);
        return bufferedImage;
    }
}

