/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ExceptionListener;
import java.beans.ObjectHandler;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import sun.reflect.misc.ConstructorUtil;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

class ReflectionUtils {
    private static Reference methodCacheRef;
    static Class class$java$lang$Boolean;
    static Class class$java$lang$Byte;
    static Class class$java$lang$Character;
    static Class class$java$lang$Short;
    static Class class$java$lang$Integer;
    static Class class$java$lang$Float;
    static Class class$java$lang$Void;
    static Class class$java$lang$Long;
    static Class class$java$lang$Double;

    ReflectionUtils() {
    }

    public static boolean isPrimitive(Class clazz) {
        return ReflectionUtils.primitiveTypeFor(clazz) != null;
    }

    public static Class primitiveTypeFor(Class clazz) {
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReflectionUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.TYPE;
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectionUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.TYPE;
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = ReflectionUtils.class$("java.lang.Character")) : class$java$lang$Character)) {
            return Character.TYPE;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = ReflectionUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.TYPE;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ReflectionUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.TYPE;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ReflectionUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.TYPE;
        }
        if (clazz == (class$java$lang$Void == null ? (class$java$lang$Void = ReflectionUtils.class$("java.lang.Void")) : class$java$lang$Void)) {
            return Void.TYPE;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ReflectionUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.TYPE;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ReflectionUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.TYPE;
        }
        return null;
    }

    public static Class typeToClass(Class clazz) {
        return clazz.isPrimitive() ? ObjectHandler.typeNameToClass(clazz.getName()) : clazz;
    }

    private static boolean matchArguments(Class[] classArray, Class[] classArray2) {
        boolean bl2 = classArray.length == classArray2.length;
        for (int i2 = 0; i2 < classArray.length && bl2; ++i2) {
            Class clazz = classArray2[i2];
            if (clazz.isPrimitive()) {
                clazz = ReflectionUtils.typeToClass(clazz);
            }
            if (classArray[i2] == null || clazz.isAssignableFrom(classArray[i2])) continue;
            bl2 = false;
        }
        return bl2;
    }

    private static boolean matchExplicitArguments(Class[] classArray, Class[] classArray2) {
        boolean bl2 = classArray.length == classArray2.length;
        for (int i2 = 0; i2 < classArray.length && bl2; ++i2) {
            Class clazz = classArray2[i2];
            if (clazz.isPrimitive()) {
                clazz = ReflectionUtils.typeToClass(clazz);
            }
            if (classArray[i2] == clazz) continue;
            bl2 = false;
        }
        return bl2;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public static Constructor getConstructor(Class clazz, Class[] classArray) {
        Constructor constructor = null;
        Constructor[] constructorArray = ConstructorUtil.getConstructors(clazz);
        for (int i2 = 0; i2 < constructorArray.length; ++i2) {
            if (!ReflectionUtils.matchArguments(classArray, constructorArray[i2].getParameterTypes())) continue;
            constructor = constructorArray[i2];
        }
        return constructor;
    }

    public static Object getPrivateField(Object object, Class clazz, String string) {
        return ReflectionUtils.getPrivateField(object, clazz, string, null);
    }

    public static Method findMethod(Class clazz, String string, Class[] classArray) {
        Method method = ReflectionUtils.findPublicMethod(clazz, string, classArray);
        if (method != null && Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            return method;
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class[] classArray2 = clazz2.getInterfaces();
            for (int i2 = 0; i2 < classArray2.length; ++i2) {
                method = ReflectionUtils.findPublicMethod(classArray2[i2], string, classArray);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    public static Method findPublicMethod(Class clazz, String string, Class[] classArray) {
        Method method;
        if (classArray.length == 0) {
            try {
                return MethodUtil.getMethod(clazz, string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        Method[] methodArray = MethodUtil.getPublicMethods(clazz);
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            method = methodArray[i2];
            if (!method.getName().equals(string) || !ReflectionUtils.matchArguments(classArray, method.getParameterTypes())) continue;
            arrayList.add(method);
        }
        if (arrayList.size() > 0) {
            if (arrayList.size() == 1) {
                return (Method)arrayList.get(0);
            }
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                method = (Method)listIterator.next();
                if (!ReflectionUtils.matchExplicitArguments(classArray, method.getParameterTypes())) continue;
                return method;
            }
            return (Method)arrayList.get(0);
        }
        return null;
    }

    public static synchronized Method getMethod(Class clazz, String string, Class[] classArray) {
        Signature signature = new Signature(clazz, string, classArray);
        Method method = null;
        Map map = null;
        boolean bl2 = false;
        if (ReflectUtil.isPackageAccessible(clazz)) {
            bl2 = true;
        }
        if (bl2 && methodCacheRef != null && (map = (Map)methodCacheRef.get()) != null && (method = (Method)map.get(signature)) != null) {
            return method;
        }
        method = ReflectionUtils.findMethod(clazz, string, classArray);
        if (bl2 && method != null) {
            if (map == null) {
                map = new HashMap();
                methodCacheRef = new SoftReference(map);
            }
            map.put(signature, method);
        }
        return method;
    }

    static Method getPublicMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        Method method = ReflectionUtils.findPublicMethod(clazz, string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(clazz.getName() + "." + string);
        }
        return method;
    }

    public static Object getPrivateField(Object object, Class clazz, String string, ExceptionListener exceptionListener) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception exception) {
            if (exceptionListener != null) {
                exceptionListener.exceptionThrown(exception);
            }
            return null;
        }
    }

    private static class Signature {
        private Class targetClass;
        private String methodName;
        private Class[] argClasses;
        private volatile int hashCode = 0;

        public int hashCode() {
            if (this.hashCode == 0) {
                int n2 = 17;
                n2 = 37 * n2 + this.targetClass.hashCode();
                n2 = 37 * n2 + this.methodName.hashCode();
                if (this.argClasses != null) {
                    for (int i2 = 0; i2 < this.argClasses.length; ++i2) {
                        n2 = 37 * n2 + (this.argClasses[i2] == null ? 0 : this.argClasses[i2].hashCode());
                    }
                }
                this.hashCode = n2;
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            Signature signature = (Signature)object;
            if (this.targetClass != signature.targetClass) {
                return false;
            }
            if (!this.methodName.equals(signature.methodName)) {
                return false;
            }
            if (this.argClasses.length != signature.argClasses.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.argClasses.length; ++i2) {
                if (this.argClasses[i2] == signature.argClasses[i2]) continue;
                return false;
            }
            return true;
        }

        public Signature(Class clazz, String string, Class[] classArray) {
            this.targetClass = clazz;
            this.methodName = string;
            this.argClasses = classArray;
        }
    }
}

