/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessController;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;

public abstract class Signer
extends Identity {
    private PrivateKey privateKey;

    protected Signer() {
    }

    String printKeys() {
        String string = "";
        PublicKey publicKey = this.getPublicKey();
        string = publicKey != null && this.privateKey != null ? "\tpublic and private keys initialized" : "\tno keys";
        return string;
    }

    public String toString() {
        return "[Signer]" + super.toString();
    }

    public Signer(String string) {
        super(string);
    }

    private static void check(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }

    public final void setKeyPair(KeyPair keyPair) throws InvalidParameterException, KeyException {
        Signer.check("setSignerKeyPair");
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        if (publicKey == null || privateKey == null) {
            throw new InvalidParameterException();
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(this, publicKey){
                private final PublicKey val$pub;
                private final Signer this$0;

                public Object run() throws KeyManagementException {
                    this.this$0.setPublicKey(this.val$pub);
                    return null;
                }
                {
                    this.this$0 = signer;
                    this.val$pub = publicKey;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (KeyManagementException)privilegedActionException.getException();
        }
        this.privateKey = privateKey;
    }

    public PrivateKey getPrivateKey() {
        Signer.check("getSignerPrivateKey");
        return this.privateKey;
    }

    public Signer(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }
}

