/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedList
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    private transient Entry header = new Entry(null, null, null);
    private transient int size = 0;
    private static final long serialVersionUID = 876323262645176354L;

    public int size() {
        return this.size;
    }

    public LinkedList() {
        this.header.next = this.header.previous = this.header;
    }

    public void clear() {
        ++this.modCount;
        this.header.next = this.header.previous = this.header;
        this.size = 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.header.next = this.header.previous = (this.header = new Entry(null, null, null));
        for (int i2 = 0; i2 < n2; ++i2) {
            this.add(objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectOutputStream.writeObject(entry.element);
            entry = entry.next;
        }
    }

    public Object clone() {
        LinkedList linkedList = null;
        try {
            linkedList = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        linkedList.header.next = linkedList.header.previous = (linkedList.header = new Entry(null, null, null));
        linkedList.size = 0;
        linkedList.modCount = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            linkedList.add(entry.element);
            entry = entry.next;
        }
        return linkedList;
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.next.element;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.element;
    }

    public Object removeFirst() {
        Object object = this.header.next.element;
        this.remove(this.header.next);
        return object;
    }

    public Object removeLast() {
        Object object = this.header.previous.element;
        this.remove(this.header.previous);
        return object;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        int n2 = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectArray[n2++] = entry.element;
            entry = entry.next;
        }
        return objectArray;
    }

    public Object get(int n2) {
        return this.entry((int)n2).element;
    }

    public Object remove(int n2) {
        Entry entry = this.entry(n2);
        this.remove(entry);
        return entry.element;
    }

    public void add(int n2, Object object) {
        this.addBefore(object, n2 == this.size ? this.header : this.entry(n2));
    }

    public int indexOf(Object object) {
        int n2 = 0;
        if (object == null) {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (entry.element == null) {
                    return n2;
                }
                ++n2;
                entry = entry.next;
            }
        } else {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (object.equals(entry.element)) {
                    return n2;
                }
                ++n2;
                entry = entry.next;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n2 = this.size;
        if (object == null) {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                --n2;
                if (entry.element == null) {
                    return n2;
                }
                entry = entry.previous;
            }
        } else {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                --n2;
                if (object.equals(entry.element)) {
                    return n2;
                }
                entry = entry.previous;
            }
        }
        return -1;
    }

    public void addFirst(Object object) {
        this.addBefore(object, this.header.next);
    }

    public void addLast(Object object) {
        this.addBefore(object, this.header);
    }

    public boolean add(Object object) {
        this.addBefore(object, this.header);
        return true;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public boolean remove(Object object) {
        if (object == null) {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (entry.element == null) {
                    this.remove(entry);
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (object.equals(entry.element)) {
                    this.remove(entry);
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean addAll(int n2, Collection collection) {
        Object[] objectArray = collection.toArray();
        int n3 = objectArray.length;
        if (n3 == 0) {
            return false;
        }
        ++this.modCount;
        Entry entry = n2 == this.size ? this.header : this.entry(n2);
        Entry entry2 = entry.previous;
        for (int i2 = 0; i2 < n3; ++i2) {
            Entry entry3;
            entry2.next = entry3 = new Entry(objectArray[i2], entry, entry2);
            entry2 = entry3;
        }
        entry.previous = entry2;
        this.size += n3;
        return true;
    }

    public LinkedList(Collection collection) {
        this();
        this.addAll(collection);
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    static int access$100(LinkedList linkedList) {
        return linkedList.size;
    }

    private Entry entry(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        Entry entry = this.header;
        if (n2 < this.size >> 1) {
            for (int i2 = 0; i2 <= n2; ++i2) {
                entry = entry.next;
            }
        } else {
            for (int i3 = this.size; i3 > n2; --i3) {
                entry = entry.previous;
            }
        }
        return entry;
    }

    private void remove(Entry entry) {
        if (entry == this.header) {
            throw new NoSuchElementException();
        }
        entry.previous.next = entry.next;
        entry.next.previous = entry.previous;
        --this.size;
        ++this.modCount;
    }

    public ListIterator listIterator(int n2) {
        return new ListItr(this, n2);
    }

    public Object set(int n2, Object object) {
        Entry entry = this.entry(n2);
        Object object2 = entry.element;
        entry.element = object;
        return object2;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        int n2 = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectArray[n2++] = entry.element;
            entry = entry.next;
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    static Entry access$000(LinkedList linkedList) {
        return linkedList.header;
    }

    static void access$200(LinkedList linkedList, Entry entry) {
        linkedList.remove(entry);
    }

    private Entry addBefore(Object object, Entry entry) {
        Entry entry2;
        entry2.previous.next = entry2 = new Entry(object, entry, entry.previous);
        entry2.next.previous = entry2;
        ++this.size;
        ++this.modCount;
        return entry2;
    }

    static Entry access$300(LinkedList linkedList, Object object, Entry entry) {
        return linkedList.addBefore(object, entry);
    }

    private static class Entry {
        Object element;
        Entry next;
        Entry previous;

        Entry(Object object, Entry entry, Entry entry2) {
            this.element = object;
            this.next = entry;
            this.previous = entry2;
        }
    }

    private class ListItr
    implements ListIterator {
        private Entry lastReturned;
        private Entry next;
        private int nextIndex;
        private int expectedModCount;
        private final LinkedList this$0;

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        final void checkForComodification() {
            if (this.this$0.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        public void remove() {
            this.checkForComodification();
            try {
                LinkedList.access$200(this.this$0, this.lastReturned);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalStateException();
            }
            if (this.next == this.lastReturned) {
                this.next = this.lastReturned.next;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = LinkedList.access$000(this.this$0);
            ++this.expectedModCount;
        }

        public boolean hasNext() {
            return this.nextIndex != LinkedList.access$100(this.this$0);
        }

        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        public Object next() {
            this.checkForComodification();
            if (this.nextIndex == LinkedList.access$100(this.this$0)) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.element;
        }

        public Object previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next = this.next.previous;
            --this.nextIndex;
            this.checkForComodification();
            return this.lastReturned.element;
        }

        public void add(Object object) {
            this.checkForComodification();
            this.lastReturned = LinkedList.access$000(this.this$0);
            LinkedList.access$300(this.this$0, object, this.next);
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        public void set(Object object) {
            if (this.lastReturned == LinkedList.access$000(this.this$0)) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.element = object;
        }

        ListItr(LinkedList linkedList, int n2) {
            this.this$0 = linkedList;
            this.lastReturned = LinkedList.access$000(this.this$0);
            this.expectedModCount = this.this$0.modCount;
            if (n2 < 0 || n2 > LinkedList.access$100(linkedList)) {
                throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + LinkedList.access$100(linkedList));
            }
            if (n2 < LinkedList.access$100(linkedList) >> 1) {
                this.next = LinkedList.access$000((LinkedList)linkedList).next;
                this.nextIndex = 0;
                while (this.nextIndex < n2) {
                    this.next = this.next.next;
                    ++this.nextIndex;
                }
            } else {
                this.next = LinkedList.access$000(linkedList);
                this.nextIndex = LinkedList.access$100(linkedList);
                while (this.nextIndex > n2) {
                    this.next = this.next.previous;
                    --this.nextIndex;
                }
            }
        }
    }
}

