/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import javax.naming.CompositeName;
import javax.naming.Name;

public class NamingException
extends Exception {
    protected Name resolvedName = null;
    protected Object resolvedObj = null;
    protected Name remainingName = null;
    protected Throwable rootException = null;
    private static final long serialVersionUID = -1299181962103167177L;

    public NamingException() {
    }

    public Object getResolvedObj() {
        return this.resolvedObj;
    }

    public void setResolvedObj(Object object) {
        this.resolvedObj = object;
    }

    public String getExplanation() {
        return this.getMessage();
    }

    public String toString() {
        String string = super.toString();
        if (this.rootException != null) {
            string = string + " [Root exception is " + this.rootException + "]";
        }
        if (this.remainingName != null) {
            string = string + "; remaining name '" + this.remainingName + "'";
        }
        return string;
    }

    public NamingException(String string) {
        super(string);
    }

    public void appendRemainingComponent(String string) {
        if (string != null) {
            try {
                if (this.remainingName == null) {
                    this.remainingName = new CompositeName();
                }
                this.remainingName.add(string);
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException(namingException.toString());
            }
        }
    }

    public String toString(boolean bl2) {
        if (!bl2 || this.resolvedObj == null) {
            return this.toString();
        }
        return this.toString() + "; resolved object " + this.resolvedObj;
    }

    public Throwable getCause() {
        return this.getRootCause();
    }

    public Throwable getRootCause() {
        return this.rootException;
    }

    public void setRootCause(Throwable throwable) {
        if (throwable != this) {
            this.rootException = throwable;
        }
    }

    public Name getRemainingName() {
        return this.remainingName;
    }

    public Name getResolvedName() {
        return this.resolvedName;
    }

    public void appendRemainingName(Name name) {
        if (name == null) {
            return;
        }
        if (this.remainingName != null) {
            try {
                this.remainingName.addAll(name);
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException(namingException.toString());
            }
        } else {
            this.remainingName = (Name)name.clone();
        }
    }

    public void setRemainingName(Name name) {
        this.remainingName = name != null ? (Name)name.clone() : null;
    }

    public void setResolvedName(Name name) {
        this.resolvedName = name != null ? (Name)name.clone() : null;
    }

    public Throwable initCause(Throwable throwable) {
        super.initCause(throwable);
        this.setRootCause(throwable);
        return this;
    }
}

