/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;

public class JToolBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "ToolBarUI";
    private boolean paintBorder = true;
    private Insets margin = null;
    private boolean floatable = true;
    private int orientation = 0;

    public int getOrientation() {
        return this.orientation;
    }

    public JToolBar() {
        this(0);
    }

    public void addSeparator() {
        this.addSeparator(null);
    }

    public void updateUI() {
        this.setUI((ToolBarUI)UIManager.getUI(this));
        if (this.getLayout() == null) {
            this.setLayout(new DefaultToolBarLayout(this, this.getOrientation()));
        }
        this.invalidate();
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public boolean isFloatable() {
        return this.floatable;
    }

    public boolean isRollover() {
        Boolean bl2 = (Boolean)this.getClientProperty("JToolBar.isRollover");
        if (bl2 != null) {
            return bl2;
        }
        return false;
    }

    public JToolBar(int n2) {
        this(null, n2);
    }

    private void checkOrientation(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public void setOrientation(int n2) {
        this.checkOrientation(n2);
        if (this.orientation != n2) {
            int n3 = this.orientation;
            this.orientation = n2;
            this.firePropertyChange("orientation", n3, n2);
            this.revalidate();
            this.repaint();
        }
    }

    public void setBorderPainted(boolean bl2) {
        if (this.paintBorder != bl2) {
            boolean bl3 = this.paintBorder;
            this.paintBorder = bl2;
            this.firePropertyChange("borderPainted", bl3, bl2);
            this.revalidate();
            this.repaint();
        }
    }

    public void setFloatable(boolean bl2) {
        if (this.floatable != bl2) {
            boolean bl3 = this.floatable;
            this.floatable = bl2;
            this.firePropertyChange("floatable", bl3, bl2);
            this.revalidate();
            this.repaint();
        }
    }

    public void setRollover(boolean bl2) {
        this.putClientProperty("JToolBar.isRollover", bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public Component getComponentAtIndex(int n2) {
        int n3 = this.getComponentCount();
        if (n2 >= 0 && n2 < n3) {
            Component[] componentArray = this.getComponents();
            return componentArray[n2];
        }
        return null;
    }

    public int getComponentIndex(Component component) {
        int n2 = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component2 = componentArray[i2];
            if (component2 != component) continue;
            return i2;
        }
        return -1;
    }

    public void addSeparator(Dimension dimension) {
        Separator separator = new Separator(dimension);
        if (this.getOrientation() == 1) {
            separator.setOrientation(0);
        } else {
            separator.setOrientation(1);
        }
        this.add(separator);
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        this.revalidate();
        this.repaint();
    }

    public void setLayout(LayoutManager layoutManager) {
        LayoutManager layoutManager2 = this.getLayout();
        if (layoutManager2 instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)layoutManager2));
        }
        super.setLayout(layoutManager);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.paintBorder ? "true" : "false";
        String string2 = this.margin != null ? this.margin.toString() : "";
        String string3 = this.floatable ? "true" : "false";
        String string4 = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        return super.paramString() + ",floatable=" + string3 + ",margin=" + string2 + ",orientation=" + string4 + ",paintBorder=" + string;
    }

    public JToolBar(String string) {
        this(string, 0);
    }

    public JToolBar(String string, int n2) {
        this.setName(string);
        this.checkOrientation(n2);
        this.orientation = n2;
        DefaultToolBarLayout defaultToolBarLayout = new DefaultToolBarLayout(this, n2);
        this.setLayout(defaultToolBarLayout);
        this.addPropertyChangeListener(defaultToolBarLayout);
        this.updateUI();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToolBar(this);
        }
        return this.accessibleContext;
    }

    public ToolBarUI getUI() {
        return (ToolBarUI)this.ui;
    }

    public void setUI(ToolBarUI toolBarUI) {
        super.setUI(toolBarUI);
    }

    protected PropertyChangeListener createActionChangeListener(JButton jButton) {
        return null;
    }

    protected void addImpl(Component component, Object object, int n2) {
        super.addImpl(component, object, n2);
        if (component instanceof JButton) {
            ((JButton)component).setDefaultCapable(false);
        }
    }

    public JButton add(Action action) {
        JButton jButton = this.createActionComponent(action);
        jButton.setAction(action);
        this.add(jButton);
        return jButton;
    }

    protected JButton createActionComponent(Action action) {
        String string = action != null ? (String)action.getValue("Name") : null;
        Icon icon = action != null ? (Icon)action.getValue("SmallIcon") : null;
        boolean bl2 = action != null ? action.isEnabled() : true;
        String string2 = action != null ? (String)action.getValue("ShortDescription") : null;
        JButton jButton = new JButton(this, string, icon){
            private final JToolBar this$0;

            protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
                PropertyChangeListener propertyChangeListener = this.this$0.createActionChangeListener(this);
                if (propertyChangeListener == null) {
                    propertyChangeListener = super.createActionPropertyChangeListener(action);
                }
                return propertyChangeListener;
            }
            {
                this.this$0 = jToolBar;
                super(string, icon);
            }
        };
        if (icon != null) {
            jButton.putClientProperty("hideActionText", Boolean.TRUE);
        }
        jButton.setHorizontalTextPosition(0);
        jButton.setVerticalTextPosition(3);
        jButton.setEnabled(bl2);
        jButton.setToolTipText(string2);
        return jButton;
    }

    protected class AccessibleJToolBar
    extends JComponent.AccessibleJComponent {
        private final JToolBar this$0;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOOL_BAR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }

        protected AccessibleJToolBar(JToolBar jToolBar) {
            this.this$0 = jToolBar;
            super(jToolBar);
        }
    }

    private class DefaultToolBarLayout
    implements LayoutManager2,
    Serializable,
    PropertyChangeListener,
    UIResource {
        LayoutManager lm;
        private final JToolBar this$0;

        public void removeLayoutComponent(Component component) {
        }

        public float getLayoutAlignmentX(Container container) {
            if (this.lm instanceof LayoutManager2) {
                return ((LayoutManager2)this.lm).getLayoutAlignmentX(container);
            }
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container container) {
            if (this.lm instanceof LayoutManager2) {
                return ((LayoutManager2)this.lm).getLayoutAlignmentY(container);
            }
            return 0.5f;
        }

        public void invalidateLayout(Container container) {
            if (this.lm instanceof LayoutManager2) {
                ((LayoutManager2)this.lm).invalidateLayout(container);
            }
        }

        public void layoutContainer(Container container) {
            this.lm.layoutContainer(container);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("orientation")) {
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                this.lm = n2 == 1 ? new BoxLayout(this.this$0, 3) : new BoxLayout(this.this$0, 2);
            }
        }

        DefaultToolBarLayout(JToolBar jToolBar, int n2) {
            this.this$0 = jToolBar;
            this.lm = n2 == 1 ? new BoxLayout(jToolBar, 3) : new BoxLayout(jToolBar, 2);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension maximumLayoutSize(Container container) {
            if (this.lm instanceof LayoutManager2) {
                return ((LayoutManager2)this.lm).maximumLayoutSize(container);
            }
            return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.lm.minimumLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.lm.preferredLayoutSize(container);
        }

        public void addLayoutComponent(Component component, Object object) {
        }
    }

    public static class Separator
    extends JSeparator {
        private Dimension separatorSize;

        public Separator() {
            this(null);
        }

        public Dimension getMaximumSize() {
            if (this.separatorSize != null) {
                return this.separatorSize.getSize();
            }
            return super.getMaximumSize();
        }

        public Dimension getMinimumSize() {
            if (this.separatorSize != null) {
                return this.separatorSize.getSize();
            }
            return super.getMinimumSize();
        }

        public Dimension getPreferredSize() {
            if (this.separatorSize != null) {
                return this.separatorSize.getSize();
            }
            return super.getPreferredSize();
        }

        public Dimension getSeparatorSize() {
            return this.separatorSize;
        }

        public Separator(Dimension dimension) {
            super(0);
            this.setSeparatorSize(dimension);
        }

        public void setSeparatorSize(Dimension dimension) {
            if (dimension != null) {
                this.separatorSize = dimension;
            } else {
                super.updateUI();
            }
            this.invalidate();
        }

        public String getUIClassID() {
            return "ToolBarSeparatorUI";
        }
    }
}

