/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.DecompData;
import sun.text.Normalizer;

public final class ComposedCharIter {
    public static final char DONE = '\uffff';
    private final int minDecomp;
    private final boolean hangul;
    private char curChar = '\u0000';
    private char nextChar = (char)65535;
    private static final char HANGUL_BASE = '\uac00';
    private static final char HANGUL_LIMIT = '\ud7a4';

    public char next() {
        if (this.nextChar == '\uffff') {
            this.findNextChar();
        }
        this.curChar = this.nextChar;
        this.nextChar = (char)65535;
        return this.curChar;
    }

    public ComposedCharIter() {
        this.minDecomp = 11177;
        this.hangul = false;
    }

    private void findNextChar() {
        if (this.curChar != '\uffff') {
            char c2 = this.curChar;
            while ((c2 = (char)(c2 + '\u0001')) < '\uffff') {
                int n2 = DecompData.offsets.elementAt(c2) & Short.MAX_VALUE;
                if (n2 <= this.minDecomp && (!this.hangul || c2 < '\uac00' || c2 >= '\ud7a4')) continue;
                this.nextChar = c2;
                break;
            }
        }
    }

    public boolean hasNext() {
        if (this.nextChar == '\uffff') {
            this.findNextChar();
        }
        return this.nextChar != '\uffff';
    }

    public ComposedCharIter(boolean bl2, int n2) {
        this.minDecomp = bl2 ? 0 : 11177;
        this.hangul = (n2 & 1) == 0;
    }

    public String decomposition() {
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = (char)(DecompData.offsets.elementAt(this.curChar) & Short.MAX_VALUE);
        if (c2 > this.minDecomp) {
            Normalizer.doAppend("\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf", c2, stringBuffer);
        } else if (this.hangul && this.curChar >= '\uac00' && this.curChar < '\ud7a4') {
            Normalizer.hangulToJamo(this.curChar, stringBuffer, this.minDecomp);
        } else {
            stringBuffer.append(this.curChar);
        }
        return stringBuffer.toString();
    }
}

