/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPaneAdjustable;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ScrollPanePeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import sun.awt.ScrollPaneWheelScroller;

public class ScrollPane
extends Container
implements Accessible {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    private int scrollbarDisplayPolicy;
    private ScrollPaneAdjustable vAdjustable;
    private ScrollPaneAdjustable hAdjustable;
    private static final String base = "scrollpane";
    private static int nameCounter;
    private static final boolean defaultWheelScroll = true;
    private boolean wheelScrollingEnabled = true;
    private static final long serialVersionUID = 7956609840827222915L;

    public int getHScrollbarHeight() {
        ScrollPanePeer scrollPanePeer;
        int n2 = 0;
        if (this.scrollbarDisplayPolicy != 2 && (scrollPanePeer = (ScrollPanePeer)this.peer) != null) {
            n2 = scrollPanePeer.getHScrollbarHeight();
        }
        return n2;
    }

    public int getScrollbarDisplayPolicy() {
        return this.scrollbarDisplayPolicy;
    }

    public int getVScrollbarWidth() {
        ScrollPanePeer scrollPanePeer;
        int n2 = 0;
        if (this.scrollbarDisplayPolicy != 2 && (scrollPanePeer = (ScrollPanePeer)this.peer) != null) {
            n2 = scrollPanePeer.getVScrollbarWidth();
        }
        return n2;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            ScrollPane.initIDs();
        }
        nameCounter = 0;
    }

    public ScrollPane() throws HeadlessException {
        this(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = 0;
            int n3 = 0;
            if (this.getComponentCount() > 0) {
                n2 = this.vAdjustable.getValue();
                n3 = this.hAdjustable.getValue();
                this.vAdjustable.setValue(0);
                this.hAdjustable.setValue(0);
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createScrollPane(this);
            }
            super.addNotify();
            if (this.getComponentCount() > 0) {
                this.vAdjustable.setValue(n2);
                this.hAdjustable.setValue(n3);
            }
            if (this.getComponentCount() > 0) {
                Component component = this.getComponent(0);
                if (component.peer instanceof LightweightPeer) {
                    this.remove(0);
                    Panel panel = new Panel();
                    panel.setLayout(new BorderLayout());
                    panel.add(component);
                    this.add(panel);
                }
            }
        }
    }

    public void doLayout() {
        this.layout();
    }

    private static native void initIDs();

    public void layout() {
        if (this.ncomponents > 0) {
            Component component = this.getComponent(0);
            Point point = this.getScrollPosition();
            Dimension dimension = this.calculateChildSize();
            Dimension dimension2 = this.getViewportSize();
            Insets insets = this.getInsets();
            component.reshape(insets.left - point.x, insets.top - point.y, dimension.width, dimension.height);
            ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.peer;
            if (scrollPanePeer != null) {
                scrollPanePeer.childResized(dimension.width, dimension.height);
            }
            dimension2 = this.getViewportSize();
            this.hAdjustable.setSpan(0, dimension.width, dimension2.width);
            this.vAdjustable.setSpan(0, dimension.height, dimension2.height);
        }
    }

    public boolean isWheelScrollingEnabled() {
        return this.wheelScrollingEnabled;
    }

    public ScrollPane(int n2) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.layoutMgr = null;
        this.width = 100;
        this.height = 100;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                this.scrollbarDisplayPolicy = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal scrollbar display policy");
            }
        }
        this.vAdjustable = new ScrollPaneAdjustable(this, new PeerFixer(this, this), 1);
        this.hAdjustable = new ScrollPaneAdjustable(this, new PeerFixer(this, this), 0);
        this.setWheelScrollingEnabled(true);
    }

    protected boolean eventTypeEnabled(int n2) {
        if (n2 == 507 && this.isWheelScrollingEnabled()) {
            return true;
        }
        return super.eventTypeEnabled(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScrollPosition(int n2, int n3) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.ncomponents <= 0) {
                throw new NullPointerException("child is null");
            }
            this.hAdjustable.setValue(n2);
            this.vAdjustable.setValue(n3);
        }
    }

    public void setWheelScrollingEnabled(boolean bl2) {
        this.wheelScrollingEnabled = bl2;
    }

    public Adjustable getHAdjustable() {
        return this.hAdjustable;
    }

    public Adjustable getVAdjustable() {
        return this.vAdjustable;
    }

    Dimension calculateChildSize() {
        boolean bl2;
        boolean bl3;
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n2 = dimension.width - insets.left * 2;
        int n3 = dimension.height - insets.top * 2;
        Component component = this.getComponent(0);
        Dimension dimension2 = new Dimension(component.getPreferredSize());
        if (this.scrollbarDisplayPolicy == 0) {
            bl3 = dimension2.height > n3;
            bl2 = dimension2.width > n2;
        } else if (this.scrollbarDisplayPolicy == 1) {
            bl2 = true;
            bl3 = true;
        } else {
            bl2 = false;
            bl3 = false;
        }
        int n4 = this.getVScrollbarWidth();
        int n5 = this.getHScrollbarHeight();
        if (bl3) {
            n2 -= n4;
        }
        if (bl2) {
            n3 -= n5;
        }
        if (dimension2.width < n2) {
            dimension2.width = n2;
        }
        if (dimension2.height < n3) {
            dimension2.height = n3;
        }
        return dimension2;
    }

    public Dimension getViewportSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.width - insets.right - insets.left, this.height - insets.top - insets.bottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printComponents(Graphics graphics) {
        if (this.ncomponents > 0) {
            Component component = this.component[0];
            Point point = component.getLocation();
            Dimension dimension = this.getViewportSize();
            Insets insets = this.getInsets();
            Graphics graphics2 = graphics.create();
            try {
                graphics2.clipRect(insets.left, insets.top, dimension.width, dimension.height);
                graphics2.translate(point.x, point.y);
                component.printAll(graphics2);
            }
            finally {
                graphics2.dispose();
            }
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
        throw new AWTError("ScrollPane controls layout");
    }

    public Point getScrollPosition() {
        if (this.ncomponents <= 0) {
            throw new NullPointerException("child is null");
        }
        return new Point(this.hAdjustable.getValue(), this.vAdjustable.getValue());
    }

    public void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    void autoProcessMouseWheel(MouseWheelEvent mouseWheelEvent) {
        this.processMouseWheelEvent(mouseWheelEvent);
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        if (this.isWheelScrollingEnabled()) {
            ScrollPaneWheelScroller.handleWheelScrolling(this, mouseWheelEvent);
            mouseWheelEvent.consume();
        }
        super.processMouseWheelEvent(mouseWheelEvent);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        GraphicsEnvironment.checkHeadless();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.scrollbarDisplayPolicy = getField.get("scrollbarDisplayPolicy", 0);
        this.hAdjustable = (ScrollPaneAdjustable)getField.get("hAdjustable", null);
        this.vAdjustable = (ScrollPaneAdjustable)getField.get("vAdjustable", null);
        this.wheelScrollingEnabled = getField.get("wheelScrollingEnabled", true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    public String paramString() {
        String string;
        switch (this.scrollbarDisplayPolicy) {
            case 0: {
                string = "as-needed";
                break;
            }
            case 1: {
                string = "always";
                break;
            }
            case 2: {
                string = "never";
                break;
            }
            default: {
                string = "invalid display policy";
            }
        }
        Point point = this.ncomponents > 0 ? this.getScrollPosition() : new Point(0, 0);
        Insets insets = this.getInsets();
        return super.paramString() + ",ScrollPosition=(" + point.x + "," + point.y + ")" + ",Insets=(" + insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right + ")" + ",ScrollbarDisplayPolicy=" + string + ",wheelScrollingEnabled=" + this.isWheelScrollingEnabled();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTScrollPane(this);
        }
        return this.accessibleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addImpl(Component component, Object object, int n2) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            if (this.getComponentCount() > 0) {
                this.remove(0);
            }
            if (n2 > 0) {
                throw new IllegalArgumentException("position greater than 0");
            }
            super.addImpl(component, object, n2);
        }
    }

    protected class AccessibleAWTScrollPane
    extends Container.AccessibleAWTContainer {
        private final ScrollPane this$0;

        protected AccessibleAWTScrollPane(ScrollPane scrollPane) {
            this.this$0 = scrollPane;
            super(scrollPane);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_PANE;
        }
    }

    class PeerFixer
    implements AdjustmentListener,
    Serializable {
        private ScrollPane scroller;
        private final ScrollPane this$0;

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Adjustable adjustable = adjustmentEvent.getAdjustable();
            int n2 = adjustmentEvent.getValue();
            ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.scroller.peer;
            if (scrollPanePeer != null) {
                scrollPanePeer.setValue(adjustable, n2);
            }
            Component component = this.scroller.getComponent(0);
            switch (adjustable.getOrientation()) {
                case 1: {
                    component.move(component.getLocation().x, -n2);
                    break;
                }
                case 0: {
                    component.move(-n2, component.getLocation().y);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal adjustable orientation");
                }
            }
        }

        PeerFixer(ScrollPane scrollPane, ScrollPane scrollPane2) {
            this.this$0 = scrollPane;
            this.scroller = scrollPane2;
        }
    }
}

