/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;

public class LogStream
extends PrintStream {
    private static Hashtable known = new Hashtable(5);
    private static PrintStream defaultStream = System.err;
    private String name;
    private OutputStream logOut;
    private OutputStreamWriter logWriter;
    private StringBuffer buffer = new StringBuffer();
    private ByteArrayOutputStream bufOut = (ByteArrayOutputStream)this.out;
    public static final int SILENT = 0;
    public static final int BRIEF = 10;
    public static final int VERBOSE = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n2) {
        if (n2 == 10) {
            LogStream logStream = this;
            synchronized (logStream) {
                OutputStream outputStream = this.logOut;
                synchronized (outputStream) {
                    this.buffer.setLength(0);
                    this.buffer.append(new Date().toString());
                    this.buffer.append(':');
                    this.buffer.append(this.name);
                    this.buffer.append(':');
                    this.buffer.append(Thread.currentThread().getName());
                    this.buffer.append(':');
                    try {
                        this.logWriter.write(this.buffer.toString());
                        this.logWriter.flush();
                        this.bufOut.writeTo(this.logOut);
                        this.logOut.write(n2);
                        this.logOut.flush();
                    }
                    catch (IOException iOException) {
                        this.setError();
                    }
                    finally {
                        this.bufOut.reset();
                    }
                }
            }
        }
        super.write(n2);
    }

    public void write(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write(byArray[n2 + i2]);
        }
    }

    public synchronized OutputStream getOutputStream() {
        return this.logOut;
    }

    public synchronized void setOutputStream(OutputStream outputStream) {
        this.logOut = outputStream;
        this.logWriter = new OutputStreamWriter(this.logOut);
    }

    public static synchronized PrintStream getDefaultStream() {
        return defaultStream;
    }

    public static synchronized void setDefaultStream(PrintStream printStream) {
        defaultStream = printStream;
    }

    public String toString() {
        return this.name;
    }

    public static int parseLevel(String string) {
        if (string == null || string.length() < 1) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.length() < 1) {
                return -1;
            }
            if ("SILENT".startsWith(string.toUpperCase())) {
                return 0;
            }
            if ("BRIEF".startsWith(string.toUpperCase())) {
                return 10;
            }
            if ("VERBOSE".startsWith(string.toUpperCase())) {
                return 20;
            }
            return -1;
        }
    }

    private LogStream(String string, OutputStream outputStream) {
        super(new ByteArrayOutputStream());
        this.name = string;
        this.setOutputStream(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogStream log(String string) {
        LogStream logStream;
        Hashtable hashtable = known;
        synchronized (hashtable) {
            logStream = (LogStream)known.get(string);
            if (logStream == null) {
                logStream = new LogStream(string, defaultStream);
            }
            known.put(string, logStream);
        }
        return logStream;
    }
}

