/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class SimpleAttributeSet
implements MutableAttributeSet,
Serializable,
Cloneable {
    public static final AttributeSet EMPTY = new EmptyAttributeSet();
    private transient Hashtable table = new Hashtable(3);
    private static Enumeration emptyEnumeration;

    public int getAttributeCount() {
        return this.table.size();
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public SimpleAttributeSet() {
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.table = new Hashtable(3);
        StyleContext.readAttributeSet(objectInputStream, this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        StyleContext.writeAttributeSet(objectOutputStream, this);
    }

    public Object clone() {
        SimpleAttributeSet simpleAttributeSet;
        try {
            simpleAttributeSet = (SimpleAttributeSet)super.clone();
            simpleAttributeSet.table = (Hashtable)this.table.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            simpleAttributeSet = null;
        }
        return simpleAttributeSet;
    }

    public void removeAttribute(Object object) {
        this.table.remove(object);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AttributeSet) {
            AttributeSet attributeSet = (AttributeSet)object;
            return this.isEqual(attributeSet);
        }
        return false;
    }

    public boolean isDefined(Object object) {
        return this.table.containsKey(object);
    }

    public String toString() {
        String string = "";
        Enumeration enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Object object2 = this.getAttribute(object);
            if (object2 instanceof AttributeSet) {
                string = string + object + "=**AttributeSet** ";
                continue;
            }
            string = string + object + "=" + object2 + " ";
        }
        return string;
    }

    static Enumeration access$000() {
        return SimpleAttributeSet.getEmptyEnumeration();
    }

    public Enumeration getAttributeNames() {
        return this.table.keys();
    }

    private static Enumeration getEmptyEnumeration() {
        if (emptyEnumeration == null) {
            emptyEnumeration = new Enumeration(){

                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    throw new NoSuchElementException("No more elements");
                }
            };
        }
        return emptyEnumeration;
    }

    public void removeAttributes(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.removeAttribute(enumeration.nextElement());
        }
    }

    private SimpleAttributeSet(Hashtable hashtable) {
        this.table = hashtable;
    }

    public AttributeSet copyAttributes() {
        return (AttributeSet)this.clone();
    }

    public AttributeSet getResolveParent() {
        return (AttributeSet)this.table.get(StyleConstants.ResolveAttribute);
    }

    public SimpleAttributeSet(AttributeSet attributeSet) {
        this.addAttributes(attributeSet);
    }

    public void addAttributes(AttributeSet attributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            this.addAttribute(object, attributeSet.getAttribute(object));
        }
    }

    public void removeAttributes(AttributeSet attributeSet) {
        if (attributeSet == this) {
            this.table.clear();
        } else {
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = attributeSet.getAttribute(object);
                if (!object2.equals(this.getAttribute(object))) continue;
                this.removeAttribute(object);
            }
        }
    }

    public void setResolveParent(AttributeSet attributeSet) {
        this.addAttribute(StyleConstants.ResolveAttribute, attributeSet);
    }

    public boolean containsAttributes(AttributeSet attributeSet) {
        boolean bl2 = true;
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (bl2 && enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            bl2 = attributeSet.getAttribute(object).equals(this.getAttribute(object));
        }
        return bl2;
    }

    public boolean isEqual(AttributeSet attributeSet) {
        return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
    }

    public Object getAttribute(Object object) {
        AttributeSet attributeSet;
        Object object2 = this.table.get(object);
        if (object2 == null && (attributeSet = this.getResolveParent()) != null) {
            object2 = attributeSet.getAttribute(object);
        }
        return object2;
    }

    public void addAttribute(Object object, Object object2) {
        this.table.put(object, object2);
    }

    public boolean containsAttribute(Object object, Object object2) {
        return object2.equals(this.getAttribute(object));
    }

    static class EmptyAttributeSet
    implements AttributeSet,
    Serializable {
        public int getAttributeCount() {
            return 0;
        }

        public int hashCode() {
            return 0;
        }

        EmptyAttributeSet() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object instanceof AttributeSet && ((AttributeSet)object).getAttributeCount() == 0;
        }

        public boolean isDefined(Object object) {
            return false;
        }

        public Enumeration getAttributeNames() {
            return SimpleAttributeSet.access$000();
        }

        public AttributeSet copyAttributes() {
            return this;
        }

        public AttributeSet getResolveParent() {
            return null;
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            return attributeSet.getAttributeCount() == 0;
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return attributeSet.getAttributeCount() == 0;
        }

        public Object getAttribute(Object object) {
            return null;
        }

        public boolean containsAttribute(Object object, Object object2) {
            return false;
        }
    }
}

