/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.SeparatorUI;

public class JSeparator
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "SeparatorUI";
    private int orientation = 0;

    public int getOrientation() {
        return this.orientation;
    }

    public JSeparator() {
        this(0);
    }

    public void updateUI() {
        this.setUI((SeparatorUI)UIManager.getUI(this));
    }

    public JSeparator(int n2) {
        this.checkOrientation(n2);
        this.orientation = n2;
        this.setFocusable(false);
        this.updateUI();
    }

    private void checkOrientation(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public void setOrientation(int n2) {
        if (this.orientation == n2) {
            return;
        }
        int n3 = this.orientation;
        this.checkOrientation(n2);
        this.orientation = n2;
        this.firePropertyChange("orientation", n3, n2);
        this.revalidate();
        this.repaint();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        return super.paramString() + ",orientation=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSeparator(this);
        }
        return this.accessibleContext;
    }

    public SeparatorUI getUI() {
        return (SeparatorUI)this.ui;
    }

    public void setUI(SeparatorUI separatorUI) {
        super.setUI(separatorUI);
    }

    protected class AccessibleJSeparator
    extends JComponent.AccessibleJComponent {
        private final JSeparator this$0;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SEPARATOR;
        }

        protected AccessibleJSeparator(JSeparator jSeparator) {
            this.this$0 = jSeparator;
            super(jSeparator);
        }
    }
}

