/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalProgressBarUI
extends BasicProgressBarUI {
    private Rectangle innards;
    private Rectangle box;

    public void paintDeterminate(Graphics graphics, JComponent jComponent) {
        super.paintDeterminate(graphics, jComponent);
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        if (this.progressBar.isBorderPainted()) {
            Insets insets = this.progressBar.getInsets();
            int n2 = this.progressBar.getWidth() - (insets.left + insets.right);
            int n3 = this.progressBar.getHeight() - (insets.top + insets.bottom);
            int n4 = this.getAmountFull(insets, n2, n3);
            boolean bl2 = MetalUtils.isLeftToRight(jComponent);
            int n5 = insets.left;
            int n6 = insets.top;
            int n7 = insets.left + n2 - 1;
            int n8 = insets.top + n3 - 1;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(1.0f));
            if (this.progressBar.getOrientation() == 0) {
                graphics2D.setColor(MetalLookAndFeel.getControlShadow());
                graphics2D.drawLine(n5, n6, n7, n6);
                if (n4 > 0) {
                    graphics2D.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                    if (bl2) {
                        graphics2D.drawLine(n5, n6, n5 + n4 - 1, n6);
                    } else {
                        graphics2D.drawLine(n7, n6, n7 - n4 + 1, n6);
                        if (this.progressBar.getPercentComplete() != 1.0) {
                            graphics2D.setColor(MetalLookAndFeel.getControlShadow());
                        }
                    }
                }
                graphics2D.drawLine(n5, n6, n5, n8);
            } else {
                graphics2D.setColor(MetalLookAndFeel.getControlShadow());
                graphics2D.drawLine(n5, n6, n5, n8);
                if (n4 > 0) {
                    graphics2D.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                    graphics2D.drawLine(n5, n8, n5, n8 - n4 + 1);
                }
                graphics2D.setColor(MetalLookAndFeel.getControlShadow());
                if (this.progressBar.getPercentComplete() == 1.0) {
                    graphics2D.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                }
                graphics2D.drawLine(n5, n6, n7, n6);
            }
        }
    }

    public void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        super.paintIndeterminate(graphics, jComponent);
        if (!this.progressBar.isBorderPainted() || !(graphics instanceof Graphics2D)) {
            return;
        }
        Insets insets = this.progressBar.getInsets();
        int n2 = this.progressBar.getWidth() - (insets.left + insets.right);
        int n3 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int n4 = this.getAmountFull(insets, n2, n3);
        boolean bl2 = MetalUtils.isLeftToRight(jComponent);
        Rectangle rectangle = null;
        rectangle = this.getBox(rectangle);
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = insets.left + n2 - 1;
        int n8 = insets.top + n3 - 1;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f));
        if (this.progressBar.getOrientation() == 0) {
            graphics2D.setColor(MetalLookAndFeel.getControlShadow());
            graphics2D.drawLine(n5, n6, n7, n6);
            graphics2D.drawLine(n5, n6, n5, n8);
            graphics2D.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics2D.drawLine(rectangle.x, n6, rectangle.x + rectangle.width - 1, n6);
        } else {
            graphics2D.setColor(MetalLookAndFeel.getControlShadow());
            graphics2D.drawLine(n5, n6, n5, n8);
            graphics2D.drawLine(n5, n6, n7, n6);
            graphics2D.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics2D.drawLine(n5, rectangle.y, n5, rectangle.y + rectangle.height - 1);
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalProgressBarUI();
    }
}

