/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.PrintWriter;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnection;
import sun.jdbc.odbc.JdbcOdbcDriverInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcTracer;
import sun.jdbc.odbc.ee.ConnectionHandler;
import sun.security.action.GetPropertyAction;

public class JdbcOdbcDriver
extends JdbcOdbcObject
implements JdbcOdbcDriverInterface {
    protected static JdbcOdbc OdbcApi;
    protected static long hEnv;
    protected static long hDbc;
    protected static Hashtable connectionList;
    protected int iTimeOut;
    protected static String nativePrefix;
    protected PrintWriter outWriter;
    protected JdbcOdbcTracer tracer = new JdbcOdbcTracer();

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 1;
    }

    public int getTimeOut() {
        return this.iTimeOut;
    }

    static {
        block3: {
            JdbcOdbcTracer jdbcOdbcTracer = new JdbcOdbcTracer();
            if (jdbcOdbcTracer.isTracing()) {
                jdbcOdbcTracer.trace("JdbcOdbcDriver class loaded");
            }
            JdbcOdbcDriver jdbcOdbcDriver = new JdbcOdbcDriver();
            try {
                DriverManager.registerDriver(jdbcOdbcDriver);
            }
            catch (SQLException sQLException) {
                if (!jdbcOdbcTracer.isTracing()) break block3;
                jdbcOdbcTracer.trace("Unable to register driver");
            }
        }
    }

    public JdbcOdbcDriver() {
        if (connectionList == null) {
            connectionList = new Hashtable();
        }
        nativePrefix = "";
    }

    protected synchronized void finalize() {
        if (OdbcApi.getTracer().isTracing()) {
            OdbcApi.getTracer().trace("Driver.finalize");
        }
        try {
            if (hDbc != 0L) {
                this.disconnect(hDbc);
                this.closeConnection(hDbc);
                hDbc = 0L;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private boolean initialize() throws SQLException {
        boolean bl2 = true;
        if (OdbcApi == null) {
            try {
                OdbcApi = new JdbcOdbc(this.tracer, nativePrefix);
                this.tracer = OdbcApi.getTracer();
                JdbcOdbcDriver.OdbcApi.charSet = (String)AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
            }
            catch (Exception exception) {
                if (OdbcApi.getTracer().isTracing()) {
                    OdbcApi.getTracer().trace("Unable to load JdbcOdbc library");
                }
                bl2 = false;
            }
        }
        if (this.getWriter() != null) {
            OdbcApi.getTracer().setWriter(this.getWriter());
        }
        if (hEnv == 0L) {
            try {
                hEnv = OdbcApi.SQLAllocEnv();
            }
            catch (Exception exception) {
                if (OdbcApi.getTracer().isTracing()) {
                    OdbcApi.getTracer().trace("Unable to allocate environment");
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private boolean trusted() {
        SecurityManager securityManager;
        boolean bl2 = false;
        if (this.tracer.isTracing()) {
            this.tracer.trace("JDBC to ODBC Bridge: Checking security");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            try {
                String string = (String)AccessController.doPrivileged(new GetPropertyAction("browser"));
                if (string != null && string.equalsIgnoreCase("Netscape Navigator")) {
                    nativePrefix = "Netscape_";
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                securityManager.checkWrite("JdbcOdbcSecurityCheck");
                bl2 = true;
            }
            catch (SecurityException securityException) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("Security check failed: " + securityException.getMessage());
                }
                bl2 = false;
            }
        } else {
            if (this.tracer.isTracing()) {
                this.tracer.trace("No SecurityManager present, assuming trusted application/applet");
            }
            bl2 = true;
        }
        bl2 = true;
        return bl2;
    }

    public void setTimeOut(int n2) {
        this.iTimeOut = n2;
    }

    public long allocConnection(long l2) throws SQLException {
        long l3 = 0L;
        l3 = OdbcApi.SQLAllocConnect(l2);
        connectionList.put(new Long(l3), new Long(l2));
        return l3;
    }

    public void closeConnection(long l2) throws SQLException {
        OdbcApi.SQLFreeConnect(l2);
        Long l3 = (Long)connectionList.remove(new Long(l2));
        if (connectionList.size() == 0 && hEnv != 0L) {
            OdbcApi.SQLFreeEnv(hEnv);
            hEnv = 0L;
        }
    }

    public void disconnect(long l2) throws SQLException {
        OdbcApi.SQLDisconnect(l2);
    }

    public PrintWriter getWriter() {
        return this.outWriter;
    }

    public void setWriter(PrintWriter printWriter) {
        this.outWriter = printWriter;
        this.tracer.setWriter(this.outWriter);
    }

    public boolean acceptsURL(String string) throws SQLException {
        boolean bl2 = false;
        if (this.knownURL(string) && this.trusted()) {
            bl2 = true;
        }
        return bl2;
    }

    private boolean knownURL(String string) {
        String string2 = JdbcOdbcDriver.getProtocol(string);
        if (!string2.equalsIgnoreCase("jdbc")) {
            return false;
        }
        string2 = JdbcOdbcDriver.getSubProtocol(string);
        return string2.equalsIgnoreCase("odbc");
    }

    public static String getProtocol(String string) {
        String string2 = "";
        int n2 = string.indexOf(58);
        if (n2 >= 0) {
            string2 = string.substring(0, n2);
        }
        return string2;
    }

    public static String getSubName(String string) {
        int n2;
        String string2 = "";
        int n3 = string.indexOf(58);
        if (n3 >= 0 && (n2 = string.indexOf(58, n3 + 1)) >= 0) {
            string2 = string.substring(n2 + 1);
        }
        return string2;
    }

    public static String getSubProtocol(String string) {
        int n2;
        String string2 = "";
        int n3 = string.indexOf(58);
        if (n3 >= 0 && (n2 = string.indexOf(58, n3 + 1)) >= 0) {
            string2 = string.substring(n3 + 1, n2);
        }
        return string2;
    }

    protected static String[] listToArray(String string) {
        String string2;
        String[] stringArray = null;
        Hashtable hashtable = new Hashtable();
        int n2 = 0;
        int n3 = 1;
        int n4 = 1;
        int n5 = string.length();
        if (!string.startsWith("{")) {
            return null;
        }
        if (!string.endsWith("}")) {
            return null;
        }
        while (n3 < n5) {
            n4 = string.indexOf(",", n3);
            if (n4 < 0) {
                n4 = n5 - 1;
            }
            string2 = string.substring(n3, n4);
            hashtable.put(new Integer(n2), string2);
            ++n2;
            n3 = n4 + 1;
        }
        stringArray = new String[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            stringArray[n3] = string2 = (String)hashtable.get(new Integer(n3));
        }
        return stringArray;
    }

    protected static String makeConnectionString(Properties properties) {
        String string = "";
        Enumeration enumeration = properties.propertyNames();
        JdbcOdbcDriver.OdbcApi.charSet = properties.getProperty("charSet", (String)AccessController.doPrivileged(new GetPropertyAction("file.encoding")));
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (string2.equalsIgnoreCase("user")) {
                string2 = "UID";
            }
            if (string2.equalsIgnoreCase("password")) {
                string2 = "PWD";
            }
            if (string3 == null) continue;
            string = string + ";" + string2 + "=" + string3;
        }
        return string;
    }

    public Hashtable getAttributeProperties(String string) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Hashtable hashtable = new Hashtable();
        int n5 = string.length();
        while (n2 < n5) {
            boolean bl2 = true;
            String string2 = null;
            String string3 = null;
            String[] stringArray = null;
            String string4 = null;
            n3 = string.indexOf(";", n2);
            if (n3 < 0) {
                n3 = n5;
            }
            String string5 = string.substring(n2, n3);
            int n6 = 0;
            int n7 = string5.indexOf(":", 0);
            int n8 = string5.indexOf("=", 0);
            if (string5.startsWith("*")) {
                bl2 = false;
                ++n6;
            }
            if (n7 > 0) {
                string2 = string5.substring(n6, n7);
            }
            if (n7 > 0 && n8 > 0) {
                string3 = string5.substring(n7 + 1, n8);
            }
            if (n8 > 0 && (string4 = string5.substring(n8 + 1)).equals("?")) {
                string4 = null;
            }
            if (string4 != null && string4.startsWith("{")) {
                stringArray = JdbcOdbcDriver.listToArray(string4);
                string4 = null;
            }
            DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, string4);
            driverPropertyInfo.description = string3;
            driverPropertyInfo.required = bl2;
            driverPropertyInfo.choices = stringArray;
            hashtable.put(new Integer(n4), driverPropertyInfo);
            ++n4;
            n2 = n3 + 1;
        }
        return hashtable;
    }

    public String getConnectionAttributes(String string, String string2) throws SQLException {
        String string3;
        String string4 = "DSN=" + string + string2;
        if (hDbc == 0L) {
            hDbc = this.allocConnection(hEnv);
        }
        if ((string3 = OdbcApi.SQLBrowseConnect(hDbc, string4)) == null) {
            string3 = "";
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        return string3;
    }

    public synchronized Connection EEConnect(String string, Properties properties) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Driver.connect (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (hDbc != 0L) {
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        if (!this.initialize()) {
            return null;
        }
        ConnectionHandler connectionHandler = new ConnectionHandler(OdbcApi, hEnv, this);
        int n2 = this.getTimeOut() > 0 ? this.getTimeOut() : DriverManager.getLoginTimeout();
        connectionHandler.initialize(JdbcOdbcDriver.getSubName(string), properties, n2);
        connectionHandler.setURL(string);
        return connectionHandler;
    }

    public synchronized Connection connect(String string, Properties properties) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Driver.connect (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (hDbc != 0L) {
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        if (!this.initialize()) {
            return null;
        }
        JdbcOdbcConnection jdbcOdbcConnection = new JdbcOdbcConnection(OdbcApi, hEnv, this);
        int n2 = this.getTimeOut() > 0 ? this.getTimeOut() : DriverManager.getLoginTimeout();
        jdbcOdbcConnection.initialize(JdbcOdbcDriver.getSubName(string), properties, n2);
        jdbcOdbcConnection.setURL(string);
        return jdbcOdbcConnection;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Driver.getPropertyInfo (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (!this.initialize()) {
            return null;
        }
        String string2 = JdbcOdbcDriver.makeConnectionString(properties);
        String string3 = "";
        string3 = this.getConnectionAttributes(JdbcOdbcDriver.getSubName(string), string2);
        Hashtable hashtable = this.getAttributeProperties(string3);
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[hashtable.size()];
        for (int i2 = 0; i2 < hashtable.size(); ++i2) {
            driverPropertyInfoArray[i2] = (DriverPropertyInfo)hashtable.get(new Integer(i2));
        }
        return driverPropertyInfoArray;
    }
}

