/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.ComboPopup;
import sun.awt.AppContext;

public class BasicComboBoxUI
extends ComboBoxUI {
    protected JComboBox comboBox;
    protected boolean hasFocus = false;
    private boolean isTableCellEditor = false;
    private static final String IS_TABLE_CELL_EDITOR = "JComboBox.isTableCellEditor";
    protected JList listBox;
    protected CellRendererPane currentValuePane = new CellRendererPane();
    protected ComboPopup popup;
    protected Component editor;
    protected JButton arrowButton;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected PropertyChangeListener propertyChangeListener;
    private FocusListener editorFocusListener;
    private ActionListener editorActionListener;
    protected ItemListener itemListener;
    protected MouseListener popupMouseListener;
    protected MouseMotionListener popupMouseMotionListener;
    protected KeyListener popupKeyListener;
    protected ListDataListener listDataListener;
    protected boolean isMinimumSizeDirty = true;
    protected Dimension cachedMinimumSize = new Dimension(0, 0);
    private boolean isDisplaySizeDirty = true;
    private Dimension cachedDisplaySize = new Dimension(0, 0);
    private static final Object COMBO_UI_LIST_CELL_RENDERER_KEY = new StringBuffer("DefaultListCellRendererKey");
    static Action homeAction = new NavigationalAction(36);
    static Action endAction = new NavigationalAction(35);
    static Action pgUpAction = new NavigationalAction(33);
    static Action pgDownAction = new NavigationalAction(34);

    public void addEditor() {
        this.removeEditor();
        this.editor = this.comboBox.getEditor().getEditorComponent();
        if (this.editor != null) {
            this.configureEditor();
            this.comboBox.add(this.editor);
        }
    }

    public void configureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.setEnabled(this.comboBox.isEnabled());
            this.arrowButton.setRequestFocusEnabled(false);
            this.arrowButton.addMouseListener(this.popup.getMouseListener());
            this.arrowButton.addMouseMotionListener(this.popup.getMouseMotionListener());
            this.arrowButton.resetKeyboardActions();
        }
    }

    protected void configureEditor() {
        AccessibleContext accessibleContext;
        this.editor.setEnabled(this.comboBox.isEnabled());
        this.editor.setFont(this.comboBox.getFont());
        if (this.editor instanceof Accessible && (accessibleContext = ((Accessible)((Object)this.editor)).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleParent(this.comboBox);
        }
        if (this.focusListener != null) {
            this.editor.addFocusListener(this.focusListener);
        }
        if (this.editorFocusListener == null) {
            this.editorFocusListener = new EditorFocusListener(this);
        }
        this.editor.addFocusListener(this.editorFocusListener);
        if (this.editorActionListener == null) {
            this.editorActionListener = new EditorActionListener(this);
        }
        this.comboBox.getEditor().addActionListener(this.editorActionListener);
        this.comboBox.configureEditor(this.comboBox.getEditor(), this.comboBox.getSelectedItem());
    }

    protected void installComponents() {
        this.arrowButton = this.createArrowButton();
        this.comboBox.add(this.arrowButton);
        if (this.arrowButton != null) {
            this.configureArrowButton();
        }
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        LookAndFeel.installBorder(this.comboBox, "ComboBox.border");
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        if (actionMap != null) {
            SwingUtilities.replaceUIActionMap(this.comboBox, actionMap);
        }
    }

    protected void installListeners() {
        this.itemListener = this.createItemListener();
        if (this.itemListener != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.comboBox.addKeyListener(this.keyListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.comboBox.addFocusListener(this.focusListener);
        }
        if ((this.popupMouseListener = this.popup.getMouseListener()) != null) {
            this.comboBox.addMouseListener(this.popupMouseListener);
        }
        if ((this.popupMouseMotionListener = this.popup.getMouseMotionListener()) != null) {
            this.comboBox.addMouseMotionListener(this.popupMouseMotionListener);
        }
        if ((this.popupKeyListener = this.popup.getKeyListener()) != null) {
            this.comboBox.addKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && (this.listDataListener = this.createListDataListener()) != null) {
            this.comboBox.getModel().addListDataListener(this.listDataListener);
        }
    }

    public void removeEditor() {
        if (this.editor != null) {
            this.unconfigureEditor();
            this.comboBox.remove(this.editor);
            this.editor = null;
        }
    }

    void repaintCurrentValue() {
        Rectangle rectangle = this.rectangleForCurrentValue();
        this.comboBox.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void selectNextPossibleValue() {
        int n2 = this.isTableCellEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (n2 < this.comboBox.getModel().getSize() - 1) {
            if (this.isTableCellEditor) {
                this.listBox.setSelectedIndex(n2 + 1);
                this.listBox.ensureIndexIsVisible(n2 + 1);
            } else {
                this.comboBox.setSelectedIndex(n2 + 1);
            }
            this.comboBox.repaint();
        }
    }

    protected void selectPreviousPossibleValue() {
        int n2 = this.isTableCellEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (n2 > 0) {
            if (this.isTableCellEditor) {
                this.listBox.setSelectedIndex(n2 - 1);
                this.listBox.ensureIndexIsVisible(n2 - 1);
            } else {
                this.comboBox.setSelectedIndex(n2 - 1);
            }
            this.comboBox.repaint();
        }
    }

    protected void toggleOpenClose() {
        this.setPopupVisible(this.comboBox, !this.isPopupVisible(this.comboBox));
    }

    public void unconfigureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(this.popup.getMouseListener());
            this.arrowButton.removeMouseMotionListener(this.popup.getMouseMotionListener());
        }
    }

    protected void unconfigureEditor() {
        if (this.focusListener != null) {
            this.editor.removeFocusListener(this.focusListener);
        }
        if (this.editorFocusListener != null) {
            this.editor.removeFocusListener(this.editorFocusListener);
        }
        if (this.editorActionListener != null) {
            this.comboBox.getEditor().removeActionListener(this.editorActionListener);
        }
    }

    protected void uninstallComponents() {
        if (this.arrowButton != null) {
            this.unconfigureArrowButton();
        }
        if (this.editor != null) {
            this.unconfigureEditor();
        }
        this.comboBox.removeAll();
        this.arrowButton = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        LookAndFeel.uninstallBorder(this.comboBox);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, null);
        SwingUtilities.replaceUIActionMap(this.comboBox, null);
    }

    protected void uninstallListeners() {
        if (this.keyListener != null) {
            this.comboBox.removeKeyListener(this.keyListener);
        }
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.focusListener != null) {
            this.comboBox.removeFocusListener(this.focusListener);
        }
        if (this.popupMouseListener != null) {
            this.comboBox.removeMouseListener(this.popupMouseListener);
        }
        if (this.popupMouseMotionListener != null) {
            this.comboBox.removeMouseMotionListener(this.popupMouseMotionListener);
        }
        if (this.popupKeyListener != null) {
            this.comboBox.removeKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && this.listDataListener != null) {
            this.comboBox.getModel().removeListDataListener(this.listDataListener);
        }
    }

    private void updateToolTipTextForChildren() {
        Component[] componentArray = this.comboBox.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (!(componentArray[i2] instanceof JComponent)) continue;
            ((JComponent)componentArray[i2]).setToolTipText(this.comboBox.getToolTipText());
        }
    }

    boolean isTableCellEditor() {
        return this.isTableCellEditor;
    }

    protected boolean isNavigationKey(int n2) {
        return n2 == 38 || n2 == 40 || n2 == KeyStroke.getKeyStroke("KP_UP").getKeyCode() || n2 == KeyStroke.getKeyStroke("KP_DOWN").getKeyCode();
    }

    protected Dimension getDefaultSize() {
        Dimension dimension = this.getSizeForComponent(BasicComboBoxUI.getDefaultListCellRenderer().getListCellRendererComponent(this.listBox, " ", -1, false, false));
        return new Dimension(dimension.width, dimension.height);
    }

    protected Dimension getDisplaySize() {
        Object object;
        Object object2;
        if (!this.isDisplaySizeDirty) {
            return new Dimension(this.cachedDisplaySize);
        }
        Dimension dimension = new Dimension();
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (listCellRenderer == null) {
            listCellRenderer = new DefaultListCellRenderer();
        }
        if ((object2 = this.comboBox.getPrototypeDisplayValue()) != null) {
            dimension = this.getSizeForComponent(listCellRenderer.getListCellRendererComponent(this.listBox, object2, -1, false, false));
        } else {
            object = this.comboBox.getModel();
            int n2 = object.getSize();
            if (n2 > 0) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    Dimension dimension2 = this.getSizeForComponent(listCellRenderer.getListCellRendererComponent(this.listBox, object.getElementAt(i2), -1, false, false));
                    dimension.width = Math.max(dimension.width, dimension2.width);
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
            } else {
                dimension = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    dimension.width = 100;
                }
            }
        }
        if (this.comboBox.isEditable()) {
            object = this.editor.getPreferredSize();
            dimension.width = Math.max(dimension.width, ((Dimension)object).width);
            dimension.height = Math.max(dimension.height, ((Dimension)object).height);
        }
        this.cachedDisplaySize.setSize(dimension.width, dimension.height);
        this.isDisplaySizeDirty = false;
        return dimension;
    }

    protected Insets getInsets() {
        return this.comboBox.getInsets();
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager(this);
    }

    protected Rectangle rectangleForCurrentValue() {
        int n2 = this.comboBox.getWidth();
        int n3 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n4 = n3 - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            n4 = this.arrowButton.getWidth();
        }
        if (BasicGraphicsUtils.isLeftToRight(this.comboBox)) {
            return new Rectangle(insets.left, insets.top, n2 - (insets.left + insets.right + n4), n3 - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + n4, insets.top, n2 - (insets.left + insets.right + n4), n3 - (insets.top + insets.bottom));
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected ItemListener createItemListener() {
        return null;
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("hidePopup", new HidePopupAction(this));
        actionMapUIResource.put("pageDownPassThrough", pgDownAction);
        actionMapUIResource.put("pageUpPassThrough", pgUpAction);
        actionMapUIResource.put("homePassThrough", homeAction);
        actionMapUIResource.put("endPassThrough", endAction);
        actionMapUIResource.put("selectNext", new DownAction());
        actionMapUIResource.put("togglePopup", new AltAction());
        actionMapUIResource.put("spacePopup", new SpaceAction());
        actionMapUIResource.put("selectPrevious", new UpAction());
        actionMapUIResource.put("enterPressed", new EnterAction());
        return actionMapUIResource;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ComboBoxEditor createEditor() {
        return new BasicComboBoxEditor.UIResource();
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            return (InputMap)UIManager.get("ComboBox.ancestorInputMap");
        }
        return null;
    }

    protected JButton createArrowButton() {
        return new BasicArrowButton(5, UIManager.getColor("ComboBox.buttonBackground"), UIManager.getColor("ComboBox.buttonShadow"), UIManager.getColor("ComboBox.buttonDarkShadow"), UIManager.getColor("ComboBox.buttonHighlight"));
    }

    public boolean isFocusTraversable(JComboBox jComboBox) {
        return !this.comboBox.isEditable();
    }

    public boolean isPopupVisible(JComboBox jComboBox) {
        return this.popup.isVisible();
    }

    public void setPopupVisible(JComboBox jComboBox, boolean bl2) {
        if (bl2) {
            this.popup.show();
        } else {
            this.popup.hide();
        }
    }

    public int getAccessibleChildrenCount(JComponent jComponent) {
        if (this.comboBox.isEditable()) {
            return 2;
        }
        return 1;
    }

    public void installUI(JComponent jComponent) {
        this.isMinimumSizeDirty = true;
        this.comboBox = (JComboBox)jComponent;
        this.installDefaults();
        this.popup = this.createPopup();
        this.listBox = this.popup.getList();
        Boolean bl2 = (Boolean)jComponent.getClientProperty(IS_TABLE_CELL_EDITOR);
        if (bl2 != null) {
            boolean bl3 = this.isTableCellEditor = bl2.equals(Boolean.TRUE);
        }
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(this.createRenderer());
        }
        if (this.comboBox.getEditor() == null || this.comboBox.getEditor() instanceof UIResource) {
            this.comboBox.setEditor(this.createEditor());
        }
        this.installListeners();
        this.installComponents();
        this.comboBox.setLayout(this.createLayoutManager());
        this.comboBox.setRequestFocusEnabled(true);
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.setPopupVisible(this.comboBox, false);
        this.popup.uninstallingUI();
        this.uninstallKeyboardActions();
        this.comboBox.setLayout(null);
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(null);
        }
        if (this.comboBox.getEditor() == null || this.comboBox.getEditor() instanceof UIResource) {
            this.comboBox.setEditor(null);
        }
        this.keyListener = null;
        this.focusListener = null;
        this.listDataListener = null;
        this.propertyChangeListener = null;
        this.editorActionListener = null;
        this.editorFocusListener = null;
        this.popup = null;
        this.listBox = null;
        this.comboBox = null;
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer.UIResource();
    }

    private static ListCellRenderer getDefaultListCellRenderer() {
        ListCellRenderer listCellRenderer = (ListCellRenderer)AppContext.getAppContext().get(COMBO_UI_LIST_CELL_RENDERER_KEY);
        if (listCellRenderer == null) {
            listCellRenderer = new DefaultListCellRenderer();
            AppContext.getAppContext().put(COMBO_UI_LIST_CELL_RENDERER_KEY, new DefaultListCellRenderer());
        }
        return listCellRenderer;
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler(this);
    }

    static void access$100(BasicComboBoxUI basicComboBoxUI) {
        basicComboBoxUI.updateToolTipTextForChildren();
    }

    static boolean access$002(BasicComboBoxUI basicComboBoxUI, boolean bl2) {
        basicComboBoxUI.isDisplaySizeDirty = bl2;
        return basicComboBoxUI.isDisplaySizeDirty;
    }

    static boolean access$202(BasicComboBoxUI basicComboBoxUI, boolean bl2) {
        basicComboBoxUI.isTableCellEditor = bl2;
        return basicComboBoxUI.isTableCellEditor;
    }

    protected ComboPopup createPopup() {
        BasicComboPopup basicComboPopup = new BasicComboPopup(this.comboBox);
        basicComboPopup.getAccessibleContext().setAccessibleParent(this.comboBox);
        return basicComboPopup;
    }

    private Dimension getSizeForComponent(Component component) {
        this.currentValuePane.add(component);
        component.setFont(this.comboBox.getFont());
        Dimension dimension = component.getPreferredSize();
        this.currentValuePane.remove(component);
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = this.getDisplaySize();
        Insets insets = this.getInsets();
        dimension.height += insets.top + insets.bottom;
        int n2 = dimension.height - (insets.top + insets.bottom);
        dimension.width += insets.left + insets.right + n2;
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(dimension);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl2) {
        Component component;
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (bl2 && !this.isPopupVisible(this.comboBox)) {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setBackground(UIManager.getColor("ComboBox.background"));
        }
        component.setFont(this.comboBox.getFont());
        if (bl2 && !this.isPopupVisible(this.comboBox)) {
            component.setForeground(this.listBox.getSelectionForeground());
            component.setBackground(this.listBox.getSelectionBackground());
        } else if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean bl3 = false;
        if (component instanceof JPanel) {
            bl3 = true;
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl3);
    }

    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl2) {
        Color color = graphics.getColor();
        if (this.comboBox.isEnabled()) {
            graphics.setColor(UIManager.getColor("ComboBox.background"));
        } else {
            graphics.setColor(UIManager.getColor("ComboBox.disabledBackground"));
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
    }

    public Accessible getAccessibleChild(JComponent jComponent, int n2) {
        switch (n2) {
            case 0: {
                if (!(this.popup instanceof Accessible)) break;
                AccessibleContext accessibleContext = ((Accessible)((Object)this.popup)).getAccessibleContext();
                accessibleContext.setAccessibleParent(this.comboBox);
                return (Accessible)((Object)this.popup);
            }
            case 1: {
                if (!this.comboBox.isEditable() || !(this.editor instanceof Accessible)) break;
                AccessibleContext accessibleContext = ((Accessible)((Object)this.editor)).getAccessibleContext();
                accessibleContext.setAccessibleParent(this.comboBox);
                return (Accessible)((Object)this.editor);
            }
        }
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(graphics, rectangle, this.hasFocus);
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicComboBoxUI();
    }

    static class AltAction
    extends AbstractAction {
        AltAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled()) {
                BasicComboBoxUI basicComboBoxUI = (BasicComboBoxUI)jComboBox.getUI();
                if (basicComboBoxUI.isTableCellEditor()) {
                    jComboBox.setSelectedIndex(basicComboBoxUI.popup.getList().getSelectedIndex());
                } else {
                    jComboBox.setPopupVisible(!jComboBox.isPopupVisible());
                }
            }
        }
    }

    public class ComboBoxLayoutManager
    implements LayoutManager {
        private final BasicComboBoxUI this$0;

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            int n2 = jComboBox.getWidth();
            int n3 = jComboBox.getHeight();
            Insets insets = this.this$0.getInsets();
            int n4 = n3 - (insets.top + insets.bottom);
            if (this.this$0.arrowButton != null) {
                if (BasicGraphicsUtils.isLeftToRight(jComboBox)) {
                    this.this$0.arrowButton.setBounds(n2 - (insets.right + n4), insets.top, n4, n4);
                } else {
                    this.this$0.arrowButton.setBounds(insets.left, insets.top, n4, n4);
                }
            }
            if (this.this$0.editor != null) {
                Rectangle rectangle = this.this$0.rectangleForCurrentValue();
                this.this$0.editor.setBounds(rectangle);
            }
        }

        public ComboBoxLayoutManager(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            return container.getMinimumSize();
        }

        public Dimension preferredLayoutSize(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            return container.getPreferredSize();
        }
    }

    static class DownAction
    extends AbstractAction {
        DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled() && jComboBox.isShowing()) {
                if (jComboBox.isPopupVisible()) {
                    BasicComboBoxUI basicComboBoxUI = (BasicComboBoxUI)jComboBox.getUI();
                    basicComboBoxUI.selectNextPossibleValue();
                } else {
                    jComboBox.setPopupVisible(true);
                }
            }
        }
    }

    class EditorActionListener
    implements ActionListener {
        private final BasicComboBoxUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            Action action;
            ActionMap actionMap;
            Object object = this.this$0.comboBox.getEditor().getItem();
            if (object != null && object.equals(this.this$0.comboBox.getSelectedItem()) && (actionMap = this.this$0.comboBox.getActionMap()) != null && (action = actionMap.get("enterPressed")) != null) {
                action.actionPerformed(new ActionEvent(this.this$0.comboBox, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getModifiers()));
            }
        }

        EditorActionListener(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }
    }

    class EditorFocusListener
    extends FocusAdapter {
        private final BasicComboBoxUI this$0;

        public void focusLost(FocusEvent focusEvent) {
            ComboBoxEditor comboBoxEditor = this.this$0.comboBox.getEditor();
            Object object = comboBoxEditor.getItem();
            if (!focusEvent.isTemporary() && object != null && !object.equals(this.this$0.comboBox.getSelectedItem())) {
                this.this$0.comboBox.actionPerformed(new ActionEvent(comboBoxEditor, 0, "", EventQueue.getMostRecentEventTime(), 0));
            }
        }

        EditorFocusListener(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }
    }

    static class EnterAction
    extends AbstractAction {
        EnterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (!jComboBox.isEnabled()) {
                return;
            }
            BasicComboBoxUI basicComboBoxUI = (BasicComboBoxUI)jComboBox.getUI();
            if (basicComboBoxUI.isTableCellEditor()) {
                jComboBox.setSelectedIndex(basicComboBoxUI.popup.getList().getSelectedIndex());
            } else if (jComboBox.isPopupVisible()) {
                jComboBox.setPopupVisible(false);
            } else {
                JRootPane jRootPane = SwingUtilities.getRootPane(jComboBox);
                if (jRootPane != null) {
                    Action action;
                    Object object;
                    InputMap inputMap = jRootPane.getInputMap(2);
                    ActionMap actionMap = jRootPane.getActionMap();
                    if (inputMap != null && actionMap != null && (object = inputMap.get(KeyStroke.getKeyStroke(10, 0))) != null && (action = actionMap.get(object)) != null) {
                        action.actionPerformed(actionEvent);
                    }
                }
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        private final BasicComboBoxUI this$0;

        public void focusGained(FocusEvent focusEvent) {
            AccessibleContext accessibleContext;
            this.this$0.hasFocus = true;
            this.this$0.comboBox.repaint();
            if (this.this$0.comboBox.isEditable() && this.this$0.editor != null) {
                this.this$0.editor.requestFocus();
            }
            if (this.this$0.comboBox instanceof Accessible && (accessibleContext = this.this$0.comboBox.getAccessibleContext()) != null) {
                accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            AccessibleContext accessibleContext;
            this.this$0.hasFocus = false;
            if (!focusEvent.isTemporary() && this.this$0.comboBox.isLightWeightPopupEnabled()) {
                this.this$0.setPopupVisible(this.this$0.comboBox, false);
            }
            this.this$0.comboBox.repaint();
            if (this.this$0.comboBox instanceof Accessible && (accessibleContext = this.this$0.comboBox.getAccessibleContext()) != null) {
                accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }

        public FocusHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }
    }

    class HidePopupAction
    extends AbstractAction {
        private final BasicComboBoxUI this$0;

        public boolean isEnabled() {
            return this.this$0.comboBox.isPopupVisible();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled()) {
                jComboBox.firePopupMenuCanceled();
                jComboBox.setPopupVisible(false);
            }
        }

        HidePopupAction(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }
    }

    public class ItemHandler
    implements ItemListener {
        private final BasicComboBoxUI this$0;

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        public ItemHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        private final BasicComboBoxUI this$0;

        public void keyPressed(KeyEvent keyEvent) {
            if (this.this$0.comboBox.isEnabled() && !this.this$0.isNavigationKey(keyEvent.getKeyCode()) && this.isTypeAheadKey(keyEvent) && this.this$0.comboBox.selectWithKeyChar(keyEvent.getKeyChar())) {
                keyEvent.consume();
            }
        }

        boolean isTypeAheadKey(KeyEvent keyEvent) {
            return !keyEvent.isAltDown() && !keyEvent.isControlDown() && !keyEvent.isMetaDown();
        }

        public KeyHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        private final BasicComboBoxUI this$0;

        public void contentsChanged(ListDataEvent listDataEvent) {
            if (listDataEvent.getIndex0() != -1 || listDataEvent.getIndex1() != -1) {
                this.this$0.isMinimumSizeDirty = true;
                this.this$0.comboBox.revalidate();
            }
            if (this.this$0.comboBox.isEditable() && this.this$0.editor != null) {
                this.this$0.comboBox.configureEditor(this.this$0.comboBox.getEditor(), this.this$0.comboBox.getSelectedItem());
            }
            this.this$0.comboBox.repaint();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            BasicComboBoxUI.access$002(this.this$0, true);
            this.contentsChanged(listDataEvent);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            BasicComboBoxUI.access$002(this.this$0, true);
            this.contentsChanged(listDataEvent);
        }

        public ListDataHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }
    }

    static class NavigationalAction
    extends AbstractAction {
        int keyCode;

        NavigationalAction(int n2) {
            this.keyCode = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            int n2 = this.getNextIndex(jComboBox);
            if (n2 >= 0 && n2 < jComboBox.getItemCount()) {
                jComboBox.setSelectedIndex(n2);
            }
        }

        int getNextIndex(JComboBox jComboBox) {
            switch (this.keyCode) {
                case 33: {
                    int n2 = jComboBox.getMaximumRowCount();
                    int n3 = jComboBox.getSelectedIndex() - n2;
                    return n3 < 0 ? 0 : n3;
                }
                case 34: {
                    int n4 = jComboBox.getMaximumRowCount();
                    int n5 = jComboBox.getSelectedIndex() + n4;
                    int n6 = jComboBox.getItemCount();
                    return n5 < n6 ? n5 : n6 - 1;
                }
                case 36: {
                    return 0;
                }
                case 35: {
                    return jComboBox.getItemCount() - 1;
                }
            }
            return jComboBox.getSelectedIndex();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private final BasicComboBoxUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JComboBox jComboBox = (JComboBox)propertyChangeEvent.getSource();
            if (string.equals("model")) {
                ComboBoxModel comboBoxModel = (ComboBoxModel)propertyChangeEvent.getNewValue();
                ComboBoxModel comboBoxModel2 = (ComboBoxModel)propertyChangeEvent.getOldValue();
                if (comboBoxModel2 != null && this.this$0.listDataListener != null) {
                    comboBoxModel2.removeListDataListener(this.this$0.listDataListener);
                }
                if (comboBoxModel != null && this.this$0.listDataListener != null) {
                    comboBoxModel.addListDataListener(this.this$0.listDataListener);
                }
                if (this.this$0.editor != null) {
                    jComboBox.configureEditor(jComboBox.getEditor(), jComboBox.getSelectedItem());
                }
                this.this$0.isMinimumSizeDirty = true;
                BasicComboBoxUI.access$002(this.this$0, true);
                jComboBox.revalidate();
                jComboBox.repaint();
            } else if (string.equals("editor") && jComboBox.isEditable()) {
                this.this$0.addEditor();
                jComboBox.revalidate();
            } else if (string.equals("editable")) {
                if (jComboBox.isEditable()) {
                    jComboBox.setRequestFocusEnabled(false);
                    this.this$0.addEditor();
                } else {
                    jComboBox.setRequestFocusEnabled(true);
                    this.this$0.removeEditor();
                }
                BasicComboBoxUI.access$100(this.this$0);
                jComboBox.revalidate();
            } else if (string.equals("enabled")) {
                boolean bl2 = jComboBox.isEnabled();
                if (this.this$0.editor != null) {
                    this.this$0.editor.setEnabled(bl2);
                }
                if (this.this$0.arrowButton != null) {
                    this.this$0.arrowButton.setEnabled(bl2);
                }
                jComboBox.repaint();
            } else if (string.equals("maximumRowCount")) {
                if (this.this$0.isPopupVisible(jComboBox)) {
                    this.this$0.setPopupVisible(jComboBox, false);
                    this.this$0.setPopupVisible(jComboBox, true);
                }
            } else if (string.equals("font")) {
                this.this$0.listBox.setFont(jComboBox.getFont());
                if (this.this$0.editor != null) {
                    this.this$0.editor.setFont(jComboBox.getFont());
                }
                this.this$0.isMinimumSizeDirty = true;
                jComboBox.validate();
            } else if (string.equals("ToolTipText")) {
                BasicComboBoxUI.access$100(this.this$0);
            } else if (string.equals(BasicComboBoxUI.IS_TABLE_CELL_EDITOR)) {
                Boolean bl3 = (Boolean)propertyChangeEvent.getNewValue();
                BasicComboBoxUI.access$202(this.this$0, bl3.equals(Boolean.TRUE));
            } else if (string.equals("prototypeDisplayValue")) {
                this.this$0.isMinimumSizeDirty = true;
                BasicComboBoxUI.access$002(this.this$0, true);
                jComboBox.revalidate();
            } else if (string.equals("renderer")) {
                this.this$0.isMinimumSizeDirty = true;
                BasicComboBoxUI.access$002(this.this$0, true);
                jComboBox.revalidate();
            }
        }

        public PropertyChangeHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }
    }

    static class SpaceAction
    extends AltAction {
        SpaceAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (!jComboBox.isEditable()) {
                super.actionPerformed(actionEvent);
            }
        }
    }

    static class UpAction
    extends AbstractAction {
        UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicComboBoxUI basicComboBoxUI;
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled() && (basicComboBoxUI = (BasicComboBoxUI)jComboBox.getUI()).isPopupVisible(jComboBox)) {
                basicComboBoxUI.selectPreviousPossibleValue();
            }
        }
    }
}

