/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuItemPeer;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.awt.windows.WMenuPeer;
import sun.awt.windows.WObjectPeer;
import sun.awt.windows.WToolkit;

class WMenuItemPeer
extends WObjectPeer
implements MenuItemPeer {
    String shortcutLabel;
    boolean isCheckbox = false;
    private static Font defaultMenuFont;

    static {
        WMenuItemPeer.initIDs();
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("sun.awt.windows.awtLocalization");
            defaultMenuFont = Font.decode(resourceBundle.getString("menuFont"));
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException.getMessage());
            System.out.println("Using default MenuItem font\n");
            defaultMenuFont = new Font("SanSerif", 0, 11);
        }
    }

    protected WMenuItemPeer() {
    }

    private synchronized native void _dispose();

    public void disable() {
        this.enable(false);
    }

    protected void disposeImpl() {
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    public void enable() {
        this.enable(true);
    }

    private static native void initIDs();

    void handleAction(long l2, int n2) {
        WToolkit.executeOnEventHandlerThread(this.target, new Runnable(this, l2, n2){
            private final long val$when;
            private final int val$modifiers;
            private final WMenuItemPeer this$0;

            public void run() {
                this.this$0.postEvent(new ActionEvent(this.this$0.target, 1001, ((MenuItem)this.this$0.target).getActionCommand(), this.val$when, this.val$modifiers));
            }
            {
                this.this$0 = wMenuItemPeer;
                this.val$when = l2;
                this.val$modifiers = n2;
            }
        });
    }

    native void enable(boolean var1);

    public void setEnabled(boolean bl2) {
        this.enable(bl2);
    }

    void postEvent(AWTEvent aWTEvent) {
        WToolkit.postEvent(WToolkit.targetToAppContext(this.target), aWTEvent);
    }

    static Font getDefaultFont() {
        return defaultMenuFont;
    }

    WMenuItemPeer(MenuItem menuItem) {
        this.target = menuItem;
        WMenuPeer wMenuPeer = (WMenuPeer)WToolkit.targetToPeer(menuItem.getParent());
        this.create(wMenuPeer);
        MenuShortcut menuShortcut = menuItem.getShortcut();
        if (menuShortcut != null) {
            this.shortcutLabel = menuShortcut.toString();
        }
    }

    public native void _setLabel(String var1);

    public void setLabel(String string) {
        MenuShortcut menuShortcut = ((MenuItem)this.target).getShortcut();
        this.shortcutLabel = menuShortcut != null ? menuShortcut.toString() : null;
        this._setLabel(string);
    }

    native void create(WMenuPeer var1);
}

