/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StripClassFile {
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;
    private static final String[] requiredTypes = new String[]{"Code", "ConstantValue", "Exceptions", "InnerClasses", "Synthetic"};
    private ByteStream bs;
    private DataInputStream dis;
    int magic;
    short minor_version;
    short major_version;
    int constant_pool_count;
    ConstantPool[] constant_pool;

    private void parseCodeAttribute() throws IOException {
        int n = this.bs.getOffset();
        int n2 = this.dis.readInt();
        this.dis.skip(2L);
        this.dis.skip(2L);
        int n3 = this.dis.readInt();
        this.dis.skip(n3);
        int n4 = this.dis.readUnsignedShort();
        this.dis.skip(8 * n4);
        int n5 = this.bs.getOffset();
        int n6 = this.dis.readUnsignedShort();
        for (int i = 0; i < n6; ++i) {
            int n7 = this.bs.getOffset();
            if (this.parseAttributeInfo()) continue;
            int n8 = this.bs.getOffset() - n7;
            this.bs.decrementCount(n5);
            this.bs.removeBytes(n7, this.bs.getOffset());
            this.bs.setOffset(n7);
            this.bs.decrementLength(n, n8);
        }
    }

    private void parseFieldInfo() throws IOException {
        int n = this.dis.readUnsignedShort();
        int n2 = this.dis.readUnsignedShort();
        this.validateName(n2);
        int n3 = this.dis.readUnsignedShort();
        this.validateName(n3);
        int n4 = this.dis.readUnsignedShort();
        for (int i = 0; i < n4; ++i) {
            this.parseAttributeInfo();
        }
    }

    private void parseMethodInfo() throws IOException {
        this.dis.skip(2L);
        int n = this.dis.readUnsignedShort();
        this.validateName(n);
        int n2 = this.dis.readUnsignedShort();
        this.validateName(n2);
        int n3 = this.dis.readUnsignedShort();
        for (int i = 0; i < n3; ++i) {
            this.parseAttributeInfo();
        }
    }

    private void stripClassFile() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        this.magic = this.dis.readInt();
        this.minor_version = this.dis.readShort();
        this.major_version = this.dis.readShort();
        this.constant_pool_count = this.dis.readUnsignedShort();
        this.constant_pool = new ConstantPool[this.constant_pool_count - 1];
        int n5 = this.bs.getOffset();
        for (n4 = 0; n4 < 2; ++n4) {
            int n6;
            int n7;
            ConstantPool constantPool;
            n3 = n4 == 0 ? 1 : 0;
            n2 = n4 != 0 ? 1 : 0;
            this.bs.setOffset(n5);
            for (n = 0; n < this.constant_pool_count - 1; ++n) {
                constantPool = this.constant_pool[n];
                this.constant_pool[n] = constantPool = new ConstantPool(this, n2 != 0 && constantPool.invalid);
                if (constantPool.tag != 5 && constantPool.tag != 6) continue;
                ++n;
            }
            for (n = 0; n < this.constant_pool_count - 1; ++n) {
                constantPool = this.constant_pool[n];
                constantPool.verify(this.constant_pool);
                if (constantPool.tag != 5 && constantPool.tag != 6) continue;
                ++n;
            }
            this.dis.skip(2L);
            n = this.dis.readUnsignedShort();
            int n8 = this.dis.readUnsignedShort();
            int n9 = this.dis.readShort();
            for (n7 = 0; n7 < n9; ++n7) {
                n6 = this.dis.readUnsignedShort();
            }
            n7 = this.dis.readShort();
            for (n6 = 0; n6 < n7; ++n6) {
                this.parseFieldInfo();
            }
            n6 = this.dis.readShort();
            for (int i = 0; i < n6; ++i) {
                this.parseMethodInfo();
            }
        }
        n4 = this.bs.getOffset();
        n3 = this.dis.readShort();
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.bs.getOffset();
            if (this.parseAttributeInfo()) continue;
            this.bs.decrementCount(n4);
            this.bs.removeBytes(n, this.bs.getOffset());
            this.bs.setOffset(n);
        }
    }

    private boolean parseAttributeInfo() throws IOException {
        int n = this.dis.readUnsignedShort();
        ConstantPool constantPool = this.constant_pool[n - 1];
        String string = constantPool.string;
        if (string.equals("Code")) {
            this.parseCodeAttribute();
            return true;
        }
        int n2 = this.dis.readInt();
        this.dis.skip(n2);
        return this.attributeRequired(string);
    }

    private static boolean validJavaCharacter(char c, boolean bl) {
        if (c == '/' || c == '(' || c == ')' || c == ';' || c == '[') {
            return true;
        }
        return bl ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c);
    }

    private boolean validateClassName(int n) throws IOException {
        ConstantPool constantPool = this.constant_pool[n - 1];
        n = constantPool.nameIndex;
        return this.validateName(n);
    }

    private boolean validateName(int n) throws IOException {
        ConstantPool constantPool = this.constant_pool[n - 1];
        if (constantPool.string == null || constantPool.string.equals("<init>") || constantPool.string.equals("<clinit>")) {
            return true;
        }
        for (int i = 0; i < constantPool.string.length(); ++i) {
            char c = constantPool.string.charAt(i);
            if (StripClassFile.validJavaCharacter(c, i == 0)) continue;
            constantPool.invalid = true;
            return false;
        }
        return true;
    }

    public byte[] strip(byte[] byArray) throws Exception {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        this.bs = new ByteStream(this, byArray2);
        this.dis = new DataInputStream(this.bs);
        this.stripClassFile();
        int n2 = this.bs.getOffset();
        byte[] byArray3 = new byte[n2];
        byArray2 = this.bs.getArray();
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }

    boolean attributeRequired(String string) {
        for (int i = 0; i < requiredTypes.length; ++i) {
            if (!string.equals(requiredTypes[i])) continue;
            return true;
        }
        return false;
    }

    static void charToUnicode(char c, StringBuffer stringBuffer) {
        stringBuffer.append("U");
        String string = Integer.toHexString(c);
        for (int i = string.length(); i < 4; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
    }

    static boolean access$200(StripClassFile stripClassFile, int n) throws IOException {
        return stripClassFile.validateClassName(n);
    }

    static boolean access$300(StripClassFile stripClassFile, int n) throws IOException {
        return stripClassFile.validateName(n);
    }

    static DataInputStream access$000(StripClassFile stripClassFile) {
        return stripClassFile.dis;
    }

    static String makeValid(String string) {
        int n = string.length();
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n * 5);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (StripClassFile.validJavaCharacter(c, i == 0)) {
                stringBuffer.append(cArray[i]);
                continue;
            }
            StripClassFile.charToUnicode(cArray[i], stringBuffer);
        }
        return stringBuffer.toString();
    }

    static ByteStream access$100(StripClassFile stripClassFile) {
        return stripClassFile.bs;
    }

    private class ByteStream
    extends InputStream {
        private byte[] array;
        private int offset;
        private int length;
        private final StripClassFile this$0;

        public int getOffset() {
            return this.offset;
        }

        public int read() throws IOException {
            if (this.offset == this.length) {
                throw new IOException();
            }
            int n = this.array[this.offset++] & 0xFF;
            return n;
        }

        public byte[] getArray() {
            return this.array;
        }

        public void decrementCount(int n) {
            int n2 = this.array[n] & 0xFF;
            int n3 = this.array[n + 1] & 0xFF;
            int n4 = (n2 << 8) + (n3 << 0) - 1;
            this.array[n] = (byte)(n4 >>> 8 & 0xFF);
            this.array[n + 1] = (byte)(n4 >>> 0 & 0xFF);
        }

        public void setOffset(int n) {
            this.offset = n;
        }

        public void addBytes(int n, int n2) {
            byte[] byArray = new byte[this.length + n2];
            System.arraycopy(this.array, 0, byArray, 0, n);
            System.arraycopy(this.array, n, byArray, n + n2, this.length - n);
            this.array = byArray;
            this.length += n2;
        }

        public void decrementLength(int n, int n2) {
            int n3 = this.array[n] & 0xFF;
            int n4 = this.array[n + 1] & 0xFF;
            int n5 = this.array[n + 2] & 0xFF;
            int n6 = this.array[n + 3] & 0xFF;
            int n7 = (n3 << 24) + (n4 << 16) + (n5 << 8) + (n6 << 0);
            this.array[n] = (byte)((n7 -= n2) >>> 24 & 0xFF);
            this.array[n + 1] = (byte)(n7 >>> 16 & 0xFF);
            this.array[n + 2] = (byte)(n7 >>> 8 & 0xFF);
            this.array[n + 3] = (byte)(n7 >>> 0 & 0xFF);
        }

        public void removeBytes(int n, int n2) {
            System.arraycopy(this.array, n2, this.array, n, this.length - n2);
            this.length -= n2 - n;
        }

        public void setByte(int n, int n2) {
            this.array[n] = (byte)n2;
        }

        public void write(byte[] byArray) throws IOException {
            if (this.offset + byArray.length > this.length) {
                throw new IOException();
            }
            for (int i = 0; i < byArray.length; ++i) {
                this.array[this.offset++] = byArray[i];
            }
        }

        ByteStream(StripClassFile stripClassFile, byte[] byArray) {
            this.this$0 = stripClassFile;
            this.array = byArray;
            this.offset = 0;
            this.length = byArray.length;
        }
    }

    private class ConstantPool {
        byte tag;
        int nameIndex;
        String string;
        int stringOffset;
        int descriptorIndex;
        boolean invalid;
        private final StripClassFile this$0;

        ConstantPool(StripClassFile stripClassFile, boolean bl) throws IOException {
            this.this$0 = stripClassFile;
            this.tag = (byte)StripClassFile.access$000(stripClassFile).read();
            switch (this.tag) {
                case 7: 
                case 8: {
                    this.nameIndex = StripClassFile.access$000(stripClassFile).readUnsignedShort();
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.nameIndex = StripClassFile.access$000(stripClassFile).readUnsignedShort();
                    this.descriptorIndex = StripClassFile.access$000(stripClassFile).readUnsignedShort();
                    break;
                }
                case 3: 
                case 4: {
                    StripClassFile.access$000(stripClassFile).skip(4L);
                    break;
                }
                case 12: {
                    this.nameIndex = StripClassFile.access$000(stripClassFile).readUnsignedShort();
                    this.descriptorIndex = StripClassFile.access$000(stripClassFile).readUnsignedShort();
                    break;
                }
                case 5: 
                case 6: {
                    StripClassFile.access$000(stripClassFile).skip(8L);
                    break;
                }
                case 1: {
                    this.stringOffset = StripClassFile.access$100(stripClassFile).getOffset();
                    this.string = StripClassFile.access$000(stripClassFile).readUTF();
                    if (!bl) break;
                    int n = StripClassFile.access$100(stripClassFile).getOffset() - this.stringOffset;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    this.string = StripClassFile.makeValid(this.string);
                    dataOutputStream.writeUTF(this.string);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream = null;
                    StripClassFile.access$100(stripClassFile).addBytes(this.stringOffset, byArray.length - n);
                    StripClassFile.access$100(stripClassFile).setOffset(this.stringOffset);
                    StripClassFile.access$100(stripClassFile).write(byArray);
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
        }

        void verify(ConstantPool[] constantPoolArray) throws IOException {
            switch (this.tag) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    StripClassFile.access$200(this.this$0, this.nameIndex);
                    break;
                }
                case 10: {
                    StripClassFile.access$200(this.this$0, this.nameIndex);
                    break;
                }
                case 11: {
                    StripClassFile.access$200(this.this$0, this.nameIndex);
                    break;
                }
                case 12: {
                    StripClassFile.access$300(this.this$0, this.nameIndex);
                    StripClassFile.access$300(this.this$0, this.descriptorIndex);
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
        }
    }
}

