/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Observer;
import java.util.Vector;

public class Observable {
    private boolean changed = false;
    private Vector obs = new Vector();

    public synchronized int countObservers() {
        return this.obs.size();
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized void deleteObservers() {
        this.obs.removeAllElements();
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object object) {
        Object[] objectArray;
        Observable observable = this;
        synchronized (observable) {
            if (!this.changed) {
                return;
            }
            objectArray = this.obs.toArray();
            this.clearChanged();
        }
        for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
            ((Observer)objectArray[i2]).update(this, object);
        }
    }

    public synchronized void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        if (!this.obs.contains(observer)) {
            this.obs.addElement(observer);
        }
    }

    public synchronized void deleteObserver(Observer observer) {
        this.obs.removeElement(observer);
    }
}

