/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class PopupFactory {
    private static final Object SharedInstanceKey = new StringBuffer("PopupFactory.SharedInstanceKey");
    private static final int MAX_CACHE_SIZE = 5;
    static final int LIGHT_WEIGHT_POPUP = 0;
    static final int MEDIUM_WEIGHT_POPUP = 1;
    static final int HEAVY_WEIGHT_POPUP = 2;
    private int popupType = 0;
    static Class class$javax$swing$PopupFactory$HeavyWeightPopup;
    static Class class$javax$swing$PopupFactory$LightWeightPopup;
    static Class class$javax$swing$PopupFactory$MediumWeightPopup;

    int getPopupType() {
        return this.popupType;
    }

    void setPopupType(int n2) {
        this.popupType = n2;
    }

    private boolean invokerInHeavyWeightPopup(Component component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof Popup.HeavyWeightWindow)) continue;
                return true;
            }
        }
        return false;
    }

    public static PopupFactory getSharedInstance() {
        PopupFactory popupFactory = (PopupFactory)SwingUtilities.appContextGet(SharedInstanceKey);
        if (popupFactory == null) {
            popupFactory = new PopupFactory();
            PopupFactory.setSharedInstance(popupFactory);
        }
        return popupFactory;
    }

    public static void setSharedInstance(PopupFactory popupFactory) {
        if (popupFactory == null) {
            throw new IllegalArgumentException("PopupFactory can not be null");
        }
        SwingUtilities.appContextPut(SharedInstanceKey, popupFactory);
    }

    private int getPopupType(Component component, Component component2, int n2, int n3) {
        int n4 = this.getPopupType();
        if (component == null || this.invokerInHeavyWeightPopup(component)) {
            n4 = 2;
        } else if (n4 == 0 && !(component2 instanceof JToolTip) && !(component2 instanceof JPopupMenu)) {
            n4 = 1;
        }
        return n4;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private Popup getHeadlessPopup(Component component, Component component2, int n2, int n3) {
        return HeadlessPopup.getHeadlessPopup(component, component2, n2, n3);
    }

    private Popup getHeavyWeightPopup(Component component, Component component2, int n2, int n3) {
        if (GraphicsEnvironment.isHeadless()) {
            return this.getMediumWeightPopup(component, component2, n2, n3);
        }
        return HeavyWeightPopup.getHeavyWeightPopup(component, component2, n2, n3);
    }

    private Popup getLightWeightPopup(Component component, Component component2, int n2, int n3) {
        return LightWeightPopup.getLightWeightPopup(component, component2, n2, n3);
    }

    private Popup getMediumWeightPopup(Component component, Component component2, int n2, int n3) {
        return MediumWeightPopup.getMediumWeightPopup(component, component2, n2, n3);
    }

    public Popup getPopup(Component component, Component component2, int n2, int n3) throws IllegalArgumentException {
        if (component2 == null) {
            throw new IllegalArgumentException("Popup.getPopup must be passed non-null contents");
        }
        int n4 = this.getPopupType(component, component2, n2, n3);
        Popup popup = this.getPopup(component, component2, n2, n3, n4);
        if (popup == null) {
            popup = this.getPopup(component, component2, n2, n3, 2);
        }
        return popup;
    }

    private Popup getPopup(Component component, Component component2, int n2, int n3, int n4) {
        if (GraphicsEnvironment.isHeadless()) {
            return this.getHeadlessPopup(component, component2, n2, n3);
        }
        switch (n4) {
            case 0: {
                return this.getLightWeightPopup(component, component2, n2, n3);
            }
            case 1: {
                return this.getMediumWeightPopup(component, component2, n2, n3);
            }
            case 2: {
                return this.getHeavyWeightPopup(component, component2, n2, n3);
            }
        }
        return null;
    }

    private static class ContainerPopup
    extends Popup {
        Component owner;
        int x;
        int y;

        private ContainerPopup() {
        }

        public void hide() {
            Container container;
            Component component = this.getComponent();
            if (component != null && (container = component.getParent()) != null) {
                Rectangle rectangle = component.getBounds();
                container.remove(component);
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.owner = null;
        }

        public void pack() {
            Component component = this.getComponent();
            if (component != null) {
                component.setSize(component.getPreferredSize());
            }
        }

        boolean fitsOnScreen() {
            Component component = this.getComponent();
            if (this.owner != null && component != null) {
                int n2 = component.getWidth();
                int n3 = component.getHeight();
                for (Container container = this.owner.getParent(); container != null; container = container.getParent()) {
                    if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                        Rectangle rectangle = container.getBounds();
                        Insets insets = container.getInsets();
                        rectangle.x += insets.left;
                        rectangle.y += insets.top;
                        rectangle.width -= insets.left + insets.right;
                        rectangle.height -= insets.top + insets.bottom;
                        return SwingUtilities.isRectangleContainingRectangle(rectangle, new Rectangle(this.x, this.y, n2, n3));
                    }
                    if (container instanceof JApplet) {
                        Rectangle rectangle = container.getBounds();
                        Point point = container.getLocationOnScreen();
                        rectangle.x = point.x;
                        rectangle.y = point.y;
                        return SwingUtilities.isRectangleContainingRectangle(rectangle, new Rectangle(this.x, this.y, n2, n3));
                    }
                    if (container instanceof Window || container instanceof Applet) break;
                }
            }
            return false;
        }

        boolean overlappedByOwnedWindow() {
            Component component = this.getComponent();
            if (this.owner != null && component != null) {
                Window window = SwingUtilities.getWindowAncestor(this.owner);
                if (window == null) {
                    return false;
                }
                Window[] windowArray = window.getOwnedWindows();
                if (windowArray != null) {
                    Rectangle rectangle = component.getBounds();
                    for (int i2 = 0; i2 < windowArray.length; ++i2) {
                        Window window2 = windowArray[i2];
                        if (!window2.isVisible() || !rectangle.intersects(window2.getBounds())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        ContainerPopup(1 var1_1) {
            this();
        }

        void reset(Component component, Component component2, int n2, int n3) {
            if (component instanceof JFrame || component instanceof JDialog || component instanceof JWindow) {
                component = ((RootPaneContainer)((Object)component)).getLayeredPane();
            }
            super.reset(component, component2, n2, n3);
            this.x = n2;
            this.y = n3;
            this.owner = component;
        }
    }

    private static class HeadlessPopup
    extends ContainerPopup {
        private HeadlessPopup() {
            super(null);
        }

        public void hide() {
        }

        public void show() {
        }

        Component createComponent(Component component) {
            return new Panel(new BorderLayout());
        }

        static Popup getHeadlessPopup(Component component, Component component2, int n2, int n3) {
            HeadlessPopup headlessPopup = new HeadlessPopup();
            headlessPopup.reset(component, component2, n2, n3);
            return headlessPopup;
        }
    }

    private static class HeavyWeightPopup
    extends Popup {
        private static final Object heavyWeightPopupCacheKey = new StringBuffer("PopupFactory.heavyWeightPopupCache");

        private HeavyWeightPopup() {
        }

        void _dispose() {
            super.dispose();
        }

        void dispose() {
        }

        public void hide() {
            super.hide();
            HeavyWeightPopup.recycleHeavyWeightPopup(this);
        }

        static Map access$000() {
            return HeavyWeightPopup.getHeavyWeightPopupCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Map getHeavyWeightPopupCache() {
            Class clazz = class$javax$swing$PopupFactory$HeavyWeightPopup == null ? (class$javax$swing$PopupFactory$HeavyWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$HeavyWeightPopup")) : class$javax$swing$PopupFactory$HeavyWeightPopup;
            synchronized (clazz) {
                Map map = (Map)SwingUtilities.appContextGet(heavyWeightPopupCacheKey);
                if (map == null) {
                    map = new HashMap(2);
                    SwingUtilities.appContextPut(heavyWeightPopupCacheKey, map);
                }
                return map;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void recycleHeavyWeightPopup(HeavyWeightPopup heavyWeightPopup) {
            Class clazz = class$javax$swing$PopupFactory$HeavyWeightPopup == null ? (class$javax$swing$PopupFactory$HeavyWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$HeavyWeightPopup")) : class$javax$swing$PopupFactory$HeavyWeightPopup;
            synchronized (clazz) {
                List list;
                Window window = SwingUtilities.getWindowAncestor(heavyWeightPopup.getComponent());
                Map map = HeavyWeightPopup.getHeavyWeightPopupCache();
                if (window instanceof Popup.DefaultFrame || !window.isVisible()) {
                    heavyWeightPopup._dispose();
                    return;
                }
                if (map.containsKey(window)) {
                    list = (List)map.get(window);
                } else {
                    list = new ArrayList();
                    map.put(window, list);
                    Window window2 = window;
                    window2.addWindowListener(new WindowAdapter(window2){
                        private final Window val$w;
                        {
                            this.val$w = window;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void windowClosed(WindowEvent windowEvent) {
                            List list;
                            Class clazz = class$javax$swing$PopupFactory$HeavyWeightPopup == null ? (class$javax$swing$PopupFactory$HeavyWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$HeavyWeightPopup")) : class$javax$swing$PopupFactory$HeavyWeightPopup;
                            synchronized (clazz) {
                                Map map = HeavyWeightPopup.access$000();
                                list = (List)map.remove(this.val$w);
                            }
                            if (list != null) {
                                for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                                    ((HeavyWeightPopup)list.get(i2))._dispose();
                                }
                            }
                        }
                    });
                }
                if (list.size() < 5) {
                    list.add(heavyWeightPopup);
                } else {
                    heavyWeightPopup._dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static HeavyWeightPopup getRecycledHeavyWeightPopup(Window window) {
            Class clazz = class$javax$swing$PopupFactory$HeavyWeightPopup == null ? (class$javax$swing$PopupFactory$HeavyWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$HeavyWeightPopup")) : class$javax$swing$PopupFactory$HeavyWeightPopup;
            synchronized (clazz) {
                Map map = HeavyWeightPopup.getHeavyWeightPopupCache();
                if (!map.containsKey(window)) {
                    return null;
                }
                List list = (List)map.get(window);
                int n2 = list.size();
                if (n2 > 0) {
                    HeavyWeightPopup heavyWeightPopup = (HeavyWeightPopup)list.get(0);
                    list.remove(0);
                    return heavyWeightPopup;
                }
                return null;
            }
        }

        static Popup getHeavyWeightPopup(Component component, Component component2, int n2, int n3) {
            Container container;
            Window window = component != null ? SwingUtilities.getWindowAncestor(component) : null;
            HeavyWeightPopup heavyWeightPopup = null;
            if (window != null) {
                heavyWeightPopup = HeavyWeightPopup.getRecycledHeavyWeightPopup(window);
            }
            boolean bl2 = false;
            if (component2 != null && component2.isFocusable() && component2 instanceof JPopupMenu) {
                container = (JPopupMenu)component2;
                Component[] componentArray = container.getComponents();
                for (int i2 = 0; i2 < componentArray.length; ++i2) {
                    if (componentArray[i2] instanceof MenuElement || componentArray[i2] instanceof JSeparator) continue;
                    bl2 = true;
                    break;
                }
            }
            if (heavyWeightPopup == null || ((JWindow)heavyWeightPopup.getComponent()).getFocusableWindowState() != bl2) {
                if (heavyWeightPopup != null) {
                    heavyWeightPopup._dispose();
                }
                heavyWeightPopup = new HeavyWeightPopup();
            }
            heavyWeightPopup.reset(component, component2, n2, n3);
            if (bl2) {
                container = (JWindow)heavyWeightPopup.getComponent();
                ((Window)container).setFocusableWindowState(true);
                container.setName("###focusableSwingPopup###");
            }
            return heavyWeightPopup;
        }
    }

    private static class LightWeightPopup
    extends ContainerPopup {
        private static final Object lightWeightPopupCacheKey = new StringBuffer("PopupFactory.lightPopupCache");

        private LightWeightPopup() {
            super(null);
        }

        public void hide() {
            super.hide();
            Container container = (Container)this.getComponent();
            container.removeAll();
            LightWeightPopup.recycleLightWeightPopup(this);
        }

        public void show() {
            Serializable serializable;
            Serializable serializable2 = null;
            if (this.owner != null) {
                serializable2 = this.owner instanceof Container ? (Container)this.owner : this.owner.getParent();
            }
            for (serializable = serializable2; serializable != null; serializable = ((Component)serializable).getParent()) {
                if (serializable instanceof JRootPane) {
                    if (((Component)serializable).getParent() instanceof JInternalFrame) continue;
                    serializable2 = ((JRootPane)serializable).getLayeredPane();
                    continue;
                }
                if (serializable instanceof Window) {
                    if (serializable2 != null) break;
                    serializable2 = serializable;
                    break;
                }
                if (serializable instanceof JApplet) break;
            }
            serializable = SwingUtilities.convertScreenLocationToParent((Container)serializable2, this.x, this.y);
            Component component = this.getComponent();
            component.setLocation(((Point)serializable).x, ((Point)serializable).y);
            if (serializable2 instanceof JLayeredPane) {
                ((JLayeredPane)serializable2).add(component, JLayeredPane.POPUP_LAYER, 0);
            } else {
                ((Container)serializable2).add(component);
            }
        }

        private static List getLightWeightPopupCache() {
            List list = (List)SwingUtilities.appContextGet(lightWeightPopupCacheKey);
            if (list == null) {
                list = new ArrayList();
                SwingUtilities.appContextPut(lightWeightPopupCacheKey, list);
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static LightWeightPopup getRecycledLightWeightPopup() {
            Class clazz = class$javax$swing$PopupFactory$LightWeightPopup == null ? (class$javax$swing$PopupFactory$LightWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$LightWeightPopup")) : class$javax$swing$PopupFactory$LightWeightPopup;
            synchronized (clazz) {
                List list = LightWeightPopup.getLightWeightPopupCache();
                int n2 = list.size();
                if (n2 > 0) {
                    LightWeightPopup lightWeightPopup = (LightWeightPopup)list.get(0);
                    list.remove(0);
                    return lightWeightPopup;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void recycleLightWeightPopup(LightWeightPopup lightWeightPopup) {
            Class clazz = class$javax$swing$PopupFactory$LightWeightPopup == null ? (class$javax$swing$PopupFactory$LightWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$LightWeightPopup")) : class$javax$swing$PopupFactory$LightWeightPopup;
            synchronized (clazz) {
                List list = LightWeightPopup.getLightWeightPopupCache();
                if (list.size() < 5) {
                    list.add(lightWeightPopup);
                }
            }
        }

        Component createComponent(Component component) {
            JPanel jPanel = new JPanel(new BorderLayout(), true);
            jPanel.setOpaque(true);
            return jPanel;
        }

        void reset(Component component, Component component2, int n2, int n3) {
            super.reset(component, component2, n2, n3);
            JComponent jComponent = (JComponent)this.getComponent();
            jComponent.setLocation(n2, n3);
            jComponent.add(component2, "Center");
            component2.invalidate();
            this.pack();
        }

        static Popup getLightWeightPopup(Component component, Component component2, int n2, int n3) {
            LightWeightPopup lightWeightPopup = LightWeightPopup.getRecycledLightWeightPopup();
            if (lightWeightPopup == null) {
                lightWeightPopup = new LightWeightPopup();
            }
            lightWeightPopup.reset(component, component2, n2, n3);
            if (!lightWeightPopup.fitsOnScreen() || lightWeightPopup.overlappedByOwnedWindow()) {
                lightWeightPopup.hide();
                return null;
            }
            return lightWeightPopup;
        }
    }

    private static class MediumWeightPopup
    extends ContainerPopup {
        private static final Object mediumWeightPopupCacheKey = new StringBuffer("PopupFactory.mediumPopupCache");
        private JRootPane rootPane;

        private MediumWeightPopup() {
            super(null);
        }

        public void hide() {
            super.hide();
            this.rootPane.getContentPane().removeAll();
            MediumWeightPopup.recycleMediumWeightPopup(this);
        }

        public void show() {
            Component component = this.getComponent();
            Container container = null;
            if (this.owner != null) {
                container = this.owner.getParent();
            }
            while (!(container instanceof Window) && !(container instanceof Applet) && container != null) {
                container = container.getParent();
            }
            if (container instanceof RootPaneContainer) {
                container = ((RootPaneContainer)((Object)container)).getLayeredPane();
                Point point = SwingUtilities.convertScreenLocationToParent(container, this.x, this.y);
                component.setVisible(false);
                component.setLocation(point.x, point.y);
                ((JLayeredPane)container).add(component, JLayeredPane.POPUP_LAYER, 0);
            } else {
                Point point = SwingUtilities.convertScreenLocationToParent(container, this.x, this.y);
                component.setLocation(point.x, point.y);
                component.setVisible(false);
                container.add(component);
            }
            component.setVisible(true);
        }

        private static List getMediumWeightPopupCache() {
            List list = (List)SwingUtilities.appContextGet(mediumWeightPopupCacheKey);
            if (list == null) {
                list = new ArrayList();
                SwingUtilities.appContextPut(mediumWeightPopupCacheKey, list);
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MediumWeightPopup getRecycledMediumWeightPopup() {
            Class clazz = class$javax$swing$PopupFactory$MediumWeightPopup == null ? (class$javax$swing$PopupFactory$MediumWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$MediumWeightPopup")) : class$javax$swing$PopupFactory$MediumWeightPopup;
            synchronized (clazz) {
                List list = MediumWeightPopup.getMediumWeightPopupCache();
                int n2 = list.size();
                if (n2 > 0) {
                    MediumWeightPopup mediumWeightPopup = (MediumWeightPopup)list.get(0);
                    list.remove(0);
                    return mediumWeightPopup;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void recycleMediumWeightPopup(MediumWeightPopup mediumWeightPopup) {
            Class clazz = class$javax$swing$PopupFactory$MediumWeightPopup == null ? (class$javax$swing$PopupFactory$MediumWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$MediumWeightPopup")) : class$javax$swing$PopupFactory$MediumWeightPopup;
            synchronized (clazz) {
                List list = MediumWeightPopup.getMediumWeightPopupCache();
                if (list.size() < 5) {
                    list.add(mediumWeightPopup);
                }
            }
        }

        Component createComponent(Component component) {
            Panel panel = new Panel(new BorderLayout());
            this.rootPane = new JRootPane();
            panel.add((Component)this.rootPane, "Center");
            return panel;
        }

        void reset(Component component, Component component2, int n2, int n3) {
            super.reset(component, component2, n2, n3);
            Component component3 = this.getComponent();
            component3.setLocation(n2, n3);
            this.rootPane.getContentPane().add(component2, "Center");
            component2.invalidate();
            component3.validate();
            this.pack();
        }

        static Popup getMediumWeightPopup(Component component, Component component2, int n2, int n3) {
            MediumWeightPopup mediumWeightPopup = MediumWeightPopup.getRecycledMediumWeightPopup();
            if (mediumWeightPopup == null) {
                mediumWeightPopup = new MediumWeightPopup();
            }
            mediumWeightPopup.reset(component, component2, n2, n3);
            if (!mediumWeightPopup.fitsOnScreen() || mediumWeightPopup.overlappedByOwnedWindow()) {
                mediumWeightPopup.hide();
                return null;
            }
            return mediumWeightPopup;
        }
    }
}

