/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.GlyphView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.TabExpander;

class GlyphPainter2
extends GlyphView.GlyphPainter {
    TextLayout layout;

    public GlyphPainter2(TextLayout textLayout) {
        this.layout = textLayout;
    }

    public float getAscent(GlyphView glyphView) {
        return this.layout.getAscent();
    }

    public float getDescent(GlyphView glyphView) {
        return this.layout.getDescent();
    }

    public float getHeight(GlyphView glyphView) {
        return this.layout.getAscent() + this.layout.getDescent() + this.layout.getLeading();
    }

    public int getBoundedPosition(GlyphView glyphView, int n2, float f2, float f3) {
        if (f3 < 0.0f) {
            throw new IllegalArgumentException("Length must be >= 0.");
        }
        TextHitInfo textHitInfo = this.layout.hitTestChar(f3, 0.0f);
        if (textHitInfo.getCharIndex() == -1 && !this.layout.isLeftToRight()) {
            return glyphView.getEndOffset();
        }
        int n3 = textHitInfo.isLeadingEdge() ? textHitInfo.getInsertionIndex() : textHitInfo.getInsertionIndex() - 1;
        return n3 + glyphView.getStartOffset();
    }

    public GlyphView.GlyphPainter getPainter(GlyphView glyphView, int n2, int n3) {
        return null;
    }

    public float getSpan(GlyphView glyphView, int n2, int n3, TabExpander tabExpander, float f2) {
        if (n2 == glyphView.getStartOffset() && n3 == glyphView.getEndOffset()) {
            return this.layout.getAdvance();
        }
        int n4 = glyphView.getStartOffset();
        int n5 = n2 - n4;
        int n6 = n3 - n4;
        TextHitInfo textHitInfo = TextHitInfo.afterOffset(n5);
        TextHitInfo textHitInfo2 = TextHitInfo.beforeOffset(n6);
        float[] fArray = this.layout.getCaretInfo(textHitInfo);
        float f3 = fArray[0];
        fArray = this.layout.getCaretInfo(textHitInfo2);
        float f4 = fArray[0];
        return f4 > f3 ? f4 - f3 : f3 - f4;
    }

    public void paint(GlyphView glyphView, Graphics graphics, Shape shape, int n2, int n3) {
        if (graphics instanceof Graphics2D) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            Graphics2D graphics2D = (Graphics2D)graphics;
            float f2 = (float)rectangle2D.getY() + this.layout.getAscent() + this.layout.getLeading();
            float f3 = (float)rectangle2D.getX();
            if (n2 > glyphView.getStartOffset() || n3 < glyphView.getEndOffset()) {
                try {
                    Shape shape2 = glyphView.modelToView(n2, Position.Bias.Forward, n3, Position.Bias.Backward, shape);
                    Shape shape3 = graphics.getClip();
                    graphics2D.clip(shape2);
                    this.layout.draw(graphics2D, f3, f2);
                    graphics.setClip(shape3);
                }
                catch (BadLocationException badLocationException) {}
            } else {
                this.layout.draw(graphics2D, f3, f2);
            }
        }
    }

    public int viewToModel(GlyphView glyphView, float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        Rectangle2D rectangle2D = shape instanceof Rectangle2D ? (Rectangle2D)shape : shape.getBounds2D();
        TextHitInfo textHitInfo = this.layout.hitTestChar(f2 - (float)rectangle2D.getX(), 0.0f);
        int n2 = textHitInfo.getInsertionIndex();
        biasArray[0] = textHitInfo.isLeadingEdge() ? Position.Bias.Forward : Position.Bias.Backward;
        return n2 + glyphView.getStartOffset();
    }

    public Shape modelToView(GlyphView glyphView, int n2, Position.Bias bias, Shape shape) throws BadLocationException {
        int n3 = n2 - glyphView.getStartOffset();
        Rectangle2D rectangle2D = shape.getBounds2D();
        TextHitInfo textHitInfo = bias == Position.Bias.Forward ? TextHitInfo.afterOffset(n3) : TextHitInfo.beforeOffset(n3);
        float[] fArray = this.layout.getCaretInfo(textHitInfo);
        rectangle2D.setRect(rectangle2D.getX() + (double)fArray[0], rectangle2D.getY(), 1.0, rectangle2D.getHeight());
        return rectangle2D;
    }

    public int getNextVisualPositionFrom(GlyphView glyphView, int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) throws BadLocationException {
        int n4 = glyphView.getStartOffset();
        int n5 = glyphView.getEndOffset();
        switch (n3) {
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                AbstractDocument abstractDocument = (AbstractDocument)glyphView.getDocument();
                boolean bl2 = abstractDocument.isLeftToRight(n4, n5);
                if (n4 == abstractDocument.getLength()) {
                    if (n2 == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n4;
                    }
                    return -1;
                }
                if (n2 == -1) {
                    if (bl2) {
                        biasArray[0] = Position.Bias.Forward;
                        return n4;
                    }
                    Segment segment = glyphView.getText(n5 - 1, n5);
                    char c2 = segment.array[segment.offset];
                    SegmentCache.releaseSharedSegment(segment);
                    if (c2 == '\n') {
                        biasArray[0] = Position.Bias.Forward;
                        return n5 - 1;
                    }
                    biasArray[0] = Position.Bias.Backward;
                    return n5;
                }
                TextHitInfo textHitInfo = bias == Position.Bias.Forward ? TextHitInfo.afterOffset(n2 - n4) : TextHitInfo.beforeOffset(n2 - n4);
                TextHitInfo textHitInfo2 = this.layout.getNextRightHit(textHitInfo);
                if (textHitInfo2 == null) {
                    return -1;
                }
                if (bl2 != this.layout.isLeftToRight()) {
                    textHitInfo2 = this.layout.getVisualOtherHit(textHitInfo2);
                }
                if ((n2 = textHitInfo2.getInsertionIndex() + n4) == n5) {
                    Segment segment = glyphView.getText(n5 - 1, n5);
                    char c3 = segment.array[segment.offset];
                    SegmentCache.releaseSharedSegment(segment);
                    if (c3 == '\n') {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Backward;
                } else {
                    biasArray[0] = Position.Bias.Forward;
                }
                return n2;
            }
            case 7: {
                AbstractDocument abstractDocument = (AbstractDocument)glyphView.getDocument();
                boolean bl3 = abstractDocument.isLeftToRight(n4, n5);
                if (n4 == abstractDocument.getLength()) {
                    if (n2 == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n4;
                    }
                    return -1;
                }
                if (n2 == -1) {
                    if (bl3) {
                        Segment segment = glyphView.getText(n5 - 1, n5);
                        char c4 = segment.array[segment.offset];
                        SegmentCache.releaseSharedSegment(segment);
                        if (c4 == '\n') {
                            biasArray[0] = Position.Bias.Forward;
                            return n5 - 1;
                        }
                        biasArray[0] = Position.Bias.Backward;
                        return n5;
                    }
                    biasArray[0] = Position.Bias.Forward;
                    return n4;
                }
                TextHitInfo textHitInfo = bias == Position.Bias.Forward ? TextHitInfo.afterOffset(n2 - n4) : TextHitInfo.beforeOffset(n2 - n4);
                TextHitInfo textHitInfo3 = this.layout.getNextLeftHit(textHitInfo);
                if (textHitInfo3 == null) {
                    return -1;
                }
                if (bl3 != this.layout.isLeftToRight()) {
                    textHitInfo3 = this.layout.getVisualOtherHit(textHitInfo3);
                }
                if ((n2 = textHitInfo3.getInsertionIndex() + n4) == n5) {
                    Segment segment = glyphView.getText(n5 - 1, n5);
                    char c5 = segment.array[segment.offset];
                    SegmentCache.releaseSharedSegment(segment);
                    if (c5 == '\n') {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Backward;
                } else {
                    biasArray[0] = Position.Bias.Forward;
                }
                return n2;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + n3);
            }
        }
        return n2;
    }
}

